/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSProfileCLIListProfileInvoker
extends WSProfileCLIModeInvoker {
    private boolean fIsPublic = false;
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("list", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profileName", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final CommandLineArgument[] ACLA_RESERVED_OPTIONAL_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("getProfilePath", V_EMPTY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("getTemplatePath", V_EMPTY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("getIsDefault", V_EMPTY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("listAll", V_EMPTY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final String S_SUCCESS_KEY = "WSProfile.WSProfileCLIListProfileInvoker.successMessage";
    private static final String S_PARTIAL_SUCCESS_KEY = "WSProfile.WSProfileCLIListProfileInvoker.partialSuccessMessage";
    private static final String S_FAILURE_KEY = "WSProfile.WSProfileCLIListProfileInvoker.failureMessage";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIListProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIListProfileInvoker.class.getName();

    @Override
    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "list";
    }

    @Override
    public boolean isPublicMode() {
        return this.fIsPublic;
    }

    @Override
    public void printOutExecutionResult(int nReturnCode, Map<String, List> mapArgs) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getExecutionResultMessage");
        String sReturnMessageKey = "";
        if (nReturnCode == 1) {
            sReturnMessageKey = S_FAILURE_KEY;
        } else if (nReturnCode == 2) {
            sReturnMessageKey = S_PARTIAL_SUCCESS_KEY;
        } else if (nReturnCode == 0) {
            sReturnMessageKey = S_SUCCESS_KEY;
        }
        String sExecutionMessage = ResourceBundleUtils.getLocaleString(sReturnMessageKey, LoggerFactoryConstants.getGlobalLogFilePath());
        if (!sExecutionMessage.equals(sReturnMessageKey)) {
            OutputStreamHandler.put();
            OutputStreamHandler.println(sExecutionMessage);
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, sExecutionMessage, "A message for the key " + sReturnMessageKey + " does not exist in the resource bundle.");
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getExecutionResultMessage");
    }

    @Override
    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        String sProfileName = this.getArgumentValue("profileName");
        Map mapOptionalArgMap = CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments());
        int nReturnCode = 1;
        try {
            if (mapOptionalArgMap.containsKey("getIsDefault") || mapOptionalArgMap.containsKey("listAll")) {
                OutputStreamHandler.add("isDefault", Boolean.toString(WSProfile.getProfile(sProfileName).isDefault()));
            }
            if (mapOptionalArgMap.containsKey("getTemplatePath") || mapOptionalArgMap.containsKey("listAll")) {
                OutputStreamHandler.add("templatePath", WSProfile.getProfileTemplateLocation(sProfileName));
            }
            if (mapOptionalArgMap.containsKey("getProfilePath") || mapOptionalArgMap.containsKey("listAll")) {
                OutputStreamHandler.add("profilePath", WSProfile.getProfileLocation(sProfileName));
            }
            nReturnCode = WSProfile.list(sProfileName, mapOptionalArgMap, this.getProfileRegistryPath());
        }
        catch (WSProfileException e) {
            LogUtils.logException(LOGGER, e);
            nReturnCode = 1;
        }
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_FAILURE_KEY));
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_PARTIAL_SUCCESS_KEY));
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_SUCCESS_KEY));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return nReturnCode;
    }

    @Override
    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector vclaRet = new Vector(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        String sProfileName = this.getArgumentValue("profileName");
        if (sProfileName != null) {
            try {
                String sTemplatePath = WSProfile.getProfile(sProfileName, this.getProfileRegistryPath()).getWSProfileTemplate().getProfileTemplatePath().getPath();
                System.setProperty("WS_CMT_ACTION_REGISTRY", new File(sTemplatePath, "listRegistry.xml").getAbsolutePath());
                List listclaRequired = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getRequiredArgumentsList(sTemplatePath));
                vclaRet = this.mergeCommandLineArgs(vclaRet, listclaRequired);
            }
            catch (WSProfileException e) {
                LogUtils.logException(LOGGER, e);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    @Override
    protected Vector getListOfOptionalCommandLineArguments() {
        Vector vclaRet = new Vector(Arrays.asList(ACLA_RESERVED_OPTIONAL_ARGUMENTS));
        String sProfileName = this.getArgumentValue("profileName");
        if (sProfileName != null) {
            try {
                String sTemplatePath = WSProfile.getProfile(sProfileName, this.getProfileRegistryPath()).getWSProfileTemplate().getProfileTemplatePath().getPath();
                System.setProperty("WS_CMT_ACTION_REGISTRY", new File(sTemplatePath, "listRegistry.xml").getAbsolutePath());
                List listclaOptional = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getOptionalArgumentsList(sTemplatePath));
                vclaRet = this.mergeCommandLineArgs(vclaRet, listclaOptional);
            }
            catch (WSProfileException e) {
                LogUtils.logException(LOGGER, e);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfOptionalCommandLineArgumetns");
        return vclaRet;
    }
}

