/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.install.configmanager.utils.ArrayUtils;
import com.ibm.ws.install.configmanager.utils.ClassPathModifier;
import com.ibm.ws.profile.anttasks.PortResolverRecommendedValues;
import com.ibm.ws.profile.utils.PortResolutionUtils;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PortResolver
extends Task {
    private int m_nMinimumPortNumber = 0;
    private File m_WASRegistryFile = null;
    private File m_WAS_HOME = null;
    private String m_sPortKeys = null;
    private String m_sPortKeyValuePairs = null;
    private String m_sErrorMessage = "";
    private File m_reservedPortsFile = null;
    private static final String S_INVALID_MINIMUM_PORT_PARAMETER = "The minimum port number is not valid.";
    private static final String S_INVALID_WAS_HOME_LIB_DIR = "Can not locate the lib directory under WebSphere install location directory.";
    private static final String S_MISSING_PORT_KEYS_PARAMETER = "The port keys parameter is missing.";
    private static final String S_LIB = "lib";
    private static final String[] ARR_DEPENDENT_JARS = new String[]{"admin.jar", "wasproduct.jar"};
    private static final String S_EMPTY = "";
    private static final String S_SPACES = " \t\n\r\f";
    private static final String S_EQUAL = "=";
    private static final Logger LOGGER = LoggerFactory.createLogger(PortResolver.class);
    private static final String S_CLASS_NAME = PortResolver.class.getName();

    public void init() throws BuildException {
        super.init();
    }

    public void execute() throws BuildException {
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        Hashtable hashtablePortMappings = null;
        if (this.isSequentialPortAssignment()) {
            hashtablePortMappings = this.sequentiallyAssignPorts(this.convertPortKeysToArray(), this.m_nMinimumPortNumber);
        } else {
            try {
                int[] reservedPorts = this.determineReservedPorts();
                hashtablePortMappings = PortResolutionUtils.recommendPorts(this.convertPortKeysToArray(), this.m_nMinimumPortNumber, this.m_WASRegistryFile, reservedPorts);
            }
            catch (WSProfileException wspe) {
                throw new BuildException(wspe);
            }
        }
        this.setEnvironmentWithPortMappings(hashtablePortMappings);
    }

    public void setMinimumPortNumber(int nMinimumPortNumber) {
        this.m_nMinimumPortNumber = nMinimumPortNumber;
    }

    public void setWASRegistryFile(File WASRegistryFile) {
        this.m_WASRegistryFile = WASRegistryFile;
    }

    public void setWAS_HOME(File WAS_HOME) {
        this.m_WAS_HOME = WAS_HOME;
    }

    public void setPortKeys(String sPortKeys) {
        this.m_sPortKeys = sPortKeys;
    }

    public void setPortKeyValuePairs(String sPortKeyValuePairs) {
        this.m_sPortKeyValuePairs = sPortKeyValuePairs;
    }

    public void setReservedPortsFile(File reservedPortsFile) {
        LOGGER.entering(PortResolverRecommendedValues.class.getName(), "setReservedPortsFile");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setReservedPortsFile", "The reserved ports file is: " + reservedPortsFile.toString());
        this.m_reservedPortsFile = reservedPortsFile;
        LOGGER.exiting(PortResolverRecommendedValues.class.getName(), "setReservedPortsFile");
    }

    private boolean doAllParamsCheckOutOk() {
        if (this.m_nMinimumPortNumber < 0) {
            this.m_sErrorMessage = S_INVALID_MINIMUM_PORT_PARAMETER;
            return false;
        }
        try {
            String libDir = this.m_WAS_HOME.getAbsolutePath() + File.separator + S_LIB;
            for (int i = 0; i < ARR_DEPENDENT_JARS.length; ++i) {
                ClassPathModifier.addFileToClassPath(libDir + File.separator + ARR_DEPENDENT_JARS[i]);
            }
        }
        catch (IOException e) {
            this.m_sErrorMessage = S_INVALID_WAS_HOME_LIB_DIR;
            return false;
        }
        if (this.m_sPortKeys == null || this.m_sPortKeys.trim().equals(S_EMPTY)) {
            this.m_sErrorMessage = S_MISSING_PORT_KEYS_PARAMETER;
            return false;
        }
        return true;
    }

    private String[] convertPortKeysToArray() {
        StringTokenizer st = new StringTokenizer(this.m_sPortKeys, S_SPACES);
        ArrayList<String> alsPortKeys = new ArrayList<String>();
        while (st.hasMoreElements()) {
            String sKey = (String)st.nextElement();
            alsPortKeys.add(sKey);
        }
        return alsPortKeys.toArray(new String[0]);
    }

    private void setEnvironmentWithPortMappings(Hashtable hPortMappings) {
        StringBuffer keyValuePairs = new StringBuffer();
        Enumeration enumPortKeys = hPortMappings.keys();
        while (enumPortKeys.hasMoreElements()) {
            String sPortKey = enumPortKeys.nextElement().toString();
            String sPortValue = hPortMappings.get(sPortKey).toString();
            keyValuePairs.append(sPortKey + S_EQUAL + sPortValue + "\n");
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setEnvironmentWithPortMappings", "Returning port key value pairs as property, " + this.m_sPortKeyValuePairs + S_EQUAL + keyValuePairs.toString());
        this.getProject().setNewProperty(this.m_sPortKeyValuePairs, keyValuePairs.toString());
        System.setProperty(this.m_sPortKeyValuePairs, keyValuePairs.toString());
    }

    private int[] determineReservedPorts() throws WSProfileException {
        if (this.m_reservedPortsFile == null || !this.m_reservedPortsFile.exists()) {
            return new int[0];
        }
        Properties propsReservedPorts = new Properties();
        try {
            propsReservedPorts.load(new FileInputStream(this.m_reservedPortsFile));
        }
        catch (FileNotFoundException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        String[] ports = propsReservedPorts.values().toArray(new String[0]);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "determineReservedPorts", "Reserved Ports: " + ArrayUtils.join(",", ports));
        int[] iaReservedPorts = new int[ports.length];
        for (int i = 0; i < ports.length; ++i) {
            iaReservedPorts[i] = Integer.parseInt(ports[i]);
        }
        return iaReservedPorts;
    }

    private boolean isSequentialPortAssignment() {
        boolean fIsSequential = false;
        if (PlatformConstants.isCurrentPlatformOS400()) {
            fIsSequential = true;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "isSequentialPortAssignment", "Use sequential port assignment=" + fIsSequential);
        return fIsSequential;
    }

    private Hashtable sequentiallyAssignPorts(String[] saPortKeys, int nStartingPort) {
        Hashtable<String, Integer> hashtablePortMappings = new Hashtable<String, Integer>();
        int nPortValue = nStartingPort;
        for (int i = 0; i < saPortKeys.length; ++i) {
            hashtablePortMappings.put(saPortKeys[i], new Integer(nPortValue));
            ++nPortValue;
        }
        return hashtablePortMappings;
    }
}

