/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DebugPortResolver
extends Task {
    private String m_sDebugPortKey = null;
    private String m_sPortdefPath = null;
    private String m_sTemplatePortdefPath = null;
    private String m_sReferencePortName = null;
    private String m_sErrorMessage = "";
    private static final String S_MISSING_DEBUG_PORT_KEY_PARAMETER = "The debug port key parameter is missing: ";
    private static final String S_MISSING_REFERENCE_PORT_NAME_PARAMETER = "The reference port name parameter is missing: ";
    private static final String S_MISSING_PORT_DEF_PATH_PARAMETER = "The debug port def path parameter is missing.";
    private static final String S_MISSING_PORT_DEF_PATH_INVALID_PARAMETER = "The debug port def path parameter is invalid: ";
    private static final String S_MISSING_TEMPLATE_PORT_DEF_PATH_PARAMETER = "The template debug port def path parameter is missing.";
    private static final String S_MISSING_TEMPLATE_PORT_DEF_PATH_INVALID_PARAMETER = "The template debug port def path parameter is invalid: ";
    private static final String S_EMPTY = "";
    private static final int DEFAULT_DEBUG_PORT = 7777;
    private static final Logger LOGGER = LoggerFactory.createLogger(DebugPortResolver.class);
    private static final String S_CLASS_NAME = DebugPortResolver.class.getName();

    public void init() throws BuildException {
        super.init();
    }

    private void doLog(String msg) {
        if (msg == null) {
            return;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "doLog", msg);
    }

    public void execute() throws BuildException {
        this.doLog("Executing parent execute()...");
        super.execute();
        this.doLog("Executing DebugPortResolver.execute()...");
        if (!this.doAllParamsCheckOutOk()) {
            this.doLog("Parameter check failed: " + this.m_sErrorMessage);
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        this.doLog("Parameter check success.");
        int debugPort = this.computeDebugPort();
        if (debugPort > 0) {
            String debugPortStr = S_EMPTY + debugPort;
            System.setProperty(this.m_sDebugPortKey, debugPortStr);
            this.getProject().setNewProperty(this.m_sDebugPortKey, S_EMPTY + debugPortStr);
            this.doLog(" m_sDebugPortKey=" + debugPortStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int computeDebugPort() {
        int referencePortNum = -1;
        int seedReferencePortNum = -1;
        InputStream finPropDef = null;
        InputStream finTemplatePropDef = null;
        int debugPort = -1;
        try {
            Properties portDefProp = new Properties();
            this.doLog("Loading port def file: " + this.m_sPortdefPath);
            finPropDef = new FileInputStream(this.m_sPortdefPath);
            portDefProp.load(finPropDef);
            this.doLog("Port def prop=" + portDefProp.size());
            String referencePort = portDefProp.getProperty(this.m_sReferencePortName);
            this.doLog("referencePort=" + referencePort);
            referencePortNum = Integer.parseInt(referencePort);
            Properties templatePortDefProp = new Properties();
            this.doLog("Loading template port def file: " + this.m_sPortdefPath);
            finTemplatePropDef = new FileInputStream(this.m_sTemplatePortdefPath);
            templatePortDefProp.load(finTemplatePropDef);
            this.doLog("Template port def prop=" + templatePortDefProp.size());
            String seedReferencePort = templatePortDefProp.getProperty(this.m_sReferencePortName);
            this.doLog("seedReferencePort=" + seedReferencePort);
            seedReferencePortNum = Integer.parseInt(seedReferencePort);
            if (referencePortNum > 0 && seedReferencePortNum > 0 && referencePortNum >= seedReferencePortNum) {
                debugPort = 7777 + referencePortNum - seedReferencePortNum;
                this.doLog("Computed debug port=" + debugPort);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (finPropDef != null) {
                try {
                    finPropDef.close();
                }
                catch (Exception e) {}
            }
            if (finTemplatePropDef != null) {
                try {
                    finTemplatePropDef.close();
                }
                catch (Exception e) {}
            }
        }
        return debugPort;
    }

    public void setDebugPortKey(String sDebugPortKey) {
        this.m_sDebugPortKey = sDebugPortKey;
    }

    public void setPortdefPath(String sPortdefPath) {
        this.m_sPortdefPath = sPortdefPath;
        if (this.m_sPortdefPath != null) {
            this.m_sPortdefPath = this.m_sPortdefPath.replace('\\', '/');
        }
    }

    public void setReferencePortName(String sReferencePortName) {
        this.m_sReferencePortName = sReferencePortName;
    }

    public void setTemplatePortdefPath(String sTemplatePortdefPath) {
        this.m_sTemplatePortdefPath = sTemplatePortdefPath;
        if (this.m_sTemplatePortdefPath != null) {
            this.m_sTemplatePortdefPath = this.m_sTemplatePortdefPath.replace('\\', '/');
        }
    }

    private boolean doAllParamsCheckOutOk() {
        if (this.m_sDebugPortKey == null || this.m_sDebugPortKey.trim().equals(S_EMPTY)) {
            this.m_sErrorMessage = S_MISSING_DEBUG_PORT_KEY_PARAMETER + this.m_sDebugPortKey;
            return false;
        }
        this.doLog("doAllParamsCheckOutOk(): debug port key ok: " + this.m_sDebugPortKey);
        if (this.m_sReferencePortName == null || this.m_sReferencePortName.trim().equals(S_EMPTY)) {
            this.m_sErrorMessage = S_MISSING_REFERENCE_PORT_NAME_PARAMETER + this.m_sReferencePortName;
            return false;
        }
        this.doLog("doAllParamsCheckOutOk(): reference port name ok: " + this.m_sReferencePortName);
        if (this.m_sPortdefPath == null || this.m_sPortdefPath.trim().equals(S_EMPTY)) {
            this.m_sErrorMessage = S_MISSING_PORT_DEF_PATH_PARAMETER;
            return false;
        }
        File fp = new File(this.m_sPortdefPath);
        if (!fp.exists() || !fp.isFile()) {
            this.m_sErrorMessage = S_MISSING_PORT_DEF_PATH_INVALID_PARAMETER + this.m_sPortdefPath;
            return false;
        }
        this.doLog("doAllParamsCheckOutOk(): port def path ok: " + this.m_sPortdefPath);
        if (this.m_sTemplatePortdefPath == null) {
            this.m_sErrorMessage = S_MISSING_TEMPLATE_PORT_DEF_PATH_PARAMETER;
            return false;
        }
        fp = new File(this.m_sTemplatePortdefPath);
        if (!fp.exists() || !fp.isFile()) {
            this.m_sErrorMessage = S_MISSING_TEMPLATE_PORT_DEF_PATH_INVALID_PARAMETER + this.m_sTemplatePortdefPath;
            return false;
        }
        this.doLog("doAllParamsCheckOutOk(): template port def path ok: " + this.m_sTemplatePortdefPath);
        return true;
    }
}

