/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.aggregation.tags;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.aggregation.tags.InsertReqWrapper;
import com.ibm.ws.portletcontainer.aggregation.tags.InsertRespWrapper;
import com.ibm.ws.portletcontainer.aggregation.tags.PortletStateHashtable;
import com.ibm.ws.portletcontainer.portletserving.core.PortletWindowIdentifier;
import com.ibm.ws.portletcontainer.portletserving.core.PortletWindowIdentifierImpl;
import com.ibm.ws.portletcontainer.util.PublicRenderParameterUpdateUtil;
import com.ibm.wsspi.portletcontainer.InvalidPortletWindowIdentifierException;
import com.ibm.wsspi.portletcontainer.ObjectID;
import com.ibm.wsspi.portletcontainer.ObjectIDAdapter;
import com.ibm.wsspi.portletcontainer.util.PortletURLHelper;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

class Utils {
    private static final String CLASS_NAME = Utils.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    protected static final String DEFAULT_WINDOWID = "default";
    protected static final String MODE = "mode";
    protected static final String RENDER_PARAM = "rparam";
    protected static final String STATE = "state";
    protected static String modeSuffix = ":mode";
    protected static String stateSuffix = ":state";
    protected static String rparamSuffix = ":rparam";

    protected Utils() {
    }

    protected static int getScope(String scope) {
        int scopeValue = 1;
        if (scope != null) {
            if ("request".equals(scope)) {
                scopeValue = 2;
            } else if ("session".equals(scope)) {
                scopeValue = 3;
            } else if ("application".equals(scope)) {
                scopeValue = 4;
            }
        }
        return scopeValue;
    }

    protected static String assembleURL(String prefix, String url, String windowId, String version, boolean action, boolean resource, String modeValue, String stateValue, Map rparams, String suffix, String URLQueryParams, String resourceId) {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "assembleURL()", "prefix: [" + prefix + "] url: [" + url + "] windowId: [" + windowId + "] action: [" + action + "] resource: [" + resource + "] modeValue: [" + modeValue + "] stateValue: [" + stateValue + "] rparams: [" + rparams + "] suffix: [" + suffix + "]  URLQueryParams: [" + URLQueryParams + "] resourceId: [" + resourceId + "]");
        }
        StringBuffer sb = new StringBuffer(100);
        if (prefix != null) {
            int inx2;
            int inx = prefix.indexOf("://");
            String prefixWithoutProtocolHost = null;
            if (inx >= 0 && (inx2 = (prefixWithoutProtocolHost = prefix.substring(inx + 3)).indexOf("/")) >= 0) {
                prefixWithoutProtocolHost = prefix.substring(0, inx + 3 + inx2 + 1);
            }
            if (prefixWithoutProtocolHost != null) {
                sb.append(prefixWithoutProtocolHost);
            } else {
                sb.append(prefix);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "assembleURL()", "prefix 2: [" + prefix + "]");
        }
        sb.append(url);
        if (windowId != null) {
            sb.append("/" + windowId);
        } else {
            sb.append("/default");
        }
        if (version != null && !resource) {
            sb.append("/ver=");
            sb.append(version);
        } else {
            sb.append("/ver=2.0");
        }
        if (action) {
            sb.append("/action");
        } else if (resource) {
            sb.append("/resource");
            if (resourceId != null) {
                sb.append("/id=");
                sb.append(resourceId);
            }
        }
        if (modeValue != null) {
            sb.append("/mode=" + modeValue);
        }
        if (stateValue != null) {
            sb.append("/state=" + stateValue);
        }
        if (rparams != null) {
            Set keySet = rparams.keySet();
            Iterator i = keySet.iterator();
            String key = null;
            String[] value = null;
            while (i.hasNext()) {
                key = (String)i.next();
                value = (String[])rparams.get(key);
                sb.append("/rparam=" + key);
                if (value == null) continue;
                for (int j = 0; j < value.length; ++j) {
                    sb.append("=" + PortletURLHelper.encodeParameter(value[j]));
                }
            }
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        if (URLQueryParams != null) {
            sb.append("?" + URLQueryParams);
        }
        return sb.toString();
    }

    protected static String getResponseAsString(PageContext pageContext, String context, String targetUrlWithoutContext, String portletURLPrefix, String portletURLSuffix, String portletURLQueryParams, String targetWindowId, String currentWindowId) throws IOException, JspException {
        return Utils.getResponseAsString(pageContext, context, targetUrlWithoutContext, portletURLPrefix, portletURLSuffix, portletURLQueryParams, targetWindowId, currentWindowId, null);
    }

    protected static String getResponseAsString(PageContext pageContext, String context, String targetUrlWithoutContext, String portletURLPrefix, String portletURLSuffix, String portletURLQueryParams, String targetWindowId, String currentWindowId, InsertRespWrapper insertRespWrapperArg) throws IOException, JspException {
        InsertRespWrapper insertRespWrapper;
        if (!(pageContext.getRequest() instanceof HttpServletRequest) || !(pageContext.getResponse() instanceof HttpServletResponse)) {
            throw new JspTagException("Relative &lt;insert&gt; from non-HTTP request not allowed.");
        }
        ServletContext servletContext = null;
        if (context != null) {
            if (!context.startsWith("/")) {
                context = "/" + context;
            }
            servletContext = pageContext.getServletContext().getContext(context);
        }
        if (servletContext == null) {
            throw new JspTagException("Unable to get RequestDispatcher for Context: [" + context + "] and URL: [" + targetUrlWithoutContext + "]. \n Verify values and/or enable cross context access.");
        }
        RequestDispatcher rd = servletContext.getRequestDispatcher(targetUrlWithoutContext);
        if (rd == null) {
            throw new JspTagException("Unable to get RequestDispatcher for Context: [" + context + "] and URL: [" + targetUrlWithoutContext + "]. \n Verify values and/or enable cross context access.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getResponseAsString()", "targetUrlWithoutContext: [" + targetUrlWithoutContext + "] rd: [" + rd + "]");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getResponseAsString()", "insertRespWrapperArg: [" + insertRespWrapperArg + "]");
        }
        if ((insertRespWrapper = insertRespWrapperArg) == null) {
            insertRespWrapper = new InsertRespWrapper((HttpServletResponse)pageContext.getResponse());
        }
        HttpServletRequest orgServletRequest = (HttpServletRequest)pageContext.getRequest();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getResponseAsString()", "orgServletRequest: [" + orgServletRequest + "]");
        }
        orgServletRequest.setAttribute("com.ibm.wsspi.portlet.url.prefix", portletURLPrefix);
        if (portletURLSuffix != null && portletURLSuffix != "") {
            orgServletRequest.setAttribute("com.ibm.wsspi.portlet.url.suffix", portletURLSuffix);
        }
        if (portletURLQueryParams != null && portletURLQueryParams != "") {
            orgServletRequest.setAttribute("com.ibm.wsspi.portlet.url.queryparams", portletURLQueryParams);
        }
        InsertReqWrapper insertReqWrapper = new InsertReqWrapper(orgServletRequest, targetWindowId, currentWindowId);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getResponseAsString()", "insertReqWrapper: [" + insertReqWrapper + "]");
            logger.logp(Level.FINE, CLASS_NAME, "getResponseAsString()", "insertRespWrapper: [" + insertRespWrapper + "]");
        }
        try {
            rd.include(insertReqWrapper, insertRespWrapper);
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.portletcontainer.aggregation.tags.Utils.getResponseAsString", (String)"183");
            throw new JspException(ex);
        }
        catch (RuntimeException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.portletcontainer.aggregation.tags.Utils.getResponseAsString", (String)"186");
            throw new JspException(ex);
        }
        catch (ServletException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.portletcontainer.aggregation.tags.Utils.getResponseAsString", (String)"189");
            Throwable rc = ex.getRootCause();
            if (rc == null) {
                throw new JspException(ex);
            }
            throw new JspException(rc);
        }
        finally {
            pageContext.getRequest().removeAttribute("com.ibm.wsspi.portlet.url.prefix");
            pageContext.getRequest().removeAttribute("com.ibm.wsspi.portlet.url.suffix");
            pageContext.getRequest().removeAttribute("com.ibm.wsspi.portlet.url.queryparams");
        }
        return insertRespWrapper.getString(null);
    }

    static void updatePublicRenderParameter(PortletWindowIdentifier sourcePWI, Map renderParameter, ServletRequest request) throws InvalidPortletWindowIdentifierException {
        Map portalScope;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "updateSharedRenderParameter", new Object[]{renderParameter, request});
        }
        if ((portalScope = (Map)request.getAttribute("com.ibm.ws.portletcontainer.portletserving.portal_scope")) != null) {
            Set keys = portalScope.keySet();
            HttpSession session = ((HttpServletRequest)request).getSession();
            for (String currentPortletUrl : keys) {
                Map valueMap = (Map)portalScope.get(currentPortletUrl);
                List portletWindows = (List)valueMap.get("com.ibm.ws.portletcontainer.portletserving.portal_scope.windowids");
                for (PortletWindowIdentifier portletWindow : portletWindows) {
                    Map<String, String[]> renderParameter_window = PortletStateHashtable.getRenderParameters(session, (com.ibm.wsspi.portletcontainer.PortletWindowIdentifier)portletWindow);
                    Map newRenderParameter = PublicRenderParameterUpdateUtil.getMergedRenderParameters((com.ibm.wsspi.portletcontainer.PortletWindowIdentifier)sourcePWI, (com.ibm.wsspi.portletcontainer.PortletWindowIdentifier)portletWindow, renderParameter_window, (Map)renderParameter);
                    PortletStateHashtable.setRenderParameter(session, (com.ibm.wsspi.portletcontainer.PortletWindowIdentifier)portletWindow, newRenderParameter);
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "updateSharedRenderParameter");
        }
    }

    static PortletWindowIdentifier createPortletWindowIdentifier(String context, String portletname, String windowId) throws InvalidPortletWindowIdentifierException {
        PortletWindowIdentifierImpl pwi = null;
        String portletWindowId = portletname + "_" + windowId;
        ObjectIDAdapter portletWindowOID = new ObjectIDAdapter(portletWindowId);
        pwi = new PortletWindowIdentifierImpl(context, portletname, (ObjectID)portletWindowOID);
        return pwi;
    }

    static Map getScopeValues(ServletRequest request, String portletURL) {
        Map portalScope = (Map)request.getAttribute("com.ibm.ws.portletcontainer.portletserving.portal_scope");
        if (portalScope == null) {
            return null;
        }
        String internalURL = null;
        internalURL = !portletURL.startsWith("/") ? "/" + portletURL : portletURL;
        Set registeredURLs = portalScope.keySet();
        String currentURL = null;
        int longestMatch = -1;
        for (String tempURL : registeredURLs) {
            if (!internalURL.startsWith(tempURL) || longestMatch >= tempURL.length()) continue;
            currentURL = tempURL;
            longestMatch = tempURL.length();
        }
        Map scopeValues = (Map)portalScope.get(currentURL);
        return scopeValues;
    }
}

