/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wasresource.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.management.Session;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wasresource.common.WASResource;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import com.ibm.ws.management.wasresource.common.WASResourceTypeRegistry;
import com.ibm.ws.management.wasresource.common.WASResourcesConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import javax.xml.namespace.QName;

public class WASResourceManager
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(WASResourceManager.class, null, null);
    private static WASResourceManager wasResMgr = new WASResourceManager();
    private Set wasresource;
    private WASResourceTypeRegistry resTypeReg;

    private WASResourceManager() {
        String METHOD_NAME = "init";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.initialize();
        this.registerAlarm();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public static WASResourceManager getInstance() {
        return wasResMgr;
    }

    private void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", this);
        }
        this.resTypeReg = WASResourceTypeRegistry.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this.resTypeReg);
        }
    }

    private void registerAlarm() {
    }

    public Set getWasresource() {
        return this.wasresource;
    }

    public void setWasresource(Set theWasresource) {
        this.wasresource = theWasresource;
    }

    public WASResource createResource(HashMap eprRefProps) throws WASResourceInitializeException {
        return this.createResource(eprRefProps, null);
    }

    public WASResource createResource(HashMap eprRefProps, Session session) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResource", eprRefProps);
        }
        WASResource res = this.resTypeReg.createResourceTypeInstance(eprRefProps, session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResource", res);
        }
        return res;
    }

    public List createResourceExtension(HashMap eprRefProps, Session session) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceExtension", new Object[]{eprRefProps, session});
        }
        List resList = this.resTypeReg.createResourceExtTypeInstances(eprRefProps, session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceExtension", resList);
        }
        return resList;
    }

    public List createResourceExtension(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceExtension", eprRefProps);
        }
        List resList = this.createResourceExtension(eprRefProps, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceExtension", resList);
        }
        return resList;
    }

    public WASResource getResource(HashMap eprRefProps, String scope, String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResource", new Object[]{eprRefProps, scope, resourceName, this});
        }
        WASResource res = this.resTypeReg.getResourceTypeInstance(eprRefProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", res);
        }
        return res;
    }

    public List queryResource(String resourceType, String locationPath) {
        return this.queryResource(null, resourceType, locationPath);
    }

    public List queryResource(Session session, String resourceType, ObjectName scope, String locationPath) {
        List result;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "queryResource", new Object[]{resourceType, scope, locationPath, this});
            }
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(WASResourcesConstants.WAS_WSDM_Resource_Type, resourceType);
            result = null;
            try {
                WASResource res = this.resTypeReg.getResourceTypeObject(props);
                result = res.getResourceInstances(session, scope, locationPath);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wasresource.resource.WASResourceManager.queryResource", (String)"97", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "No resources type: " + resourceType + ", locationPath: " + locationPath + " found", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryResource", result);
        }
        return result;
    }

    public List queryResource(Session session, String resourceType, String locationPath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryResource", new Object[]{resourceType, locationPath, this});
        }
        List result = this.queryResource(session, resourceType, null, locationPath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryResource", result);
        }
        return result;
    }

    public Set getAllResourceTypes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllResourceTypes");
        }
        Set result = this.resTypeReg.getAllTypes();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllResourceTypes", result);
        }
        return result;
    }

    public void destroy() {
    }

    public synchronized void alarm(Object alarmContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", new Object[]{alarmContext, this});
        }
        this.resTypeReg.cleanResgistryEntries();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }
}

