/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.transform.ConfigTransformer;
import com.ibm.websphere.management.transform.ConfigTransformerWithDocUri;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.TransformRepository;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class TransformMap {
    private String docName;
    private List transformURIs;
    private List scopes;
    private String customClassName;
    private String customClassPath;
    private TransformClassLoader customClassLoader;
    private boolean transformNamespaces = false;

    public TransformMap(String docName, List transformURIs, List scopes, boolean transformNamespaces) {
        this.docName = docName;
        this.transformURIs = transformURIs;
        this.scopes = scopes;
        this.transformNamespaces = transformNamespaces;
    }

    public TransformMap(String docName, List scopes, String className, String classPath, boolean transformNamespaces) {
        this.docName = docName;
        this.scopes = scopes;
        this.customClassName = className;
        this.customClassPath = classPath;
        this.transformNamespaces = transformNamespaces;
        this.customClassLoader = new TransformClassLoader();
        this.customClassLoader.addPath(classPath);
    }

    public String getDocName() {
        return this.docName;
    }

    public List getTransformURIs() {
        return this.transformURIs;
    }

    public List getTransformStreams() throws RepositoryException {
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        Iterator i = this.transformURIs.iterator();
        while (i.hasNext()) {
            InputStream input = TransformRepository.extract((String)i.next());
            streams.add(input);
        }
        return streams;
    }

    public List getScopes() {
        return this.scopes;
    }

    public boolean transformNamespaces() {
        return this.transformNamespaces;
    }

    public String getCustomClassName() {
        return this.customClassName;
    }

    public String getCustomClassPath() {
        return this.customClassPath;
    }

    public ConfigTransformer getCustomTransformer() {
        ConfigTransformer transformer = null;
        try {
            Class<?> c = this.customClassLoader.loadClass(this.customClassName);
            try {
                transformer = (ConfigTransformer)c.newInstance();
            }
            catch (ClassCastException cce) {
                return null;
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.TransformMap.TransformClassLoader.getCustomTransformer", (String)"160", (Object)this);
        }
        return transformer;
    }

    protected ConfigTransformerWithDocUri getCustomTransformerWithDocUri() {
        ConfigTransformerWithDocUri transformer = null;
        try {
            Class<?> c = this.customClassLoader.loadClass(this.customClassName);
            transformer = (ConfigTransformerWithDocUri)c.newInstance();
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.TransformMap.TransformClassLoader.getCustomTransformer", (String)"160", (Object)this);
        }
        return transformer;
    }

    class TransformClassLoader
    extends URLClassLoader {
        private ArrayList descriptorPath;

        TransformClassLoader() {
            super(new URL[0], Thread.currentThread().getContextClassLoader());
            this.descriptorPath = new ArrayList();
        }

        public void addPath(String path) {
            if (path != null) {
                StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
                while (st.hasMoreTokens()) {
                    File f = new File(st.nextToken());
                    try {
                        f = f.getCanonicalFile();
                    }
                    catch (IOException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.transform.TransformMap.TransformClassLoader.addPath", (String)"188", (Object)this);
                    }
                    try {
                        URL url = f.toURL();
                        if (this.descriptorPath.contains(url)) continue;
                        this.descriptorPath.add(url);
                        super.addURL(url);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.transform.TransformMap.TransformClassLoader.addPath", (String)"203", (Object)this);
                    }
                }
            }
        }
    }
}

