/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.TransformRepository;
import java.util.ArrayList;

public class TransformCacheInvalidator {
    private static ArrayList releases = new ArrayList();
    private static ConfigRepository repository = null;
    private static boolean initialized = false;
    private static TraceComponent tc = Tr.register(TransformCacheInvalidator.class, "Transform", "com.ibm.ws.management.resources.sync");

    public static void initialize(ConfigRepository cr) {
        TransformCacheInvalidator.initialize(cr, false);
    }

    public static synchronized void initialize(ConfigRepository cr, boolean keepCache) {
        if (!initialized) {
            repository = cr;
            String[] docs = TransformRepository.getReleaseFolderList();
            if (docs.length > 0) {
                for (int i = 0; i < docs.length; ++i) {
                    String folder = "xformed/" + docs[i];
                    releases.add(folder + "/");
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Adding folder to list: " + folder);
                }
            }
            if (!keepCache) {
                TransformCacheInvalidator.invalidateAll();
            }
            initialized = true;
        }
    }

    static void addRelease(String release) {
        String folder = "xformed/" + release + "/";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding folder to release list: " + folder);
        }
        releases.add(folder);
    }

    public static void invalidate(String docURI) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invalidate transform cache for " + docURI);
        }
        if (!docURI.startsWith("xformed")) {
            for (String release : releases) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Attempting to delete " + release + docURI);
                    }
                    repository.delete(release + docURI);
                }
                catch (DocumentNotFoundException e) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Did not exist: " + release + docURI);
                }
                catch (RepositoryException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to delete " + release + docURI);
                    }
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.transform.TransformCacheInvalidator.invalidate", (String)"93");
                }
            }
        }
    }

    public static void invalidateAll() {
        String[] docs = repository.listResourceNames("xformed", 1, Integer.MAX_VALUE);
        if (docs.length > 0) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleting " + docs.length + " cached transformed documents");
                }
                repository.delete(docs);
            }
            catch (RepositoryException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.transform.TransformCacheInvalidator.invalidateAll", (String)"120");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no cached transformed documents to delete");
        }
    }
}

