/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ws.management.transform.TransformException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NamespaceTransformer {
    private Map namespaceMapping = new HashMap();

    public NamespaceTransformer(Reader xmlConfig) throws TransformException {
        this.parseConfigDoc(xmlConfig);
    }

    public NamespaceTransformer(List xmlConfigs) throws TransformException {
        Iterator i = xmlConfigs.iterator();
        while (i.hasNext()) {
            this.parseConfigDoc((Reader)i.next());
        }
    }

    public void transform(Reader xmlSource, Writer xmlResult) throws TransformException {
        try {
            boolean startedHeader = false;
            boolean startedElement = false;
            int c = 0;
            while ((c = xmlSource.read()) != -1) {
                xmlResult.write(c);
                if (c == 61) {
                    xmlResult.write(this.convertAttribute(xmlSource));
                    continue;
                }
                if (c == 60) {
                    if (startedHeader) {
                        startedElement = true;
                        continue;
                    }
                    startedHeader = true;
                    continue;
                }
                if (c != 62 || !startedElement) continue;
            }
            while ((c = xmlSource.read()) != -1) {
                xmlResult.write(c);
            }
        }
        catch (IOException exc) {
            throw new TransformException(exc);
        }
    }

    private String convertAttribute(Reader xmlSource) throws TransformException {
        StringBuffer readBuffer = new StringBuffer();
        StringBuffer writeBuffer = new StringBuffer();
        char startQuote = ' ';
        try {
            while (true) {
                int ci;
                if ((ci = xmlSource.read()) == -1) {
                    writeBuffer.append(readBuffer.toString());
                    break;
                }
                char c = (char)ci;
                if (startQuote == ' ') {
                    if (c == '\"' || c == '\'') {
                        startQuote = c;
                    }
                    writeBuffer.append(c);
                    continue;
                }
                if (c == startQuote) {
                    String oldns = readBuffer.toString().trim();
                    String newns = (String)this.namespaceMapping.get(oldns);
                    if (newns == null) {
                        newns = oldns;
                    }
                    writeBuffer.append(newns);
                    break;
                }
                readBuffer.append(c);
            }
        }
        catch (IOException exc) {
            throw new TransformException(exc);
        }
        writeBuffer.append(startQuote);
        return writeBuffer.toString();
    }

    private void parseConfigDoc(Reader xmlConfig) throws TransformException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            InputSource source = new InputSource(xmlConfig);
            NamespaceConfigDocumentHandler handler = new NamespaceConfigDocumentHandler();
            parser.parse(source, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException exc) {
            throw new TransformException(exc);
        }
        catch (SAXException exc) {
            throw new TransformException(exc);
        }
        catch (IOException exc) {
            throw new TransformException(exc);
        }
    }

    protected boolean mapIsEmpty() {
        return this.namespaceMapping.size() == 0;
    }

    class NamespaceConfigDocumentHandler
    extends DefaultHandler {
        private StringBuffer charBuffer = null;
        private String sourcens;
        private String resultns;

        NamespaceConfigDocumentHandler() {
        }

        public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
            this.charBuffer = new StringBuffer();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.charBuffer.append(ch, start, length);
        }

        public void endElement(String uri, String localName, String qname) throws SAXException {
            if (qname.equals("xmlns-source")) {
                this.sourcens = this.charBuffer.toString();
            } else if (qname.equals("xmlns-result")) {
                this.resultns = this.charBuffer.toString();
                NamespaceTransformer.this.namespaceMapping.put(this.sourcens, this.resultns);
            }
        }
    }
}

