/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.cellmanager.CellManager;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.ws.management.connector.ConnectorHelper;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.tools.GenericServerProcHelper;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class ServerStatus
extends AdminTool {
    private static TraceComponent tc = Tr.register(ServerStatus.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "*=all=disabled";
    private static final String DEFAULT_TRACE_FILE = "serverStatus.log";
    private boolean allservers = false;
    private AdminClient adminClient = null;
    private ServerIdentifiers sid = null;
    private static final String WSSERVER_CLASS = "com.ibm.ws.runtime.WsServer";
    private VariableMap variableMap = null;
    private Repository repository = null;

    public static void main(String[] args) {
        System.exit(new ServerStatus().executeUtility(args));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        if (!this.allservers) {
            defaultTraceFile = defaultTraceFile + File.separator + this.sid.getServerName();
        }
        defaultTraceFile = defaultTraceFile + File.separator + DEFAULT_TRACE_FILE;
        return defaultTraceFile;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected boolean isValidMinimumArgument(String arg) {
        return !arg.startsWith("-") || arg.equals("-all");
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU0502I", null, null);
    }

    protected int parseRequiredArgs(String[] args) {
        this.sid = new ServerIdentifiers();
        this.sid.setConfigRoot(args[0]);
        this.sid.setCellName(args[1]);
        this.sid.setNodeName(args[2]);
        if (args[3].equals("-all")) {
            this.allservers = true;
        } else {
            this.sid.setServerName(args[3]);
        }
        return 4;
    }

    protected int runTool() throws Exception {
        String statusTarget = "all servers";
        if (!this.allservers) {
            statusTarget = this.sid.getServerName();
            if (!this.serverConfigExists(this.sid)) {
                this.issueMessage("ADMU0522E", new Object[]{this.sid.getServerName()}, null);
                return -1;
            }
        }
        if (!this.allservers) {
            this.issueMessage("ADMU0500I", new Object[]{statusTarget}, null);
        } else {
            this.issueMessage("ADMU0503I", null, null);
        }
        Vector<String> servers = null;
        if (this.allservers) {
            servers = this.getServers();
        } else {
            servers = new Vector<String>();
            servers.add(this.sid.getServerName());
        }
        for (int i = 0; i < servers.size(); ++i) {
            String server = (String)servers.get(i);
            this.getStatus(server);
        }
        return 0;
    }

    private void getStatus(String serverName) {
        block11: {
            AdminClient admin = null;
            this.sid.setServerName(serverName);
            try {
                String preferredConnector;
                String localAdminProtocol;
                ConfigService configService = ConfigServiceFactory.createConfigService((String)this.sid.getConfigRoot(), (String)this.sid.getCellName(), (String)this.sid.getNodeName(), (String)this.sid.getServerName());
                this.repository = RepositoryFactory.createRepository((String)"ws-server", (String)this.sid.getConfigRoot(), (String)this.sid.getCellName(), (String)this.sid.getNodeName(), (String)this.sid.getServerName());
                this.variableMap = VariableMapFactory.createVariableMap((Repository)this.repository);
                this.variableMap.initialize(null);
                if (GenericServerProcHelper.isServerAWebServer(this.sid)) {
                    String status = GenericServerProcHelper.getStatusUsingPing(this.sid);
                    this.issueMessage("ADMU0508I", new Object[]{"Web server", serverName, status}, null);
                    return;
                }
                if (GenericServerProcHelper.isServerAGenericServer(this.sid)) {
                    String status = GenericServerProcHelper.getStatusUsingPidFile(this.sid);
                    this.issueMessage("ADMU0508I", new Object[]{"generic server", serverName, status}, null);
                    return;
                }
                Resource resource = this.repository.getConfigRoot().getResource(4, "server.xml");
                String serverType = this.getServerType(resource);
                ConnectorHelper helper = new ConnectorHelper(configService, this.variableMap, null, "localhost", null, false, this.userid, this.pwd);
                ArrayList<String> protocols = new ArrayList<String>();
                String remoteAdminProtocol = helper.getRemoteAdminProtocol();
                if (remoteAdminProtocol != null) {
                    protocols.add(remoteAdminProtocol);
                }
                if ((localAdminProtocol = helper.getLocalAdminProtocol()) != null) {
                    protocols.add(localAdminProtocol);
                }
                if ((preferredConnector = helper.getPreferredConnector()) != null) {
                    protocols.add(preferredConnector);
                }
                try {
                    admin = helper.createConnector(protocols, true);
                }
                catch (Throwable ex) {
                    this.issueMessage("ADMU0509I", new Object[]{serverType, serverName}, null);
                    return;
                }
                if (admin == null) break block11;
                String status = null;
                try {
                    status = this.getServerStatus(admin);
                }
                catch (OutOfMemoryError oom) {
                    this.issueMessage("ADMU0002E", new Object[]{serverName, oom}, null);
                    Tr.error(tc, "ADMU0002E", new Object[]{serverName, oom});
                    return;
                }
                this.issueMessage("ADMU0508I", new Object[]{serverType, serverName, status}, null);
            }
            catch (Exception e) {
                Tr.error(tc, "ADMU0002E", new Object[]{this.sid.getServerName(), e});
                this.issueMessage("ADMU0002E", new Object[]{serverName, e}, null);
            }
        }
    }

    private String getServerType(Resource res) {
        Server server = (Server)res.getContents().get(0);
        EList componentList = server.getComponents();
        for (Component c : componentList) {
            if (c instanceof CellManager) {
                return "Deployment Manager";
            }
            if (c instanceof NodeAgent) {
                return "Node Agent";
            }
            if (c instanceof ApplicationServer) {
                return "Application Server";
            }
            if (!(c instanceof JMSServer)) continue;
            return "JMS Server";
        }
        return "Server";
    }

    private String getServerStatus(AdminClient admin) throws Exception {
        String status = null;
        ObjectName server = this.getServerHandle(admin);
        status = server != null ? (String)admin.getAttribute(server, "state") : "RUNTIME/CONFIG MISMATCH";
        return status;
    }

    private boolean serverConfigExists(ServerIdentifiers sid) {
        boolean exists = false;
        String serverPath = sid.getConfigRoot() + "/cells/" + sid.getCellName() + "/nodes/" + sid.getNodeName() + "/servers/" + sid.getServerName();
        File serverDir = new File(serverPath);
        if (serverDir.exists()) {
            exists = true;
        }
        return exists;
    }
}

