/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.IPCConnector;
import com.ibm.websphere.models.config.adminservice.JMXConnector;
import com.ibm.websphere.models.config.adminservice.JSR160RMIConnector;
import com.ibm.websphere.models.config.adminservice.RMIConnector;
import com.ibm.websphere.models.config.adminservice.SOAPConnector;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.ConfigRootFactory;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class LaunchUtils {
    private static TraceComponent tc = Tr.register(LaunchUtils.class, "Admin", AdminTool.BUNDLE_NAME);
    private static ResourceBundle bundle = ResourceBundle.getBundle(AdminTool.BUNDLE_NAME, Locale.getDefault());
    private static ConfigRoot _cfgRoot = null;
    private static String cellName = null;
    private static String nodeName = null;

    public static String getFormattedMessage(String key, Object[] args, String defaultString) {
        try {
            String result = bundle.getString(key);
            if (result == null) {
                return defaultString;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (defaultString == null) {
                return defaultString;
            }
            return MessageFormat.format(defaultString, args);
        }
        catch (NullPointerException npe) {
            return defaultString;
        }
    }

    public static int retcodeFromMessage(String msg) {
        int ret = 0;
        if (msg == null) {
            return ret;
        }
        if (msg.startsWith("ADMU")) {
            String intpart = msg.substring(4, 8);
            try {
                ret = Integer.parseInt(intpart);
            }
            catch (NumberFormatException nfe) {
                ret = -1;
            }
        }
        return ret;
    }

    public static int issueMessage(String key, Object[] args, String inputmsg, boolean verbose) {
        String msg = LaunchUtils.getFormattedMessage(key, args, inputmsg);
        if (verbose) {
            System.out.println(msg);
        }
        return LaunchUtils.retcodeFromMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getStatus(Socket s) {
        FilterInputStream dataInput;
        InputStream socketInput;
        int status;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getStatus");
            }
            status = -1;
            socketInput = null;
            dataInput = null;
            socketInput = s.getInputStream();
            dataInput = new DataInputStream(socketInput);
            status = ((DataInputStream)dataInput).readInt();
            Object var7_4 = null;
            try {
                dataInput.close();
                socketInput.close();
                break block10;
            }
            catch (IOException e2) {
                Tr.error(tc, "ADMU3009E", e2);
            }
            {
                break block10;
                catch (IOException e) {
                    Tr.error(tc, "ADMU3009E", e);
                    int n = -1;
                    Object var7_5 = null;
                    try {
                        dataInput.close();
                        socketInput.close();
                    }
                    catch (IOException e2) {
                        Tr.error(tc, "ADMU3009E", e2);
                    }
                    dataInput = null;
                    socketInput = null;
                    return n;
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    dataInput.close();
                    socketInput.close();
                }
                catch (IOException e2) {
                    Tr.error(tc, "ADMU3009E", e2);
                }
                dataInput = null;
                socketInput = null;
                throw throwable;
            }
        }
        dataInput = null;
        socketInput = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatus", status);
        }
        return status;
    }

    public static ServerSocket getFreePort(int timeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFreePort");
        }
        ServerSocket s = null;
        try {
            s = new ServerSocket(0);
            s.setSoTimeout(timeout);
        }
        catch (IOException ioe) {
            Tr.error(tc, "ADMU3012E", ioe);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFreePort");
        }
        return s;
    }

    public static int waitForServerInit(ServerSocket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForServerInit");
        }
        Socket acceptedSocket = null;
        boolean statusReceived = false;
        boolean timedOut = false;
        int result = 0;
        while (!statusReceived && !timedOut) {
            try {
                acceptedSocket = socket.accept();
            }
            catch (InterruptedIOException e) {
                acceptedSocket = null;
                timedOut = true;
            }
            catch (IOException ioe) {
                Tr.error(tc, "ADMU3009E", ioe);
                acceptedSocket = null;
                statusReceived = true;
                result = -1;
            }
            if (acceptedSocket == null || (result = LaunchUtils.getStatus(acceptedSocket)) != 0) continue;
            statusReceived = true;
        }
        if (!statusReceived) {
            result = -2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForServerInit", result);
        }
        return result;
    }

    public static int waitForServer(ServerSocket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForServer");
        }
        Socket acceptedSocket = null;
        boolean statusReceived = false;
        boolean timedOut = false;
        int result = 0;
        while (!statusReceived && !timedOut) {
            try {
                acceptedSocket = socket.accept();
            }
            catch (InterruptedIOException e) {
                acceptedSocket = null;
                timedOut = true;
            }
            catch (IOException ioe) {
                Tr.error(tc, "ADMU3019E", ioe);
                acceptedSocket = null;
                statusReceived = true;
                result = -10;
            }
            if (acceptedSocket == null || (result = LaunchUtils.getStatus(acceptedSocket)) != 0) continue;
            statusReceived = true;
        }
        if (!statusReceived) {
            result = -11;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForServer", result);
        }
        return result;
    }

    private static ResourceSet getResourceSet(final String configRoot) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceSet: ", configRoot);
        }
        LaunchUtils.initializeModel();
        WASResourceSetImpl rs = new WASResourceSetImpl();
        URIConverterImpl uric = new URIConverterImpl(){

            public URI normalize(URI uri) {
                if (uri.isRelative()) {
                    return uri.resolve(URI.createFileURI(configRoot + File.separator));
                }
                return super.normalize(uri);
            }
        };
        rs.setURIConverter(uric);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceSet: ", rs);
        }
        return rs;
    }

    public static AdminClient getAdminClient(JMXConnector connector2, String configRoot, String cellName, String nodeName, String serverName, String username, String password) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient", new Object[]{configRoot, cellName, nodeName, serverName, username});
        }
        LaunchUtils.cellName = cellName;
        LaunchUtils.nodeName = nodeName;
        _cfgRoot = ConfigRootFactory.createConfigRoot((String)configRoot, null, null, null, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_cfgRootPath = " + _cfgRoot.getConfigRootPath());
        }
        String path = "cells/" + cellName + "/nodes/" + nodeName + "/serverindex.xml";
        ResourceSet set = LaunchUtils.getResourceSet(configRoot);
        URI uri = URI.createFileURI(path);
        Resource res = set.getResource(uri, true);
        ServerIndex si = (ServerIndex)res.getContents().get(0);
        path = "cells/" + cellName + "/security.xml";
        uri = URI.createFileURI(path);
        res = set.getResource(uri, true);
        Security secCfg = (Security)res.getContents().get(0);
        boolean secEnabled = secCfg.isEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return LaunchUtils.getAdminClient(si, serverName, connector2, secEnabled, username, password);
    }

    public static AdminClient getAdminClient(Repository repository2, JMXConnector connector2, String username, String password) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient", new Object[]{"repository", username});
        }
        nodeName = repository2.getNodeName();
        String serverName = repository2.getServerName();
        ConfigRoot cfgRoot = repository2.getConfigRoot();
        cellName = repository2.getCellName();
        _cfgRoot = cfgRoot;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cfgRoot " + _cfgRoot);
        }
        String oldNode = cfgRoot.getValue(3);
        cfgRoot.setValue(3, nodeName);
        Resource r = cfgRoot.getResource(3, "serverindex.xml");
        ServerIndex si = (ServerIndex)r.getContents().get(0);
        cfgRoot.setValue(3, oldNode);
        boolean secEnabled = LaunchUtils.isSecurityEnabled(repository2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return LaunchUtils.getAdminClient(si, serverName, connector2, secEnabled, username, password);
    }

    private static AdminClient getAdminClient(ServerIndex si, String serverName, JMXConnector connector2, boolean secEnabled, String username, String password) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient", new Object[]{"serverindex", serverName});
        }
        AdminClient _admin = null;
        Properties connProps = new Properties();
        if (secEnabled) {
            connProps.setProperty("securityEnabled", "true");
        }
        if (username != null) {
            connProps.setProperty("username", username);
        }
        if (password != null) {
            connProps.setProperty("password", password);
        }
        if (connector2 instanceof SOAPConnector) {
            connProps.setProperty("type", "SOAP");
            LaunchUtils.loadSOAPConnectorData(si, serverName, connProps);
        } else if (connector2 instanceof RMIConnector) {
            connProps.setProperty("type", "RMI");
            LaunchUtils.loadRMIConnectorData(si, serverName, connProps);
        } else if (connector2 instanceof JSR160RMIConnector) {
            connProps.setProperty("type", "JSR160RMI");
            LaunchUtils.loadRMIConnectorData(si, serverName, connProps);
        } else if (connector2 instanceof IPCConnector) {
            connProps.setProperty("type", "IPC");
            LaunchUtils.loadIPCConnectorData(si, serverName, connProps);
        }
        EList wccmProperties = connector2.getProperties();
        for (int i = 0; i < wccmProperties.size(); ++i) {
            Property p = (Property)wccmProperties.get(i);
            if (p.getName().equals("host")) {
                connProps.setProperty("host", p.getValue());
            }
            if (!p.getName().equals("port")) continue;
            connProps.setProperty("port", p.getValue());
        }
        if (connProps.getProperty("host") == null) {
            connProps.setProperty("host", "localhost");
        }
        if (connProps.getProperty("type") == null) {
            connProps.setProperty("type", "SOAP");
            if (connProps.getProperty("port") == null) {
                connProps.setProperty("port", "8880");
            }
        }
        _admin = AdminClientFactory.createAdminClient(connProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return _admin;
    }

    private static void loadSOAPConnectorData(ServerIndex si, String serverName, Properties connProps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadSOAPConnectorData");
        }
        String name = "SOAP_CONNECTOR_ADDRESS";
        EList entries = si.getServerEntries();
        int n = entries.size();
        for (int i = 0; i < n; ++i) {
            ServerEntry se = (ServerEntry)entries.get(i);
            if (!se.getServerName().equals(serverName)) continue;
            EList namedEPs = se.getSpecialEndpoints();
            int m = namedEPs.size();
            for (int j = 0; j < m; ++j) {
                NamedEndPoint namedEndPt = (NamedEndPoint)namedEPs.get(j);
                if (!namedEndPt.getEndPointName().equals("SOAP_PROXY_CONNECTOR_ADDRESS") || !se.getServerType().equals("DEPLOYMENT_MANAGER")) continue;
                name = "SOAP_PROXY_CONNECTOR_ADDRESS";
            }
        }
        LaunchUtils.loadNamedEndPoint(si, serverName, connProps, name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadSOAPConnectorData");
        }
    }

    private static void loadRMIConnectorData(ServerIndex si, String serverName, Properties connProps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadRMIConnectorData");
        }
        LaunchUtils.loadNamedEndPoint(si, serverName, connProps, "BOOTSTRAP_ADDRESS");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadRMIConnectorData");
        }
    }

    private static void loadIPCConnectorData(ServerIndex si, String serverName, Properties connProps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadIPCConnectorData");
        }
        LaunchUtils.loadNamedEndPoint(si, serverName, connProps, "IPC_CONNECTOR_ADDRESS");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadIPCConnectorData");
        }
    }

    private static void loadNamedEndPoint(ServerIndex si, String serverName, Properties connProps, String name) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadNamedEndPoint", new Object[]{serverName, name});
        }
        VariableMap variableMap = null;
        if (_cfgRoot != null) {
            variableMap = LaunchUtils.getVariableMap(_cfgRoot.getConfigRootPath(), cellName, nodeName, serverName);
        }
        EList entries = si.getServerEntries();
        int n = entries.size();
        block0: for (int i = 0; i < n; ++i) {
            ServerEntry se = (ServerEntry)entries.get(i);
            if (!se.getServerName().equals(serverName)) continue;
            EList namedEPs = se.getSpecialEndpoints();
            int m = namedEPs.size();
            for (int j = 0; j < m; ++j) {
                NamedEndPoint namedEndPt = (NamedEndPoint)namedEPs.get(j);
                if (!namedEndPt.getEndPointName().equals(name)) continue;
                EndPoint endPt = namedEndPt.getEndPoint();
                String port = new Integer(endPt.getPort()).toString();
                String host = endPt.getHost();
                if (variableMap != null) {
                    host = variableMap.expand(host);
                    port = variableMap.expand(port);
                }
                connProps.setProperty("host", host);
                connProps.setProperty("port", port);
                if (!tc.isDebugEnabled()) continue block0;
                Tr.debug(tc, "{host, port}", new Object[]{host, port});
                continue block0;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadNamedEndPoint");
        }
    }

    private static boolean isSecurityEnabled(Repository repository2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityEnabled");
        }
        boolean enabled = false;
        Object uid = null;
        Object passwd = null;
        try {
            Resource r = repository2.getConfigRoot().getResource(0, "security.xml");
            Security secCfg = (Security)r.getContents().get(0);
            enabled = secCfg.isEnabled();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecurityEnabled", enabled);
        }
        return enabled;
    }

    public static JMXConnector getJMXConnector(String configRoot, String cellName, String nodeName, String serverName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJMXConnector", new Object[]{configRoot, cellName, nodeName, serverName});
        }
        String serverPath = "cells/" + cellName + "/nodes/" + nodeName + "/servers/" + serverName + "/server.xml";
        ResourceSet set = LaunchUtils.getResourceSet(configRoot);
        URI uri = URI.createFileURI(serverPath);
        Resource res = set.getResource(uri, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJMXConnector");
        }
        return LaunchUtils.getJMXConnector(res);
    }

    public static JMXConnector getJMXConnector(Resource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJMXConnector");
        }
        JMXConnector connector2 = null;
        Server server = LaunchUtils.getServer(res);
        AdminService admin = null;
        EList services = server.getServices();
        for (int i = 0; i < services.size(); ++i) {
            Service service = (Service)services.get(i);
            if (!(service instanceof AdminService)) continue;
            admin = (AdminService)service;
            break;
        }
        if (admin != null) {
            connector2 = admin.getLocalAdminProtocol();
            if (connector2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using localAdminProtocol " + connector2);
                }
            } else {
                connector2 = admin.getRemoteAdminProtocol();
                if (connector2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using remoteAdminProtocol " + connector2);
                    }
                } else {
                    connector2 = admin.getPreferredConnector();
                    if (connector2 != null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using preferredConnector " + connector2);
                    }
                }
            }
            if (connector2 == null || !connector2.isEnable()) {
                connector2 = null;
                EList connectors = admin.getConnectors();
                for (int j = 0; j < connectors.size(); ++j) {
                    JMXConnector tmp = (JMXConnector)connectors.get(j);
                    if (!tmp.isEnable()) continue;
                    connector2 = tmp;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Using arbitrary available connector: " + connector2);
                    break;
                }
            }
            if (connector2 == null) {
                throw new Exception("No connector available");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJMXConnector");
        }
        return connector2;
    }

    private static Server getServer(Resource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServer");
        }
        Server svr = null;
        EList resContents = res.getContents();
        for (int i = 0; i < resContents.size(); ++i) {
            Object resource = resContents.get(i);
            if (!(resource instanceof Server)) continue;
            svr = (Server)resource;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServer");
        }
        return svr;
    }

    private static VariableMap getVariableMap(String cRoot, String cName, String nName, String sName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVariableMap: " + cRoot + ", " + cName + ", " + nName + ", " + sName);
        }
        try {
            Repository rep = RepositoryFactory.createRepository((String)"ws-server", (String)cRoot, (String)cName, (String)nName, (String)sName);
            VariableMap oldMap = VariableMapFactory.createVariableMap((Repository)rep);
            oldMap.initialize(null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getVariableMap: " + oldMap);
            }
            return oldMap;
        }
        catch (Throwable th) {
            Tr.error(tc, "Error creating varMap " + th.getMessage());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getVariableMap: NULL returned");
            }
            return null;
        }
    }

    private static void initializeModel() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeModel");
        }
        ModelMgr.initialize((String)"server");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeModel");
        }
    }
}

