/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.AdminserviceFactory;
import com.ibm.websphere.models.config.adminservice.AdminservicePackage;
import com.ibm.websphere.models.config.adminservice.RMIConnector;
import com.ibm.websphere.models.config.adminservice.RepositoryService;
import com.ibm.websphere.models.config.adminservice.SOAPConnector;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.ApplicationserverFactory;
import com.ibm.websphere.models.config.applicationserver.ApplicationserverPackage;
import com.ibm.websphere.models.config.applicationserver.TransactionService;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EJBCache;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EJBContainer;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EjbcontainerFactory;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EjbcontainerPackage;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebcontainerFactory;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebcontainerPackage;
import com.ibm.websphere.models.config.classloader.ClassLoaderPolicy;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.ipc.IpcPackage;
import com.ibm.websphere.models.config.loggingservice.ras.MessageFilterLevelKind;
import com.ibm.websphere.models.config.loggingservice.ras.RASLoggingService;
import com.ibm.websphere.models.config.loggingservice.ras.RasFactory;
import com.ibm.websphere.models.config.loggingservice.ras.RasPackage;
import com.ibm.websphere.models.config.loggingservice.ras.ServiceLog;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.messagingserver.MessagingserverFactory;
import com.ibm.websphere.models.config.messagingserver.MessagingserverPackage;
import com.ibm.websphere.models.config.namingserver.NameServer;
import com.ibm.websphere.models.config.namingserver.NamingserverFactory;
import com.ibm.websphere.models.config.namingserver.NamingserverPackage;
import com.ibm.websphere.models.config.orb.Interceptor;
import com.ibm.websphere.models.config.orb.ORBPlugin;
import com.ibm.websphere.models.config.orb.ObjectRequestBroker;
import com.ibm.websphere.models.config.orb.OrbFactory;
import com.ibm.websphere.models.config.orb.OrbPackage;
import com.ibm.websphere.models.config.pmiservice.PmiserviceFactory;
import com.ibm.websphere.models.config.pmiservice.PmiservicePackage;
import com.ibm.websphere.models.config.process.ExecutionState;
import com.ibm.websphere.models.config.process.MessageFormatKind;
import com.ibm.websphere.models.config.process.ProcessFactory;
import com.ibm.websphere.models.config.process.ProcessPackage;
import com.ibm.websphere.models.config.process.RolloverType;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.StateManageable;
import com.ibm.websphere.models.config.process.StatisticsProvider;
import com.ibm.websphere.models.config.process.StreamRedirect;
import com.ibm.websphere.models.config.process.ThreadPool;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.JavaVirtualMachine;
import com.ibm.websphere.models.config.processexec.OutputRedirect;
import com.ibm.websphere.models.config.processexec.ProcessExecution;
import com.ibm.websphere.models.config.processexec.ProcessexecFactory;
import com.ibm.websphere.models.config.processexec.ProcessexecPackage;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.topology.node.NodeFactory;
import com.ibm.websphere.models.config.topology.node.NodePackage;
import com.ibm.websphere.models.config.traceservice.TraceFormatKind;
import com.ibm.websphere.models.config.traceservice.TraceLog;
import com.ibm.websphere.models.config.traceservice.TraceOutputKind;
import com.ibm.websphere.models.config.traceservice.TraceService;
import com.ibm.websphere.models.config.traceservice.TraceserviceFactory;
import com.ibm.websphere.models.config.traceservice.TraceservicePackage;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.management.AdminHelper;
import java.io.File;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class JMSServerConfigBuilder {
    protected ProcessFactory processFactory;
    protected ProcessexecFactory processexecFactory;
    protected IpcFactory ipcFactory;
    protected TraceserviceFactory traceServiceFactory;
    protected PropertiesFactory propFactory;
    protected NodeFactory nodeFactory;
    protected OrbFactory orbFactory;
    protected NamingserverFactory namingFactory;
    protected AdminserviceFactory adminFactory;
    protected RasFactory rasFactory;
    protected PmiserviceFactory pmiFactory;
    protected MessagingserverFactory msgFactory;
    protected EjbcontainerFactory ejbContainerFactory;
    protected WebcontainerFactory webContainerFactory;
    protected ApplicationserverFactory appServerFactory;
    public static final String DEFAULT_PROCESS_NAME = "jmsserver";
    protected String procName;
    protected String configRoot;
    private String nodeName;
    public static final String TRANSITION_NAME = "ClusterTransitionName";
    public static final String TRANSITION_UID = "was.ClusterTransitionUUID";
    public static final String SYSTEM_NAME = "was.ConfiguredSystemName";
    private boolean zos = false;
    private String shortName;
    private VariableMap nodeVarMap;
    private String cellShortName;

    public void setConfigRepositoryRoot(String root) {
        this.configRoot = root;
    }

    public String getConfigRepositoryRoot() {
        if (this.configRoot == null || this.configRoot.equals("")) {
            this.configRoot = "unknown config root";
        }
        return this.configRoot;
    }

    public JMSServerConfigBuilder() {
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.zos = true;
        }
        this.initializeFactories();
    }

    public EObject buildRootElements() {
        Server root = this.buildSampleProcess();
        return root;
    }

    public WebContainer buildSampleWebContainer(ApplicationServer appserver) {
        WebContainer webContainer = this.webContainerFactory.createWebContainer();
        appserver.getComponents().add(webContainer);
        StateManageable stateManagement = this.processFactory.createStateManageable();
        stateManagement.setInitialState(ExecutionState.START_LITERAL);
        webContainer.setStateManagement(stateManagement);
        webContainer.setEnableServletCaching(true);
        ThreadPool threadPool2 = this.processFactory.createThreadPool();
        threadPool2.setInactivityTimeout(3500);
        threadPool2.setIsGrowable(false);
        threadPool2.setMaximumSize(50);
        threadPool2.setMinimumSize(10);
        webContainer.setThreadPool(threadPool2);
        return webContainer;
    }

    public EJBContainer buildSampleEJBContainer(ApplicationServer appserver) {
        EJBContainer ejbContainer = this.ejbContainerFactory.createEJBContainer();
        StateManageable stateManagement = this.processFactory.createStateManageable();
        stateManagement.setInitialState(ExecutionState.START_LITERAL);
        ejbContainer.setStateManagement(stateManagement);
        EJBCache ejbCache = this.ejbContainerFactory.createEJBCache();
        ejbCache.setCacheSize(2053L);
        ejbCache.setCleanupInterval(3000L);
        ejbContainer.setCacheSettings(ejbCache);
        ejbContainer.setPassivationDirectory("${USER_INSTALL_ROOT}/temp");
        ejbContainer.setInactivePoolCleanupInterval(30000L);
        return ejbContainer;
    }

    public void setupSampleApplicationServerServices(ApplicationServer appserver) {
        TransactionService tranService = this.appServerFactory.createTransactionService();
        tranService.setEnable(true);
        tranService.setClientInactivityTimeout(60);
        tranService.setTotalTranLifetimeTimeout(120);
        appserver.getServices().add(tranService);
    }

    public ApplicationServer buildApplicationServer(String serverName) {
        ApplicationServer appserv1 = this.appServerFactory.createApplicationServer();
        appserv1.setApplicationClassLoaderPolicy(ClassLoaderPolicy.MULTIPLE_LITERAL);
        return appserv1;
    }

    public ApplicationServer buildSampleApplicationServer() {
        ApplicationServer appserver = this.buildApplicationServer("");
        ProcessPackage ppkg = this.processFactory.getProcessPackage();
        StateManageable stateManagement = this.processFactory.createStateManageable();
        stateManagement.setInitialState(ExecutionState.START_LITERAL);
        appserver.setStateManagement(stateManagement);
        this.setupSampleApplicationServerServices(appserver);
        EJBContainer ejbContainer = this.buildSampleEJBContainer(appserver);
        WebContainer webContainer = this.buildSampleWebContainer(appserver);
        appserver.getComponents().add(ejbContainer);
        appserver.getComponents().add(webContainer);
        return appserver;
    }

    public NameServer buildNameServer() {
        NameServer nameServer = this.namingFactory.createNameServer();
        ProcessPackage ppkg = this.processFactory.getProcessPackage();
        StateManageable stateManagement = this.processFactory.createStateManageable();
        stateManagement.setInitialState(ExecutionState.START_LITERAL);
        nameServer.setStateManagement(stateManagement);
        return nameServer;
    }

    public Server buildSampleProcess() {
        Server server = this.processFactory.createServer();
        server.setName(this.getProcessName());
        StreamRedirect sysOutRedir = this.processFactory.createStreamRedirect();
        StreamRedirect sysErrRedir = this.processFactory.createStreamRedirect();
        sysOutRedir.setFileName("$(LOG_ROOT)/jmsserver/SystemOut.log");
        sysOutRedir.setRolloverSize(1);
        sysOutRedir.setRolloverType(RolloverType.SIZE_LITERAL);
        sysOutRedir.setMaxNumberOfBackupFiles(1);
        sysOutRedir.setBaseHour(24);
        sysOutRedir.setRolloverPeriod(24);
        sysOutRedir.setSuppressWrites(false);
        sysOutRedir.setSuppressStackTrace(false);
        sysOutRedir.setFormatWrites(true);
        sysOutRedir.setMessageFormatKind(MessageFormatKind.BASIC_LITERAL);
        sysErrRedir.setFileName("$(LOG_ROOT)/jmsserver/SystemErr.log");
        sysErrRedir.setRolloverSize(1);
        sysErrRedir.setRolloverType(RolloverType.SIZE_LITERAL);
        sysErrRedir.setMaxNumberOfBackupFiles(1);
        sysErrRedir.setBaseHour(24);
        sysErrRedir.setRolloverPeriod(24);
        sysErrRedir.setSuppressWrites(false);
        sysErrRedir.setSuppressStackTrace(false);
        sysErrRedir.setFormatWrites(true);
        sysErrRedir.setMessageFormatKind(MessageFormatKind.BASIC_LITERAL);
        server.setOutputStreamRedirect(sysOutRedir);
        server.setErrorStreamRedirect(sysErrRedir);
        ProcessPackage ppkg = this.processFactory.getProcessPackage();
        StateManageable stateManagement = this.processFactory.createStateManageable();
        stateManagement.setInitialState(ExecutionState.START_LITERAL);
        server.setStateManagement(stateManagement);
        StatisticsProvider stats = this.processFactory.createStatisticsProvider();
        server.setStatisticsProvider(stats);
        server.getStatisticsProvider().setSpecification("");
        server.getComponents().add(this.buildJMSServer());
        server.getComponents().add(this.buildNameServer());
        server.getComponents().add(this.buildSampleApplicationServer());
        this.setupSampleServices(server);
        if (AdminHelper.getPlatformHelper().isZOS()) {
            server.setShortName(this.shortName);
            server.setUniqueId(AdminHelper.getPlatformHelper().getUniqueId());
            server.getProcessDefinitions().add(this.buildControlProcessDef());
        } else {
            server.setProcessDefinition(this.buildSampleProcessDef());
        }
        return server;
    }

    public JavaProcessDef buildControlProcessDef() {
        JavaProcessDef processDef = this.processexecFactory.createJavaProcessDef();
        processDef.setExecutableName("${JAVA_HOME}/bin/java");
        processDef.setWorkingDirectory("${USER_INSTALL_ROOT}");
        processDef.getExecutableArguments().add("");
        processDef.setProcessType("Control");
        EList varMapEntries = this.nodeVarMap.getEntries();
        String ctrl_proc = null;
        Object cell_short = null;
        String node_short = null;
        for (int j = 0; j < varMapEntries.size(); ++j) {
            VariableSubstitutionEntry vse = (VariableSubstitutionEntry)varMapEntries.get(j);
            String sn = vse.getSymbolicName();
            if (sn.equalsIgnoreCase("WAS_DEFAULT_CONTROL_PROC_NAME")) {
                ctrl_proc = vse.getValue();
                continue;
            }
            if (!sn.equalsIgnoreCase("WAS_DAEMON_ONLY_node_short_name")) continue;
            node_short = vse.getValue();
        }
        String start = "START " + ctrl_proc;
        String startArgs = "JOBNAME=" + this.shortName + ",ENV=" + this.cellShortName + "." + node_short + "." + this.shortName;
        String stop = "STOP " + this.shortName + "; CANCEL " + this.shortName;
        String term = "FORCE " + this.shortName;
        processDef.setStartCommand(start);
        processDef.getStartCommandArgs().add(startArgs);
        processDef.setStopCommand(stop);
        processDef.setTerminateCommand(term);
        ProcessExecution processExec = this.processexecFactory.createProcessExecution();
        processExec.setRunAsUser("");
        processExec.setProcessPriority(20);
        processExec.setRunAsGroup("");
        processDef.setExecution(processExec);
        JavaVirtualMachine jvm = this.processexecFactory.createJavaVirtualMachine();
        jvm.getClasspath().add("");
        jvm.getBootClasspath().add("");
        jvm.setVerboseModeClass(false);
        jvm.setVerboseModeGarbageCollection(false);
        jvm.setVerboseModeJNI(false);
        jvm.setDebugMode(false);
        jvm.setDebugArgs("-Djava.compiler=NONE -Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=7777");
        jvm.setHprofArguments("");
        jvm.setInitialHeapSize(48);
        jvm.setMaximumHeapSize(256);
        jvm.setRunHProf(false);
        processDef.getJvmEntries().add(jvm);
        return processDef;
    }

    public JavaProcessDef buildSampleProcessDef() {
        JavaProcessDef processDef = this.processexecFactory.createJavaProcessDef();
        processDef.setWorkingDirectory("${USER_INSTALL_ROOT}");
        processDef.getExecutableArguments().add("");
        OutputRedirect outRedir = this.processexecFactory.createOutputRedirect();
        outRedir.setStdoutFilename("${LOG_ROOT}/jmsserver/native_stdout.log");
        outRedir.setStderrFilename("${LOG_ROOT}/jmsserver/native_stderr.log");
        processDef.setIoRedirect(outRedir);
        ProcessExecution processExec = this.processexecFactory.createProcessExecution();
        if (System.getProperty("os.name").equals("OS/400")) {
            processExec.setRunAsUser("QEJBSVR");
            processExec.setRunAsGroup("");
            processExec.setProcessPriority(25);
        } else {
            processExec.setRunAsUser("");
            processExec.setRunAsGroup("");
            processExec.setProcessPriority(1000);
        }
        processDef.setExecution(processExec);
        JavaVirtualMachine jvm = this.processexecFactory.createJavaVirtualMachine();
        jvm.getClasspath().add("");
        jvm.getBootClasspath().add("");
        jvm.setVerboseModeClass(false);
        jvm.setVerboseModeGarbageCollection(false);
        jvm.setVerboseModeJNI(false);
        jvm.setDebugMode(false);
        jvm.setDebugArgs("-Djava.compiler=NONE -Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=7777");
        jvm.setHprofArguments("");
        jvm.setRunHProf(false);
        processDef.getJvmEntries().add(jvm);
        return processDef;
    }

    public void setProcessName(String proc) {
        this.procName = proc;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getProcessName() {
        if (this.procName != null) {
            return this.procName;
        }
        return DEFAULT_PROCESS_NAME;
    }

    public String getDocumentName() {
        return "server.xml";
    }

    public void initializeFactories() {
        CommonarchiveFactoryImpl.getActiveFactory();
        ArchiveInit.init();
        ConfigInit.init();
        PmiservicePackage pmipkg = (PmiservicePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/pmiservice.xmi");
        this.pmiFactory = pmipkg.getPmiserviceFactory();
        AdminservicePackage adminpkg = (AdminservicePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi");
        this.adminFactory = adminpkg.getAdminserviceFactory();
        RasPackage raspkg = (RasPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/loggingservice.ras.xmi");
        this.rasFactory = raspkg.getRasFactory();
        NodePackage pkg = (NodePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/topology.node.xmi");
        this.nodeFactory = pkg.getNodeFactory();
        ProcessexecPackage pepkg = (ProcessexecPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/processexec.xmi");
        this.processexecFactory = pepkg.getProcessexecFactory();
        ProcessPackage processpkg = (ProcessPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/process.xmi");
        this.processFactory = processpkg.getProcessFactory();
        PropertiesPackage propertiespkg = (PropertiesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/properties.xmi");
        this.propFactory = propertiespkg.getPropertiesFactory();
        IpcPackage ipcpkg = (IpcPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/ipc.xmi");
        this.ipcFactory = ipcpkg.getIpcFactory();
        TraceservicePackage tracepkg = (TraceservicePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/traceservice.xmi");
        this.traceServiceFactory = tracepkg.getTraceserviceFactory();
        MessagingserverPackage msgPkg = (MessagingserverPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/messagingserver.xmi");
        this.msgFactory = msgPkg.getMessagingserverFactory();
        OrbPackage orbpkg = (OrbPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/orb.xmi");
        this.orbFactory = orbpkg.getOrbFactory();
        NamingserverPackage namingPkg = (NamingserverPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/namingserver.xmi");
        this.namingFactory = namingPkg.getNamingserverFactory();
        ApplicationserverPackage aspkg = (ApplicationserverPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.xmi");
        this.appServerFactory = aspkg.getApplicationserverFactory();
        EjbcontainerPackage ejbcpkg = (EjbcontainerPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.ejbcontainer.xmi");
        this.ejbContainerFactory = ejbcpkg.getEjbcontainerFactory();
        WebcontainerPackage webcpkg = (WebcontainerPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.webcontainer.xmi");
        this.webContainerFactory = webcpkg.getWebcontainerFactory();
    }

    public ResourceSet getResourceSet() {
        WASResourceSetImpl rs = new WASResourceSetImpl();
        URIConverterImpl uric = new URIConverterImpl(){

            public URI normalize(URI uri) {
                if (uri.isRelative()) {
                    return uri.resolve(URI.createFileURI(JMSServerConfigBuilder.this.getConfigRepositoryRoot() + File.separator));
                }
                return super.normalize(uri);
            }
        };
        rs.setURIConverter(uric);
        return rs;
    }

    public void write(EObject docRoot, String fileName) throws Exception {
        ResourceSet set = this.getResourceSet();
        URI uri = URI.createFileURI(fileName);
        Resource configResource = set.createResource(uri);
        configResource.getContents().add(docRoot);
        configResource.save(new HashMap());
    }

    public void setupSampleServices(Server process) {
        AdminService adminService = this.adminFactory.createAdminService();
        adminService.setEnable(true);
        adminService.setStandalone(false);
        if (AdminHelper.getPlatformHelper().isZOS()) {
            Property transNameProp = this.propFactory.createProperty();
            transNameProp.setName(TRANSITION_NAME);
            transNameProp.setValue(this.shortName);
            Property transIdProp = this.propFactory.createProperty();
            transIdProp.setName(TRANSITION_UID);
            transIdProp.setValue(AdminHelper.getPlatformHelper().getUniqueId());
            EList varMapEntries = this.nodeVarMap.getEntries();
            String system_name = null;
            for (int j = 0; j < varMapEntries.size(); ++j) {
                VariableSubstitutionEntry vse = (VariableSubstitutionEntry)varMapEntries.get(j);
                String sn = vse.getSymbolicName();
                if (!sn.equalsIgnoreCase("WAS_DAEMON_ONLY_server_configured_system_name")) continue;
                system_name = vse.getValue();
            }
            Property systemNameProp = this.propFactory.createProperty();
            systemNameProp.setName(SYSTEM_NAME);
            systemNameProp.setValue(system_name);
            adminService.getProperties().add(transNameProp);
            adminService.getProperties().add(transIdProp);
            adminService.getProperties().add(systemNameProp);
        }
        SOAPConnector soapConnector = this.adminFactory.createSOAPConnector();
        RMIConnector rmiConnector = this.adminFactory.createRMIConnector();
        Property sslProp = this.propFactory.createProperty();
        sslProp.setName("sslConfig");
        if (AdminHelper.getPlatformHelper().isZOS()) {
            sslProp.setValue(this.nodeName + "/RACFJSSESettings");
        } else {
            sslProp.setValue(this.nodeName + "/DefaultSSLSettings");
        }
        soapConnector.getProperties().add(sslProp);
        RepositoryService rep = this.adminFactory.createRepositoryService();
        adminService.getConnectors().add(soapConnector);
        adminService.getConnectors().add(rmiConnector);
        adminService.setConfigRepository(rep);
        adminService.setPreferredConnector(soapConnector);
        process.getServices().add(adminService);
        TraceService traceService = this.traceServiceFactory.createTraceService();
        traceService.setEnable(true);
        TraceLog traceLog = this.traceServiceFactory.createTraceLog();
        traceLog.setFileName("${LOG_ROOT}/jmsserver/trace.log");
        traceLog.setRolloverSize(20);
        traceLog.setMaxNumberOfBackupFiles(1);
        traceService.setTraceLog(traceLog);
        traceService.setStartupTraceSpecification("com.ibm.*=all=disabled");
        traceService.setTraceFormat(TraceFormatKind.BASIC_LITERAL);
        if (this.zos) {
            traceService.setTraceOutputType(TraceOutputKind.MEMORY_BUFFER_LITERAL);
        } else {
            traceService.setTraceOutputType(TraceOutputKind.SPECIFIED_FILE_LITERAL);
        }
        traceService.setMemoryBufferSize(8);
        process.getServices().add(traceService);
        RASLoggingService logging = this.rasFactory.createRASLoggingService();
        logging.setEnable(true);
        logging.setEnableCorrelationId(true);
        logging.setMessageFilterLevel(MessageFilterLevelKind.NONE_LITERAL);
        ServiceLog log = this.rasFactory.createServiceLog();
        log.setName("${LOG_ROOT}/activity.log");
        log.setSize(2);
        log.setEnabled(true);
        logging.setServiceLog(log);
        process.getServices().add(logging);
        ThreadPool threadPool1 = this.processFactory.createThreadPool();
        threadPool1.setInactivityTimeout(3500);
        threadPool1.setIsGrowable(false);
        threadPool1.setMaximumSize(50);
        threadPool1.setMinimumSize(10);
        ObjectRequestBroker orb = this.orbFactory.createObjectRequestBroker();
        orb.setEnable(true);
        orb.setThreadPool(threadPool1);
        orb.setCommTraceEnabled(false);
        orb.setConnectionCacheMinimum(100);
        orb.setConnectionCacheMaximum(240);
        orb.setForceTunnel("never");
        orb.setLocateRequestTimeout(180);
        orb.setNoLocalCopies(true);
        orb.setRequestRetriesCount(1);
        orb.setRequestRetriesDelay(0);
        orb.setRequestTimeout(180);
        this.addORBPlugin(orb, "com.ibm.ws.orbimpl.transport.WSTransport");
        this.addORBPlugin(orb, "com.ibm.ISecurityUtilityImpl.SecurityPropertyManager");
        this.addORBPlugin(orb, "com.ibm.ws.orbimpl.WSORBPropertyManager");
        this.addORBInterceptor(orb, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityComponentFactory");
        this.addORBInterceptor(orb, "com.ibm.ISecurityLocalObjectBaseL13Impl.ServerRIWrapper");
        this.addORBInterceptor(orb, "com.ibm.ISecurityLocalObjectBaseL13Impl.ClientRIWrapper");
        this.addORBInterceptor(orb, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRI");
        this.addORBInterceptor(orb, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRI");
        this.addORBProperty(orb, "com.ibm.CORBA.enableLocateRequest", "true");
        this.addORBProperty(orb, "com.ibm.ws.orb.transport.WSSSLServerSocketFactoryName", "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl");
        this.addORBProperty(orb, "com.ibm.ws.orb.transport.WSSSLClientSocketFactoryName", "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl");
        this.addORBProperty(orb, "com.ibm.CORBA.ConnectionInterceptorName", "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor");
        process.getServices().add(orb);
    }

    private void addORBProperty(ObjectRequestBroker orb, String key, String value) {
        Property sysProp = this.propFactory.createProperty();
        sysProp.setName(key);
        sysProp.setValue(value);
        orb.getProperties().add(sysProp);
    }

    private void addORBPlugin(ObjectRequestBroker orb, String orbplugin) {
        ORBPlugin plugin = this.orbFactory.createORBPlugin();
        plugin.setName(orbplugin);
        orb.getPlugins().add(plugin);
    }

    private void addORBInterceptor(ObjectRequestBroker orb, String interceptor) {
        Interceptor i = this.orbFactory.createInterceptor();
        i.setName(interceptor);
        orb.getInterceptors().add(i);
    }

    public JMSServer buildJMSServer() {
        JMSServer jmsServer = this.msgFactory.createJMSServer();
        ProcessPackage ppkg = this.processFactory.getProcessPackage();
        StateManageable stateManagement = this.processFactory.createStateManageable();
        stateManagement.setInitialState(ExecutionState.START_LITERAL);
        jmsServer.setStateManagement(stateManagement);
        jmsServer.setDescription("Internal WebSphere JMS Server");
        jmsServer.setName("JMSServer");
        jmsServer.setNumThreads(1);
        EndPoint securityEP = this.ipcFactory.createEndPoint();
        securityEP.setHost("localhost");
        securityEP.setPort(5557);
        jmsServer.setSecurityPort(securityEP);
        return jmsServer;
    }

    protected String getShortName() {
        return this.shortName;
    }

    protected void setShortName(String sn) {
        this.shortName = sn;
    }

    protected VariableMap getNodeVariableMap() {
        return this.nodeVarMap;
    }

    protected void setNodeVariableMap(VariableMap varMap) {
        this.nodeVarMap = varMap;
    }

    protected String getCellShortName() {
        return this.cellShortName;
    }

    protected void setCellShortName(String shortName) {
        this.cellShortName = shortName;
    }
}

