/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.launcher.LaunchCommand;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.LaunchUtils;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;

public class GenericServerProcHelper {
    private static TraceComponent tc = Tr.register(GenericServerProcHelper.class, "Admin", "com.ibm.ws.management.resources.nodeutils");

    private static ConfigService getRepository(ServerIdentifiers sid) {
        return ConfigServiceFactory.createConfigService((String)sid.getConfigRoot(), (String)sid.getCellName(), (String)sid.getNodeName(), (String)sid.getServerName());
    }

    private static VariableMap getVariableMap(ServerIdentifiers sid) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVariableMap(), sid = " + sid.toString());
        }
        ConfigService repository2 = GenericServerProcHelper.getRepository(sid);
        VariableMap variableMap = VariableMapFactory.createVariableMap((ConfigService)repository2);
        try {
            variableMap.initialize(null);
        }
        catch (Throwable t) {
            throw Utils.makeAdminException(t);
        }
        return variableMap;
    }

    private static ConfigObject getProcessDef(ServerIdentifiers sid) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessDef(sid), sid = " + sid.toString());
        }
        List resource = null;
        String path = "/servers/" + sid.getServerName() + "/server.xml";
        try {
            ConfigService cs = GenericServerProcHelper.getRepository(sid);
            resource = cs.getDocumentObjects(cs.getScope(3), path);
        }
        catch (Exception nofile) {
            throw new AdminException(nofile, sid.toString());
        }
        ConfigObject server = (ConfigObject)resource.get(0);
        if (!server.getString("name", "__null__").equals(sid.getServerName())) {
            throw new AdminException(sid.getServerName());
        }
        List processDefs = server.getObjectList("processDefinitions");
        ConfigObject processDef = !processDefs.isEmpty() ? (ConfigObject)processDefs.get(0) : server.getObject("processDefinition");
        return processDef;
    }

    public static boolean isServerAnIHSServer(ServerIdentifiers sid) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerAnIHSServer, sid = " + sid.toString());
        }
        if (!GenericServerProcHelper.isServerAWebServer(sid)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isServerAnIHSServer = false");
            }
            return false;
        }
        List resource = null;
        String path = "/servers/" + sid.getServerName() + "/server.xml";
        Tr.debug(tc, "server path = " + path);
        try {
            ConfigService cs = GenericServerProcHelper.getRepository(sid);
            resource = cs.getDocumentObjects(cs.getScope(3), path);
        }
        catch (Exception nofile) {
            throw new AdminException(nofile, sid.toString());
        }
        ConfigObject server = (ConfigObject)resource.get(0);
        ConfigObject webServer = GenericServerProcHelper.getWebServer(server);
        if (webServer.getString("webserverType", "IHS").equals("IHS") || webServer.getString("webserverType", "IHS").equals("HTTPSERVER_ZOS")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isServerAnIHSServer = true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerAnIHSServer = false");
        }
        return false;
    }

    public static boolean isServerAGenericServer(ServerIdentifiers sid) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerAGenericServer(), sid = " + sid.toString());
        }
        return GenericServerProcHelper.isItThisTypeOfServer("GENERIC_SERVER", sid);
    }

    public static boolean isServerAWebServer(ServerIdentifiers sid) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerAWebServer(), sid = " + sid.toString());
        }
        return GenericServerProcHelper.isItThisTypeOfServer("WEB_SERVER", sid);
    }

    private static boolean isItThisTypeOfServer(String serverType, ServerIdentifiers sid) throws AdminException {
        if (tc.isEntryEnabled()) {
            String inputParms = "serverType = " + serverType + "\nsid = " + sid.toString();
            Tr.entry(tc, "isItThisTypeOfServer(), input params = " + inputParms);
        }
        List resource = null;
        String path = "/serverindex.xml";
        try {
            ConfigService cs = GenericServerProcHelper.getRepository(sid);
            resource = cs.getDocumentObjects(cs.getScope(3), path);
        }
        catch (Throwable t) {
            throw new AdminException(t, sid.toString());
        }
        ConfigObject si = (ConfigObject)resource.get(0);
        List servers = si.getObjectList("serverEntries");
        for (int i = 0; i < servers.size(); ++i) {
            ConfigObject se = (ConfigObject)servers.get(i);
            if (!se.getString("serverName", "__null__").equals(sid.getServerName()) || !se.getString("serverType", "__null__").equals(serverType)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "server IS a " + serverType);
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "server IS NOT a " + serverType);
        }
        return false;
    }

    protected static int launchGenericServer(LaunchCommand launcher2, ServerIdentifiers sid) throws AdminException {
        int launchStatus = -2;
        Process p = null;
        try {
            p = launcher2.launchProcess();
        }
        catch (Exception e) {
            throw new AdminException(e, "process for " + sid.toString() + "failed to launch");
        }
        try {
            String pid = p.id();
            pid = pid.toUpperCase();
            GenericServerProcHelper.savePidToFile(pid, sid);
            Tr.debug(tc, "Launched process pid: " + pid);
            String serverName = sid.getServerName();
            Tr.debug(tc, "Processing as generic server. ");
            if (!GenericServerProcHelper.getStatusUsingPidFile(sid).equals("RUNNING")) {
                throw new AdminException(LaunchUtils.getFormattedMessage("ADML0011E", null, null));
            }
            launchStatus = 0;
            Tr.audit(tc, "ADML0000I", new Object[]{pid, serverName});
            Tr.debug(tc, "processName = " + serverName + " pid = " + pid + " status = " + launchStatus);
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in LaunchCommand.launchProcess():", t);
            }
            throw new AdminException(t, "Process for: " + sid.toString() + "launched successfully but there was a subsequent problem");
        }
        return launchStatus;
    }

    public static String getStatusUsingPidFile(ServerIdentifiers sid) throws AdminException, Exception {
        if (GenericServerProcHelper.isServerAWebServer(sid) || GenericServerProcHelper.isServerAnIHSServer(sid)) {
            String webStatus = GenericServerProcHelper.getStatusUsingPing(sid);
            return webStatus;
        }
        String pathToPidFile = GenericServerProcHelper.getPathToPidFile(sid);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerProcessStatus: ", pathToPidFile);
        }
        boolean result = true;
        Process p = null;
        String pid = GenericServerProcHelper.getPidFromFile(pathToPidFile.trim());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " PID ======> " + pid);
        }
        if (pid != null) {
            try {
                p = ProcessFactory.bindTo((String)pid);
            }
            catch (Exception e1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Pid file found but existing pid is invalid! - processing will continue");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerProcessStatus ", "STOPPED");
                }
                return "STOPPED";
            }
            try {
                result = p.isAlive();
            }
            catch (ProcessOpException pEx) {
                return "STOPPED";
            }
            if (result) {
                return "RUNNING";
            }
            return "STOPPED";
        }
        return "STOPPED";
    }

    public static String getStatusUsingPing(ServerIdentifiers sid) throws AdminException, Exception {
        String status = "";
        String serverName = "";
        String webHost = "";
        int webPort = 0;
        List resource = null;
        List resource2 = null;
        String path = "/servers/" + sid.getServerName() + "/server.xml";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "StatusUsing Ping -> serverPath = " + path);
        }
        try {
            ConfigService cs = GenericServerProcHelper.getRepository(sid);
            resource = cs.getDocumentObjects(cs.getScope(3), path);
            resource2 = cs.getDocumentObjects(cs.getScope(3), "serverindex.xml");
        }
        catch (Throwable t) {
            throw Utils.makeAdminException(t);
        }
        ConfigObject server = (ConfigObject)resource.get(0);
        serverName = server.getString("name", "__null__");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Check Status for Web Server->  " + serverName);
            Tr.debug(tc, "Check Status for Web Server->  " + server);
        }
        ConfigObject si = (ConfigObject)resource2.get(0);
        List list = si.getObjectList("serverEntries");
        block4: for (int i = 0; i < list.size(); ++i) {
            ConfigObject se = (ConfigObject)list.get(i);
            if (!se.getString("serverName", "__null__").equals(serverName)) continue;
            List endPointList = se.getObjectList("specialEndpoints");
            for (int x = 0; x < endPointList.size(); ++x) {
                ConfigObject namedEndPoint = (ConfigObject)endPointList.get(x);
                if (!namedEndPoint.getString("endPointName", "__null__").equals("WEBSERVER_ADDRESS")) continue;
                ConfigObject ep = namedEndPoint.getObject("endPoint");
                webHost = ep.getString("host", "__null__");
                webPort = ep.getInt("port", 0);
                if (!tc.isDebugEnabled()) continue block4;
                Tr.debug(tc, "Found namedEndPoint for Web server on hostname " + webHost + " on port:" + webPort);
                continue block4;
            }
        }
        if (!webHost.equals("")) {
            InetSocketAddress socketaddress = new InetSocketAddress(webHost, webPort);
            if (socketaddress.isUnresolved()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Socket Address unresolved for web server-> " + server + " on hostname " + webHost + " on port:" + webPort + " =UNAVAILABLE");
                }
                status = "UNAVAILABLE";
            }
            Socket sock = new Socket();
            try {
                sock.connect(socketaddress, 5000);
                sock.close();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Status for web server-> " + server + " on hostname " + webHost + " on port:" + webPort + " =RUNNING");
                }
                status = "RUNNING";
            }
            catch (Exception socketEx) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Status for web server-> " + server + " on hostname " + webHost + " on port:" + webPort + " =STOPPED");
                }
                status = "STOPPED";
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HostName not available form serverIndex for Web server -> " + server + "status = UNAVAILABLE");
            }
            status = "UNAVAILABLE";
        }
        return status;
    }

    private static String getPathToPidFile(ServerIdentifiers sid) throws IllegalArgumentException, AdminException, Exception {
        if (GenericServerProcHelper.isServerAnIHSServer(sid)) {
            return GenericServerProcHelper.getIHSPidFile(sid);
        }
        return GenericServerProcHelper.getVariableMap(sid).expand("${LOG_ROOT}/" + sid.getServerName() + "/" + sid.getServerName() + ".pid");
    }

    public static String getIHSPidFile(ServerIdentifiers sid) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIHSPidFile(), sid = " + sid.toString());
        }
        if (!GenericServerProcHelper.isServerAWebServer(sid)) {
            return "";
        }
        List resource = null;
        String path = "/servers/" + sid.getServerName() + "/server.xml";
        Tr.debug(tc, "server path = " + path);
        try {
            ConfigService cs = GenericServerProcHelper.getRepository(sid);
            resource = cs.getDocumentObjects(cs.getScope(3), path);
        }
        catch (Throwable t) {
            throw Utils.makeAdminException(t);
        }
        ConfigObject server = (ConfigObject)resource.get(0);
        ConfigObject webServer = GenericServerProcHelper.getWebServer(server);
        if (webServer.getString("webserverType", "IHS").equals("IHS")) {
            String iRoot = webServer.getUnexpandedString("configurationFilename", "__null__");
            if (iRoot == null) {
                return "";
            }
            String pidFileName = "";
            if (iRoot != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "webServer config file name = " + iRoot);
                }
                iRoot = GenericServerProcHelper.getVariableMap(sid).expand(iRoot);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "webServer config file name expanded = " + iRoot);
                }
                if ((pidFileName = GenericServerProcHelper.parseConfFile(iRoot)) != null) {
                    return pidFileName;
                }
                return "";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String parseConfFile(String httpdConfFile) {
        block14: {
            block13: {
                httpdf = new File(httpdConfFile);
                bfr = null;
                try {
                    try {
                        bfr = new BufferedReader(new FileReader(httpdf));
                        line = "";
                        while ((line = bfr.readLine()) != null) {
                            if (line.trim().length() <= 0 || !line.trim().startsWith("PidFile")) continue;
                            pidFile = line.substring(line.indexOf(" "));
                            if (GenericServerProcHelper.tc.isDebugEnabled()) {
                                Tr.debug(GenericServerProcHelper.tc, "PID FILE got from httpd.conf " + pidFile);
                            }
                            var5_6 = pidFile;
                            var7_7 = null;
                            break block13;
                        }
                        bfr.close();
                        break block14;
                    }
                    catch (IOException e) {
                        if (GenericServerProcHelper.tc.isDebugEnabled()) {
                            Tr.debug(GenericServerProcHelper.tc, e.getMessage(), e);
                        }
                        var7_9 = null;
                        try {
                            if (bfr == null) return "";
                            bfr.close();
                            return "";
                        }
                        catch (Exception e1) {
                            return "";
                        }
                    }
                }
                catch (Throwable var6_15) {
                    var7_10 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 165->176)] { 
lbl33:
                    // 1 sources

                    if (bfr == null) throw var6_15;
                    bfr.close();
                    throw var6_15;
lbl36:
                    // 1 sources

                    catch (Exception e1) {
                        // empty catch block
                    }
                    throw var6_15;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 165->176)] { 
lbl41:
            // 1 sources

            if (bfr == null) return var5_6;
            bfr.close();
            return var5_6;
lbl44:
            // 1 sources

            catch (Exception e1) {
                // empty catch block
            }
            return var5_6;
        }
        var7_8 = null;
        try {}
        catch (Exception e1) {}
        if (bfr == null) return "";
        bfr.close();
        return "";
        return "";
    }

    public static int stopArbitraryServerProcess(ServerIdentifiers sid) throws AdminException {
        String executableName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopAbitraryServerProcess(), sid = " + sid.toString());
        }
        int exitCode = 0;
        CreationParams params = new CreationParams();
        ConfigObject procdef = GenericServerProcHelper.getProcessDef(sid);
        String stopCmd = procdef.getUnexpandedString("stopCommand", "__null__");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stopCommand=" + stopCmd);
        }
        if ((executableName = GenericServerProcHelper.getVariableMap(sid).expand(stopCmd)) == null) {
            throw new AdminException("Stop Command does not exist - perhaps you should try Terminate");
        }
        params.setExecutable(executableName);
        params.setProcessName(new File(executableName).getName());
        String wd = procdef.getUnexpandedString("workingDirectory", "__null__");
        if (wd != null && wd.equals("")) {
            wd = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "workingDirectory=" + wd);
        }
        String workingDirectory = GenericServerProcHelper.getVariableMap(sid).expand(wd);
        params.setWorkingDirectory(workingDirectory);
        params.setDetachProcess(true);
        List stopCmdArgs = procdef.getUnexpandedStringList("stopCommandArgs");
        String[] stopCommandLineArgs = new String[stopCmdArgs.size()];
        for (int i = 0; i < stopCmdArgs.size(); ++i) {
            stopCommandLineArgs[i] = GenericServerProcHelper.getVariableMap(sid).expand((String)stopCmdArgs.get(i));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "stopArg=" + stopCommandLineArgs[i]);
        }
        params.setCommandLineArgs(stopCommandLineArgs);
        try {
            Process p = ProcessFactory.create((CreationParams)params);
            p.waitForTermination(30);
            exitCode = p.getExitCode();
            p.release();
            GenericServerProcHelper.removeFileContainingPid(sid);
        }
        catch (Throwable t) {
            throw Utils.makeAdminException(t);
        }
        return exitCode;
    }

    public static void savePidToFile(String pid, ServerIdentifiers sid) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "savePidToFile", pid);
        }
        try {
            if (GenericServerProcHelper.isServerAnIHSServer(sid)) {
                return;
            }
            String pidFile = GenericServerProcHelper.getPathToPidFile(sid);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid = " + pid + " to be saved in " + pidFile);
            }
            if (pid != null) {
                File f = new File(pidFile);
                f.getParentFile().mkdirs();
                FileOutputStream out = null;
                if (!f.exists()) {
                    f.createNewFile();
                }
                out = new FileOutputStream(f);
                out.write(pid.getBytes());
                out.flush();
                out.close();
            }
        }
        catch (Throwable t) {
            throw Utils.makeAdminException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "savePidToFile");
        }
    }

    private static String getPidFromFile(String pathToPidFile) throws AdminException {
        String pid = null;
        File f = new File(pathToPidFile);
        try {
            if (f.exists()) {
                BufferedReader br = null;
                br = new BufferedReader(new FileReader(f));
                pid = br.readLine();
                if (br != null) {
                    br.close();
                }
            }
        }
        catch (Throwable t) {
            throw Utils.makeAdminException(t);
        }
        return pid;
    }

    public static String getPidFromSid(ServerIdentifiers sid) throws AdminException {
        String pid = null;
        try {
            pid = GenericServerProcHelper.getPidFromFile(GenericServerProcHelper.getPathToPidFile(sid));
        }
        catch (Throwable t) {
            throw Utils.makeAdminException(t);
        }
        return pid;
    }

    public static void removeFileContainingPid(ServerIdentifiers sid) throws AdminException {
        File f;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFilePid(), sid = " + sid.toString());
        }
        String pidFile = GenericServerProcHelper.getVariableMap(sid).expand("${LOG_ROOT}/" + sid.getServerName() + "/" + sid.getServerName() + ".pid");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pid file to be deleted: " + pidFile);
        }
        if ((f = new File(pidFile)).exists()) {
            f.delete();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFilePid");
        }
    }

    private static ConfigObject getWebServer(ConfigObject server) throws Exception {
        ConfigObject websvr = null;
        List comps = server.getObjectList("components");
        for (int i = 0; i < comps.size(); ++i) {
            ConfigObject resource = (ConfigObject)comps.get(i);
            if (!resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/webserver.xmi", "WebServer")) continue;
            websvr = resource;
        }
        return websvr;
    }
}

