/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.adminservice.JMXConnector;
import com.ibm.ws.management.tools.LaunchUtils;
import com.ibm.ws.management.tools.WindowsService;
import com.ibm.ws.management.util.Utils;
import com.ibm.wsspi.profile.WSProfile;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.MBeanException;
import javax.management.ObjectName;

public abstract class AdminTool {
    private boolean displayCurrentProfile = true;
    protected Properties adminProperties = new Properties();
    public static String BUNDLE_NAME = "com.ibm.ws.management.resources.nodeutils";
    private static final TraceComponent tc = Tr.register(AdminTool.class, "Admin", BUNDLE_NAME);
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    public static final String ALL_TRACE = "com.ibm.*=all=enabled";
    public static final String TRACE_PROP = "com.ibm.ws.tools.trace.traceString";
    public static final String TRACE_FILE_PROP = "com.ibm.ws.tools.trace.traceFile";
    public static final String DEBUG_PROP = "com.ibm.ws.tools.trace";
    public static final int STATUS_TIMEOUT = 300000;
    public static final int MAX_MSG_LEN = 79;
    public static final String INDENT = "           ";
    public static final String LINE_SEPARATOR = "\n";
    protected static final int BAD_OPTION = -1;
    protected static final int EXPECTED_PARAMETER = -2;
    protected static final int INVALID_PARAMETER = -3;
    protected static final int REQUIRED_PARAMETER = -4;
    protected String configRoot;
    protected String cellName;
    protected String nodeName;
    protected boolean nowait = false;
    protected String userid = null;
    protected String pwd = null;
    protected String logfile = null;
    private boolean replacelog = false;
    protected boolean trace = false;
    private boolean quiet = false;
    protected boolean help = false;
    private boolean isDoubleByteSystem = false;
    private boolean isDoubleByteTested = false;
    protected boolean parseAndSetTraceCalled = false;
    protected Integer statusPort = null;
    protected ServerSocket statusSocket = null;
    protected int statusTimeout = 0;
    protected boolean invokedByWindowsService = false;
    public static final int BUFFER_SIZE = 1024;
    public static final String[] DO_NOT_COMPRESS_LIST = new String[]{".zip", ".jar", ".ear", ".war", ".rar"};
    private byte[] buffer = new byte[1024];

    protected AdminTool() {
    }

    protected abstract String getDefaultTraceString();

    protected abstract String getDefaultTraceFile();

    protected abstract int getMinimumNumArgs();

    protected abstract void issueUsageMessage();

    protected abstract int parseRequiredArgs(String[] var1) throws AdminException;

    protected abstract int runTool() throws Exception;

    protected void toolFailed(Throwable exception) {
    }

    protected int executeUtilityWithoutProfileDisplay(String[] args) {
        this.displayCurrentProfile = false;
        int retval = this.executeUtility(args);
        this.displayCurrentProfile = true;
        return retval;
    }

    protected int parseAndSetTrace(String[] args) {
        int exitStatus = 0;
        boolean succeed = false;
        try {
            succeed = this.parseArgs(args);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!succeed) {
            exitStatus = !this.help ? -1 : 12345;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to parse arguments within executeUtility method. Return code " + exitStatus + ". Arguments: " + args);
            }
        } else if (!this.setTrace()) {
            exitStatus = -1;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trace not set within executeUtility method. Return code -1.");
            }
        } else {
            exitStatus = 0;
        }
        return exitStatus;
    }

    protected int executeUtility(String[] args) {
        int exitStatus;
        block13: {
            exitStatus = 0;
            if (this.parseAndSetTraceCalled || (exitStatus = this.parseAndSetTrace(args)) == 0) {
                if (this.parseAndSetTraceCalled) {
                    String tracespec = this.trace ? ALL_TRACE : "";
                    ManagerAdmin.setTraceState(tracespec);
                }
                if (!this.parseAndSetTraceCalled) {
                    Tr.event(tc, "Executing utility with arguments: " + this.getUtilityArguments(args));
                }
                try {
                    this.displayCurrentProfile();
                    exitStatus = this.runTool();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Returning from auxiliary method runTool with return: " + exitStatus);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof MBeanException) {
                        t = t.getCause();
                    }
                    Tr.error(tc, "ADMU0111E", t);
                    this.toolFailed(t);
                    exitStatus = -1;
                    int issueMsgRC = t.getCause() != null ? (t.getMessage().indexOf("ADMN0022E") != -1 ? this.issueMessage("ADMU0111E", new Object[]{t}, null) : this.issueMessage("ADMU0113E", new Object[]{t, AdminTool.getRootCause(t).toString()}, null)) : this.issueMessage("ADMU0111E", new Object[]{t}, null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Returning from auxiliary method issueMessage with return code: " + issueMsgRC);
                    }
                    if (this.isMessageInException("ADMN0022E", t)) {
                        issueMsgRC = this.issueMessage("ADMU4113E", null, null);
                    } else if (this.isMessageInException("ADMC0016E", t) || this.isMessageInException("ADMC0018E", t)) {
                        String mainClass = System.getProperty("com.ibm.WebSphere.main_class");
                        issueMsgRC = mainClass.equals("ProfileRegistrationUtility") || mainClass.equals("ProfileDeregistrationUtility") ? this.issueMessage("ADMU8035E", null, "Ensure that the AdminAgent is running on the specified port.") : this.issueMessage("ADMU4123E", null, null);
                    }
                    if (!this.trace) {
                        issueMsgRC = this.issueMessage("ADMU1211I", null, null);
                    }
                    issueMsgRC = this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug(tc, "Returning from auxiliary method issueMessage with return code: " + issueMsgRC);
                    Tr.debug(tc, "Returning from executeUtility method with return code: " + exitStatus);
                }
            }
        }
        if (exitStatus == 12345) {
            exitStatus = 0;
        }
        return exitStatus;
    }

    protected String getUtilityArguments(String[] args) {
        StringBuffer cmdLineBuf = new StringBuffer();
        boolean pwdarg = false;
        if (args != null || args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (pwdarg) {
                    cmdLineBuf.append(" ******** ");
                    pwdarg = false;
                    continue;
                }
                cmdLineBuf.append(args[i]);
                cmdLineBuf.append(" ");
                if (args[i].toUpperCase().indexOf("PASSWORD") < 0) continue;
                pwdarg = true;
            }
        }
        return cmdLineBuf.toString();
    }

    private boolean isMessageInException(String message, Throwable t) {
        if (t == null || t.getMessage() == null) {
            return false;
        }
        if (t.getMessage().indexOf(message) >= 0) {
            return true;
        }
        return this.isMessageInException(message, t.getCause());
    }

    protected boolean parseArgs(String[] args) throws AdminException {
        if (this.isHelpNeeded(args)) {
            return false;
        }
        if (!this.isGivenMinimumNumArgs(args)) {
            return false;
        }
        this.configRoot = args[0];
        this.cellName = args[1];
        this.nodeName = args[2];
        int nextOption = this.parseRequiredArgs(args);
        if (nextOption < 0) {
            this.issueUsageMessage();
            return false;
        }
        for (int i = nextOption; i < args.length; ++i) {
            String option = args[i];
            if (option.equals("-nowait")) {
                this.nowait = true;
                this.adminProperties.setProperty("-nowait", "true");
                continue;
            }
            if (option.equals("-quiet")) {
                this.quiet = true;
                this.adminProperties.setProperty("-quiet", "true");
                continue;
            }
            if (option.equals("-trace")) {
                this.trace = true;
                this.adminProperties.setProperty("-trace", "true");
                System.setProperty("com.ibm.security.jgss.debug", "all");
                System.setProperty("com.ibm.security.krb5.Krb5Debug", "all");
                continue;
            }
            if (option.equals("-logfile")) {
                if (this.isValidParameter(args, i + 1)) {
                    this.logfile = args[i + 1];
                    ++i;
                    this.adminProperties.setProperty("-logfile", this.logfile);
                    continue;
                }
                this.issueExpectedParameterMessage(args[i]);
                return false;
            }
            if (option.equals("-replacelog")) {
                this.replacelog = true;
                this.adminProperties.setProperty("-replacelog", "true");
                continue;
            }
            if (option.equals("-username") || option.equals("-user")) {
                if (args.length > i + 1) {
                    this.userid = args[i + 1];
                    ++i;
                    continue;
                }
                this.issueExpectedParameterMessage(args[i]);
                return false;
            }
            if (option.equals("-password")) {
                if (args.length > i + 1) {
                    this.pwd = args[i + 1];
                    ++i;
                    continue;
                }
                this.issueExpectedParameterMessage(args[i]);
                return false;
            }
            if (option.equals("-statusport")) {
                if (this.isValidParameter(args, i + 1)) {
                    this.statusPort = new Integer(args[i + 1]);
                    this.adminProperties.setProperty("-statusport", this.statusPort.toString());
                    ++i;
                    continue;
                }
                this.issueExpectedParameterMessage(args[i]);
                return false;
            }
            int nextArg = this.parseUtilitySpecificOption(args, i);
            if (nextArg < 0) {
                this.issueBadOptionsMessage(nextArg, args[i]);
                return false;
            }
            i = nextArg - 1;
        }
        return true;
    }

    private void issueBadOptionsMessage(int id, String option) {
        if (id == -1) {
            this.issueUnknownOptionMessage(option);
        } else if (id == -2) {
            this.issueExpectedParameterMessage(option);
        } else if (id == -3) {
            this.issueExpectedParameterMessage(option);
        } else if (id == -4) {
            this.issueInvalidParameterMessage(option);
        }
    }

    private void issueUnknownOptionMessage(String option) {
        this.issueMessage("ADMU9991E", new Object[]{option}, null);
        this.issueUsageMessage();
    }

    private void issueExpectedParameterMessage(String option) {
        this.issueMessage("ADMU9992E", new Object[]{option}, null);
        this.issueUsageMessage();
    }

    private void issueInvalidParameterMessage(String option) {
        this.issueMessage("ADMU9993E", new Object[]{option}, null);
        this.issueUsageMessage();
    }

    protected boolean isValidParameter(String[] args, int index) {
        return args.length > index && !args[index].startsWith("-");
    }

    private boolean isHelpNeeded(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-?") && !args[i].equals("-help")) continue;
            this.issueUsageMessage();
            this.help = true;
            return true;
        }
        return false;
    }

    protected boolean isGivenMinimumNumArgs(String[] args) {
        int numArgs = 0;
        for (int i = 0; i < args.length && this.isValidMinimumArgument(args[i]); ++i) {
            ++numArgs;
        }
        if (numArgs < this.getMinimumNumArgs()) {
            this.issueUsageMessage();
            return false;
        }
        return true;
    }

    protected boolean isValidMinimumArgument(String arg) {
        return !arg.startsWith("-");
    }

    protected int parseUtilitySpecificOption(String[] args, int curOption) {
        return -1;
    }

    private void displayCurrentProfile() {
        if (!this.displayCurrentProfile) {
            return;
        }
        File profileDir = this.guessProfileDir();
        if (profileDir != null) {
            try {
                String profileName = WSProfile.getProfileName(profileDir);
                this.issueMessage("ADMU0128I", new String[]{profileName}, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private File guessProfileDir() {
        File profileDir = null;
        int index = this.configRoot.indexOf("config");
        if (index >= 0 && !(profileDir = new File(this.configRoot.substring(0, index))).exists()) {
            profileDir = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Our guess at the profile dir: " + profileDir);
        }
        return profileDir;
    }

    protected String[] stopAllServers() throws Exception {
        return this.stopAllServers(this.userid, this.pwd);
    }

    protected String[] stopAllServers(String parmUserName, String parmPassword) throws Exception {
        Vector servers = this.getServers();
        this.issueMessage("ADMU2010I", new Object[]{this.nodeName}, null);
        ArrayList stoppedServers = new ArrayList();
        String nodeAgentName = "nodeagent";
        boolean nodeAgentExist = false;
        for (int i = 0; i < servers.size(); ++i) {
            String serverName = (String)servers.get(i);
            if (!serverName.equals(nodeAgentName)) {
                this.doStopServer(stoppedServers, serverName, parmUserName, parmPassword);
                continue;
            }
            nodeAgentExist = true;
        }
        if (nodeAgentExist) {
            this.doStopServer(stoppedServers, nodeAgentName, parmUserName, parmPassword);
        }
        String[] serverNames = new String[stoppedServers.size()];
        return stoppedServers.toArray(serverNames);
    }

    protected String[] stopAllServers(String parmUserName, String parmPassword, String profileConfigRoot, String profileCellName, String profileNodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopAllServers for configRoot " + profileConfigRoot + " cell " + profileCellName + " node " + profileNodeName);
        }
        Vector servers = this.getServers(profileConfigRoot, profileCellName, profileNodeName);
        this.issueMessage("ADMU2010I", new Object[]{profileNodeName}, null);
        ArrayList stoppedServers = new ArrayList();
        for (int i = 0; i < servers.size(); ++i) {
            String serverName = (String)servers.get(i);
            this.doStopServer(stoppedServers, serverName, parmUserName, parmPassword, profileConfigRoot, profileCellName, profileNodeName);
        }
        String[] serverNames = new String[stoppedServers.size()];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopAllServers for configRoot " + serverNames);
        }
        return stoppedServers.toArray(serverNames);
    }

    private void doStopServer(List stoppedServers, String serverName, String parmUserName, String parmPassword) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doStopServer for " + stoppedServers.toArray() + " server " + serverName);
        }
        this.doStopServer(stoppedServers, serverName, parmUserName, parmPassword, null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doStopServer");
        }
    }

    private void doStopServer(List stoppedServers, String serverName, String parmUserName, String parmPassword, String profileConfigRoot, String profileCellName, String profileNodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doStopServer for " + stoppedServers.toArray() + " server " + serverName + " profileRoot " + profileConfigRoot + " cell " + profileCellName + " node " + profileNodeName);
        }
        if (AdminTool.isPlatformWindows()) {
            WindowsService windowsSvc;
            block11: {
                windowsSvc = null;
                try {
                    windowsSvc = WindowsService.getWindowsServiceInstance(serverName, null);
                }
                catch (AdminException ae) {
                    windowsSvc = null;
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "after WindowsService.getWindowsServiceInstance " + ae.getMessage());
                }
            }
            if (windowsSvc != null && !this.invokedByWindowsService) {
                block12: {
                    try {
                        if (windowsSvc.getServiceStatus() != 2) {
                            return;
                        }
                    }
                    catch (AdminException exc) {
                        windowsSvc = null;
                        return;
                    }
                    try {
                        windowsSvc.doStopService();
                    }
                    catch (AdminException ae) {
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug(tc, "after windowsSvc.doStopService() " + ae.getMessage());
                    }
                }
                return;
            }
        }
        this.stopNormalAppServer(stoppedServers, serverName, parmUserName, parmPassword, profileConfigRoot, profileCellName, profileNodeName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doStopServer");
        }
    }

    private void stopNormalAppServer(List stoppedServers, String serverName, String _userName, String _pwd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopNormalAppServer:  serverName = " + serverName + ", _userName = " + _userName + ", _pwd = " + _pwd);
        }
        this.stopNormalAppServer(stoppedServers, serverName, _userName, _pwd, null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopNormalAppServer");
        }
    }

    private void stopNormalAppServer(List stoppedServers, String serverName, String parmUserName, String parmPassword, String profileConfigRoot, String profileCellName, String profileNodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopNormalAppServer:  configRoot = " + profileConfigRoot + " cell = " + profileCellName + " node = " + profileNodeName + " server = " + serverName + ", _userName = " + parmUserName + ", _pwd = " + parmPassword);
        }
        JMXConnector connector2 = null;
        connector2 = profileConfigRoot != null && profileCellName != null && profileNodeName != null ? LaunchUtils.getJMXConnector(profileConfigRoot, profileCellName, profileNodeName, serverName) : LaunchUtils.getJMXConnector(this.configRoot, this.cellName, this.nodeName, serverName);
        if (connector2 != null) {
            AdminClient admin;
            block6: {
                admin = null;
                try {
                    admin = profileConfigRoot != null && profileCellName != null && profileNodeName != null ? LaunchUtils.getAdminClient(connector2, profileConfigRoot, profileCellName, profileNodeName, serverName, parmUserName, parmPassword) : LaunchUtils.getAdminClient(connector2, this.configRoot, this.cellName, this.nodeName, serverName, parmUserName, parmPassword);
                }
                catch (Exception ex) {
                    this.issueMessage("ADMU0512I", new Object[]{serverName}, null);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, ex.getMessage(), ex);
                }
            }
            if (admin != null) {
                this.sendStop(admin, serverName);
                stoppedServers.add(serverName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopNormalAppServer");
        }
    }

    public void removeAllServices() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllServices()");
        }
        this.removeAllServices(null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllServices()");
        }
    }

    public void removeAllServices(List doNotRemoveServerList) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllServices");
        }
        Vector servers = null;
        if (!AdminTool.isPlatformWindows()) {
            return;
        }
        try {
            servers = this.getServers();
        }
        catch (Throwable t) {
            throw Utils.makeAdminException(t);
        }
        for (int i = 0; i < servers.size(); ++i) {
            String serverName = (String)servers.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName = " + serverName);
            }
            if (doNotRemoveServerList != null && doNotRemoveServerList.contains(serverName)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "skipping removal of service for server: " + serverName);
                continue;
            }
            try {
                WindowsService windowsService = null;
                try {
                    windowsService = WindowsService.getWindowsServiceInstance(serverName, null);
                    if (windowsService == null) {
                        continue;
                    }
                }
                catch (AdminException ae) {
                    // empty catch block
                }
                windowsService.doRemoveService();
                continue;
            }
            catch (AdminException ae) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllServices");
        }
    }

    public void removeAllServices(String profilePath, String profileCellName, String profileNodeName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllServices for profilePath " + profilePath + " profileCellName " + profileCellName + " profileNodeName " + profileNodeName);
        }
        Vector servers = null;
        if (!AdminTool.isPlatformWindows()) {
            return;
        }
        try {
            String profileConfigRoot = null;
            if (profilePath != null) {
                profileConfigRoot = AdminTool.getConfigRootFromProfileHome(profilePath);
            }
            servers = this.getServers(profileConfigRoot, profileCellName, profileNodeName);
        }
        catch (Throwable t) {
            throw Utils.makeAdminException(t);
        }
        for (int i = 0; i < servers.size(); ++i) {
            String serverName = (String)servers.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName = " + serverName);
            }
            try {
                WindowsService windowsService = null;
                try {
                    windowsService = WindowsService.getWindowsServiceInstance(serverName, profilePath);
                    if (windowsService == null) {
                        continue;
                    }
                }
                catch (AdminException ae) {
                    // empty catch block
                }
                windowsService.doRemoveService(profilePath);
                continue;
            }
            catch (AdminException ae) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllServices");
        }
    }

    protected static String getConfigRootFromProfileHome(String sProfileHome) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRootFromProfileHome ", sProfileHome);
        }
        String S_CONFIG = "config";
        String configRoot = null;
        File configFile = new File(sProfileHome + File.separator + S_CONFIG);
        if (configFile.exists() && configFile.isDirectory()) {
            try {
                configRoot = configFile.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
                configRoot = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigRootFromProfileHome ", configRoot);
        }
        return configRoot;
    }

    public void stopAndRemoveAllServices() throws Exception {
        this.stopAllServers();
        this.removeAllServices();
    }

    protected static boolean isPlatformWindows() {
        String osName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPlatformWindows()");
        }
        return (osName = System.getProperty("os.name")).toLowerCase().indexOf("windows") >= 0;
    }

    protected Vector getServers() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServers()");
        }
        Vector v = this.getServers(null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServers()");
        }
        return v;
    }

    private Vector getServers(String profileConfigRoot, String pCellName, String pNodeName) {
        Vector v;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServers for profileRoot " + profileConfigRoot + " cell " + pCellName + " node " + pNodeName);
        }
        if ((v = this.getServerList(profileConfigRoot, pCellName, pNodeName)) == null || v.size() == 0) {
            this.issueMessage("ADMU0507I", new Object[]{this.configRoot + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers"}, null);
        } else {
            this.issueMessage("ADMU0505I", null, null);
            for (int i = 0; i < v.size(); ++i) {
                this.issueMessage("ADMU0506I", new Object[]{v.elementAt(i)}, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServers " + v.toArray());
        }
        return v;
    }

    protected Vector getServerList() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerList()");
        }
        Vector serverList = this.getServerList(null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerList()");
        }
        return serverList;
    }

    private Vector getServerList(String profileConfigRoot, String pCellName, String pNodeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerList for configRoot " + profileConfigRoot + " cell " + this.cellName + " node " + this.nodeName);
        }
        Vector<String> serverList = new Vector<String>();
        String sdir = null;
        sdir = profileConfigRoot != null && pCellName != null && pNodeName != null ? profileConfigRoot + "/cells/" + pCellName + "/nodes/" + pNodeName + "/servers" : this.configRoot + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers";
        File serverContexts = new File(sdir);
        File[] servers = serverContexts.listFiles();
        if (servers != null) {
            for (int i = 0; i < servers.length; ++i) {
                if (!servers[i].isDirectory()) continue;
                String serverName = servers[i].getName();
                serverList.add(serverName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerList " + serverList.toArray());
        }
        return serverList;
    }

    private void sendStop(AdminClient admin, String serverName) throws Exception {
        boolean needToWaitForCallback = true;
        boolean rethrow = false;
        int status = -10;
        ObjectName server = this.getServerHandle(admin);
        String sName = server.getKeyProperty("name");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The server name mbean is " + sName);
            Tr.debug(tc, "The server name being stopped is " + serverName);
        }
        if (sName.equals(serverName)) {
            if (this.statusPort == null) {
                this.statusSocket = LaunchUtils.getFreePort(300000);
                this.statusPort = new Integer(this.statusSocket.getLocalPort());
            }
            if (server != null) {
                String opName = "stop";
                String[] signature = new String[]{"java.lang.Boolean", "java.lang.Integer"};
                Object[] params = new Object[]{new Boolean(true), this.statusPort};
                try {
                    admin.invoke(server, opName, params, signature);
                }
                catch (Exception e1) {
                    try {
                        admin.isAlive();
                        rethrow = true;
                        throw e1;
                    }
                    catch (Exception e2) {
                        if (rethrow) {
                            throw e2;
                        }
                        needToWaitForCallback = false;
                        status = 0;
                    }
                }
                if (needToWaitForCallback) {
                    status = LaunchUtils.waitForServer(this.statusSocket);
                }
                if (status == 0) {
                    this.issueMessage("ADMU0510I", new Object[]{serverName, "STOPPED"}, null);
                } else {
                    this.issueMessage("ADMU0021E", null, null);
                    String timeString = new Integer(this.statusTimeout / 1000).toString();
                    throw new AdminException(this.getFormattedMessage("ADMU3060E", new Object[]{timeString}, "Timed out waiting for server shutdown."));
                }
            }
        }
    }

    protected Integer getStatusPort() {
        this.initStatusPort();
        return this.statusPort;
    }

    protected ServerSocket getStatusSocket() {
        this.initStatusPort();
        return this.statusSocket;
    }

    private void initStatusPort() {
        if (this.statusSocket != null) {
            return;
        }
        int portnum = 0;
        if (this.statusPort != null) {
            portnum = this.statusPort;
        }
        try {
            this.statusSocket = new ServerSocket(portnum);
            this.statusSocket.setSoTimeout(this.statusTimeout);
            this.statusPort = new Integer(this.statusSocket.getLocalPort());
        }
        catch (IOException ioe) {
            this.issueMessage("ADMU3012E", new Object[]{ioe.getMessage()}, null);
            Tr.error(tc, "ADMU3012E", ioe);
        }
    }

    protected ObjectName getServerHandle(AdminClient admin) throws Exception {
        ObjectName hdl = admin.getServerMBean();
        if (hdl == null) {
            throw new Exception("Server is in disarray such that getServerMBean() returned null; cannot proceed");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Repository handle is ==> " + hdl.getCanonicalName());
        }
        return hdl;
    }

    private boolean setTrace() {
        String spec = null;
        spec = this.trace || this.parseAndSetTraceCalled ? ALL_TRACE : "";
        if (this.logfile == null) {
            this.logfile = this.getDefaultTraceFile();
        }
        boolean writeToFile = true;
        if (!ManagerAdmin.isLogFileWriteable(this.logfile)) {
            this.issueMessage("ADMU0118E", new Object[]{new File(this.logfile).getAbsolutePath()}, null);
            writeToFile = false;
        }
        if (writeToFile) {
            this.issueMessage("ADMU0116I", new Object[]{new File(this.logfile).getAbsolutePath()}, null);
            ManagerAdmin.configureClientTrace(spec, "named file", this.logfile, this.replacelog, "basic", false);
        }
        return true;
    }

    protected int issueMessage(String key, Object[] args, String inputmsg) {
        String msg = this.getFormattedMessage(key, args, inputmsg);
        if (msg == null) {
            msg = this.getFormattedMessage("ADMU0123E", new Object[]{key}, null);
        }
        if (!this.quiet) {
            this.printMessage(msg);
        }
        this.emitNotification(key, msg);
        Tr.audit(tc, key, args);
        return this.retcodeFromMessage(msg);
    }

    protected void printMessage(String msg) {
        int maxLength = 79;
        this.printMessage(msg, maxLength, false);
    }

    protected void printLineSeparator(String line) {
        if (line == null) {
            line = LINE_SEPARATOR;
        }
        System.out.println(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isDoubleByteSystem(String sampleStr) {
        block9: {
            ByteArrayOutputStream baos;
            block10: {
                if (this.isDoubleByteTested) break block9;
                baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeUTF(sampleStr);
                dos.flush();
                Object var7_4 = null;
                try {
                    dos.close();
                }
                catch (IOException exc2) {}
                break block10;
                {
                    catch (IOException exc) {
                        boolean bl = false;
                        Object var7_5 = null;
                        try {
                            dos.close();
                        }
                        catch (IOException exc2) {
                            // empty catch block
                        }
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    try {
                        dos.close();
                    }
                    catch (IOException exc2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            byte[] bytes = baos.toByteArray();
            this.isDoubleByteSystem = (double)bytes.length > (double)sampleStr.length() + (double)sampleStr.length() * 0.1;
        }
        return this.isDoubleByteSystem;
    }

    private void printMessage(String msg, int maxLength, boolean indent) {
        int maxLocalLength = maxLength;
        if (indent) {
            System.out.print(INDENT);
            maxLocalLength -= INDENT.length();
        }
        if (msg.length() <= maxLocalLength) {
            System.out.println(msg);
        } else {
            int i = msg.lastIndexOf(32, maxLocalLength);
            if (i == -1 && (i = msg.indexOf(32)) == -1) {
                System.out.println(msg);
                return;
            }
            this.printMessage(msg.substring(0, i), maxLength, false);
            this.printMessage(msg.substring(i + 1), maxLength, true);
        }
    }

    protected String getFormattedMessage(String key, Object[] args, String defaultString) {
        try {
            String result = RESOURCE_BUNDLE.getString(key);
            if (result == null) {
                return defaultString;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (defaultString == null) {
                return defaultString;
            }
            return MessageFormat.format(defaultString, args);
        }
        catch (NullPointerException npe) {
            return defaultString;
        }
    }

    protected void emitNotification(String key, String msg) {
    }

    private int retcodeFromMessage(String msg) {
        int ret = 0;
        if (msg == null) {
            return ret;
        }
        if (msg.startsWith("ADM")) {
            String intpart = msg.substring(4, 8);
            try {
                ret = Integer.parseInt(intpart);
            }
            catch (NumberFormatException nfe) {
                ret = -1;
            }
        } else {
            ret = -1;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Message does not start with expected value. First characters: " + msg.substring(0, 8));
            }
        }
        return ret;
    }

    public void setQuiet(boolean isQuiet) {
        this.quiet = isQuiet;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int compressDir(String rootDir, File zipFile) throws IOException {
        ZipOutputStream zipper = new ZipOutputStream(new FileOutputStream(zipFile));
        int numFilesCompressed = 0;
        try {
            File curFile = new File(rootDir);
            numFilesCompressed = this.zipFileRecursive(curFile, zipper, numFilesCompressed);
            Object var7_6 = null;
            if (!this.isQuiet()) {
                System.out.println();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!this.isQuiet()) {
                System.out.println();
            }
            zipper.close();
            throw throwable;
        }
        zipper.close();
        return numFilesCompressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int compressDir(String rootDir, String rootDir2, File zipFile) throws IOException {
        ZipOutputStream zipper = new ZipOutputStream(new FileOutputStream(zipFile));
        int numFilesCompressed = 0;
        try {
            File curFile = new File(rootDir);
            numFilesCompressed = this.zipFileRecursive(curFile, zipper, numFilesCompressed);
            curFile = new File(rootDir2);
            numFilesCompressed += this.zipFileRecursive(curFile, zipper, numFilesCompressed);
            Object var8_7 = null;
            if (!this.isQuiet()) {
                System.out.println();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!this.isQuiet()) {
                System.out.println();
            }
            zipper.close();
            throw throwable;
        }
        zipper.close();
        return numFilesCompressed;
    }

    private int zipFileRecursive(File fileOrDirectory, ZipOutputStream zipper, int numFilesCompressed) throws IOException {
        int result = numFilesCompressed;
        if (fileOrDirectory.isDirectory()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Backing up directory " + fileOrDirectory.getCanonicalPath());
            }
            File[] files = fileOrDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                result = this.zipFileRecursive(files[i], zipper, result);
            }
        } else {
            this.zipFile(fileOrDirectory, zipper);
            ++result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipFile(File file, ZipOutputStream zipper) throws IOException {
        if (!this.isQuiet()) {
            System.out.print('.');
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Backing up file " + file);
        }
        ZipEntry zipEntry = new ZipEntry(this.getRelativeName(file));
        zipEntry.setSize(file.length());
        zipEntry.setTime(file.lastModified());
        zipEntry.setSize(file.length());
        this.setCompressionMethod(zipEntry);
        zipper.putNextEntry(zipEntry);
        FileInputStream fis = new FileInputStream(file);
        try {
            int bytesRead = 0;
            while ((bytesRead = fis.read(this.buffer)) > -1) {
                zipper.write(this.buffer, 0, bytesRead);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
        zipper.closeEntry();
    }

    private String getRelativeName(File file) {
        return file.getPath().substring(this.configRoot.length() + 1);
    }

    private void setCompressionMethod(ZipEntry zipEntry) {
        String fileName = zipEntry.getName();
        for (int i = 0; i < DO_NOT_COMPRESS_LIST.length; ++i) {
            if (!fileName.endsWith(DO_NOT_COMPRESS_LIST[i])) continue;
            zipEntry.setMethod(0);
        }
        zipEntry.setMethod(8);
    }

    protected static Throwable getRootCause(Throwable t) {
        Throwable tt = t.getCause();
        if (tt == null) {
            return t;
        }
        return AdminTool.getRootCause(tt);
    }
}

