/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class SerializationHelper {
    private static TraceComponent tc = Tr.register(SerializationHelper.class, "Sync", "com.ibm.ws.management.resources.sync");
    private static String epochDir = null;

    private static synchronized String getEpochFileDir() {
        if (epochDir == null) {
            String installRoot = System.getProperty("user.install.root");
            if (installRoot != null && !installRoot.equals("")) {
                String currentProcess = AdminServiceFactory.getAdminService().getProcessName();
                epochDir = installRoot + File.separator + "logs" + File.separator + currentProcess + File.separator;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting epochDir to " + epochDir);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to set epochDir because user.install.root is null or empty");
            }
        }
        return epochDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object loadObject(String filename) {
        Object o;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadObject", filename);
            }
            String path = SerializationHelper.getEpochFileDir() + filename;
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            o = null;
            try {
                try {
                    fis = new FileInputStream(path);
                    ois = new ObjectInputStream(fis);
                    o = ois.readObject();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Deserialized object from " + path);
                    }
                    SerializationHelper.deleteFile(path);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.SerializationHelper.loadObject", (String)"67");
                    Object var7_6 = null;
                    SerializationHelper.closeInputStream(ois);
                    SerializationHelper.closeInputStream(fis);
                    break block7;
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                SerializationHelper.closeInputStream(ois);
                SerializationHelper.closeInputStream(fis);
                throw throwable;
            }
            SerializationHelper.closeInputStream(ois);
            SerializationHelper.closeInputStream(fis);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadObject", filename);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void persistObject(Object o, String filename) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "persistObject", filename);
            }
            String path = SerializationHelper.getEpochFileDir() + filename;
            FileOutputStream fos = null;
            ObjectOutputStream oos = null;
            try {
                block6: {
                    try {
                        fos = new FileOutputStream(path);
                        oos = new ObjectOutputStream(fos);
                        oos.writeObject(o);
                        if (!tc.isDebugEnabled()) break block6;
                        Tr.debug(tc, "Saved object to " + path);
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.SerializationHelper.persistObject", (String)"100");
                        Object var7_6 = null;
                        SerializationHelper.closeOutputStream(oos);
                        SerializationHelper.closeOutputStream(fos);
                        break block7;
                    }
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                SerializationHelper.closeOutputStream(oos);
                SerializationHelper.closeOutputStream(fos);
                throw throwable;
            }
            SerializationHelper.closeOutputStream(oos);
            SerializationHelper.closeOutputStream(fos);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistObject", filename);
        }
    }

    private static void closeOutputStream(OutputStream s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.SerializationHelper.closeOutputStream", (String)"116");
            }
        }
    }

    private static void closeInputStream(InputStream s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.SerializationHelper.closeInputStream", (String)"127");
            }
        }
    }

    private static void deleteFile(String path) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Deleting " + path);
        }
        File f = new File(path);
        boolean deleted = f.delete();
        if (tc.isDebugEnabled() && !deleted) {
            Tr.debug(tc, "Unable to delete " + path);
        }
    }
}

