/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository.client;

import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.ws.management.repository.client.LocalConfigRepositoryClient;
import java.util.Properties;

public class ProfileKeyConfigRepositoryClient
extends LocalConfigRepositoryClient {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connect(Properties connectInfo) throws ConnectorException {
        String uuid = AdminContext.peek();
        String profileKey = connectInfo.getProperty("profileKey");
        if (profileKey == null || profileKey.trim().length() <= 0) throw new ConnectorException("No profileKey provided");
        this.checkAdminContext(profileKey, uuid);
        try {
            this.repository = ConfigRepositoryFactory.getConfigRepository();
            if (this.repository == null) {
                this.repository = ConfigRepositoryFactory.createConfigRepository((boolean)true);
                System.setProperty("com.ibm.ws.management.standalone", "true");
                this.repository.initialize(connectInfo);
            }
        }
        catch (AdminException e) {
            throw new ConnectorException(e);
        }
        if (this.repository != null) return;
        throw new ConnectorException("No repository created!");
    }

    private void checkAdminContext(String propStr, String contextStr) throws ConnectorException {
        if (propStr == contextStr || propStr != null && propStr.equals(contextStr) || contextStr != null && contextStr.equals(propStr)) {
            return;
        }
        ConnectorException ex = new ConnectorException("Attempt to connect to ProfileKeyConfigRepositoryClient created with profileKey property: " + propStr + " but AdminContext uuid is: " + contextStr);
        throw ex;
    }
}

