/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.authorizer.SecurityAuditingHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.DocumentAlreadyExistsException;
import com.ibm.websphere.management.exception.DocumentChangedException;
import com.ibm.websphere.management.exception.DocumentIOException;
import com.ibm.websphere.management.exception.DocumentLockedException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.DocumentUnavailableException;
import com.ibm.websphere.management.exception.InvalidDocumentURIException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.exception.RepositoryLockedException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.management.repository.DocumentDigestImpl;
import com.ibm.ws.management.repository.FileDocument;
import com.ibm.ws.management.repository.RepositoryLock;
import com.ibm.ws.management.repository.RepositoryLockFactory;
import com.ibm.ws.management.sync.CellSync;
import com.ibm.ws.management.sync.J2CRAProcessor;
import com.ibm.ws.management.sync.SerializationHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.util.ImplFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.Notification;

public class FileRepository
extends RuntimeCollaborator
implements ConfigRepository,
ResourceNameFilter,
ConfigRepositoryListener {
    private static FileRepository repository = new FileRepository();
    private Class digestImplClass;
    private String repositoryDir;
    private String backupDir;
    private File backupDirectory;
    private String tempDir;
    private File tempDirectory;
    private HashSet locks;
    private boolean initialized = false;
    private String processType = null;
    private boolean inServer = false;
    private RepositoryLock repositoryLock = null;
    private ConfigEpoch repositoryEpoch;
    private final String EPOCH_FILE_NAME = "repository.epoch";
    private boolean hotRestartSync = false;
    private boolean auditingEnabled = true;
    private ArrayList listeners;
    private boolean listenersUpdated;
    private Object[] listenersCopy;
    private boolean allowOverwrites = false;
    private static TraceComponent tc = Tr.register(FileRepository.class, "ConfigRepository", "com.ibm.ws.management.resources.repository");
    private FileTransferOptions ftOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
    private FileTransferConfig ftConfig = null;
    private Properties configProperties = null;
    private static final int AVAILABLE = 0;
    private static final int UNAVAILABLE = 1;
    private static final int INVALID = 2;
    private static final int READ = 0;
    private static final int WRITE = 1;
    private static final String[] ACCESS_TYPE_VERBIAGE = new String[]{"READ", "WRITE"};
    private FileDocument document;
    private String profileKey = null;

    public FileRepository() {
    }

    public FileRepository(String pKey) {
        this.profileKey = pKey;
    }

    public static FileRepository getRepository() {
        return repository;
    }

    public synchronized void initialize(Properties props) throws AdminException {
        Object lstnr;
        Boolean isLocalMode;
        Constructor<?> constr;
        Class<?> clz;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.checkAdminContext();
        if (this.initialized) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Config repository already initialized");
            }
            return;
        }
        this.document = new FileDocument();
        String sprop = System.getProperty("com.ibm.ws.management.standalone");
        if (sprop != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Standalone system property set.");
            }
            this.processType = "UnManagedProcess";
            this.inServer = false;
        } else {
            try {
                AdminServiceFactory.getMBeanFactory().activateMBean("ConfigRepository", this, "repository", null);
            }
            catch (AdminException ae) {
                FFDCFilter.processException((Throwable)ae, (String)"com.ibm.ws.management.repository.FileRepository.initialize", (String)"149", (Object)this);
                Tr.error(tc, "ADMR0006E", ae);
                throw ae;
            }
            this.processType = AdminServiceFactory.getAdminService().getProcessType();
            this.inServer = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processType = " + this.processType);
        }
        this.processProps(props);
        if (this.tempDir != null && new File(this.tempDir).exists() && this.inServer) {
            new TrashSweepTask(this.tempDir).triggerSweep();
        }
        this.initialized = true;
        this.hotRestartSync = Utils.isSyncHotRestartEnabled();
        if (this.hotRestartSync) {
            this.repositoryEpoch = this.loadRepositoryEpoch();
            if (this.repositoryEpoch == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No persisted epoch file found. Initialize the epoch for the repository now");
                }
                this.repositoryEpoch = new ConfigEpoch();
            }
        } else {
            this.repositoryEpoch = new ConfigEpoch();
        }
        this.listeners = new ArrayList();
        this.listenersUpdated = true;
        this.addListener(this);
        try {
            clz = Class.forName("com.ibm.ws.management.application.sync.AppBinaryProcessor");
            constr = clz.getConstructor(Boolean.class, ConfigRepository.class);
            isLocalMode = new Boolean(sprop != null);
            lstnr = constr.newInstance(isLocalMode, this);
            this.addListener((ConfigRepositoryListener)lstnr);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.repository.FileRepository.initialize", (String)"225", (Object)this);
            Tr.error(tc, "ADMR0118E", th);
        }
        try {
            clz = Class.forName("com.ibm.ws.management.bla.sync.BLABinaryProcessor");
            constr = clz.getConstructor(Boolean.class, ConfigRepository.class);
            isLocalMode = new Boolean(sprop != null);
            lstnr = constr.newInstance(isLocalMode, this);
            this.addListener((ConfigRepositoryListener)lstnr);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.repository.FileRepository.initialize", (String)"245", (Object)this);
            Tr.error(tc, "ADMR0118E", th);
        }
        try {
            Boolean isLocalMode2 = new Boolean(sprop != null);
            J2CRAProcessor lr = new J2CRAProcessor(isLocalMode2, this);
            this.addListener(lr);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.repository.FileRepository.initialize", (String)"249", (Object)this);
            Tr.error(tc, "ADMR0118E", th);
        }
        this.locks = new HashSet();
        this.document.setRepository(this);
        this.repositoryLock = RepositoryLockFactory.createRepositoryLock();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public Properties getConfig() {
        this.checkAdminContext();
        return (Properties)this.configProperties.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processProps(Properties props) throws AdminException {
        block57: {
            String allowOverwritesProp;
            block58: {
                block56: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "processProps");
                    }
                    props = props == null ? new Properties() : (Properties)props.clone();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "repository props:", props);
                    }
                    this.configProperties = props;
                    this.repositoryDir = System.getProperty("was.repository.root");
                    if (this.repositoryDir == null || this.profileKey != null) {
                        this.repositoryDir = props.getProperty("was.repository.root");
                        if (this.repositoryDir == null) {
                            String installRoot = System.getProperty("user.install.root");
                            if (installRoot != null && !installRoot.equals("")) {
                                this.repositoryDir = installRoot + File.separator + "config";
                            } else {
                                installRoot = props.getProperty("user.install.root");
                                if (installRoot != null && !installRoot.equals("")) {
                                    this.repositoryDir = installRoot + File.separator + "config";
                                }
                            }
                            if (this.repositoryDir == null) {
                                installRoot = System.getProperty("was.install.root");
                                if (installRoot != null && !installRoot.equals("")) {
                                    this.repositoryDir = installRoot + File.separator + "config";
                                } else {
                                    installRoot = props.getProperty("was.install.root");
                                    if (installRoot != null && !installRoot.equals("")) {
                                        this.repositoryDir = installRoot + File.separator + "config";
                                    }
                                }
                            }
                        }
                    }
                    if (this.repositoryDir == null) {
                        Tr.error(tc, "ADMR0001E");
                        throw new AdminException("Neither was.repository.root nor was.install.root are set");
                    }
                    File f = new File(this.repositoryDir);
                    if (!f.isDirectory()) {
                        Tr.error(tc, "ADMR0001E");
                        throw new AdminException("repositoryDir " + this.repositoryDir + " is not a valid directory");
                    }
                    try {
                        this.repositoryDir = f.getCanonicalPath();
                    }
                    catch (IOException ex) {
                        Tr.error(tc, "ADMR0001E");
                        throw new AdminException("repositoryDir " + this.repositoryDir + " is not a valid directory");
                    }
                    String tempDirProp = System.getProperty("was.repository.temp");
                    if (tempDirProp == null || this.profileKey != null) {
                        tempDirProp = props.getProperty("was.repository.temp");
                    }
                    if (tempDirProp != null) {
                        f = new File(tempDirProp);
                        try {
                            String tempPath = f.getCanonicalPath();
                            if (tempPath.startsWith(this.repositoryDir + File.separator) && !tempPath.equals(this.repositoryDir + File.separator + "temp")) {
                                Tr.warning(tc, "ADMR0014W", tempDirProp);
                                tempDirProp = null;
                            }
                        }
                        catch (IOException e) {
                            Tr.warning(tc, "ADMR0014W", tempDirProp);
                            tempDirProp = null;
                        }
                    }
                    this.tempDir = tempDirProp != null ? tempDirProp : this.repositoryDir + File.separator + "temp";
                    f = new File(this.tempDir);
                    if (f.exists()) {
                        if (!f.isDirectory()) {
                            Tr.warning(tc, "ADMR0014W", this.tempDir);
                            this.tempDir = this.repositoryDir + File.separator + "temp";
                        }
                    } else if (!f.mkdirs()) {
                        Tr.warning(tc, "ADMR0014W", this.tempDir);
                        this.tempDir = this.repositoryDir + File.separator + "temp";
                    }
                    try {
                        f = new File(this.tempDir);
                        this.tempDir = f.getCanonicalPath();
                    }
                    catch (IOException ex) {
                        this.tempDir = this.repositoryDir + File.separator + "temp";
                    }
                    String backupDirProp = System.getProperty("was.repository.backup");
                    if (backupDirProp == null || this.profileKey != null) {
                        backupDirProp = props.getProperty("was.repository.backup");
                    }
                    if (backupDirProp != null) {
                        f = new File(backupDirProp);
                        try {
                            String backupPath = f.getCanonicalPath();
                            if (backupPath.startsWith(this.repositoryDir + File.separator) && !backupPath.equals(this.repositoryDir + File.separator + "backup")) {
                                Tr.warning(tc, "ADMR0013W", backupDirProp);
                                backupDirProp = null;
                            }
                        }
                        catch (IOException e) {
                            Tr.warning(tc, "ADMR0013W", backupDirProp);
                            backupDirProp = null;
                        }
                    }
                    this.backupDir = backupDirProp != null ? backupDirProp : this.repositoryDir + File.separator + "backup";
                    f = new File(this.backupDir);
                    if (f.exists()) {
                        if (!f.isDirectory()) {
                            this.backupDir = this.repositoryDir + File.separator + "backup";
                        }
                    } else if (!f.mkdirs()) {
                        this.backupDir = this.repositoryDir + File.separator + "backup";
                    }
                    try {
                        f = new File(this.backupDir);
                        this.backupDir = f.getCanonicalPath();
                    }
                    catch (IOException ex) {
                        this.backupDir = this.repositoryDir + File.separator + "backup";
                    }
                    this.tempDirectory = new File(this.tempDir);
                    this.backupDirectory = new File(this.backupDir);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "repositoryDir = " + this.repositoryDir);
                        Tr.debug(tc, "tempDir = " + this.tempDir);
                        Tr.debug(tc, "backupDir = " + this.backupDir);
                    }
                    this.tempDir = this.tempDir + File.separator;
                    if (this.profileKey == null) {
                        System.setProperty("was.repository.temp", this.tempDir);
                    }
                    this.configProperties.setProperty("was.repository.root", this.repositoryDir);
                    this.configProperties.setProperty("was.repository.temp", this.tempDir);
                    this.configProperties.setProperty("was.repository.backup", this.backupDir);
                    if (props.containsKey("transfer.compression")) {
                        boolean compress = false;
                        try {
                            compress = Boolean.valueOf((String)props.get("transfer.compression"));
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileRepository.initialize", (String)"236", (Object)this);
                        }
                        this.ftOptions.setCompress(compress);
                    }
                    this.ftOptions.setDeleteSourceOnCompletion(true);
                    this.ftOptions.setOverwrite(true);
                    try {
                        this.ftConfig = (FileTransferConfig)this.configProperties.get("fileTransferConfig");
                        if (this.ftConfig != null || this.profileKey != null) break block56;
                        this.ftConfig = new FileTransferConfigImpl();
                        this.ftConfig.getProperties().setProperty("port", FileTransferConfigImpl.DEFAULT_PORT_STRING_VALUE);
                        this.ftConfig.getProperties().setProperty("secure_port", "9043");
                        this.ftConfig.setSecurityEnabled(false);
                        if (this.inServer) {
                            boolean pushed = false;
                            try {
                                if (AdminContext.peek() != null) {
                                    AdminContext.push(null);
                                }
                                this.ftConfig.getProperties().setProperty("host", AdminHelper.getInstance().getLocalHost().getHostAddress());
                                Object var8_17 = null;
                                if (!pushed) break block56;
                            }
                            catch (Throwable throwable) {
                                Object var8_18 = null;
                                if (pushed) {
                                    AdminContext.pop();
                                }
                                throw throwable;
                            }
                            AdminContext.pop();
                            break block56;
                        }
                        this.ftConfig.getProperties().setProperty("host", InetAddress.getLocalHost().getHostAddress());
                    }
                    catch (UnknownHostException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileRepository.initialize", (String)"252", (Object)this);
                        this.ftConfig.getProperties().setProperty("host", "localhost");
                    }
                }
                String auditString = props.getProperty("auditingEnabled");
                if (auditString != null) {
                    this.auditingEnabled = auditString.equalsIgnoreCase("true");
                }
                this.allowOverwrites = this.processType.equals("NodeAgent") || !this.inServer;
                allowOverwritesProp = props.getProperty("allowConfigOverwrites");
                if (allowOverwritesProp == null) break block57;
                if (!allowOverwritesProp.equals("false")) break block58;
                if (this.processType.equals("DeploymentManager") || this.processType.equals("ManagedProcess")) {
                    this.allowOverwrites = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Overwrites are disabled.");
                    }
                    break block57;
                } else {
                    Tr.warning(tc, "ADMR0022W");
                }
                break block57;
            }
            if (allowOverwritesProp.equals("true")) {
                this.allowOverwrites = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Overwrites are enabled.");
                }
            }
        }
        this.configProperties.setProperty("allowConfigOverwrites", String.valueOf(this.allowOverwrites));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processProps");
        }
    }

    public FileTransferOptions getFileTransferOptions() {
        this.checkAdminContext();
        return this.ftOptions;
    }

    public FileTransferConfig getFileTransferConfig() {
        this.checkAdminContext();
        return this.ftConfig;
    }

    public void setFileTransferConfig(FileTransferConfig config) {
        this.checkAdminContext();
        this.ftConfig = config;
        this.document.setRepository(this);
    }

    public String getTempDir() {
        this.checkAdminContext();
        return this.tempDir;
    }

    public String getBackupDir() {
        this.checkAdminContext();
        return this.backupDir;
    }

    public DocumentDigest create(DocumentContentSource contents) throws RepositoryException {
        this.checkAdminContext();
        DocumentContentSource[] dcs = new DocumentContentSource[]{contents};
        DocumentDigest[] digest = this.create(dcs);
        return digest[0];
    }

    public DocumentDigest[] create(DocumentContentSource[] creates) throws RepositoryException {
        this.checkAdminContext();
        HashMap results = this.update(creates, null, null);
        DocumentDigest[] digests = new DocumentDigest[creates.length];
        for (int i = 0; i < creates.length; ++i) {
            digests[i] = (DocumentDigest)results.get(creates[i].getDocument().getURI());
        }
        return digests;
    }

    private synchronized void preCreate(DocumentContentSource[] contents) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preCreate", contents);
        }
        int i = 0;
        try {
            for (i = 0; i < contents.length; ++i) {
                String docURI = contents[i].getDocument().getURI();
                this.checkAccessPermission(docURI, 1);
                this.lockDocument(docURI);
                if (this.status(docURI) == 2) continue;
                this.clearSource(contents);
                this.unlockDocument(docURI);
                Tr.service(tc, "ADMR0000E", docURI);
                throw new DocumentAlreadyExistsException(docURI);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.preCreate", (String)"536", (Object)this);
            for (int j = 0; j < i; ++j) {
                try {
                    this.unlockDocument(contents[j].getDocument().getURI());
                    continue;
                }
                catch (Throwable t2) {
                    Tr.warning(tc, "ADMR0107E", new Object[]{contents[j].getDocument().getURI(), t2});
                }
            }
            throw this.getRepositoryException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preCreate", contents);
        }
    }

    private DocumentDigest[] createInternal(DocumentContentSource[] contents) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createInternal");
        }
        DocumentDigest[] digests = new DocumentDigest[contents.length];
        int i = 0;
        try {
            for (i = 0; i < contents.length; ++i) {
                String docURI = contents[i].getDocument().getURI();
                digests[i] = this.document.create(contents[i]);
            }
        }
        catch (Throwable t) {
            int j;
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.createInternal", (String)"579", (Object)this);
            for (j = 0; j <= i; ++j) {
                try {
                    this.document.delete(contents[j].getDocument().getURI());
                    continue;
                }
                catch (Throwable t2) {
                    Tr.warning(tc, "ADMR0113E", new Object[]{contents[j].getDocument().getURI(), t2});
                }
            }
            while (j < contents.length) {
                this.clearSource(contents[j]);
                ++j;
            }
            throw this.getRepositoryException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createInternal");
        }
        return digests;
    }

    private void postCreate(DocumentContentSource[] contents) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postCreate");
        }
        for (int i = 0; i < contents.length; ++i) {
            String docURI = contents[i].getDocument().getURI();
            try {
                this.unlockDocument(docURI);
                continue;
            }
            catch (Throwable t) {
                Tr.warning(tc, "ADMR0107E", new Object[]{docURI, t});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postCreate");
        }
    }

    private void undoCreate(DocumentContentSource[] contents) {
        for (int i = 0; i < contents.length; ++i) {
            try {
                this.document.delete(contents[i].getDocument().getURI());
                continue;
            }
            catch (Throwable t) {
                Tr.warning(tc, "ADMR0113E", new Object[]{contents[i].getDocument().getURI(), t});
            }
        }
    }

    public void delete(Document doc) throws RepositoryException {
        this.checkAdminContext();
        Document[] d = new Document[]{doc};
        this.delete(d);
    }

    public void delete(String docURI) throws RepositoryException {
        this.checkAdminContext();
        this.delete(new Document(docURI));
    }

    public void delete(Document[] deletes) throws RepositoryException {
        this.checkAdminContext();
        this.update(null, null, deletes);
    }

    public void delete(String[] docURIs) throws RepositoryException {
        this.checkAdminContext();
        Document[] docs = new Document[docURIs.length];
        for (int i = 0; i < docs.length; ++i) {
            docs[i] = new Document(docURIs[i]);
        }
        this.delete(docs);
    }

    private synchronized void preDelete(Document[] docs) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preDelete");
        }
        int i = 0;
        try {
            for (i = 0; i < docs.length; ++i) {
                this.checkAccessPermission(docs[i].getURI(), 1);
                this.lockDocument(docs[i].getURI());
                int docStatus = this.status(docs[i].getURI());
                if (docStatus == 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "invalid URI " + docs[i].getURI());
                    }
                    this.unlockDocument(docs[i].getURI());
                    throw new DocumentNotFoundException(docs[i].getURI());
                }
                try {
                    this.document.backup(docs[i].getURI());
                    continue;
                }
                catch (Throwable t) {
                    this.unlockDocument(docs[i].getURI());
                    throw t;
                }
            }
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pre delete caught exception", t);
            }
            for (int j = 0; j < i; ++j) {
                try {
                    this.document.removeBackup(docs[j].getURI());
                }
                catch (Throwable t2) {
                    Tr.warning(tc, "ADMR0110W", new Object[]{docs[j].getURI(), t2});
                }
                try {
                    this.unlockDocument(docs[j].getURI());
                    continue;
                }
                catch (Throwable t2) {
                    Tr.warning(tc, "ADMR0107E", new Object[]{docs[j].getURI(), t2});
                }
            }
            throw this.getRepositoryException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkExistenceAndLock");
        }
    }

    private void deleteInternal(Document[] docs) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteInternal");
        }
        int i = 0;
        try {
            for (i = 0; i < docs.length; ++i) {
                this.document.delete(docs[i].getURI());
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.deleteInternal", (String)"852", (Object)this);
            for (int j = 0; j <= i; ++j) {
                try {
                    this.document.restore(docs[j].getURI());
                    continue;
                }
                catch (Throwable t2) {
                    Tr.error(tc, "ADMR0109E", new Object[]{docs[j].getURI(), t2});
                }
            }
            Tr.error(tc, "ADMR0111E", docs[i].getURI());
            throw this.getRepositoryException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteInternal");
        }
    }

    private void postDelete(Document[] docs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postDelete");
        }
        for (int i = 0; i < docs.length; ++i) {
            try {
                this.document.removeBackup(docs[i].getURI());
            }
            catch (Throwable t) {
                Tr.warning(tc, "ADMR0110W", new Object[]{docs[i].getURI(), t});
            }
            try {
                this.unlockDocument(docs[i].getURI());
                continue;
            }
            catch (Throwable t) {
                Tr.warning(tc, "ADMR0107E", new Object[]{docs[i].getURI(), t});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postDelete");
        }
    }

    public void rename(String docURI, String newDocURI) throws RepositoryException {
        this.checkAdminContext();
        this.rename(new Document(docURI), new Document(newDocURI));
    }

    public void rename(Document doc, Document newDoc) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rename");
        }
        this.checkAdminContext();
        DocumentContentSource[] create = new DocumentContentSource[]{this.extract(doc)};
        create[0].getDocument().setURI(newDoc.getURI());
        Document[] delete = new Document[]{doc};
        this.update(create, null, delete);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rename");
        }
    }

    public DocumentContentSource extract(String docURI) throws RepositoryException {
        this.checkAdminContext();
        return this.extract(new Document(docURI));
    }

    public DocumentContentSource extract(Document doc) throws RepositoryException {
        this.checkAdminContext();
        Document[] d = new Document[]{doc};
        DocumentContentSource[] dcs = this.extract(d);
        return dcs[0];
    }

    public DocumentContentSource[] extract(String[] docURIs) throws RepositoryException {
        this.checkAdminContext();
        Document[] docs = new Document[docURIs.length];
        for (int i = 0; i < docs.length; ++i) {
            docs[i] = new Document(docURIs[i]);
        }
        return this.extract(docs);
    }

    public DocumentContentSource[] extract(Document[] docs) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract[]");
        }
        this.checkAdminContext();
        if (docs == null) {
            return new DocumentContentSource[0];
        }
        this.fixURIs(docs);
        ArrayList<Document> newDocs = new ArrayList<Document>();
        ArrayList<String> failedList = new ArrayList<String>();
        for (int i = 0; i < docs.length; ++i) {
            String uri = docs[i].getURI();
            if (this.checkInvocationPermission(uri, 0, "access resource")) {
                newDocs.add(docs[i]);
                continue;
            }
            failedList.add(uri);
        }
        if (failedList.size() > 0) {
            this.throwRepositoryException(failedList);
        }
        Document[] allowedDocs = newDocs.toArray(new Document[0]);
        DocumentContentSource[] contents = this.extractInternal(allowedDocs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract[]");
        }
        return contents;
    }

    private DocumentContentSource[] extractInternal(Document[] docs) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractInternal");
        }
        DocumentContentSource[] contents = new DocumentContentSource[docs.length];
        for (int i = 0; i < docs.length; ++i) {
            this.checkAccessPermission(docs[i].getURI(), 0);
            int docStatus = this.status(docs[i].getURI());
            if (docStatus == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extract: invalid URI; " + docs[i].getURI());
                }
                throw new DocumentNotFoundException(docs[i].getURI());
            }
            if (docStatus == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extract: unavailable URI; " + docs[i].getURI());
                }
                throw new DocumentUnavailableException(docs[i].getURI());
            }
            contents[i] = this.document.read(docs[i].getURI());
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Extracted " + docs[i].getURI() + "; digest is " + contents[i].getDocument().getDigest());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractInternal");
        }
        return contents;
    }

    public DocumentContentSource extract(String docURI, String version) {
        this.checkAdminContext();
        throw new UnsupportedOperationException();
    }

    public DocumentContentSource[] extract(String[] docURIs, String[] versions) {
        this.checkAdminContext();
        throw new UnsupportedOperationException();
    }

    public DocumentDigest modify(DocumentContentSource contents) throws RepositoryException {
        this.checkAdminContext();
        DocumentContentSource[] dcs = new DocumentContentSource[]{contents};
        DocumentDigest[] digest = this.modify(dcs);
        return digest[0];
    }

    public DocumentDigest[] modify(DocumentContentSource[] mods) throws RepositoryException {
        this.checkAdminContext();
        HashMap results = this.update(null, mods, null);
        DocumentDigest[] digests = new DocumentDigest[mods.length];
        for (int i = 0; i < mods.length; ++i) {
            digests[i] = (DocumentDigest)results.get(mods[i].getDocument().getURI());
        }
        return digests;
    }

    private synchronized void preModify(DocumentContentSource[] contents) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preModify");
        }
        int i = 0;
        try {
            for (i = 0; i < contents.length; ++i) {
                Document doc = contents[i].getDocument();
                this.checkAccessPermission(doc.getURI(), 1);
                this.lockDocument(doc.getURI());
                int docStatus = this.status(doc.getURI());
                if (docStatus == 2) {
                    this.clearSource(contents);
                    this.unlockDocument(doc.getURI());
                    throw new DocumentNotFoundException(doc.getURI());
                }
                try {
                    this.checkDigest(doc);
                    this.document.backup(doc.getURI());
                    continue;
                }
                catch (Throwable t) {
                    this.unlockDocument(doc.getURI());
                    throw t;
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.preModify", (String)"1009", (Object)this);
            for (int j = 0; j < i; ++j) {
                try {
                    this.document.removeBackup(contents[j].getDocument().getURI());
                }
                catch (Throwable t2) {
                    Tr.warning(tc, "ADMR0110W", new Object[]{contents[j].getDocument().getURI(), t2});
                }
                try {
                    this.unlockDocument(contents[j].getDocument().getURI());
                    continue;
                }
                catch (Throwable t2) {
                    Tr.warning(tc, "ADMR0107E", new Object[]{contents[j].getDocument().getURI(), t2});
                }
            }
            throw this.getRepositoryException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preModify");
        }
    }

    private DocumentDigest[] modifyInternal(DocumentContentSource[] contents) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyInternal");
        }
        DocumentDigest[] digests = new DocumentDigest[contents.length];
        int i = 0;
        try {
            for (i = 0; i < contents.length; ++i) {
                digests[i] = this.document.write(contents[i]);
            }
        }
        catch (Throwable t) {
            int j;
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.modifyInternal", (String)"1061", (Object)this);
            for (j = 0; j <= i; ++j) {
                try {
                    this.document.restore(contents[j].getDocument().getURI());
                    continue;
                }
                catch (Throwable t2) {
                    Tr.error(tc, "ADMR0109E", new Object[]{contents[j].getDocument().getURI(), t2});
                }
            }
            while (j < contents.length) {
                this.clearSource(contents[j]);
                ++j;
            }
            throw this.getRepositoryException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyInternal");
        }
        return digests;
    }

    private void postModify(DocumentContentSource[] contents) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postModify");
        }
        for (int i = 0; i < contents.length; ++i) {
            String docURI = contents[i].getDocument().getURI();
            try {
                this.document.removeBackup(docURI);
            }
            catch (Throwable t) {
                Tr.warning(tc, "ADMR0110W", new Object[]{docURI, t});
            }
            try {
                this.unlockDocument(docURI);
                continue;
            }
            catch (Throwable t) {
                Tr.warning(tc, "ADMR0107E", new Object[]{docURI, t});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postModify");
        }
    }

    private void undoModify(DocumentContentSource[] contents) {
        for (int i = 0; i < contents.length; ++i) {
            try {
                this.document.restore(contents[i].getDocument().getURI());
                continue;
            }
            catch (Throwable t) {
                Tr.warning(tc, "ADMR0109E", new Object[]{contents[i].getDocument().getURI(), t});
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap update(DocumentContentSource[] creates, DocumentContentSource[] modifies, Document[] deletes) throws RepositoryException {
        ConfigRepositoryEvent event2;
        HashMap result;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "update");
            }
            this.checkAdminContext();
            if (creates == null) {
                creates = new DocumentContentSource[]{};
            }
            if (modifies == null) {
                modifies = new DocumentContentSource[]{};
            }
            if (deletes == null) {
                deletes = new Document[]{};
            }
            this.fixURIs(creates);
            this.fixURIs(modifies);
            this.fixURIs(deletes);
            result = null;
            ArrayList<String> failedList = new ArrayList<String>();
            ArrayList<Object> newDocs = new ArrayList<Object>();
            for (int i = 0; i < creates.length; ++i) {
                String uri = creates[i].getDocument().getURI();
                if (this.checkInvocationPermission(uri, 1, "add resource")) {
                    newDocs.add(creates[i]);
                    continue;
                }
                failedList.add(uri);
            }
            DocumentContentSource[] allowedCreates = newDocs.toArray(new DocumentContentSource[0]);
            newDocs = new ArrayList();
            for (int i = 0; i < deletes.length; ++i) {
                String uri = deletes[i].getURI();
                if (this.checkInvocationPermission(uri, 1, "delete resource")) {
                    newDocs.add(deletes[i]);
                    continue;
                }
                failedList.add(uri);
            }
            Document[] allowedDeletes = newDocs.toArray(new Document[0]);
            newDocs = new ArrayList();
            for (int i = 0; i < modifies.length; ++i) {
                String uri = modifies[i].getDocument().getURI();
                if (this.checkInvocationPermission(uri, 1, "modify resource")) {
                    newDocs.add(modifies[i]);
                    continue;
                }
                failedList.add(uri);
            }
            if (failedList.size() > 0) {
                this.throwRepositoryException(failedList);
            }
            DocumentContentSource[] allowedModifies = newDocs.toArray(new DocumentContentSource[0]);
            this.preUpdate(allowedCreates, allowedModifies, allowedDeletes);
            event2 = this.preNotify(allowedCreates, allowedModifies, allowedDeletes);
            try {
                result = this.updateInternal(allowedCreates, allowedModifies, allowedDeletes);
                Object var13_16 = null;
                this.postUpdate(allowedCreates, allowedModifies, allowedDeletes);
                if (result == null) break block19;
                this.updateRepositoryEpoch();
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                this.postUpdate(allowedCreates, allowedModifies, allowedDeletes);
                if (result != null) {
                    this.updateRepositoryEpoch();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Repository epoch updated");
                    }
                }
                this.postNotify(event2, result != null);
                throw throwable;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Repository epoch updated");
            }
        }
        this.postNotify(event2, result != null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update", result);
        }
        return result;
    }

    private void throwRepositoryException(List failedList) throws RepositoryException {
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < failedList.size(); ++i) {
                sb.append((String)failedList.get(i)).append("\n");
            }
            throw new Exception(sb.toString());
        }
        catch (Exception e) {
            Tr.audit(tc, "ADMR0024E", new Object[]{SecurityHelper.getUserName(), Integer.toString(failedList.size())});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileRepository.update", (String)"1395", (Object)this);
            throw new RepositoryException("Caller is not in the required role to access restricted document(s)");
        }
    }

    private synchronized void preUpdate(DocumentContentSource[] creates, DocumentContentSource[] modifies, Document[] deletes) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preUpdate");
        }
        this.preCreate(creates);
        try {
            this.preModify(modifies);
            try {
                this.preDelete(deletes);
            }
            catch (RepositoryException e) {
                this.postModify(modifies);
                throw e;
            }
        }
        catch (RepositoryException e) {
            this.postCreate(creates);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preUpdate");
        }
    }

    private HashMap updateInternal(DocumentContentSource[] creates, DocumentContentSource[] modifies, Document[] deletes) throws RepositoryException {
        HashMap<String, DocumentDigest> result = null;
        DocumentDigest[] createDigests = null;
        DocumentDigest[] modDigests = null;
        boolean createComplete = false;
        boolean modifyComplete = false;
        boolean success = false;
        try {
            int i;
            createDigests = this.createInternal(creates);
            createComplete = true;
            modDigests = this.modifyInternal(modifies);
            modifyComplete = true;
            this.deleteInternal(deletes);
            result = new HashMap<String, DocumentDigest>();
            for (i = 0; i < creates.length; ++i) {
                result.put(creates[i].getDocument().getURI(), createDigests[i]);
            }
            for (i = 0; i < modifies.length; ++i) {
                result.put(modifies[i].getDocument().getURI(), modDigests[i]);
            }
        }
        catch (RepositoryException e) {
            if (createComplete) {
                this.undoCreate(creates);
            }
            if (modifyComplete) {
                this.undoModify(modifies);
            }
            throw e;
        }
        return result;
    }

    private void postUpdate(DocumentContentSource[] creates, DocumentContentSource[] modifies, Document[] deletes) {
        this.postCreate(creates);
        this.postModify(modifies);
        this.postDelete(deletes);
    }

    public DocumentDigest getDigest(String docURI) throws DocumentNotFoundException, DocumentIOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDigest: " + docURI);
        }
        this.checkAdminContext();
        if (this.status(docURI) == 2) {
            throw new DocumentNotFoundException(docURI);
        }
        DocumentDigestImpl d = this.document.getDigest(docURI);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDigest");
        }
        return d;
    }

    public DocumentDigest[] getDigest(String[] docURIs) throws DocumentNotFoundException, DocumentIOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDigest[]");
        }
        this.checkAdminContext();
        DocumentDigest[] digests = new DocumentDigest[docURIs.length];
        for (int i = 0; i < docURIs.length; ++i) {
            digests[i] = this.getDigest(docURIs[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDigest[]");
        }
        return digests;
    }

    public Boolean lockRepository(String reason) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lockRepository");
        }
        this.checkAdminContext();
        if (this.repositoryLock.isRepositoryLocked()) {
            return Boolean.FALSE;
        }
        boolean set = false;
        for (int i = 0; !set && i < 20; ++i) {
            set = this.lockRepository();
            if (set) continue;
            this.sleep(500L);
        }
        if (set) {
            Tr.service(tc, "ADMR0007I", reason);
            Object[] listenersCopy = this.getListenersCopy();
            for (int i = 0; i < listenersCopy.length; ++i) {
                ConfigRepositoryListener listener = (ConfigRepositoryListener)listenersCopy[i];
                try {
                    listener.onRepositoryLock();
                    continue;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.lockRepository", (String)"1519", (Object)this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lockRepository", set ? Boolean.TRUE : Boolean.FALSE);
        }
        return set ? Boolean.TRUE : Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockRepository() {
        boolean result = false;
        HashSet hashSet = this.locks;
        synchronized (hashSet) {
            if (this.locks.isEmpty() && !this.repositoryLock.isRepositoryLocked() && this.repositoryLock.lockRepository()) {
                result = true;
            }
        }
        return result;
    }

    private void sleep(long millis) {
        try {
            Thread.currentThread();
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean unlockRepository(String reason) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unlockRepository");
        }
        this.checkAdminContext();
        boolean set = false;
        HashSet hashSet = this.locks;
        synchronized (hashSet) {
            if (this.repositoryLock.isRepositoryLocked() && this.repositoryLock.unlockRepository()) {
                set = true;
            }
        }
        if (set) {
            Tr.service(tc, "ADMR0008I", reason);
            Object[] listenersCopy = this.getListenersCopy();
            for (int i = 0; i < listenersCopy.length; ++i) {
                ConfigRepositoryListener listener = (ConfigRepositoryListener)listenersCopy[i];
                try {
                    listener.onRepositoryUnlock();
                    continue;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.unlockRepository", (String)"1594", (Object)this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unlockRepository", set ? Boolean.TRUE : Boolean.FALSE);
        }
        return set ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getRepositoryDir() {
        this.checkAdminContext();
        return this.repositoryDir;
    }

    private boolean exists(String docURI) {
        this.checkAdminContext();
        File f = new File(this.getRepositoryDir() + "/" + docURI.replace('\\', '/'));
        return f.exists();
    }

    private int status(String docURI) {
        int result = 2;
        if (this.exists(docURI)) {
            result = 0;
        } else if (this.exists(docURI + ".digest")) {
            result = 1;
        }
        return result;
    }

    private void clearSource(DocumentContentSource contents) {
        block3: {
            try {
                if (contents != null && contents.getSource() != null) {
                    contents.getSource().close();
                    contents.setSource((InputStream)null);
                }
            }
            catch (Throwable t) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "clearSource error " + t.getMessage());
            }
        }
    }

    private void clearSource(DocumentContentSource[] contents) {
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                this.clearSource(contents[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockDocument(String docURI) throws DocumentLockedException, RepositoryLockedException {
        if (this.repositoryLock.isRepositoryLocked() && !this.repositoryLock.isLockOwner()) {
            throw new RepositoryLockedException();
        }
        boolean set = false;
        for (int i = 0; !set && i < 20; ++i) {
            HashSet hashSet = this.locks;
            synchronized (hashSet) {
                set = this.locks.add(docURI);
            }
            if (set) continue;
            this.sleep(500L);
        }
        if (set) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Locked " + docURI);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, docURI + " already locked");
            }
            throw new DocumentLockedException(docURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockDocument(String docURI) {
        boolean result;
        HashSet hashSet = this.locks;
        synchronized (hashSet) {
            result = this.locks.remove(docURI);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unlocked " + docURI + "; " + result);
        }
    }

    private void unlockDocument(Document doc) {
        this.unlockDocument(doc.getURI());
    }

    private void checkDigest(Document doc) throws DocumentIOException, DocumentChangedException {
        DocumentDigestImpl currentDigest = this.document.getDigest(doc.getURI());
        if (!((Object)currentDigest).equals(doc.getDigest())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Digest check failed.  Given digest is " + doc.getDigest() + "; current digest is " + currentDigest);
            }
            if (!this.allowOverwrites || !doc.getOverwrite()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "modify " + doc.getURI() + "; digest check");
                }
                throw new DocumentChangedException(doc.getURI());
            }
            if (!this.processType.equals("NodeAgent")) {
                Tr.warning(tc, "ADMR0114W", doc.getURI());
            }
        }
    }

    private RepositoryException getRepositoryException(Throwable t) {
        RepositoryException re = null;
        re = t instanceof RepositoryException ? (RepositoryException)t : new RepositoryException(t);
        return re;
    }

    private void fixURIs(DocumentContentSource[] contents) throws RepositoryException {
        for (int i = 0; i < contents.length; ++i) {
            String uri = contents[i].getDocument().getURI().replace('\\', '/');
            if (uri.indexOf("../") > -1) {
                throw new InvalidDocumentURIException("Document URI uses relative path name: " + uri);
            }
            contents[i].getDocument().setURI(uri);
        }
    }

    private void fixURIs(Document[] docs) throws RepositoryException {
        for (int i = 0; i < docs.length; ++i) {
            String uri = docs[i].getURI().replace('\\', '/');
            if (uri.indexOf("../") > -1) {
                throw new InvalidDocumentURIException("Document URI uses relative path name: " + uri);
            }
            docs[i].setURI(uri);
        }
    }

    private void audit(ConfigRepositoryEvent event2) {
        String msgID = null;
        String userID = null;
        String saAction = null;
        Object[] params = null;
        if (this.auditingEnabled) {
            userID = SecurityHelper.getAuditUserName();
            ConfigChangeNotifier[] changes = event2.getChanges();
            for (int i = 0; i < changes.length; ++i) {
                if (changes[i].getChangeType() == 0) {
                    msgID = userID == null ? "ADMR0009I" : "ADMR0015I";
                    saAction = "add resource";
                } else if (changes[i].getChangeType() == 2) {
                    msgID = userID == null ? "ADMR0010I" : "ADMR0016I";
                    saAction = "modify resource";
                } else {
                    msgID = userID == null ? "ADMR0011I" : "ADMR0017I";
                    saAction = "delete resource";
                }
                params = userID == null ? new Object[]{changes[i].getUri()} : new Object[]{changes[i].getUri(), userID};
                Tr.audit(tc, msgID, params);
                SecurityAuditingHelper.getInstance().logSecurityAuditForRepository(true, this.getClass().getName(), saAction, userID, changes[i].getUri());
            }
        }
    }

    private ConfigRepositoryEvent preNotify(DocumentContentSource[] adds, DocumentContentSource[] mods, Document[] deletes) {
        int i;
        ConfigChangeNotifier[] notifiers = new ConfigChangeNotifier[adds.length + mods.length + deletes.length];
        int n = 0;
        for (i = 0; i < adds.length; ++i) {
            notifiers[n++] = new ConfigChangeNotifier(adds[i].getDocument().getURI(), 0);
        }
        for (i = 0; i < mods.length; ++i) {
            notifiers[n++] = new ConfigChangeNotifier(mods[i].getDocument().getURI(), 2);
        }
        for (i = 0; i < deletes.length; ++i) {
            notifiers[n++] = new ConfigChangeNotifier(deletes[i].getURI(), 1);
        }
        ConfigRepositoryEvent event2 = new ConfigRepositoryEvent((ConfigRepository)this, ConfigRepositoryEvent.generateId(), notifiers);
        Object[] listenersCopy = this.getListenersCopy();
        for (int i2 = 0; i2 < listenersCopy.length; ++i2) {
            ConfigRepositoryListener listener = (ConfigRepositoryListener)listenersCopy[i2];
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling listener onChangeStart: " + listener);
                }
                listener.onChangeStart(event2);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Back from listener onChangeStart: " + listener);
                continue;
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.preNotify", (String)"1836", (Object)this);
            }
        }
        return event2;
    }

    private void postNotify(ConfigRepositoryEvent event2, boolean success) {
        if (!success) {
            ConfigRepositoryEvent newEvent;
            ConfigChangeNotifier[] notifiers = new ConfigChangeNotifier[]{};
            event2 = newEvent = new ConfigRepositoryEvent((ConfigRepository)this, event2.getId(), notifiers);
        }
        Object[] listenersCopy = this.getListenersCopy();
        ConfigRepositoryListener thisListener = null;
        for (int i = 0; i < listenersCopy.length; ++i) {
            ConfigRepositoryListener listener = (ConfigRepositoryListener)listenersCopy[i];
            try {
                if (!listener.equals(this)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling listener onChangeCompletion: " + listener);
                    }
                    listener.onChangeCompletion(event2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Back from listener onChangeCompletion: " + listener);
                    continue;
                }
                thisListener = listener;
                continue;
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.postNotify", (String)"1870", (Object)this);
            }
        }
        if (thisListener != null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling JMX listener onChangeCompletion: " + thisListener);
                }
                thisListener.onChangeCompletion(event2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Back from JMX listener onChangeCompletion: " + thisListener);
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.postNotify", (String)"1926", (Object)this);
            }
        }
    }

    public String[] listResourceNames(String parent, int type, int depth, ResourceNameFilter flt) {
        this.checkAdminContext();
        ResourceNameFilter filter = flt;
        if (filter == null) {
            filter = this;
        }
        File pf = new File(this.getRepositoryDir() + "/" + parent);
        if (this.status(parent) == 2) {
            return new String[0];
        }
        if (depth == 0) {
            if (filter == this) {
                if (filter.accept(parent, "") && this.isMatchingType(pf, type)) {
                    return new String[]{parent};
                }
                return new String[0];
            }
            if (this.accept(parent, "") && filter.accept(parent, "") && this.isMatchingType(pf, type)) {
                return new String[]{parent};
            }
            return new String[0];
        }
        ArrayList list = new ArrayList();
        if (pf.list() != null) {
            this.addResourceNames(list, pf, type, depth - 1, filter);
        }
        if (list.size() > 0) {
            String[] ret = new String[list.size()];
            list.toArray(ret);
            return ret;
        }
        return new String[0];
    }

    private boolean eliminateEmptyFolders(ArrayList list, File dir) {
        boolean empty = true;
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length && (empty = files[i].isDirectory() ? this.eliminateEmptyFolders(list, files[i]) : false); ++i) {
            }
        } else {
            this.removeEmptyFolder(list, dir);
        }
        return empty;
    }

    protected void addResourceNames(ArrayList list, File dir, int type, int depth, ResourceNameFilter filter) {
        File[] files = this.getFiles(dir);
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (filter == this) {
                    if (filter.accept(this.getUri(dir), files[i].getName()) && this.isMatchingType(files[i], type)) {
                        list.add(this.getUri(files[i]));
                    }
                } else if (this.accept(this.getUri(dir), files[i].getName()) && filter.accept(this.getUri(dir), files[i].getName()) && this.isMatchingType(files[i], type)) {
                    list.add(this.getUri(files[i]));
                }
                if (!files[i].isDirectory()) continue;
                if (depth > 0) {
                    this.addResourceNames(list, files[i], type, depth - 1, filter);
                    continue;
                }
                this.eliminateEmptyFolders(list, files[i]);
            }
        } else {
            this.removeEmptyFolder(list, dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEmptyFolder(ArrayList list, File dir) {
        if (!dir.equals(this.tempDirectory) && !dir.equals(this.backupDirectory)) {
            if (list.contains(this.getUri(dir))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing " + this.getUri(dir));
                }
                list.remove(this.getUri(dir));
            }
            Object object = this.document.getDirLock();
            synchronized (object) {
                if (dir.delete()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Deleted " + this.getUri(dir));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to delete " + this.getUri(dir));
                }
            }
            File parent = dir.getParentFile();
            File[] files = parent.listFiles();
            if (files != null && files.length < 1) {
                this.removeEmptyFolder(list, parent);
            }
        }
    }

    private File[] getFiles(File dir) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFiles");
        }
        File[] origFiles = dir.listFiles();
        HashMap<String, File> files = new HashMap<String, File>();
        if (origFiles != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Working with " + origFiles.length + " files found in directory!! ");
            }
            for (int i = 0; i < origFiles.length; ++i) {
                String name = origFiles[i].getName();
                if (name.endsWith(".digest")) {
                    String docName = name.substring(0, name.lastIndexOf(".digest"));
                    files.put(docName, new File(dir, docName));
                    continue;
                }
                files.put(name, origFiles[i]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No files found in directory!! ");
        }
        File[] newFiles = new File[files.size()];
        int i = 0;
        if (files.size() > 0) {
            for (Map.Entry e : files.entrySet()) {
                newFiles[i++] = (File)e.getValue();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No files to return!! ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFiles");
        }
        return newFiles;
    }

    public String[] listResourceNames(String parent, int type, int depth) {
        this.checkAdminContext();
        return this.listResourceNames(parent, type, depth, this);
    }

    protected int getType(File file) {
        if (file.isDirectory()) {
            return 2;
        }
        return 1;
    }

    protected boolean isMatchingType(int type, int typeOptions) {
        return (type & typeOptions) != 0;
    }

    protected boolean isMatchingType(File file, int typeOptions) {
        int type = this.getType(file);
        return (type & typeOptions) != 0;
    }

    protected String getUri(File file) {
        String ap = file.getAbsolutePath();
        if (ap.length() <= this.getRepositoryDir().length()) {
            return "/";
        }
        return ap.substring(this.getRepositoryDir().length() + 1).replace('\\', '/');
    }

    public boolean accept(String parent, String name) {
        this.checkAdminContext();
        boolean result = true;
        if (parent.equals("/")) {
            result = !name.equals("backup") && !name.equals("temp");
        } else if (parent.equals("backup") || parent.startsWith("backup/") || parent.equals("temp") || parent.startsWith("temp/")) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigRepositoryListener listener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding listener: " + listener);
        }
        this.checkAdminContext();
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (listener != null && !this.listeners.contains(listener)) {
                if (listener instanceof CellSync) {
                    this.listeners.add(0, listener);
                } else {
                    this.listeners.add(listener);
                }
                this.listenersUpdated = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConfigRepositoryListener listener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removing listener: " + listener);
        }
        this.checkAdminContext();
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
            this.listenersUpdated = true;
        }
    }

    public ConfigEpoch getRepositoryEpoch() {
        this.checkAdminContext();
        return this.repositoryEpoch;
    }

    public ConfigEpoch refreshRepositoryEpoch() {
        this.checkAdminContext();
        this.repositoryEpoch.refresh();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Refreshed repository epoch: " + this.repositoryEpoch);
        }
        Object[] listenersCopy = this.getListenersCopy();
        for (int i = 0; i < listenersCopy.length; ++i) {
            ConfigRepositoryListener listener = (ConfigRepositoryListener)listenersCopy[i];
            try {
                listener.onRepositoryEpochRefresh();
                continue;
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.refreshRepositoryEpoch", (String)"2091", (Object)this);
            }
        }
        return this.repositoryEpoch;
    }

    private void updateRepositoryEpoch() {
        this.repositoryEpoch.update();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Updated repository epoch: " + this.repositoryEpoch);
        }
    }

    public void createDigestFile(String docURI, boolean delete) throws RepositoryException {
        this.checkAdminContext();
        docURI = docURI.replace('\\', '/');
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createDigestFile: " + docURI);
        }
        this.lockDocument(docURI);
        String digestURI = docURI + ".digest";
        try {
            this.lockDocument(digestURI);
        }
        catch (DocumentLockedException e) {
            this.unlockDocument(docURI);
            throw e;
        }
        try {
            int docStatus = this.status(docURI);
            if (docStatus == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createDigestFile: invalid URI " + docURI);
                }
                throw new DocumentNotFoundException(docURI);
            }
            if (docStatus == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createDigestFile: unavailable URI; " + docURI);
                }
                throw new DocumentUnavailableException(docURI);
            }
            this.document.createDigestFile(docURI, delete);
            Object var6_7 = null;
            this.unlockDocument(digestURI);
            this.unlockDocument(docURI);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.unlockDocument(digestURI);
            this.unlockDocument(docURI);
            throw throwable;
        }
    }

    public void onChangeCompletion(ConfigRepositoryEvent event2) {
        this.checkAdminContext();
        if (this.inServer) {
            try {
                Notification n = new Notification("websphere.repository.change", this.getObjectName(), System.currentTimeMillis());
                n.setUserData(event2);
                this.sendNotification(n);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.onChangeCompletion", (String)"1705", (Object)this);
            }
        }
        this.audit(event2);
    }

    public void onChangeStart(ConfigRepositoryEvent event2) {
        this.checkAdminContext();
    }

    public void onRepositoryLock() {
        this.checkAdminContext();
        if (this.inServer) {
            try {
                Notification n = new Notification("websphere.repository.lock", this.getObjectName(), System.currentTimeMillis());
                this.sendNotification(n);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.onRepositoryLock", (String)"1742", (Object)this);
            }
        }
    }

    public void onRepositoryUnlock() {
        this.checkAdminContext();
        if (this.inServer) {
            try {
                Notification n = new Notification("websphere.repository.unlock", this.getObjectName(), System.currentTimeMillis());
                this.sendNotification(n);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.onRepositoryUnlock", (String)"1762", (Object)this);
            }
        }
    }

    public void onRepositoryEpochRefresh() {
        this.checkAdminContext();
        if (this.inServer) {
            try {
                Notification n = new Notification("websphere.repository.epoch.refresh", this.getObjectName(), System.currentTimeMillis());
                this.sendNotification(n);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.onRepositoryEpochRefresh", (String)"1954", (Object)this);
            }
        }
        Tr.audit(tc, "ADMR0012I");
    }

    private void checkAccessPermission(String docURI, int accessType) throws RepositoryException {
        boolean restricted = accessType == 0 ? !RestrictedAccess.isReadable((String)docURI) : RestrictedAccess.isRestricted((String)docURI);
        if (this.inServer && restricted) {
            RoleBasedAuthorizer auth = this.getAuthorizer();
            String saAction = "access resource";
            String userID = "N/A";
            if (docURI.endsWith("admin-authz.xml") && auth.isCallerInRole("adminsecuritymanager")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adminsecuritymanager allowed access to admin-authz.xml");
                }
                SecurityAuditingHelper.getInstance().logSecurityAuditForRepository(true, this.getClass().getName(), saAction, userID, "admin-authz.xml");
            } else if (docURI.endsWith("audit-authz.xml") && auth.isCallerInRole("auditor")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "auditor allowed access to audit-authz.xml");
                }
                SecurityAuditingHelper.getInstance().logSecurityAuditForRepository(true, this.getClass().getName(), saAction, userID, "audit-authz.xml");
            } else if (!auth.isCallerInRole("administrator")) {
                Tr.audit(tc, "ADMR0021E", new Object[]{SecurityHelper.getUserName(), docURI});
                SecurityAuditingHelper.getInstance().logSecurityAuditForRepository(false, this.getClass().getName(), saAction, userID, docURI.toString());
                throw new RepositoryException("Caller is not in the required role to access restricted document: " + docURI);
            }
        }
    }

    private boolean checkInvocationPermission(String uri, int accessType, String saAction) {
        if (this.inServer && SecurityHelper.getHelper().isSecurityEnabled()) {
            String role = accessType == 0 ? "monitor" : "configurator";
            AdminAuthorizer auth = AdminAuthorizerFactory.getAdminAuthorizer();
            if (uri.endsWith("audit.xml") && role.equals("configurator")) {
                role = "auditor";
            }
            if (auth != null && !auth.checkAccess(uri, role)) {
                Tr.audit(tc, "ADMR0023E", new Object[]{SecurityHelper.getUserName(), ACCESS_TYPE_VERBIAGE[accessType], uri});
                return false;
            }
        }
        return true;
    }

    private RoleBasedAuthorizer getAuthorizer() throws RepositoryException {
        RoleBasedAuthorizer auth = null;
        try {
            auth = SecurityHelper.getHelper().getConfigurator().getRoleBasedAuthorizer("admin-authz", "scope");
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.getAuthorizer", (String)"2200", (Object)this);
            throw new RepositoryException(t, "Unable to get caller's security role");
        }
        return auth;
    }

    private synchronized Object[] getListenersCopy() {
        if (this.listenersUpdated) {
            this.listenersCopy = this.listeners.toArray();
            this.listenersUpdated = false;
        }
        return this.listenersCopy;
    }

    private ConfigEpoch loadRepositoryEpoch() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadRepositoryEpoch");
        }
        ConfigEpoch epoch = (ConfigEpoch)SerializationHelper.loadObject("repository.epoch");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadRepositoryEpoch");
        }
        return epoch;
    }

    public void persistRepositoryEpoch() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistRepositoryEpoch");
        }
        if (this.repositoryEpoch != null) {
            SerializationHelper.persistObject(this.repositoryEpoch, "repository.epoch");
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "epoch is null, no need to persist anything");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistRepositoryEpoch");
        }
    }

    private void checkAdminContext() {
        String uuid = AdminContext.peek();
        if (uuid == this.profileKey || uuid != null && uuid.equals(this.profileKey) || this.profileKey != null && this.profileKey.equals(uuid)) {
            return;
        }
        IllegalStateException ex = new IllegalStateException("FileRepository was created with uuuid: " + this.profileKey + " but AdminContext is : " + uuid);
        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.repository.FileRepository.checkAdminContext", (String)"2365", (Object)this);
        throw ex;
    }

    class TrashSweepTask
    implements Runnable,
    AlarmListener {
        private long sweepInterval;
        private long allowedSpan = 60L;
        private File tmpRoot;
        private boolean alarmSet = false;

        public TrashSweepTask(String tmpRootPath) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TrashSweepTask created with root tmpdir " + tmpRootPath);
            }
            this.tmpRoot = new File(tmpRootPath);
            this.sweepInterval = FileRepository.this.processType == "DeploymentManager" ? 30L : 120L;
            Tr.debug(tc, "sweepInterval set to " + this.sweepInterval + " minutes");
        }

        public void alarm(Object obj) {
            this.alarmSet = false;
            this.triggerSweep();
        }

        public void triggerSweep() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trash sweeper is triggered");
            }
            try {
                Thread thd = new Thread(this);
                thd.setDaemon(true);
                thd.start();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileRepository.TrashSweepTask.triggerSweep", (String)"2230", (Object)this);
            }
            if (!this.alarmSet) {
                AlarmManager.createNonDeferrable((long)(this.sweepInterval * 60000L), (AlarmListener)this);
                this.alarmSet = true;
            }
        }

        public void run() {
            this.sweep(this.tmpRoot);
        }

        private void sweep(File dir) {
            File[] files = dir.listFiles();
            if (files == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Clean up tmpfile was unsuccessful.");
                    Tr.debug(tc, dir.getPath() + " does not denote a directory, or an I/O error occured.");
                    Tr.debug(tc, "isReadable: " + dir.canRead());
                }
            } else {
                for (int j = 0; j < files.length; ++j) {
                    boolean success;
                    if (!files[j].exists()) continue;
                    if (files[j].isDirectory()) {
                        if (!files[j].getPath().endsWith("JobManager")) {
                            this.sweep(files[j]);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Clean up is skipping JobManager dir: " + files[j].getPath());
                        continue;
                    }
                    if (System.currentTimeMillis() - files[j].lastModified() <= this.allowedSpan * 6000L) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Clean up tmpfile " + files[j].getPath());
                    }
                    if ((success = files[j].delete()) || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "...but was unsuccessful");
                }
            }
        }
    }
}

