/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.nodeagent;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.nodeagent.MonitorConfig;
import com.ibm.ws.management.nodeagent.NodeAgent;
import com.ibm.ws.management.status.StatusCache;
import com.ibm.ws.management.status.StatusCacheFactory;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.StopParams;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

class PidWaiter
implements Runnable,
NotificationListener,
AlarmListener {
    private static final String resBundleName = "com.ibm.ws.management.resources.launcher";
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.launcher");
    private static TraceComponent tc = Tr.register(PidWaiter.class, "Admin", "com.ibm.ws.management.resources.launcher");
    private Process p = null;
    private String pid;
    private String processName = null;
    private String processNameIntiatedForStop = null;
    private int timeout = 0;
    private NodeAgent agent;
    private HashMap monitoringPolicies;
    private static VariableMap variableMap;
    private MonitorConfig cfg;
    private boolean processStopping = false;
    private Session session;
    private int processAliveTimeout = 20;
    private boolean zos = false;
    private boolean processIsTerminated = false;
    private ObjectName serverON = null;
    private Alarm contactAlarm = null;
    private ContactThread contactThread = null;
    private static Integer CONTACT_ALARM_CONTEXT;
    private static String CONTACT_ALARM_TIMEOUT_PROP;
    private String profileKey = null;
    private boolean crosslpar = false;
    private int pingInterval = 0;
    private boolean xcfMonitor_Enabled = false;

    PidWaiter(NodeAgent agent, Process p, String pid, VariableMap variableMap, String processName, int timeout, boolean adopted) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PidWaiter", pid);
        }
        this.agent = agent;
        this.p = p;
        this.pid = pid;
        PidWaiter.variableMap = variableMap;
        this.processName = processName;
        this.timeout = timeout;
        this.crosslpar = agent.getcrosslpar();
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.zos = true;
        }
        if (this.zos) {
            RoutingTable rt = RoutingTable.getInstance();
            this.xcfMonitor_Enabled = rt.isXCFMonitorEnabled();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "xcfMonitor_Enabled: " + this.xcfMonitor_Enabled);
            }
        }
        StatusCache nacache = StatusCacheFactory.getStatusCache();
        Integer processTimeoutI = Integer.getInteger("com.ibm.websphere.management.timeout.processAlive");
        if (processTimeoutI != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid " + pid + ": processAlive Timeout " + processTimeoutI);
            }
            this.processAliveTimeout = processTimeoutI;
        }
        this.monitoringPolicies = agent.getMonitoringPolicies();
        if (adopted) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid " + pid + ": adopted Child " + processName);
            }
            agent.addAdoptedChild(processName, pid);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid " + pid + ": launched Child " + processName + ":pid: " + pid);
            }
            agent.addLaunchedChild(processName, pid);
            if (nacache != null) {
                nacache.addToCache(0, processName, "j2ee.state.running");
            }
        }
        this.listenForInitiatedStoppingNotifications();
        this.listenForJ2EEStateStoppingNotifications();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PidWaiter", pid);
        }
    }

    PidWaiter(NodeAgent agent, Process p, String pid, VariableMap variableMap, String processName, int timeout, boolean adopted, String profileKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PidWaiter", profileKey);
        }
        this.profileKey = profileKey;
        this.agent = agent;
        this.p = p;
        this.pid = pid;
        PidWaiter.variableMap = variableMap;
        this.processName = processName;
        this.timeout = timeout;
        this.crosslpar = agent.getcrosslpar();
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.zos = true;
        }
        if (this.zos) {
            RoutingTable rt = RoutingTable.getInstance();
            this.xcfMonitor_Enabled = rt.isXCFMonitorEnabled();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "xcfMonitor_Enabled: " + this.xcfMonitor_Enabled);
            }
        }
        StatusCache nacache = StatusCacheFactory.getStatusCache();
        Integer processTimeoutI = Integer.getInteger("com.ibm.websphere.management.timeout.processAlive");
        if (processTimeoutI != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid " + pid + ": processAlive Timeout " + processTimeoutI);
            }
            this.processAliveTimeout = processTimeoutI;
        }
        this.monitoringPolicies = agent.getMonitoringPolicies();
        if (adopted) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid " + pid + ": adopted Child " + processName);
            }
            agent.addAdoptedChild(processName, pid);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid " + pid + ": launched Child " + processName + ":pid: " + pid);
            }
            agent.addLaunchedChild(processName, pid);
            if (nacache != null) {
                nacache.addToCache(0, processName, "j2ee.state.running");
            }
        }
        this.listenForInitiatedStoppingNotifications();
        this.listenForJ2EEStateStoppingNotifications();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PidWaiter", profileKey);
        }
    }

    private void listenForInitiatedStoppingNotifications() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listenForInitiatedStoppingNotifications" + this.pid);
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName oname = null;
            oname = new ObjectName("WebSphere:type=NodeAgent,node=" + this.agent.getNodeName() + ",*");
            adminService.addNotificationListenerExtended(oname, this, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForInitiatedStoppingNotifications", this.pid);
        }
    }

    private void listenForJ2EEStateStoppingNotifications() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listenForJ2EEStateStoppingNotifications", this.pid);
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("j2ee.state.stopping");
        adminService.addNotificationListenerExtended(this.createServerObjectName(), this, filter, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForJ2EEStateStoppingNotifications", this.pid);
        }
    }

    private void removeJ2EEStateStoppingListener() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeJ2EEStateStoppingListener", this.pid);
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            adminService.removeNotificationListenerExtended(this.createServerObjectName(), this);
        }
        catch (JMException ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid " + this.pid + ": JMException occured ", ex);
            }
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.PidWaiter.removeJ2EEStateStoppingListener", (String)"116", (Object)this);
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid " + this.pid + ": In removeJ2EEStateStoppingListener, Throwable = " + th);
            }
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.nodeagent.PidWaiter.removeJ2EEStateStoppingListener", (String)"120", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeJ2EEStateStoppingListener", this.pid);
        }
    }

    private ObjectName createServerObjectName() {
        ObjectName oname = null;
        try {
            oname = new ObjectName("WebSphere:*,type=Server,processType=ManagedProcess,name=" + this.processName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return oname;
    }

    public void handleNotification(Notification notification, Object handback) {
        String type;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", notification.getType());
        }
        if ((type = notification.getType()).equals("j2ee.state.stopping")) {
            this.processStopping();
        }
        if (type.equals("websphere.process.initiatedStopping")) {
            Properties props = (Properties)notification.getUserData();
            String nodeName = props.getProperty("nodeName");
            String pName = props.getProperty("processName");
            if (this.processName.equals(pName)) {
                this.processNameIntiatedForStop = pName;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification", this.pid);
        }
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean forceKillPID(String pid) {
        StopParams sp = new StopParams();
        sp.setProcessID(pid);
        sp.setStopMode(1);
        try {
            ProcessFactory.terminate((StopParams)sp);
            return true;
        }
        catch (ProcessOpException poe) {
            poe.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void alarm(Object alarmContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", new Object[]{this.pid, alarmContext});
        }
        if (CONTACT_ALARM_CONTEXT.equals(alarmContext)) {
            RoutingTable.getInstance().disableChild(this.processName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm", this.pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void finishRunProcessing(boolean isAlarm, boolean pidWaiterStoppedProcess) {
        block121: {
            block127: {
                block130: {
                    block126: {
                        block129: {
                            block122: {
                                block128: {
                                    block117: {
                                        if (PidWaiter.tc.isEntryEnabled()) {
                                            Tr.entry(PidWaiter.tc, "finishRunProcessing", this.pid + ": " + isAlarm);
                                        }
                                        if ((rtpid = RoutingTable.getInstance().getPid(this.processName)) != null) {
                                            if (PidWaiter.tc.isDebugEnabled()) {
                                                Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": rtpid = " + rtpid + ", pid = " + this.pid);
                                            }
                                            if (rtpid.equals(this.pid)) {
                                                updateRT = true;
                                                if (this.session != null && (s = RoutingTable.getInstance().getSession(this.processName)) != null && !s.equals(this.session)) {
                                                    updateRT = false;
                                                }
                                                if (updateRT) {
                                                    RoutingTable.getInstance().removeChild(this.processName);
                                                }
                                            }
                                        }
                                        this.removeJ2EEStateStoppingListener();
                                        if (!this.agent.containAdoptedChild(this.processName, this.pid)) break block128;
                                        if (PidWaiter.tc.isEntryEnabled()) {
                                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": adopted Child stopped " + this.processName);
                                        }
                                        try {
                                            this.p.release();
                                        }
                                        catch (ProcessOpException ex) {
                                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"148", (Object)this);
                                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Exception during releasing adopted process " + this.processName);
                                        }
                                        try {
                                            this.agent.removeAdoptedChild(this.processName, this.pid);
                                        }
                                        catch (Throwable t) {
                                            if (!PidWaiter.tc.isDebugEnabled()) break block117;
                                            Tr.debug(PidWaiter.tc, "Exception thrown in calling removeLaunchedChild", t);
                                        }
                                    }
                                    rootDir = PidWaiter.variableMap.expand("${LOG_ROOT}/" + this.processName);
                                    pidFile = this.processName + ".pid";
                                    f = new File(rootDir, pidFile);
                                    if (f.exists()) {
                                        block119: {
                                            if (this.zos) {
                                                this.agent.sendNotification("websphere.process.stopped", this.processName);
                                            }
                                            this.agent.sendNotification("websphere.process.failed", this.processName);
                                            br = null;
                                            pidMatched = true;
                                            try {
                                                block118: {
                                                    br = new BufferedReader(new FileReader(f));
                                                    line = br.readLine();
                                                    if (line == null || line.equals(this.pid)) break block118;
                                                    pidMatched = false;
                                                }
                                                var11_29 = null;
                                                ** if (br == null) goto lbl-1000
                                            }
                                            catch (Throwable var10_35) {
                                                block120: {
                                                    var11_31 = null;
                                                    if (br != null) {
                                                        try {
                                                            br.close();
                                                        }
                                                        catch (IOException ioe) {
                                                            if (!PidWaiter.tc.isDebugEnabled()) break block120;
                                                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": failed to close pid file", ioe);
                                                        }
                                                    }
                                                }
                                                throw var10_35;
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                try {
                                                    br.close();
                                                }
                                                catch (IOException ioe) {
                                                    if (PidWaiter.tc.isDebugEnabled()) {
                                                        Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": failed to close pid file", ioe);
                                                    }
                                                }
                                            }
lbl-1000:
                                            // 4 sources

                                            {
                                                break block119;
                                                catch (IOException ioe) {
                                                    FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"176", (Object)this);
                                                    var11_30 = null;
                                                    if (br != null) {
                                                        try {
                                                            br.close();
                                                        }
                                                        catch (IOException ioe) {
                                                            if (PidWaiter.tc.isDebugEnabled()) {
                                                                Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": failed to close pid file", ioe);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        if (PidWaiter.tc.isDebugEnabled()) {
                                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": pidMatched = " + pidMatched);
                                        }
                                        if (pidMatched) {
                                            try {
                                                if (this.zos) {
                                                    f.delete();
                                                }
                                                if (this.cfg != null && this.cfg.getAutoRestart()) {
                                                    if (!this.zos) {
                                                        f.delete();
                                                    }
                                                    if (!this.processIsTerminated && !this.processName.equals(this.processNameIntiatedForStop)) {
                                                        if (PidWaiter.tc.isDebugEnabled()) {
                                                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Process is being relaunched");
                                                        }
                                                        this.reLaunchProcess();
                                                    } else {
                                                        if (PidWaiter.tc.isDebugEnabled()) {
                                                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": process is NOT being relaunched");
                                                        }
                                                        this.setProcessIsTerminated(false);
                                                    }
                                                    if (PidWaiter.tc.isDebugEnabled()) {
                                                        Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": reLaunchProcess1");
                                                    }
                                                }
                                                break block121;
                                            }
                                            catch (Exception e) {
                                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"200", (Object)this);
                                            }
                                        }
                                    } else if (pidWaiterStoppedProcess) {
                                        if (PidWaiter.tc.isDebugEnabled()) {
                                            Tr.debug(PidWaiter.tc, "pid file not found, but PidWaiter stopped process");
                                        }
                                        if (this.zos) {
                                            this.agent.sendNotification("websphere.process.stopped", this.processName);
                                        }
                                        this.agent.sendNotification("websphere.process.failed", this.processName);
                                        try {
                                            if (this.cfg == null || !this.cfg.getAutoRestart()) break block121;
                                            if (!this.processIsTerminated && !this.processName.equals(this.processNameIntiatedForStop)) {
                                                if (PidWaiter.tc.isDebugEnabled()) {
                                                    Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Process is being relaunched");
                                                }
                                                this.reLaunchProcess();
                                            } else {
                                                if (PidWaiter.tc.isDebugEnabled()) {
                                                    Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": process is NOT being relaunched");
                                                }
                                                this.setProcessIsTerminated(false);
                                            }
                                            if (PidWaiter.tc.isDebugEnabled()) {
                                                Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": reLaunchProcess1");
                                            }
                                            break block121;
                                        }
                                        catch (Exception e) {
                                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"200", (Object)this);
                                        }
                                    } else {
                                        if (PidWaiter.tc.isDebugEnabled()) {
                                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": pid file not found");
                                        }
                                        this.agent.sendNotification("websphere.process.stopped", this.processName);
                                    }
                                    break block121;
                                }
                                if (PidWaiter.tc.isDebugEnabled()) {
                                    Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": process doesn't contain adopted child");
                                }
                                if (!this.zos) break block129;
                                if (PidWaiter.tc.isEntryEnabled()) {
                                    Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": launched Child stopped" + this.processName + ":pid: " + this.pid);
                                }
                                try {
                                    this.p.release();
                                }
                                catch (ProcessOpException ex) {
                                    Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Exception during releasing launched process " + this.processName);
                                }
                                try {
                                    this.agent.removeLaunchedChild(this.processName, this.pid);
                                }
                                catch (Throwable t) {
                                    if (!PidWaiter.tc.isDebugEnabled()) break block122;
                                    Tr.debug(PidWaiter.tc, "Exception thrown in calling removeLaunchedChild", t);
                                }
                            }
                            rootDir = PidWaiter.variableMap.expand("${LOG_ROOT}/" + this.processName);
                            pidFile = this.processName + ".pid";
                            f = new File(rootDir, pidFile);
                            if (f.exists()) {
                                block124: {
                                    this.agent.sendNotification("websphere.process.stopped", this.processName);
                                    this.agent.sendNotification("websphere.process.failed", this.processName);
                                    br = null;
                                    pidMatched = true;
                                    try {
                                        block123: {
                                            br = new BufferedReader(new FileReader(f));
                                            line = br.readLine();
                                            if (line == null || line.equals(this.pid)) break block123;
                                            pidMatched = false;
                                        }
                                        var14_36 = null;
                                        ** if (br == null) goto lbl-1000
                                    }
                                    catch (Throwable var13_42) {
                                        block125: {
                                            var14_38 = null;
                                            if (br != null) {
                                                try {
                                                    br.close();
                                                }
                                                catch (IOException ioe) {
                                                    if (!PidWaiter.tc.isDebugEnabled()) break block125;
                                                    Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": failed to close pid file", ioe);
                                                }
                                            }
                                        }
                                        throw var13_42;
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        try {
                                            br.close();
                                        }
                                        catch (IOException ioe) {
                                            if (PidWaiter.tc.isDebugEnabled()) {
                                                Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": failed to close pid file", ioe);
                                            }
                                        }
                                    }
lbl-1000:
                                    // 4 sources

                                    {
                                        break block124;
                                        catch (IOException ioe) {
                                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": IO Exception during reading pid file", ioe);
                                            var14_37 = null;
                                            if (br != null) {
                                                try {
                                                    br.close();
                                                }
                                                catch (IOException ioe) {
                                                    if (PidWaiter.tc.isDebugEnabled()) {
                                                        Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": failed to close pid file", ioe);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                if (PidWaiter.tc.isDebugEnabled()) {
                                    Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": " + "pidMatched = " + pidMatched);
                                }
                                if (pidMatched) {
                                    try {
                                        f.delete();
                                        if (this.cfg != null && this.cfg.getAutoRestart()) {
                                            if (!this.processIsTerminated && !this.processName.equals(this.processNameIntiatedForStop)) {
                                                if (PidWaiter.tc.isDebugEnabled()) {
                                                    Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Process is being relaunched");
                                                }
                                                this.reLaunchProcess();
                                            } else {
                                                if (PidWaiter.tc.isDebugEnabled()) {
                                                    Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Process is NOT being relaunched");
                                                }
                                                this.setProcessIsTerminated(false);
                                            }
                                            if (PidWaiter.tc.isDebugEnabled()) {
                                                Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": reLaunchProcess2");
                                            }
                                        }
                                        break block121;
                                    }
                                    catch (Exception e) {
                                        if (PidWaiter.tc.isDebugEnabled()) {
                                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Error at reLaunchProcess ", e);
                                        }
                                        break block121;
                                    }
                                }
                            } else {
                                if (pidWaiterStoppedProcess) {
                                    if (PidWaiter.tc.isDebugEnabled()) {
                                        Tr.debug(PidWaiter.tc, "pid file not found, but PidWaiter stopped process");
                                    }
                                    this.agent.sendNotification("websphere.process.stopped", this.processName);
                                    this.agent.sendNotification("websphere.process.failed", this.processName);
                                    try {
                                        if (this.cfg == null || !this.cfg.getAutoRestart()) break block121;
                                        if (!this.processIsTerminated && !this.processName.equals(this.processNameIntiatedForStop)) {
                                            if (PidWaiter.tc.isDebugEnabled()) {
                                                Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Process is being relaunched" + this.processName);
                                            }
                                            this.reLaunchProcess();
                                        } else {
                                            if (PidWaiter.tc.isDebugEnabled()) {
                                                Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Process is NOT being relaunched- " + this.processName);
                                            }
                                            this.setProcessIsTerminated(false);
                                        }
                                        if (PidWaiter.tc.isDebugEnabled()) {
                                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": reLaunchProcess2");
                                        }
                                        break block121;
                                    }
                                    catch (Exception e) {
                                        if (PidWaiter.tc.isDebugEnabled()) {
                                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Error at reLaunchProcess ", e);
                                        }
                                        break block121;
                                    }
                                }
                                if (PidWaiter.tc.isDebugEnabled()) {
                                    Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": pid file not found");
                                }
                                this.agent.sendNotification("websphere.process.stopped", this.processName);
                            }
                            break block121;
                        }
                        if (PidWaiter.tc.isDebugEnabled()) {
                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": " + "getting exitcode");
                        }
                        exitcode = -2147483648;
                        exitcode = this.p.getExitCode();
                        if (!PidWaiter.tc.isDebugEnabled()) break block126;
                        Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": exit code: " + exitcode);
                    }
                    var17_43 = null;
                    try {
                        this.p.release();
                    }
                    catch (ProcessOpException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"229", (Object)this);
                    }
                    break block130;
                    {
                        catch (ProcessOpException ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"712", (Object)this);
                            var17_44 = null;
                            try {
                                this.p.release();
                            }
                            catch (ProcessOpException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"229", (Object)this);
                            }
                        }
                    }
                    catch (Throwable var16_49) {
                        var17_45 = null;
                        try {
                            this.p.release();
                        }
                        catch (ProcessOpException ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"229", (Object)this);
                        }
                        throw var16_49;
                    }
                }
                try {
                    this.agent.removeLaunchedChild(this.processName, this.pid);
                }
                catch (Throwable t) {
                    if (!PidWaiter.tc.isDebugEnabled()) break block127;
                    Tr.debug(PidWaiter.tc, "Exception thrown in calling removeLaunchedChild", t);
                }
            }
            if (PidWaiter.tc.isDebugEnabled()) {
                Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": " + "exitcode = " + exitcode);
            }
            if (exitcode == 0) {
                this.agent.sendNotification("websphere.process.stopped", this.processName);
            } else {
                this.agent.sendNotification("websphere.process.failed", this.processName);
                try {
                    if (this.cfg != null && this.cfg.getAutoRestart()) {
                        if (!this.processIsTerminated && !this.processName.equals(this.processNameIntiatedForStop)) {
                            if (PidWaiter.tc.isDebugEnabled()) {
                                Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Process is being relaunched: " + this.processName);
                            }
                            this.reLaunchProcess();
                        } else {
                            if (PidWaiter.tc.isDebugEnabled()) {
                                Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Process is NOT being relaunched: " + this.processName);
                            }
                            this.setProcessIsTerminated(false);
                        }
                        if (PidWaiter.tc.isDebugEnabled()) {
                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": reLaunchProcess3");
                        }
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"250", (Object)this);
                }
            }
        }
        if (PidWaiter.tc.isEntryEnabled()) {
            Tr.exit(PidWaiter.tc, "finishRunProcessing", this.pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contact() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contact", this.pid);
        }
        if (this.xcfMonitor_Enabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using xcfMonitor.");
            }
            RoutingTable rt = RoutingTable.getInstance();
            String memberName = rt.getmyXCFHostCellNode();
            memberName = memberName + this.processName;
            return rt.isXCFGroupMember(memberName);
        }
        Subject subject = SecurityHelper.getOwnedSubject();
        if (subject != null) {
            SecurityHelper.pushInvocationSubject(subject);
        }
        boolean failed = true;
        int counter = 2;
        for (int i = 0; i < counter; ++i) {
            block24: {
                Object var11_14;
                failed = true;
                long timeout = Long.getLong(CONTACT_ALARM_TIMEOUT_PROP, 60L);
                this.contactAlarm = AlarmManager.create((long)(timeout * 1000L), (AlarmListener)this, (Object)CONTACT_ALARM_CONTEXT);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " Creating Alarm", this.contactAlarm);
                }
                if (this.contactThread == null) {
                    this.contactThread = new ContactThread(Thread.currentThread(), this.profileKey);
                }
                int pingInterval = this.cfg.getPingInterval();
                int sleepInterval = 300000;
                if (this.cfg.getPingTimeout() != 0) {
                    sleepInterval = this.cfg.getPingTimeout() * 1000;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " Contact Thread", this.contactThread);
                }
                this.contactThread.start();
                try {
                    try {
                        Thread.sleep(sleepInterval);
                    }
                    catch (InterruptedException ie) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " Expected Exception Recieved", ie);
                        }
                        var11_14 = null;
                        this.contactThread.setResponder(null);
                        Thread.currentThread().isInterrupted();
                        break block24;
                    }
                    var11_14 = null;
                    this.contactThread.setResponder(null);
                    Thread.currentThread().isInterrupted();
                }
                catch (Throwable throwable) {
                    var11_14 = null;
                    this.contactThread.setResponder(null);
                    Thread.currentThread().isInterrupted();
                    throw throwable;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Returned from nap");
            }
            boolean returned = this.contactThread.hasReturned();
            boolean contact = false;
            if (this.contactAlarm != null) {
                this.contactAlarm.cancel();
                this.contactAlarm = null;
            }
            if (returned) {
                contact = this.contactThread.hasContacted();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Has Contacted: " + this.processName, new Boolean(contact));
                }
                if (contact && RoutingTable.getInstance().isChildDisabled(this.processName)) {
                    RoutingTable.getInstance().enableChild(this.processName);
                }
                failed = !contact;
            } else {
                failed = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Throwing away thread", this.contactThread);
            }
            this.contactThread = null;
            if (!failed || this.isProcessStopping() || i + 1 >= counter) break;
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e) {
                Tr.debug(tc, "Pid " + this.pid + ": ThreadInterrupted Exception", e);
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.PidWaiter.contact", (String)"309", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contact", new Boolean(!failed));
        }
        if (failed) return false;
        return true;
    }

    private void reLaunchProcess() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reLaunchProcess", this.pid);
        }
        boolean launched = false;
        int max = this.cfg.getMaximumStartupAttempts();
        while (!launched && max > 0) {
            --max;
            try {
                Tr.audit(tc, "ADML0064I", this.processName);
                launched = this.agent.launchProcess(this.processName, new Integer(this.timeout));
            }
            catch (AdminException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.PidWaiter.reLaunchProcess", (String)"334", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reLaunchProcess", this.pid);
        }
    }

    synchronized void processStopping() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pid " + this.pid + ": " + "processStopping = true");
        }
        this.processStopping = true;
    }

    synchronized boolean isProcessStopping() {
        return this.processStopping;
    }

    public static String getServerPidFile(String serverName) {
        String logRoot = variableMap.expand("${LOG_ROOT}");
        String pidFile = logRoot + "/" + serverName + "/" + serverName + ".pid";
        return pidFile;
    }

    public void setProcessIsTerminated(boolean value) {
        this.processIsTerminated = value;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pid " + this.pid + ": Setting processIsTerminated to " + value);
        }
    }

    private ObjectName queryServerObjectName(String processName) {
        ObjectName serverON;
        block6: {
            String queryStr = "WebSphere:*,type=Server,process=" + processName;
            serverON = null;
            try {
                Set result = AdminServiceFactory.getAdminService().queryNames(new ObjectName(queryStr), null);
                Iterator it = result.iterator();
                serverON = it.hasNext() ? it.next() : null;
            }
            catch (MalformedObjectNameException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.PidWaiter.contact", (String)"284", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Pid " + this.pid + ": wrong object name format", e);
                }
            }
            catch (OutOfMemoryError er) {
                FFDCFilter.processException((Throwable)er, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"395", (Object)this);
                Tr.fatal(tc, "An OutOfMemoryError occured on process " + processName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Pid " + this.pid + ": An OutOfMemoryError occured on process " + processName, er);
                }
                Tr.exit(tc, "contact failed");
                return null;
            }
            catch (Error er) {
                FFDCFilter.processException((Throwable)er, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"395", (Object)this);
                Tr.error(tc, "An Java Error occured on process " + processName);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Pid " + this.pid + ": An Java Error occured on process " + processName, er);
            }
        }
        return serverON;
    }

    static {
        CONTACT_ALARM_CONTEXT = new Integer(1);
        CONTACT_ALARM_TIMEOUT_PROP = "com.ibm.websphere.management.pidwaiter.contact.timeout";
    }

    class ContactThread
    extends Thread {
        boolean returned = false;
        boolean contact = false;
        Thread respond = null;
        String profileKey = null;

        ContactThread(Thread res, String profileKey) {
            this.respond = res;
            this.profileKey = profileKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ContactThread.run()");
            }
            boolean pushed = false;
            try {
                if (this.profileKey != null) {
                    pushed = AdminContext.push((String)this.profileKey);
                }
                try {
                    Subject subject = SecurityHelper.getOwnedSubject();
                    if (subject != null) {
                        SecurityHelper.pushInvocationSubject(subject);
                    }
                    AdminClient client = null;
                    client = RoutingTable.getInstance().isChildDisabled(PidWaiter.this.processName) ? RoutingTable.getInstance().getDisabledAdminClient(PidWaiter.this.processName) : RoutingTable.getInstance().getAdminClient(PidWaiter.this.processName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " checking whether the process is alive ");
                    }
                    client.isAlive();
                    this.contact = true;
                    this.returned = true;
                }
                catch (ConnectorException ce) {
                    FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.management.nodeagent.PidWaiter.ContactThread", (String)"1039", (Object)this);
                    this.contact = false;
                    this.returned = true;
                }
                catch (OutOfMemoryError oom) {
                    FFDCFilter.processException((Throwable)oom, (String)"com.ibm.ws.management.nodeagent.PidWaiter.ContactThread", (String)"1098", (Object)this);
                    this.contact = false;
                    this.returned = true;
                }
                catch (Throwable th) {
                    FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.nodeagent.PidWaiter.ContactThread", (String)"1104", (Object)this);
                    this.contact = false;
                    this.returned = true;
                }
                ContactThread contactThread = this;
                synchronized (contactThread) {
                    if (this.respond != null) {
                        this.respond.interrupt();
                    }
                }
                Object var6_8 = null;
                if (!pushed) return;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (!pushed) throw throwable;
                AdminContext.pop();
                throw throwable;
            }
            AdminContext.pop();
        }

        synchronized void setResponder(Thread th) {
            this.respond = th;
        }

        synchronized Thread getResponder() {
            return this.respond;
        }

        boolean hasReturned() {
            return this.returned;
        }

        boolean hasContacted() {
            return this.contact;
        }

        synchronized void reset(Thread th) {
            this.returned = false;
            this.contact = false;
            this.respond = th;
        }
    }
}

