/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.launcher.LaunchParams;
import com.ibm.ws.management.launcher.LaunchScriptCollaboratorFactory;
import com.ibm.ws.management.launcher.LaunchScriptPlatformCollaborator;
import com.ibm.ws.management.launcher.UnixLaunchScriptCollaborator;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;

public class LaunchScriptWriter {
    private static TraceComponent tc = Tr.register(LaunchScriptWriter.class, "Launcher", "com.ibm.ws.management.resources.launcher");
    private LaunchParams params = null;
    private static final String ARCFLOW = "arcflow";
    private static final String PURIFY = "purify";
    private static final String QUANTIFY = "quantify";
    private static final String PURIFY_OPT = "IBM_JAVA_OPTIONS=-XrunPureJVMPI:purify";
    private static final String QUANTIFY_OPT = "IBM_JAVA_OPTIONS=-XrunPureJVMPI:quantify";
    private static final String ARCFLOW_OPT1 = "PERFORMANCE_OPTION=-Xrunjprof32:generic,";
    private static final String ARCFLOW_OPT2 = ",socket,+PTT_INSTS";
    private static final String ARCFLOW_COMMENT = " For running with arcflow";
    private static final String PURIFY_COMMENT = " For running with Rational purify";
    private static final String QUANTIFY_COMMENT = " For running with Rational quantify";

    public LaunchScriptWriter(LaunchParams launchParams) {
        this.params = launchParams;
    }

    public void writeScript(String platformType, String scriptName, boolean backgroundScript) throws Exception {
        String os = platformType.toLowerCase();
        LaunchScriptPlatformCollaborator platform = LaunchScriptCollaboratorFactory.getCollaborator(os);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LaunchScriptCollaborator: " + platform.getClass());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing a launch script file: " + scriptName);
        }
        String launchString = this.buildLaunchString(platform);
        if (backgroundScript) {
            launchString = platform.addBackgroundCommand(launchString);
        }
        if (launchString != null) {
            File scriptFile = new File(scriptName);
            FileWriter outputFile = new FileWriter(scriptFile);
            outputFile.write(platform.buildScriptHeader(scriptName));
            outputFile.write(platform.getPlatformLineEnd());
            boolean devOption = this.params.getDevOption();
            if (devOption) {
                String devOption1 = null;
                outputFile.write(platform.getPlatformComment());
                outputFile.write(" Start developer performance monitoring options. Only uncomment ONE option at a time.");
                outputFile.write(platform.getPlatformLineEnd());
                String varOpt = this.calculateVarOpt(platform);
                devOption1 = ARCFLOW_OPT1 + varOpt + ARCFLOW_OPT2;
                outputFile.write(platform.getPlatformComment());
                outputFile.write(ARCFLOW_COMMENT);
                outputFile.write(platform.getPlatformLineEnd());
                outputFile.write(platform.buildDevOptions(devOption1));
                outputFile.write(platform.getPlatformLineEnd());
                outputFile.write(platform.getPlatformComment());
                outputFile.write(PURIFY_COMMENT);
                outputFile.write(platform.getPlatformLineEnd());
                outputFile.write(platform.buildDevOptions(PURIFY_OPT));
                outputFile.write(platform.getPlatformLineEnd());
                outputFile.write(platform.getPlatformComment());
                outputFile.write(QUANTIFY_COMMENT);
                outputFile.write(platform.getPlatformLineEnd());
                outputFile.write(platform.buildDevOptions(QUANTIFY_OPT));
                outputFile.write(platform.getPlatformLineEnd());
                outputFile.write(platform.getPlatformComment());
                outputFile.write(" End developer performance monitoring options.");
                outputFile.write(platform.getPlatformLineEnd());
            }
            outputFile.write(platform.buildEnvSettings(this.params.getEnvironment()));
            outputFile.write(platform.getPlatformLineEnd());
            outputFile.write(platform.getPlatformComment() + " Launch Command");
            outputFile.write(platform.getPlatformLineEnd());
            outputFile.write(launchString);
            outputFile.write(platform.getPlatformLineEnd());
            outputFile.write(platform.getPlatformLineEnd());
            outputFile.write(platform.getPlatformEndLocal());
            outputFile.close();
        }
    }

    private String buildLaunchString(LaunchScriptPlatformCollaborator os) {
        StringBuffer launchCommand = new StringBuffer();
        if (os instanceof UnixLaunchScriptCollaborator) {
            launchCommand.append("exec ");
        }
        launchCommand.append("\"");
        launchCommand.append(this.params.getExecutableName());
        launchCommand.append("\"");
        launchCommand.append(" ");
        launchCommand.append(this.params.getJvmModeString());
        launchCommand.append(" ");
        launchCommand.append(os.getPlatformVarBegin());
        launchCommand.append("DEBUG");
        launchCommand.append(os.getPlatformVarEnd());
        boolean devOption = this.params.getDevOption();
        if (devOption) {
            launchCommand.append(" ");
            launchCommand.append(os.getPlatformVarBegin());
            launchCommand.append("PERFORMANCE_OPTION");
            launchCommand.append(os.getPlatformVarEnd());
        }
        Vector args = this.params.getCommandLineArguments();
        for (int i = 0; i < args.size(); ++i) {
            String arg = (String)args.get(i);
            if (arg.equals("-server") || arg.equals("-client") || arg.equals("-classic")) continue;
            launchCommand.append(" \"" + (String)args.get(i) + "\"");
        }
        return launchCommand.toString();
    }

    private String calculateVarOpt(LaunchScriptPlatformCollaborator platform) {
        StringBuffer varOpt = new StringBuffer();
        varOpt.append("FNM=");
        varOpt.append(platform.getPlatformVarBegin());
        varOpt.append("WAS_PATH");
        varOpt.append(platform.getPlatformVarEnd());
        varOpt.append(platform.getPlatformFileDelim());
        varOpt.append("logs");
        varOpt.append(platform.getPlatformFileDelim());
        varOpt.append("log");
        return varOpt.toString();
    }
}

