/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ControllerAdminService;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.DownstreamProcessManager;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushToServantNotificationSender;
import com.ibm.ws.management.event.RemoteNotificationBroadcaster;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.Utils;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

public class ZControlNotificationManager
implements DownstreamProcessManager {
    private static TraceComponent tc = Tr.register(ZControlNotificationManager.class, "Admin", "com.ibm.ws.management.resources.event");
    private Map filterMap;
    private ServerInfo controlServerInfo = null;
    private DSMEntry controlDSMEntry = null;
    private boolean deploymentManager = false;
    private RemoteNotificationBroadcaster rnb = null;

    public ZControlNotificationManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.filterMap = new HashMap();
        String processType = AdminServiceFactory.getAdminService().getProcessType();
        if (processType.equals("DeploymentManager")) {
            this.deploymentManager = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deploymentManager", new Boolean(this.deploymentManager));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public synchronized void addDownstreamProcess(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDownstreamProcess", serverInfo);
        }
        this.controlServerInfo = serverInfo;
        if (this.isFilterAdded()) {
            this.controlDSMEntry = this.createDSMEntry();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDownstreamProcess");
        }
    }

    public synchronized void removeDownstreamProcess(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDownstreamProcess", serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDownstreamProcess");
        }
    }

    public synchronized void setFilter(Object id, ConsolidatedFilter filter) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFilter", new Object[]{id, filter});
        }
        this.filterMap.put(id, filter);
        this.updateControllerListener();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFilter");
        }
    }

    public synchronized void unsetFilter(Object id) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetFilter", id);
        }
        this.filterMap.remove(id);
        this.updateControllerListener();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetFilter");
        }
    }

    private void updateControllerListener() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateControllerListener");
        }
        if (this.controlServerInfo != null) {
            try {
                if (this.controlDSMEntry == null) {
                    if (this.isFilterAdded()) {
                        this.controlDSMEntry = this.createDSMEntry();
                    }
                } else {
                    if (this.rnb == null) {
                        this.rnb = this.getControllerProxy();
                    }
                    if (this.isFilterAdded()) {
                        ConsolidatedFilter updatedFilter = this.createFilter();
                        if (!updatedFilter.equals(this.controlDSMEntry.filter)) {
                            this.controlDSMEntry.filter = updatedFilter;
                            this.rnb.resetFilter(this.controlDSMEntry.listenerId, this.controlDSMEntry.filter);
                        }
                    } else {
                        this.rnb.removeNotificationListener(this.controlDSMEntry.listenerId);
                        this.controlDSMEntry = null;
                    }
                }
            }
            catch (ReceiverNotFoundException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.event.ZControlNotificationManager.updateControllerListener", (String)"187", (Object)this);
            }
            catch (ConnectorException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.event.ZControlNotificationManager.updateControllerListener", (String)"193", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateControllerListener");
        }
    }

    private DSMEntry createDSMEntry() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDSMEntry");
        }
        ConsolidatedFilter newFilter = this.createFilter();
        DSMEntry newEntry = null;
        if (!newFilter.isEmpty()) {
            ListenerIdentifier id = this.addRemoteListener(newFilter);
            newEntry = new DSMEntry(newFilter, id);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDSMEntry", newEntry);
        }
        return newEntry;
    }

    private ListenerIdentifier addRemoteListener(ConsolidatedFilter filter) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRemoteListener", filter);
        }
        if (this.rnb == null) {
            this.rnb = this.getControllerProxy();
        }
        PushToServantNotificationSender listener = new PushToServantNotificationSender();
        ListenerIdentifier id = this.rnb.addNotificationListener(filter, listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRemoteListener", id);
        }
        return id;
    }

    private boolean isFilterAdded() {
        return !this.filterMap.isEmpty();
    }

    private ConsolidatedFilter createFilter() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFilter");
        }
        ConsolidatedFilter filter = new ConsolidatedFilter();
        for (ConsolidatedFilter mappedFilter : this.filterMap.values()) {
            if (this.deploymentManager) {
                filter.appendAllFilterEntries(mappedFilter);
                continue;
            }
            filter.appendFilterEntries(mappedFilter, this.controlServerInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFilter", filter);
        }
        return filter;
    }

    private RemoteNotificationBroadcaster getControllerProxy() throws ConnectorException {
        ControllerAdminService proxy = null;
        try {
            proxy = Utils.getControllerAdminService();
        }
        catch (RemoteException exc) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to create controller proxy", exc);
            }
            throw new ConnectorException("unable to create controller proxy", exc);
        }
        return proxy;
    }

    class DSMEntry {
        ConsolidatedFilter filter = null;
        ListenerIdentifier listenerId = null;

        DSMEntry(ConsolidatedFilter filter, ListenerIdentifier listenerId) {
            this.filter = filter;
            this.listenerId = listenerId;
        }

        public String toString() {
            return "DSMEntry:[listenerId=" + this.listenerId + ";filter=" + this.filter + "]";
        }
    }
}

