/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import javax.management.Notification;

public class PullRemoteReceiver
extends RemoteReceiver
implements AlarmListener {
    private static TraceComponent tc = Tr.register(PullRemoteReceiver.class, "Admin", "com.ibm.ws.management.resources.event");
    private static final int BATCH_SIZE = 20;
    static final int MAX_WAIT_TIME = 20000;
    private static final int MIN_WAIT_TIME = 500;
    private static final float MAX_RATE_DECREASE = 0.75f;
    private static final float IDEAL_RATE = 0.05f;
    private static final float RATE_CHANGE_MULTIPLIER = 10.0f;
    private int waitTime = 3000;
    private Alarm pullAlarm = null;
    private long alarmId = 0L;

    public PullRemoteReceiver(AdminServiceProxy notifierProxy) {
        super(notifierProxy);
    }

    public void alarm(Object alarmContext) {
        this.getNotifications(alarmContext);
    }

    protected void unsubscribe() throws ReceiverNotFoundException, ConnectorException {
        super.unsubscribe();
        this.pullAlarm.cancel();
    }

    protected void subscribe() throws ConnectorException {
        super.subscribe();
        this.registerAlarm(0, new Long(++this.alarmId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNotifications(Object alarmContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNotifications");
        }
        if (this.getListenerId() == null) {
            return;
        }
        try {
            float curRate = 0.0f;
            float rate = 0.0f;
            do {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Pulling 20 notifications from ListenerId " + this.getListenerId());
                }
                Notification[] events = this.getRemoteNotificationService().pullNotifications(this.getListenerId(), new Integer(20));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got " + events.length + " notifications");
                }
                for (int i = 0; i < events.length; ++i) {
                    this.handleNotification(events[i]);
                }
                curRate = (float)events.length / 20.0f;
                rate += curRate;
            } while ((double)curRate >= 1.0);
            this.adjustWaitTime(rate);
        }
        catch (ReceiverNotFoundException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.event.PullRemoteReceiver.getNotifications", (String)"132", (Object)this);
            try {
                if (this.isActive() && alarmContext.equals(new Long(this.alarmId))) {
                    this.subscribe();
                }
            }
            catch (ConnectorException ex2) {
                FFDCFilter.processException((Throwable)ex2, (String)"com.ibm.ws.management.event.PullRemoteReceiver.getNotifications", (String)"137", (Object)this);
            }
        }
        catch (ConnectorException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.event.PullRemoteReceiver.getNotifications", (String)"141", (Object)this);
        }
        finally {
            if (this.isActive() && alarmContext.equals(new Long(this.alarmId))) {
                this.registerAlarm(this.waitTime, alarmContext);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNotifications");
        }
    }

    private void adjustWaitTime(float rate) {
        int oldWaitTime = this.waitTime;
        float adjustedRate = rate - 0.05f;
        adjustedRate = adjustedRate > 0.0f ? 1.0f + adjustedRate * 10.0f : (adjustedRate == 0.0f ? 1.0f : rate);
        this.waitTime = Math.min(20000, (int)Math.max(500.0f, (float)this.waitTime / Math.max(0.75f, adjustedRate)));
        if (tc.isDebugEnabled() && oldWaitTime != this.waitTime) {
            Tr.debug(tc, "Rate = " + adjustedRate + "; wait time adjusted from " + oldWaitTime + "ms to " + this.waitTime + "ms");
        }
    }

    private void registerAlarm(int timeToWait, Object alarmContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerAlarm", new Object[]{new Integer(timeToWait), alarmContext});
        }
        this.pullAlarm = AlarmManager.createNonDeferrable((long)timeToWait, (AlarmListener)this, (Object)alarmContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerAlarm");
        }
    }

    private void cancelAlarm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancelAlarm");
        }
        this.pullAlarm.cancel();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancelAlarm");
        }
    }
}

