/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.event.NotificationService;
import com.ibm.ws.management.event.WsNotifListener;
import javax.management.MBeanException;
import javax.management.Notification;

public class NotificationServiceMBean
extends RuntimeCollaborator {
    private static TraceComponent tc = Tr.register(NotificationServiceMBean.class, "Admin", "com.ibm.ws.management.resources.event");
    private long seqNum = 0L;
    private WsNotifListener delegate;

    public NotificationServiceMBean(WsNotifListener delegate) {
        this.delegate = delegate;
    }

    public void emitNotification(String notificationType, String message) throws MBeanException {
        this.emitNotification(notificationType, message, null);
    }

    public void emitNotification(String notificationType, String message, Object userData) throws MBeanException {
        Notification n = new Notification(notificationType, (Object)this.getObjectName(), this.seqNum++, message);
        if (userData != null) {
            n.setUserData(userData);
        }
        this.sendNotification(n);
    }

    public void propagateNotifications(Notification[] notifications) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propagateNotifications", notifications != null ? NotificationService.getInfo(notifications) : "<NULL notifications>");
        }
        boolean zos = false;
        if (AdminHelper.getPlatformHelper().isZOS()) {
            zos = true;
        }
        if (notifications != null) {
            for (int i = 0; i < notifications.length; ++i) {
                if (!this.delegate.isNotificationEnabled(notifications[i])) continue;
                if (zos && this.delegate instanceof NotificationService) {
                    ((NotificationService)this.delegate).handleRemoteNotification(notifications[i]);
                    continue;
                }
                this.delegate.handleNotification(notifications[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propagateNotifications");
        }
    }
}

