/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.ListenerInfo;
import com.ibm.ws.management.event.NotificationInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ListenerCollection {
    private static TraceComponent tc = Tr.register(ListenerCollection.class, "Admin", "com.ibm.ws.management.resources.event");
    private Map listenersByObjectName = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ListenerInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add", info);
        }
        boolean modified = false;
        Map map = this.listenersByObjectName;
        synchronized (map) {
            List listenersForObjName = (List)this.listenersByObjectName.get(info.getObjectName());
            if (listenersForObjName == null) {
                this.insertList(info);
                modified = true;
            } else if (!listenersForObjName.contains(info)) {
                listenersForObjName.add(info);
                modified = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add", new Boolean(modified));
        }
        return modified;
    }

    private void insertList(ListenerInfo info) {
        List<ListenerInfo> newList = Collections.synchronizedList(new ArrayList());
        newList.add(info);
        this.listenersByObjectName.put(info.getObjectName(), newList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ListenerInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", info);
        }
        boolean modified = false;
        Map map = this.listenersByObjectName;
        synchronized (map) {
            ObjectName objName = info.getObjectName();
            List listenersForObjName = (List)this.listenersByObjectName.get(objName);
            if (listenersForObjName != null && (modified = listenersForObjName.remove(info)) && listenersForObjName.isEmpty()) {
                this.listenersByObjectName.remove(objName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", new Boolean(modified));
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(ObjectName objName, NotificationListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAll", new Object[]{objName, listener});
        }
        boolean modified = false;
        Map map = this.listenersByObjectName;
        synchronized (map) {
            if (objName == null) {
                Iterator i = this.listenersByObjectName.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    boolean mod = this.removeMatchingNotificationListeners((List)entry.getValue(), (ObjectName)entry.getKey(), listener);
                    if (!mod) continue;
                    if (((List)entry.getValue()).isEmpty()) {
                        i.remove();
                    }
                    modified = true;
                }
            } else {
                List listeners = (List)this.listenersByObjectName.get(objName);
                modified = this.removeMatchingNotificationListeners(listeners, objName, listener);
                if (modified && listeners.isEmpty()) {
                    this.listenersByObjectName.remove(objName);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAll", new Boolean(modified));
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMatchingNotificationListeners(List listenersForObjName, ObjectName objName, NotificationListener listener) {
        boolean modified = false;
        if (listenersForObjName != null) {
            List list = listenersForObjName;
            synchronized (list) {
                Iterator i = listenersForObjName.iterator();
                while (i.hasNext()) {
                    ListenerInfo info = (ListenerInfo)i.next();
                    if (!info.getNotificationListener().equals(listener)) continue;
                    i.remove();
                    modified = true;
                }
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getListeners(Notification n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getListeners", n);
        }
        ArrayList listenersToReturn = null;
        Map map = this.listenersByObjectName;
        synchronized (map) {
            listenersToReturn = new ArrayList();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of lists: " + this.listenersByObjectName.size());
            }
            for (Map.Entry entry : this.listenersByObjectName.entrySet()) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Examining ObjectName " + entry.getKey());
                    }
                    if (!NotificationInfo.containsName((ObjectName)entry.getKey(), (ObjectName)n.getSource())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding list");
                    }
                    listenersToReturn.add(entry.getValue());
                }
                catch (ClassCastException exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.event.ListenerInfo.getListeners", (String)"209", (Object)this);
                }
            }
            if (listenersToReturn.isEmpty()) {
                listenersToReturn = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getListeners", listenersToReturn);
        }
        return listenersToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int curNum = 0;
        Map map = this.listenersByObjectName;
        synchronized (map) {
            Iterator i = this.listenersByObjectName.values().iterator();
            while (i.hasNext()) {
                curNum += ((List)i.next()).size();
            }
        }
        return curNum;
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map map = this.listenersByObjectName;
        synchronized (map) {
            return "ListenerCollection: " + this.listenersByObjectName.toString();
        }
    }
}

