/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminClientImpl;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.DownstreamProcessManager;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushUpstreamServerSender;
import com.ibm.ws.management.event.RemoteNotificationBroadcaster;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;

public class DownstreamServerManager
implements DownstreamProcessManager {
    private static TraceComponent tc = Tr.register(DownstreamServerManager.class, "Admin", "com.ibm.ws.management.resources.event");
    private Map _filterMap;
    private Map _serverMap;
    private ThreadManager _threadManager = new ThreadManager();
    private QueueManager _queueManager = new QueueManager(this._threadManager);

    public DownstreamServerManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this._filterMap = new HashMap();
        this._serverMap = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void addDownstreamServer(ServerInfo serverInfo) throws ConnectorException {
        boolean updateCompleted;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDownstreamServer", serverInfo);
        }
        ServerUpdateOpInfo opInfo = new ServerUpdateOpInfo(0, serverInfo);
        this._queueManager.queueUpOperation(opInfo);
        try {
            updateCompleted = opInfo.waitForRequestToComplete();
        }
        catch (ConnectorException exc) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addDownstreamServer", "ConnectorException: " + exc);
            }
            throw exc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDownstreamServer", "updateCompleted=" + updateCompleted);
        }
    }

    public void addDownstreamProcess(ServerInfo serverInfo) throws ConnectorException {
        this.addDownstreamServer(serverInfo);
    }

    public void removeDownstreamServer(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDownstreamServer", serverInfo);
        }
        ServerUpdateOpInfo opInfo = new ServerUpdateOpInfo(1, serverInfo);
        this._queueManager.queueUpOperation(opInfo);
        boolean updateCompleted = false;
        try {
            updateCompleted = opInfo.waitForRequestToComplete();
        }
        catch (ConnectorException exc) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDownstreamServer", "updateCompleted=" + updateCompleted);
        }
    }

    public void removeDownstreamProcess(ServerInfo serverInfo) throws ConnectorException {
        this.removeDownstreamServer(serverInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(Object id, ConsolidatedFilter filter) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFilter", new Object[]{id, filter});
        }
        Map map = this._filterMap;
        synchronized (map) {
            this._filterMap.put(id, filter);
        }
        this.updateServerListeners();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFilter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetFilter(Object id) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetFilter", id);
        }
        Map map = this._filterMap;
        synchronized (map) {
            this._filterMap.remove(id);
        }
        this.updateServerListeners();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetFilter");
        }
    }

    private ListenerIdentifier addRemoteListener(ServerInfo serverInfo, ConsolidatedFilter filter) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRemoteListener", new Object[]{serverInfo, filter});
        }
        RemoteNotificationBroadcaster rnb = this.getRemoteProxy(serverInfo);
        PushUpstreamServerSender listener = new PushUpstreamServerSender();
        ListenerIdentifier id = rnb.addNotificationListener(filter, listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRemoteListener", id);
        }
        return id;
    }

    private void removeRemoteListener(ServerInfo serverInfo, DSMEntry dsmEntry) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRemoteListener", new Object[]{serverInfo, dsmEntry});
        }
        RemoteNotificationBroadcaster rnb = this.getRemoteProxy(serverInfo);
        rnb.removeNotificationListener(dsmEntry.listenerId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRemoteListener");
        }
    }

    private void updateRemoteListener(ServerInfo serverInfo, DSMEntry dsmEntry) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRemoteListener", new Object[]{serverInfo, dsmEntry});
        }
        RemoteNotificationBroadcaster rnb = this.getRemoteProxy(serverInfo);
        rnb.resetFilter(dsmEntry.listenerId, dsmEntry.filter);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRemoteListener");
        }
    }

    private RemoteNotificationBroadcaster getRemoteProxy(ServerInfo serverInfo) throws ConnectorException {
        return ((AdminClientImpl)serverInfo.getAdminClient()).getProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServerListeners() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServerListeners");
        }
        ArrayList<ServerInfo> list = new ArrayList<ServerInfo>();
        Map map = this._serverMap;
        synchronized (map) {
            for (ServerInfo serverInfo : this._serverMap.keySet()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Updating server " + serverInfo);
                }
                list.add(serverInfo);
            }
        }
        ServerInfo[] serverInfoList = new ServerInfo[list.size()];
        list.toArray(serverInfoList);
        ServerUpdateOpInfo opInfo = new ServerUpdateOpInfo(2, serverInfoList);
        this._queueManager.queueUpOperation(opInfo);
        boolean updateCompleted = false;
        try {
            updateCompleted = opInfo.waitForRequestToComplete();
        }
        catch (ConnectorException exc) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateServerListeners", "updateCompleted=" + updateCompleted);
        }
    }

    private DSMEntry createDSMEntry(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDSMEntry", serverInfo);
        }
        DSMEntry newEntry = null;
        ConsolidatedFilter newFilter = this.createFilter(serverInfo);
        if (!newFilter.isEmpty()) {
            ListenerIdentifier id = this.addRemoteListener(serverInfo, newFilter);
            newEntry = new DSMEntry(newFilter, id);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDSMEntry", newEntry);
        }
        return newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsolidatedFilter createFilter(ServerInfo serverInfo) {
        ConsolidatedFilter filter;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFilter", serverInfo);
        }
        Map map = this._filterMap;
        synchronized (map) {
            filter = new ConsolidatedFilter();
            Iterator i = this._filterMap.values().iterator();
            while (i.hasNext()) {
                filter.appendFilterEntries((ConsolidatedFilter)i.next(), serverInfo);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFilter", filter);
        }
        return filter;
    }

    class QueueConsumerThread
    implements Runnable {
        private static final int MAX_ENTRIES_TO_SERVICE_PER_QUEUE = 5;
        private final int _threadIndex;
        private final ThreadManager _threadManager;
        private String TRACE_HEADING;
        private Queue _queue = null;
        private int _requestsServicedOnCurrentQueue;
        private Thread _thread = null;
        private ConnectorException _connExc;
        private String profileKey;

        public QueueConsumerThread(ThreadManager threadManager, int threadIndex, String profileKey) {
            this._threadManager = threadManager;
            this._threadIndex = threadIndex;
            this.profileKey = profileKey;
            this.setTraceHeading();
        }

        public synchronized void startUp(Queue queue) {
            if (this._thread == null) {
                this._queue = queue;
                this._requestsServicedOnCurrentQueue = 0;
                this._connExc = null;
                this.setTraceHeading();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.TRACE_HEADING + "Starting thread.");
                }
                this._thread = new Thread((Runnable)this, this.createThreadName(queue.getServerInfo()));
                this._thread.setDaemon(true);
                this._thread.start();
            } else {
                Exception e = new Exception("Thread called to start up when already started.");
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.event.DownstreamServerManager.QueueConsumerThread.startUp", (String)"1083", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, this.TRACE_HEADING + "Thread called to start up when already started.");
                }
            }
        }

        private synchronized QueueEntry getNextQueueEntry() {
            this._connExc = null;
            Thread currThread = this._thread;
            QueueEntry queueEntry = null;
            do {
                if (this._requestsServicedOnCurrentQueue >= 5) {
                    this._queue = this._threadManager.unbindQueue(this._queue, this._threadIndex);
                    if (tc.isDebugEnabled() && this._queue != null) {
                        Tr.debug(tc, this.TRACE_HEADING + "getNextQueueEntry:", "Now bound to queue " + this._queue.getQueueNumber());
                    }
                    this._requestsServicedOnCurrentQueue = 0;
                    this.setTraceHeading();
                }
                if (this._queue == null) {
                    this._thread = null;
                    continue;
                }
                queueEntry = this._queue.getNextEntry();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.TRACE_HEADING + "getNextQueueEntry:", queueEntry);
                }
                if (queueEntry != null) {
                    ++this._requestsServicedOnCurrentQueue;
                    this._thread.setName(this.createThreadName(this._queue.getServerInfo()));
                    continue;
                }
                this._requestsServicedOnCurrentQueue = 5;
            } while (queueEntry == null && this._queue != null);
            return queueEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AdminContext: " + this.profileKey);
            }
            boolean tmpProfileKey = false;
            try {
                Subject subject;
                if (this.profileKey != null) {
                    tmpProfileKey = AdminContext.push((String)this.profileKey);
                }
                if ((subject = SecurityHelper.getServerSubject()) != null) {
                    SecurityHelper.pushInvocationSubject(subject);
                }
                try {
                    QueueEntry queueEntry = this.getNextQueueEntry();
                    while (queueEntry != null) {
                        block20: {
                            try {
                                ServerInfo serverInfo = queueEntry.getServerInfo();
                                switch (queueEntry.getOperation()) {
                                    case 0: {
                                        this.addServer(serverInfo);
                                        break;
                                    }
                                    case 1: {
                                        this.removeServer(serverInfo);
                                        break;
                                    }
                                    case 2: {
                                        this.updateServers(serverInfo);
                                    }
                                }
                            }
                            catch (Throwable t) {
                                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.event.DownstreamServerManager.QueueConsumerThread.run", (String)"1173", (Object)this);
                                if (!tc.isEventEnabled()) break block20;
                                Tr.event(tc, this.TRACE_HEADING + "Unexpected error.", t);
                            }
                        }
                        int queueNumber = this._queue.getQueueNumber();
                        queueEntry.getServerOpInfo().markServerUpdateComplete(queueNumber, this._connExc);
                        queueEntry = this.getNextQueueEntry();
                    }
                }
                finally {
                    if (subject != null) {
                        SecurityHelper.popInvocationSubject(subject);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, this.TRACE_HEADING + "Ending thread.");
                    }
                }
            }
            finally {
                if (tmpProfileKey) {
                    AdminContext.pop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addServer(ServerInfo serverInfo) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.TRACE_HEADING + "addServer", serverInfo);
            }
            try {
                DSMEntry entry = DownstreamServerManager.this.createDSMEntry(serverInfo);
                Map map = DownstreamServerManager.this._serverMap;
                synchronized (map) {
                    DownstreamServerManager.this._serverMap.put(serverInfo, entry);
                }
            }
            catch (ConnectorException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.event.DownstreamServerManager.QueueConsumerThread.addServers", (String)"1205", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, this.TRACE_HEADING + "addServer: ConnectorException:", exc);
                }
                this._connExc = exc;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.TRACE_HEADING + "addServer");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeServer(ServerInfo serverInfo) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.TRACE_HEADING + "removeServer", serverInfo);
            }
            Map map = DownstreamServerManager.this._serverMap;
            synchronized (map) {
                DownstreamServerManager.this._serverMap.remove(serverInfo);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.TRACE_HEADING + "removeServer");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateServers(ServerInfo serverInfo) {
            block24: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, this.TRACE_HEADING + "updateServers", serverInfo);
                }
                try {
                    DSMEntry entry;
                    boolean serverIsInMap = true;
                    Map map = DownstreamServerManager.this._serverMap;
                    synchronized (map) {
                        entry = (DSMEntry)DownstreamServerManager.this._serverMap.get(serverInfo);
                        if (entry == null) {
                            serverIsInMap = DownstreamServerManager.this._serverMap.containsKey(serverInfo);
                        }
                    }
                    if (entry == null) {
                        if (serverIsInMap) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, this.TRACE_HEADING + "updateServers: DSMEntry null.");
                            }
                            if ((entry = DownstreamServerManager.this.createDSMEntry(serverInfo)) == null) break block24;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, this.TRACE_HEADING + "updateServers: " + "Setting non-null DSMEntry.");
                            }
                            map = DownstreamServerManager.this._serverMap;
                            synchronized (map) {
                                DownstreamServerManager.this._serverMap.put(serverInfo, entry);
                                break block24;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, this.TRACE_HEADING + "updateServers: No server map entry.");
                        }
                        break block24;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, this.TRACE_HEADING + "DSMEntry: " + entry);
                    }
                    RemoteNotificationBroadcaster server = DownstreamServerManager.this.getRemoteProxy(serverInfo);
                    ConsolidatedFilter updatedFilter = DownstreamServerManager.this.createFilter(serverInfo);
                    if (updatedFilter != null) {
                        if (!updatedFilter.equals(entry.filter)) {
                            entry.filter = updatedFilter;
                            DownstreamServerManager.this.updateRemoteListener(serverInfo, entry);
                        }
                        break block24;
                    }
                    DownstreamServerManager.this.removeRemoteListener(serverInfo, entry);
                    Map map2 = DownstreamServerManager.this._serverMap;
                    synchronized (map2) {
                        DownstreamServerManager.this._serverMap.put(serverInfo, null);
                    }
                }
                catch (ReceiverNotFoundException exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.event.DownstreamServerManager.QueueConsumerThread.updateServers", (String)"1295", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, this.TRACE_HEADING + "updateServers: ReceiverNotFoundException");
                    }
                }
                catch (ConnectorException exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.event.DownstreamServerManager.QueueConsumerThread.updateServers", (String)"1303", (Object)this);
                    if (!tc.isEventEnabled()) break block24;
                    Tr.event(tc, this.TRACE_HEADING + "updateServers: ConnectorException");
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.TRACE_HEADING + "updateServers");
            }
        }

        private void setTraceHeading() {
            StringBuffer buff = new StringBuffer();
            buff.append("QueueConsumerThread[");
            buff.append(this._threadIndex);
            buff.append("]");
            buff.append("(Q");
            if (this._queue != null) {
                buff.append(this._queue.getQueueNumber());
            } else {
                buff.append("U");
            }
            buff.append(")");
            buff.append(": ");
            this.TRACE_HEADING = buff.toString();
        }

        private String createThreadName(ServerInfo serverInfo) {
            StringBuffer buff = new StringBuffer();
            buff.append(this.TRACE_HEADING);
            buff.append(serverInfo.getCell());
            buff.append("/");
            buff.append(serverInfo.getNode());
            buff.append("/");
            buff.append(serverInfo.getName());
            return buff.toString();
        }
    }

    class ThreadManager {
        private static final int NUMBER_OF_THREADS = 50;
        private QueueConsumerThread[] _threads = new QueueConsumerThread[50];
        private boolean[] _threadWorking = new boolean[50];
        private int _numThreadsWorking;
        private ArrayList _unboundQueues = new ArrayList();
        private HashMap _queueToThread = new HashMap();

        public ThreadManager() {
            for (int i = 0; i < 50; ++i) {
                this._threads[i] = new QueueConsumerThread(this, i, AdminContext.peek());
                this._threadWorking[i] = false;
            }
            this._numThreadsWorking = 0;
        }

        public synchronized void entryAddedToQueues(Queue[] queues) {
            int idleIndex;
            int i;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "TM.entryAddedToQueues");
            }
            for (i = 0; i < queues.length && (idleIndex = this.indexOfIdleThread()) != -1; ++i) {
                Queue queue = queues[i];
                if (!this._queueToThread.containsKey(queue)) {
                    QueueConsumerThread thread = this._threads[idleIndex];
                    this._queueToThread.put(queue, thread);
                    this._threadWorking[idleIndex] = true;
                    ++this._numThreadsWorking;
                    this.removeUnboundQueue(queue);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "TM.entryAdded: Queue " + queue.getQueueNumber() + " bound to thread " + idleIndex + ".");
                    }
                    thread.startUp(queue);
                    continue;
                }
                if (!tc.isEntryEnabled()) continue;
                Tr.exit(tc, "TM.entryAdded: Queue already bound", "queue=" + queue.getQueueNumber());
            }
            while (i < queues.length) {
                Queue queue = queues[i];
                if (!this._queueToThread.containsKey(queue)) {
                    this.addUnboundQueue(queue);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "TM.entryAdded: Queue added to unbound queue list.", "queue=" + queue.getQueueNumber());
                    }
                } else if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "TM.entryAdded: Queue already bound.", "queue=" + queue.getQueueNumber());
                }
                ++i;
            }
        }

        public synchronized Queue unbindQueue(Queue queue, int threadIndex) {
            Queue retQueue;
            int numQueues;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "TM.unbindQueue");
            }
            this._queueToThread.remove(queue);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TM.unbindQueue: Queue " + queue.getQueueNumber() + " unbound from thread " + threadIndex + ".");
            }
            if (queue.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TM.unbindQueue: put queue on unbound queue list.");
                }
                this.addUnboundQueue(queue);
            }
            if ((numQueues = this._unboundQueues.size()) == 0) {
                this._threadWorking[threadIndex] = false;
                --this._numThreadsWorking;
                retQueue = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TM.unbindQueue: No more unbound queues to bind.");
                }
            } else {
                retQueue = (Queue)this._unboundQueues.remove(0);
                this._queueToThread.put(retQueue, this._threads[threadIndex]);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TM.unbindQueue: Queue " + retQueue.getQueueNumber() + " bound to thread " + threadIndex + ".");
                }
            }
            return retQueue;
        }

        private int indexOfIdleThread() {
            if (this._numThreadsWorking == 50) {
                Exception e = new Exception("All downstream server update threads are busy.");
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.event.DownstreamServerManager.ThreadManager.indexOfIdleThread", (String)"993", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "TM.indexOfIdleThread: All threads are busy.");
                }
                return -1;
            }
            for (int i = 0; i < 50; ++i) {
                if (this._threadWorking[i]) continue;
                return i;
            }
            return -1;
        }

        private void addUnboundQueue(Queue queue) {
            int unboundIndex = this._unboundQueues.indexOf(queue);
            if (unboundIndex == -1) {
                this._unboundQueues.add(queue);
            }
        }

        private void removeUnboundQueue(Queue queue) {
            int unboundIndex = this._unboundQueues.indexOf(queue);
            if (unboundIndex != -1) {
                this._unboundQueues.remove(unboundIndex);
            }
        }
    }

    class QueueEntry {
        public static final int OP_ADD_DOWNSTREAM_SERVER = 0;
        public static final int OP_REMOVE_DOWNSTREAM_SERVER = 1;
        public static final int OP_UPDATE_LISTENERS = 2;
        private final ServerUpdateOpInfo _opInfo;
        private final int _operation;
        private final ServerInfo _serverInfo;

        public QueueEntry(ServerUpdateOpInfo opInfo, int serverInfoListIndex) {
            this._opInfo = opInfo;
            this._operation = opInfo.getOperation();
            this._serverInfo = opInfo.getServerInfo(serverInfoListIndex);
        }

        public int getOperation() {
            return this._operation;
        }

        public ServerInfo getServerInfo() {
            return this._serverInfo;
        }

        public ServerUpdateOpInfo getServerOpInfo() {
            return this._opInfo;
        }

        public String toString() {
            return "op=" + this._operation + "; serverInfo=" + this._serverInfo;
        }
    }

    class Queue {
        private static final int QUEUE_SIZE_LIMIT = 100;
        private final Vector _queue = new Vector();
        private final ServerInfo _serverInfo;
        private final int _queueNumber;
        private final String TRACE_HEADING;

        public Queue(ServerInfo serverInfo, int queueNumber) {
            this._serverInfo = serverInfo;
            this._queueNumber = queueNumber;
            this.TRACE_HEADING = "Queue(" + queueNumber + "): ";
        }

        public synchronized void addEntry(QueueEntry queueEntry) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.TRACE_HEADING + "addEntry", "queueEntry=" + queueEntry);
            }
            if (this._queue.size() == 100) {
                Exception e = new Exception("QueueHandler: Queue size limit exceeded.  Downstream server update not executed.");
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.event.DownstreamServerManager.Queue.addEntry", (String)"667", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, this.TRACE_HEADING + "Queue limit exceeded.");
                }
                return;
            }
            this._queue.addElement(queueEntry);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.TRACE_HEADING + "Queue size: " + this._queue.size());
            }
        }

        public synchronized QueueEntry getNextEntry() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.TRACE_HEADING + "getNextEntry");
            }
            QueueEntry queueEntry = this._queue.size() == 0 ? null : (QueueEntry)this._queue.remove(0);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.TRACE_HEADING + "getNextEntry", "queueEntry=" + queueEntry);
            }
            return queueEntry;
        }

        public synchronized boolean clear() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.TRACE_HEADING + "clear");
            }
            while (this._queue.size() != 0) {
                QueueEntry queueEntry = (QueueEntry)this._queue.get(0);
                if (queueEntry.getOperation() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, this.TRACE_HEADING + "Queue not cleared.  Add operation is queued.");
                    }
                    return false;
                }
                queueEntry.getServerOpInfo().markServerUpdateComplete(this._queueNumber, null);
                this._queue.remove(0);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.TRACE_HEADING + "Queue cleared.");
            }
            return true;
        }

        public synchronized int size() {
            return this._queue.size();
        }

        public ServerInfo getServerInfo() {
            return this._serverInfo;
        }

        public int getQueueNumber() {
            return this._queueNumber;
        }

        public int hashCode() {
            return this._serverInfo.hashCode();
        }
    }

    class QueueManager {
        private HashMap _queues = new HashMap();
        private ThreadManager _threadManager;
        private int _queueNumber = 0;

        public QueueManager(ThreadManager threadManager) {
            this._threadManager = threadManager;
        }

        public synchronized void queueUpOperation(ServerUpdateOpInfo opInfo) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "QM.queueUpOperation", "op=" + opInfo.getOperation());
            }
            ServerInfo[] serverInfoList = opInfo.getServerInfoList();
            Queue[] queues = new Queue[serverInfoList.length];
            for (int i = 0; i < serverInfoList.length; ++i) {
                QueueEntry queueEntry = new QueueEntry(opInfo, i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "QM.queueUpOperation", "serverInfo=" + queueEntry.getServerInfo());
                }
                Queue queue = this.getQueue(queueEntry);
                queue.addEntry(queueEntry);
                queues[i] = queue;
            }
            this._threadManager.entryAddedToQueues(queues);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "QM.queueUpOperation");
            }
        }

        private Queue getQueue(QueueEntry queueEntry) {
            ServerInfo serverInfo = queueEntry.getServerInfo();
            Queue queue = (Queue)this._queues.get(serverInfo);
            if (queue == null) {
                queue = new Queue(serverInfo, this._queueNumber++);
                this._queues.put(serverInfo, queue);
            }
            return queue;
        }

        public synchronized void removeQueue(ServerInfo serverInfo) {
            Queue queue;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "QM.removeQueue", "serverInfo=" + serverInfo);
            }
            if ((queue = (Queue)this._queues.get(serverInfo)) != null) {
                if (queue.clear()) {
                    this._queues.remove(serverInfo);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "QM.removeQueue: Queue removed.");
                    }
                } else if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "QM.removeQueue: Queue not removed. Entries remain.");
                }
            } else if (tc.isEntryEnabled()) {
                Tr.exit(tc, "QM.removeQueue: Queue does not exist.");
            }
        }
    }

    class ServerUpdateOpInfo {
        public static final int TIMEOUT = 120000;
        public static final int OP_ADD_DOWNSTREAM_SERVER = 0;
        public static final int OP_REMOVE_DOWNSTREAM_SERVER = 1;
        public static final int OP_UPDATE_LISTENERS = 2;
        private final int _operation;
        private final ServerInfo[] _serverInfoList;
        private int _numUpdatesComplete = 0;
        private ConnectorException _connExc = null;

        public ServerUpdateOpInfo(int operation, ServerInfo[] serverInfoList) {
            this._operation = operation;
            this._serverInfoList = serverInfoList;
        }

        public ServerUpdateOpInfo(int operation, ServerInfo serverInfo) {
            this._operation = operation;
            this._serverInfoList = new ServerInfo[1];
            this._serverInfoList[0] = serverInfo;
        }

        public int getOperation() {
            return this._operation;
        }

        public ServerInfo[] getServerInfoList() {
            return this._serverInfoList;
        }

        public ServerInfo getServerInfo(int serverInfoListIndex) {
            return this._serverInfoList[serverInfoListIndex];
        }

        public synchronized boolean waitForRequestToComplete() throws ConnectorException {
            block11: {
                try {
                    if (this._connExc == null && this._numUpdatesComplete < this._serverInfoList.length) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "OpInfo: Waiting for update to complete.");
                        }
                        if (this._operation == 0) {
                            this.wait();
                        } else {
                            this.wait(120000L);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "OpInfo: received exception on wait for completion.", e);
                }
            }
            if (this._connExc != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "OpInfo: Finished waiting.  Throwing ConnectorException.");
                }
                throw this._connExc;
            }
            if (this._numUpdatesComplete == this._serverInfoList.length) {
                if (tc.isDebugEnabled() && this._serverInfoList.length > 0) {
                    Tr.debug(tc, "OpInfo: Finished.  All server updates have completed.");
                }
                return true;
            }
            Exception e = new Exception("Finished waiting.  Timeout occurred while waiting for downstream server  updates to complete.");
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.event.DownstreamServerManager.ServerUpdateOpInfo.waitForRequestToComplete", (String)"484", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "OpInfo: Finished waiting.  Not all server updates have completed.  Missing notifications could result.");
            }
            return false;
        }

        public synchronized void markServerUpdateComplete(int queueNumber, ConnectorException exc) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OpInfo: Server update on queue Q" + queueNumber + " has completed.");
            }
            this._connExc = exc;
            ++this._numUpdatesComplete;
            if (exc != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "OpInfo: Server update exception: " + exc);
                }
                this.notify();
            } else if (this._numUpdatesComplete == this._serverInfoList.length) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "OpInfo: All server updates have completed.");
                }
                this.notify();
            }
        }
    }

    class DSMEntry {
        ConsolidatedFilter filter;
        ListenerIdentifier listenerId;

        DSMEntry(ConsolidatedFilter filter, ListenerIdentifier listenerId) {
            this.filter = filter;
            this.listenerId = listenerId;
        }

        public String toString() {
            return "DSMEntry:[listenerId=" + this.listenerId + ";filter=" + this.filter + "]";
        }
    }
}

