/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.protocol.UdpAdv;
import com.ibm.ws.management.discovery.transport.MessengerFactory;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import com.ibm.ws.management.discovery.transport.UdpServer;
import java.io.IOException;
import java.net.InetAddress;

public class UdpTransport
implements TransportProtocol {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(UdpTransport.class, "Admin", "com.ibm.ws.management.resources.discovery");
    protected int port;
    protected boolean initialized = false;
    protected EndpointAddress localAddress;
    private UdpServer udpServer;

    public UdpTransport() {
    }

    public UdpTransport(UdpAdv uadv) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UdpTransport");
        }
        InetAddress usingInterface = null;
        this.port = new Integer(uadv.getPort());
        String interfaceAddress = uadv.getLocalAddress();
        try {
            if (interfaceAddress == null) {
                usingInterface = AdminHelper.getInstance().getLocalHost();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "In UdpTransport, the hostname or IP addr obtained from UdpAdv is null");
                }
            } else {
                usingInterface = InetAddress.getByName(interfaceAddress);
            }
            if (usingInterface.getHostAddress().equals("127.0.0.1")) {
                Tr.warning(tc, "ADMD0025W");
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.transport.UdpTransport.UdpTransport", (String)"57", (Object)this);
            Tr.error(tc, "ADMD0019E", ex.getMessage());
        }
        this.localAddress = new EndpointAddress();
        this.localAddress.setProtocolName("UDP");
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.localAddress.setProtocolAddress(usingInterface.getHostAddress() + ":" + this.port);
        } else if (interfaceAddress == null) {
            this.localAddress.setProtocolAddress(usingInterface.getHostName() + ":" + this.port);
        } else {
            this.localAddress.setProtocolAddress(interfaceAddress + ":" + this.port);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UdpTransport");
        }
    }

    public EndpointMessenger getMessenger(EndpointAddress dest) throws IOException {
        return MessengerFactory.createMessenger(dest, this);
    }

    public boolean init(Endpoint ep) throws Exception {
        if (this.initialized) {
            throw new IOException();
        }
        this.initialized = true;
        this.udpServer = new UdpServer(ep);
        this.udpServer.initialize(this.port);
        return true;
    }

    public EndpointAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocolName() {
        return "UDP";
    }

    public void close() {
        this.udpServer.shutdown(true);
    }
}

