/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.transport.Header;
import java.net.DatagramPacket;

public class UdpConnection
implements Runnable {
    private static TraceComponent tc = Tr.register(UdpConnection.class);
    Endpoint endpoint;
    DatagramPacket packet;

    public void init(Endpoint endpoint, DatagramPacket packet) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.endpoint = endpoint;
        this.packet = packet;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void run() {
        Message msg;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
            Header header = new Header();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "start to retrieve data");
            }
            byte[] data = this.packet.getData();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "data retrieved successfully");
            }
            int length = this.packet.getLength();
            if (!header.decipher(data, 0)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "can not understand the TcpHeader");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "the incoming datagram size is " + header.size);
            }
            if (header.size > data.length) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The incoming message is truncated: " + header.size + ">" + data.length);
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "run - failed");
                }
                return;
            }
            msg = null;
            try {
                msg = new Message(data, Header.length, header.size);
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.discovery.transport.UdpConnection.run", (String)"73", (Object)this);
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "can not construct discoveyr message", th);
            }
        }
        if (msg != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " forward the message up to the endpoint");
            }
            this.endpoint.demux(msg);
        }
    }
}

