/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.transport.Header;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

public class TcpMessenger
implements EndpointMessenger {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(TcpMessenger.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.discovery");
    private EndpointAddress destination;
    private EndpointAddress source;
    private InetAddress inetAddress;
    private TransportProtocol protocol;
    private Socket socket;
    private int port;
    private Header header;

    public TcpMessenger(EndpointAddress address, TransportProtocol protocol) throws IOException {
        int portIndex;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TcpMessenger", address);
        }
        this.destination = address;
        this.protocol = protocol;
        this.header = new Header();
        this.source = protocol.getLocalAddress();
        String tmp = this.destination.getProtocolAddress();
        int ind = tmp.indexOf(93);
        if (ind < 0) {
            ind = 0;
        }
        if ((portIndex = tmp.indexOf(58, ind)) == -1) {
            throw new IOException(this.nls.getString("ADMD0010E"));
        }
        this.port = Integer.valueOf(tmp.substring(portIndex + 1));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "port = " + this.port);
        }
        this.inetAddress = InetAddress.getByName(tmp.substring(0, portIndex));
        if (!this.openSocket()) {
            throw new IOException(this.nls.getFormattedMessage("ADMD0004E", new Object[]{new Integer(this.port)}, "can not open the TCP socket: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TcpMessenger(EndpointAddress, TcpTrasnport)");
        }
    }

    public void sendMessage(Message message) throws IOException {
        byte[] nextBuffer;
        int readLength;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendMessage");
        }
        if (this.destination == null) {
            throw new IOException();
        }
        InputStream inputStream = message.getInputStream();
        Vector<byte[]> msgBuffers = new Vector<byte[]>();
        msgBuffers.addElement(new byte[Header.length]);
        int msgSize = 0;
        int bufferSize = 4096;
        while (-1 != (readLength = inputStream.read(nextBuffer = new byte[bufferSize]))) {
            if (0 == readLength) continue;
            if (readLength < bufferSize) {
                byte[] anotherBuffer = new byte[readLength];
                System.arraycopy(nextBuffer, 0, anotherBuffer, 0, readLength);
                nextBuffer = anotherBuffer;
            }
            msgSize += nextBuffer.length;
            msgBuffers.addElement(nextBuffer);
        }
        this.header.cmd = (byte)2;
        String h = this.protocol.getLocalAddress().getProtocolHost();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "local host name is: " + h);
        }
        this.header.srcAddr = InetAddress.getByName(h).getAddress();
        this.header.srcPort = this.protocol.getPort();
        this.header.option = 2;
        this.header.size = msgSize;
        this.header.cipher((byte[])msgBuffers.elementAt(0), 0);
        if (this.socket == null && !this.openSocket()) {
            throw new IOException(this.nls.getFormattedMessage("ADMD0004E", new Object[]{new Integer(this.port)}, "can not open the TCP socket: {0}"));
        }
        for (int retryAttempt = 0; retryAttempt < 2; ++retryAttempt) {
            try {
                OutputStream outputStream = this.socket.getOutputStream();
                for (int eachBuffer = 0; eachBuffer < msgBuffers.size(); ++eachBuffer) {
                    outputStream.write((byte[])msgBuffers.elementAt(eachBuffer));
                }
                outputStream.flush();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sendMessage - successful");
                }
                return;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.transport.TcpMessenger.sendMessage", (String)"156", (Object)this);
                if (this.openSocket()) continue;
                try {
                    if (this.socket == null) continue;
                    this.socket.close();
                    this.socket = null;
                    continue;
                }
                catch (Exception e2) {
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.discovery.transport.TcpMessenger.sendMessage", (String)"169", (Object)this);
                    throw new IOException();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendMessage - failed");
        }
    }

    public void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.transport.TcpMessenger.close", (String)"188", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    private boolean openSocket() {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "openSocket");
            }
            this.socket = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "InetAddress, port: ", new Object[]{this.inetAddress, new Integer(this.port)});
                }
                this.socket = new Socket(this.inetAddress, this.port);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "openSocket - good");
                }
                return true;
            }
            catch (ConnectException ce) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "connection refused", ce);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.transport.TcpMessenger.openSocket", (String)"236", (Object)this);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "general socket exception", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openSocket - bad");
        }
        return false;
    }
}

