/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.transport.MUdpMessenger;
import com.ibm.ws.management.discovery.transport.TcpMessenger;
import com.ibm.ws.management.discovery.transport.TcpTransport;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import com.ibm.ws.management.discovery.transport.UdpMessenger;
import java.io.IOException;

public class MessengerFactory {
    private static TraceComponent tc = Tr.register(TcpTransport.class);

    public static EndpointMessenger createMessenger(EndpointAddress destination, TransportProtocol transport) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMessenger", new Object[]{destination, transport.getProtocolName()});
        }
        String protocol = destination.getProtocolName();
        EndpointMessenger messenger = null;
        if (protocol.equalsIgnoreCase("TCP")) {
            messenger = new TcpMessenger(destination, transport);
        } else if (protocol.equalsIgnoreCase("UDP")) {
            messenger = new UdpMessenger(destination, transport);
        } else if (protocol.equalsIgnoreCase("MUDP")) {
            messenger = new MUdpMessenger(destination, transport);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMessenger");
        }
        return messenger;
    }
}

