/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.protocol.TcpAdv;
import com.ibm.ws.management.discovery.protocol.TransportAdvertisement;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MUdpAdv
extends TransportAdvertisement {
    private static TraceComponent tc = Tr.register(TcpAdv.class);
    protected String protocol = null;
    protected String port = null;
    private String multicastAddr = null;

    public MUdpAdv(String protocol, String multicastAddr, String port) {
        this.protocol = protocol;
        this.port = port;
        this.multicastAddr = multicastAddr;
    }

    public MUdpAdv(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MUdpAdv(Element)");
        }
        this.initialize(element);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MUdpAdv(Element)");
        }
    }

    private void initialize(Node root) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        for (Node elem = root.getFirstChild(); elem != null; elem = elem.getNextSibling()) {
            if (elem instanceof Element && tc.isDebugEnabled()) {
                Tr.debug(tc, "Node name = " + elem.getNodeName() + " value = " + elem.getFirstChild().getNodeValue());
            }
            if (elem.getNodeName().equalsIgnoreCase("Protocol")) {
                this.setProtocol(elem.getFirstChild().getNodeValue());
                continue;
            }
            if (elem.getNodeName().equals("Port")) {
                this.setPort(elem.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!elem.getNodeName().equals("MulticastAddr")) continue;
            this.setMulticastAddr(elem.getFirstChild().getNodeValue().trim());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public XMLDocument getXMLDocument() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXMLDocument");
        }
        XMLDocument adv = null;
        try {
            adv = new XMLDocument(this.getAdvertisementType());
            Element e = null;
            if (this.getProtocol() != null) {
                e = adv.createElement("Protocol", this.getProtocol());
                adv.appendChild(e);
            }
            if (this.getPort() != null) {
                e = adv.createElement("Port", this.getPort());
                adv.appendChild(e);
            }
            if (this.getMulticastAddr() != null) {
                e = adv.createElement("MulticastAddr", this.getMulticastAddr());
                adv.appendChild(e);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.MUdpAdv.getXMLDocument", (String)"105", (Object)this);
            ex.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXMLDocument");
        }
        return adv;
    }

    public String getAdvertisementType() {
        return "jxta:MUDPTransportAdvertisement";
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getMulticastAddr() {
        return this.multicastAddr;
    }

    public void setMulticastAddr(String multicastaddr) {
        this.multicastAddr = multicastaddr;
    }
}

