/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.protocol.Advertisement;
import com.ibm.ws.management.discovery.protocol.MUdpAdv;
import com.ibm.ws.management.discovery.protocol.TcpAdv;
import com.ibm.ws.management.discovery.protocol.TransportAdvertisement;
import com.ibm.ws.management.discovery.protocol.UdpAdv;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EndpointAdv
implements Advertisement {
    private static TraceComponent tc = Tr.register(EndpointAdv.class);
    private String name = null;
    private TransportAdvertisement transport = null;
    private String endpointAddress = null;

    public EndpointAdv(String name, String endpointaddr, TransportAdvertisement transport) {
        this.name = name;
        this.endpointAddress = endpointaddr;
        this.transport = transport;
    }

    public EndpointAdv(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EndpointAdv(Element)");
        }
        this.initialize(element.getElementsByTagName(this.getAdvertisementType()).item(0));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EndpointAdv(Element)");
        }
    }

    private void initialize(Node root) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        for (Node elem = root.getFirstChild(); elem != null; elem = elem.getNextSibling()) {
            if (elem instanceof Element && tc.isDebugEnabled()) {
                Tr.debug(tc, "Node name = " + elem.getNodeName() + " value = " + elem.getFirstChild().getNodeValue());
            }
            if (elem.getNodeName().equals("Name")) {
                this.setName(elem.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (elem.getNodeName().equals("Address")) {
                this.setEndpointAddress(elem.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!elem.getNodeName().equals("Transport")) continue;
            for (Node nd = elem.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
                if (nd.getNodeName().equalsIgnoreCase("jxta:TCPTransportAdvertisement")) {
                    this.setTransportAdvertisement(new TcpAdv((Element)nd));
                    continue;
                }
                if (nd.getNodeName().equalsIgnoreCase("jxta:UDPTransportAdvertisement")) {
                    this.setTransportAdvertisement(new UdpAdv((Element)nd));
                    continue;
                }
                if (!nd.getNodeName().equalsIgnoreCase("jxta:MUDPTransportAdvertisement")) continue;
                this.setTransportAdvertisement(new MUdpAdv((Element)nd));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public String getAdvertisementType() {
        return "jxta:EndpointAdvertisement";
    }

    public XMLDocument getXMLDocument() {
        XMLDocument adv = null;
        try {
            adv = new XMLDocument(this.getAdvertisementType());
            Element e = null;
            if (this.getName() != null) {
                e = adv.createElement("Name", this.getName());
                adv.appendChild(e);
            }
            if (this.getEndpointAddress() != null) {
                e = adv.createElement("Address", this.getEndpointAddress());
                adv.appendChild(e);
            }
            e = adv.createElement("Transport");
            adv.appendChild(e);
            TransportAdvertisement transport = this.getTransportAdvertisement();
            XMLDocument xptDoc = transport.getXMLDocument();
            adv.copyElements(xptDoc, e);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.EndpointAdv.getXMLDocument", (String)"120", (Object)this);
            ex.printStackTrace();
        }
        return adv;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public TransportAdvertisement getTransportAdvertisement() {
        return this.transport;
    }

    private void setTransportAdvertisement(TransportAdvertisement transport) {
        this.transport = transport;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    private void setEndpointAddress(String addr) {
        this.endpointAddress = addr;
    }
}

