/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.discovery.exception.InvalidEndpointAddressException;

public class EndpointAddress {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(EndpointAddress.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private String protocol;
    private String protocolHost;
    private String protocolPort;
    private String serviceName;
    private boolean unified = true;
    private boolean warningIssued = false;

    public EndpointAddress() {
    }

    public EndpointAddress(int prot, String host, String port, String serviceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EndpointAddress", new Object[]{new Integer(prot), host, port});
        }
        if (prot == 1) {
            this.protocol = "TCP";
        } else if (prot == 0) {
            this.protocol = "UDP";
        } else if (prot == 2) {
            this.protocol = "MUDP";
        }
        this.serviceName = serviceName;
        if (host.indexOf(58) > -1 && host.indexOf(91) < 0) {
            host = "[" + host + "]";
        }
        this.protocolHost = host;
        this.protocolPort = port;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EndpointAddress");
        }
    }

    public EndpointAddress(String protocol, String host, String port, String serviceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EndpointAddress", new Object[]{protocol, host, port});
        }
        this.protocol = protocol;
        this.serviceName = serviceName;
        if (host.indexOf(58) > -1 && host.indexOf(91) < 0) {
            host = "[" + host + "]";
        }
        this.protocolHost = host;
        this.protocolPort = port;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EndpointAddress");
        }
    }

    public EndpointAddress(String address) throws InvalidEndpointAddressException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EndpointAddress", address);
        }
        this.parse(address);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EndpointAddress");
        }
    }

    private String unifyHost(String host) {
        return host;
    }

    private void parse(String addr) throws InvalidEndpointAddressException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse", addr);
        }
        int index = addr.indexOf("://");
        String tmp = null;
        if (index == -1) {
            throw new InvalidEndpointAddressException(addr);
        }
        this.protocol = addr.substring(0, index);
        tmp = addr.substring(index + 3);
        this.parse1(tmp);
    }

    private void parse1(String addr) {
        int index = addr.indexOf("/");
        String tmp = null;
        int ipv6_end = addr.indexOf(93);
        if (ipv6_end < 0) {
            ipv6_end = 0;
        }
        if (index == -1) {
            int idx = addr.indexOf(58, ipv6_end);
            if (idx != -1) {
                this.protocolHost = this.unifyHost(addr.substring(0, idx));
                this.protocolPort = addr.substring(idx + 1);
            } else {
                this.protocolHost = this.unifyHost(addr);
            }
        } else {
            String tmp1 = addr.substring(0, index);
            int idx = tmp1.indexOf(58, ipv6_end);
            if (idx != -1) {
                this.protocolHost = this.unifyHost(tmp1.substring(0, idx));
                this.protocolPort = tmp1.substring(idx + 1);
            } else {
                this.protocolHost = this.unifyHost(tmp1);
            }
            tmp = addr.substring(index + 1);
            index = tmp.indexOf("/");
            this.serviceName = index == -1 ? tmp : tmp.substring(0, index);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "protocol = " + this.protocol + " host = " + this.protocolHost + "port = " + this.protocolPort + " service = " + this.serviceName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse");
        }
    }

    public String getProtocolName() {
        return this.protocol;
    }

    public void setProtocolName(String name) {
        this.protocol = name;
    }

    public String getProtocolAddress() {
        if (this.protocolPort != null) {
            return this.getProtocolHost() + ":" + this.protocolPort;
        }
        return this.getProtocolHost();
    }

    public String getProtocolHost() {
        if (!this.unified) {
            this.protocolHost = this.unifyHost(this.protocolHost);
        }
        return this.protocolHost;
    }

    public String getProtocolPort() {
        return this.protocolPort;
    }

    public void setProtocolAddress(String address) {
        this.parse1(address);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public String getURI() {
        if (this.serviceName != null) {
            return this.protocol + "://" + this.protocolHost + ":" + this.protocolPort + "/" + this.serviceName;
        }
        return this.protocol + "://" + this.protocolHost + ":" + this.protocolPort + "/";
    }

    public String toString() {
        return this.getURI();
    }
}

