/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.http.HttpException;
import com.ibm.ws.http.HttpResponse;
import com.ibm.ws.management.connector.soap.SOAPConnection;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.mail.MessagingException;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;

public class SOAPResponse
extends HttpResponse {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(SOAPResponse.class, "Admin", "com.ibm.ws.management.resources.connector");
    public static int SC_OK = 200;
    public static int SC_INTERNAL_SERVER_ERROR = 500;

    public SOAPResponse(SOAPConnection conn) {
        super((HttpConnection)conn);
    }

    public void setContentType(String type) {
        this.addHeader("Content-Type", type);
    }

    public void setContentLength(String len) {
        this.addHeader("Content-Length", len);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeSOAPResponse(Response resp, SOAPContext resCtx, SOAPMappingRegistry smr, int status) throws IOException, HttpException {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "writeSOAPResponse");
            }
            StringWriter sw = null;
            try {
                try {
                    Envelope env = resp.buildEnvelope();
                    sw = new StringWriter();
                    env.marshall((Writer)sw, (XMLJavaMappingRegistry)smr, resCtx);
                    resCtx.setRootPart(sw.toString(), "text/xml;charset=utf-8");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "the generated soap response envelop is ", sw.toString());
                    }
                    TransportMessage sres = new TransportMessage(null, resCtx, null);
                    sres.editOutgoing(null);
                    sres.save();
                    this.setStatus(status);
                    this.setContentType(sres.getContentType());
                    Enumeration headers = sres.getHeaderNames();
                    while (headers.hasMoreElements()) {
                        String name = (String)headers.nextElement();
                        this.addHeader(name, sres.getHeader(name));
                    }
                    this.setContentLength(new Integer(sres.getContentLength()).toString());
                    sres.writeTo(this.getOutputStream());
                }
                catch (MessagingException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.connector.soap.SoapResponse.writeSoapResponse", (String)"105", (Object)((Object)this));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "writeSOAPResponse - exception", e);
                    }
                    throw new HttpException();
                }
                catch (IllegalArgumentException iae) {
                    FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.management.connector.soap.SoapResponse.writeSoapResponse", (String)"109", (Object)((Object)this));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "writeSOAPResponse - exception", iae);
                    }
                    throw new HttpException();
                }
                catch (SOAPException se) {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.management.connector.soap.SoapResponse.writeSoapResponse", (String)"113", (Object)((Object)this));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "writeSOAPResponse - exception", (Object)se);
                    }
                    throw new HttpException();
                }
                Object var11_13 = null;
                if (sw == null) break block14;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (sw != null) {
                    sw.close();
                }
                throw throwable;
            }
            sw.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeSOAPResponse");
        }
    }
}

