/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.rmi;

import com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.AdminServiceDelegator;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.connector.rmi.RMIConnector;
import com.ibm.ws.management.connector.rmi.RMINotificationListener;
import com.ibm.ws.management.connector.rmi.RMINotificationListenerAdapter;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.Utils;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import java.rmi.RemoteException;
import java.util.Set;
import java.util.Stack;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.rmi.PortableRemoteObject;

public class RMIConnectorService
extends PortableRemoteObject
implements RMIConnector {
    private static RMIConnectorService instance;
    private AdminServiceDelegator adminService;
    private boolean isStopped = true;
    private String profileKey;
    private static TraceComponent tc;

    private RMIConnectorService() throws RemoteException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating RMIConnectorService");
        }
        this.adminService = new AdminServiceDelegator();
        this.profileKey = AdminContext.peek();
    }

    public static synchronized RMIConnectorService getInstance() throws RemoteException {
        RMIConnectorService ret = null;
        String uuid = AdminContext.peek();
        if (uuid == null) {
            if (instance == null) {
                instance = new RMIConnectorService();
                JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            }
            ret = instance;
        } else {
            ret = (RMIConnectorService)AdminSubsystemServiceRegistry.getService((String)RMIConnectorService.class.getName());
            if (ret == null) {
                ret = new RMIConnectorService();
                AdminSubsystemServiceRegistry.addService((String)RMIConnectorService.class.getName(), (Object)ret);
                JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session isAlive() throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking isAlive");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            Session session = this.adminService.isAlive();
            Object var5_4 = null;
            this.postProcess(pushed, savedStack);
            return session;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set queryNames(ObjectName name, QueryExp query) throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking queryNames");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            Set set = this.adminService.queryNames(name, query);
            Object var7_6 = null;
            this.postProcess(pushed, savedStack);
            return set;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, ConnectorException {
        if (CSIServerRIBase.interceptorObjName.equals(name)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processing speical ObjectName: " + name);
            }
            if ("uuid".equals(attribute)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "returning uuid: " + this.profileKey);
                }
                return this.profileKey;
            }
        }
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getAttribute");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            Object object = this.adminService.getAttribute(name, attribute);
            Object var7_6 = null;
            this.postProcess(pushed, savedStack);
            return object;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getAttributes");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            AttributeList attributeList = this.adminService.getAttributes(name, attributes);
            Object var7_6 = null;
            this.postProcess(pushed, savedStack);
            return attributeList;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking setAttribute");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            this.adminService.setAttribute(name, attribute);
            Object var6_5 = null;
            this.postProcess(pushed, savedStack);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking setAttributes");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            AttributeList attributeList = this.adminService.setAttributes(name, attributes);
            Object var7_6 = null;
            this.postProcess(pushed, savedStack);
            return attributeList;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking invoke");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            Object object = this.adminService.invoke(name, operationName, params, signature);
            Object var9_8 = null;
            this.postProcess(pushed, savedStack);
            return object;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultDomain() throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getDefaultDomain");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            String string = this.adminService.getDefaultDomain();
            Object var5_4 = null;
            this.postProcess(pushed, savedStack);
            return string;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDomainName() throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getDomainName");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            String string = this.adminService.getDomainName();
            Object var5_4 = null;
            this.postProcess(pushed, savedStack);
            return string;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getMBeanCount() throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getMBeanCount");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            Integer n = this.adminService.getMBeanCount();
            Object var5_4 = null;
            this.postProcess(pushed, savedStack);
            return n;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getMBeanInfo");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            MBeanInfo mBeanInfo = this.adminService.getMBeanInfo(name);
            Object var6_5 = null;
            this.postProcess(pushed, savedStack);
            return mBeanInfo;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName getServerMBean() throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getServerMBean");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            ObjectName objectName = this.adminService.getServerMBean();
            Object var5_4 = null;
            this.postProcess(pushed, savedStack);
            return objectName;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(ObjectName name) throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking isRegistered");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            boolean bl = this.adminService.isRegistered(name);
            Object var6_5 = null;
            this.postProcess(pushed, savedStack);
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking isInstanceOf");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            boolean bl = this.adminService.isInstanceOf(name, className);
            Object var7_6 = null;
            this.postProcess(pushed, savedStack);
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenerIdentifier addRMINotificationListener(ConsolidatedFilter filter, RMINotificationListener listener) throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRMINotificationListener");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            RMINotificationListenerAdapter adapter = new RMINotificationListenerAdapter(listener);
            ListenerIdentifier id = this.adminService.addNotificationListener(filter, adapter);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addRMINotificationListener", id);
            }
            ListenerIdentifier listenerIdentifier = id;
            Object var9_8 = null;
            this.postProcess(pushed, savedStack);
            return listenerIdentifier;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ListenerIdentifier listenerId) throws ConnectorException, ReceiverNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking removeNotificationListener");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            this.adminService.removeNotificationListener(listenerId);
            Object var5_4 = null;
            this.postProcess(pushed, savedStack);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFilter(ListenerIdentifier listenerId, ConsolidatedFilter filter) throws ConnectorException, ReceiverNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking resetFilter");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            this.adminService.resetFilter(listenerId, filter);
            Object var6_5 = null;
            this.postProcess(pushed, savedStack);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notification[] pullNotifications(ListenerIdentifier id, Integer batchSize) throws ConnectorException, ReceiverNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking pullNotifications");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            Notification[] notificationArray = this.adminService.pullNotifications(id, batchSize);
            Object var7_6 = null;
            this.postProcess(pushed, savedStack);
            return notificationArray;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    void stop() {
        this.isStopped = true;
    }

    void start() {
        this.isStopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance getObjectInstance(ObjectName name) throws ConnectorException, InstanceNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getObjectInstance");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            ObjectInstance objectInstance = this.adminService.getObjectInstance(name);
            Object var6_5 = null;
            this.postProcess(pushed, savedStack);
            return objectInstance;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoaderFor(ObjectName name) throws ConnectorException, InstanceNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getClassLoaderFor");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            ClassLoader classLoader = this.adminService.getClassLoaderFor(name);
            Object var6_5 = null;
            this.postProcess(pushed, savedStack);
            return classLoader;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(ObjectName name) throws ConnectorException, InstanceNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getClassLoader");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            ClassLoader classLoader = this.adminService.getClassLoader(name);
            Object var6_5 = null;
            this.postProcess(pushed, savedStack);
            return classLoader;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set queryMBeans(ObjectName name, QueryExp query) throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking queryMBeans");
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            JMXVersionValidation.setClientVersion(Utils.getProductVersion());
            Set set = this.adminService.queryMBeans(name, query);
            Object var7_6 = null;
            this.postProcess(pushed, savedStack);
            return set;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws ConnectorException, InstanceNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addNotificationListener", new Object[]{name, listener, filter, handback});
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            this.adminService.addNotificationListener(name, listener, filter, handback);
            Object var8_7 = null;
            this.postProcess(pushed, savedStack);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener_2(ObjectName name, ObjectName listener) throws ConnectorException, InstanceNotFoundException, ListenerNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeNotificationListener_2", new Object[]{name, listener});
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            this.adminService.removeNotificationListener(name, listener);
            Object var6_5 = null;
            this.postProcess(pushed, savedStack);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener_4(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws ConnectorException, InstanceNotFoundException, ListenerNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeNotificationListener_4", new Object[]{name, listener, filter, handback});
        }
        boolean pushed = false;
        Stack savedStack = null;
        try {
            savedStack = AdminContext.exportStack();
            pushed = AdminContext.push((String)this.profileKey);
            this.adminService.removeNotificationListener(name, listener, filter, handback);
            Object var8_7 = null;
            this.postProcess(pushed, savedStack);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.postProcess(pushed, savedStack);
            throw throwable;
        }
    }

    private void postProcess(boolean pushed, Stack savedStack) {
        Stack currentStack;
        if (pushed) {
            AdminContext.pop();
        }
        if (savedStack != null && !savedStack.equals(currentStack = AdminContext.exportStack())) {
            AdminContext.importStack((Stack)savedStack);
            Tr.error(tc, "AdminContext Stack incorrectly used in RMIConnectorService", new Object[]{savedStack, currentStack});
            Exception ex = new Exception("AdminContext Stack incorrectly used in AdminServiceForwarder");
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorService.postProcess", (String)"719", (Object)this);
        }
    }

    static {
        tc = Tr.register(RMIConnectorService.class, "Admin", "com.ibm.ws.management.resources.connector");
    }
}

