/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.ipc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.management.connector.JMXConnector;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.HashMap;
import java.util.Properties;

public class IPCConnectorServer
implements JMXConnector {
    private static TraceComponent tc = Tr.register(IPCConnectorServer.class, "Admin", "com.ibm.ws.management.resources.connector");
    public static final String WS_TCP_CHANNEL_FACTORY_NAME = "com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory";
    public static final String WS_SSL_CHANNEL_FACTORY_NAME = "com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory";
    public static final String TCP_CHANNEL_FACTORY_NAME = "com.ibm.ws.tcp.channel.impl.TCPChannelFactory";
    public static final String APP_CHANNEL_FACTORY_NAME = "com.ibm.ws.management.connector.ipc.IPCConnectorInboundFactory";
    public static final String ZAIO_LOCAL_FACTORY_NAME = "com.ibm.ws.tcp.channel.impl.ZAioTCPChannelLocalFactory";
    public static final String ZAIO_TCP_FACTORY_NAME = "com.ibm.ws.tcp.channel.impl.ZAioTCPChannelFactory";
    private static final long STOP_DEPLAY = 0L;
    private static final int BUFFER_READ_TIMEOUT = 300;
    private static final int vcPoolSize = 500;
    private static final int bufferSize = 8192;
    public static final String APP_CHANNEL_NAME_BASE = "IPCCInboundChannel.";
    public static final String TCP_CHANNEL_NAME_BASE = "TCPInboundChannel_ipcc.";
    public static final String SSL_CHANNEL_NAME_BASE = "SSLInboundChannel_ipcc.";
    public static final String CHANNEL_CHAIN_NAME_BASE = "IPCCInboundChain.";
    public static final String CHAIN_GROUP_NAME_BASE = "IPCCInboundGroup.";
    public static final String LC_ZAIO_CHANNEL_NAME_BASE = "LC_ZAioInboundChannel.";
    public static final String LC_APP_CHANNEL_NAME_BASE = "LC_IPCCInboundChannel.";
    public static final String LC_CHANNEL_CHAIN_NAME_BASE = "LC_IPCCInboundChain.";
    private String tcpChannelName;
    private String sslChannelName;
    private String appChannelName;
    private String channelChainName;
    private String chainGroupName;
    private String lcZAioChannelName;
    private String lcAppChannelName;
    private String lcChannelChainName;
    private String serverHost;
    private int serverPort;
    private Properties connProp;
    private String profileKey = "Default";
    private ThreadPool threadPool;
    private boolean init_done;
    private ChannelFramework _framework;
    private boolean securityEnabled;
    private PlatformHelper helper;
    public static boolean UNIT_TEST = false;
    public static boolean ASYNCH = true;

    public static void main(String[] args) {
        ThreadPool tp = null;
        String profileKey = args.length > 2 ? args[2] : null;
        IPCConnectorServer _server = new IPCConnectorServer(tp, profileKey);
        String host = args.length > 0 ? args[0] : "localhost";
        String port = args.length > 1 ? args[1] : "1234";
        Properties prop = new Properties();
        prop.setProperty("host", host);
        prop.setProperty("port", port);
        try {
            _server.initialize(prop);
            _server.start();
            System.out.println("sleeping for 10 minutes");
            Thread.currentThread();
            Thread.sleep(60000000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public IPCConnectorServer(ThreadPool tp, String pKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "IPCConnectorServer");
        }
        this.threadPool = tp;
        if (pKey != null && pKey.length() > 0) {
            this.profileKey = pKey;
        }
        this.securityEnabled = SecurityHelper.getHelper().isSecurityEnabled();
        this.tcpChannelName = TCP_CHANNEL_NAME_BASE + this.profileKey;
        this.sslChannelName = SSL_CHANNEL_NAME_BASE + this.profileKey;
        this.appChannelName = APP_CHANNEL_NAME_BASE + this.profileKey;
        this.channelChainName = CHANNEL_CHAIN_NAME_BASE + this.profileKey;
        this.chainGroupName = CHAIN_GROUP_NAME_BASE + this.profileKey;
        this.lcZAioChannelName = LC_ZAIO_CHANNEL_NAME_BASE + this.profileKey;
        this.lcAppChannelName = LC_APP_CHANNEL_NAME_BASE + this.profileKey;
        this.lcChannelChainName = LC_CHANNEL_CHAIN_NAME_BASE + this.profileKey;
        this.helper = PlatformHelperFactory.getPlatformHelper();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "(Inbound) isServantJvm? " + this.helper.isServantJvm());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "IPCConnectorServer");
        }
    }

    public IPCConnectorServer(ThreadPool tp) {
        this(tp, null);
    }

    public void initialize(Properties p) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize" + p);
        }
        this.connProp = p;
        this.serverHost = this.connProp.getProperty("host");
        if (this.serverHost == null || this.serverHost.length() < 1) {
            return;
        }
        try {
            this.serverPort = Integer.parseInt(this.connProp.getProperty("port"));
        }
        catch (NumberFormatException e) {
            return;
        }
        if (SecurityContext.isServerProcess()) {
            try {
                this._framework = (ChannelFrameworkService)WsServiceRegistry.getService((Object)this, ChannelFrameworkService.class);
            }
            catch (Exception e) {
                Tr.error(tc, "ADMC0075E", e);
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "initialize; _framework=null");
                }
                return;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In unit test env; creating ChannelFramework instance");
            }
            this._framework = new ChannelFrameworkImpl();
        }
        if (this._framework == null) {
            Tr.error(tc, "ADMC0071E");
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "initialize; _framework=null");
            }
            return;
        }
        try {
            String[] cnames;
            HashMap<String, String> props = new HashMap<String, String>();
            this._framework.updateAllChannelFactoryProperties(Class.forName(APP_CHANNEL_FACTORY_NAME), props);
            props = new HashMap();
            int weight = 1;
            props.put("soReuseAddr", "1");
            props.put("hostname", this.serverHost);
            props.put("port", String.valueOf(this.serverPort));
            props.put("inactivityTimeout", String.valueOf(300));
            props.put("newConnectionBufferSize", String.valueOf(8192));
            if (this.helper.isControlJvm()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For TCP inbound, using com.ibm.ws.tcp.channel.impl.ZAioTCPChannelFactory");
                }
                this._framework.addChannel(this.tcpChannelName, Class.forName(ZAIO_TCP_FACTORY_NAME), props, weight);
            } else if (SecurityContext.isServerProcess()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For TCP inbound, using com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory");
                }
                this._framework.addChannel(this.tcpChannelName, Class.forName(WS_TCP_CHANNEL_FACTORY_NAME), props, weight);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For TCP inbound, using com.ibm.ws.tcp.channel.impl.TCPChannelFactory");
                }
                this._framework.addChannel(this.tcpChannelName, Class.forName(TCP_CHANNEL_FACTORY_NAME), props, weight);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Inbound channel added: " + this.tcpChannelName);
            }
            if (this.securityEnabled) {
                String ipcSslAlias = this.connProp.getProperty("sslConfig");
                if (ipcSslAlias != null) {
                    props.put("alias", ipcSslAlias);
                }
                props.put("endPointName", "IPC_CONNECTOR_ADDRESS");
                this._framework.addChannel(this.sslChannelName, Class.forName(WS_SSL_CHANNEL_FACTORY_NAME), props, weight);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Inbound channel added: " + this.sslChannelName);
                }
            }
            props = new HashMap();
            weight = 1;
            props.put("asynch", String.valueOf(ASYNCH));
            this._framework.addChannel(this.appChannelName, Class.forName(APP_CHANNEL_FACTORY_NAME), props, weight);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Inbound channel added: " + this.appChannelName);
            }
            if (this.securityEnabled) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "set the ssl configuration on thread for ipc");
                }
                HashMap<String, String> connectionInfo = new HashMap<String, String>();
                connectionInfo.put("com.ibm.ssl.direction", "inbound");
                connectionInfo.put("com.ibm.ssl.endPointName", "IPC_CONNECTOR_ADDRESS");
                JSSEHelper.getInstance().setInboundConnectionInfo(connectionInfo);
                String ipcSslAlias = this.connProp.getProperty("sslConfig");
                if (ipcSslAlias != null) {
                    Properties sslProps;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ipcSslAlias is " + ipcSslAlias);
                    }
                    if ((sslProps = JSSEHelper.getInstance().getProperties(ipcSslAlias, connectionInfo, null)) != null) {
                        JSSEHelper.getInstance().setSSLPropertiesOnThread(sslProps);
                    }
                }
                cnames = new String[]{this.tcpChannelName, this.sslChannelName, this.appChannelName};
            } else {
                cnames = new String[]{this.tcpChannelName, this.appChannelName};
            }
            this._framework.addChain(this.channelChainName, FlowType.getKey((int)0), cnames);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Inbound chain added: " + this.channelChainName);
            }
            cnames = new String[]{this.channelChainName};
            this._framework.addChainGroup(this.chainGroupName, cnames);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Inbound group added: " + this.chainGroupName);
            }
            if (this.helper.isZOS() && !this.helper.isServantJvm()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding localcomm channel...");
                }
                weight = 1;
                props = new HashMap();
                props.put("port", String.valueOf(this.serverPort));
                this._framework.addChannel(this.lcZAioChannelName, Class.forName(ZAIO_LOCAL_FACTORY_NAME), props, weight);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Inbound channel added: " + this.lcZAioChannelName);
                }
                weight = 1;
                props = new HashMap();
                props.put("asynch", String.valueOf(ASYNCH));
                this._framework.addChannel(this.lcAppChannelName, Class.forName(APP_CHANNEL_FACTORY_NAME), props, weight);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Inbound channel added: " + this.lcAppChannelName);
                }
                this._framework.addChain(this.lcChannelChainName, FlowType.INBOUND, new String[]{this.lcZAioChannelName, this.lcAppChannelName});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Inbound chain added: " + this.lcChannelChainName);
                }
                this._framework.addChainToGroup(this.chainGroupName, this.lcChannelChainName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Inbound channelfw _framework:", this._framework);
            }
            this.init_done = true;
        }
        catch (Exception e) {
            Tr.error(tc, "ADMC0072E", new Object[]{this.channelChainName + "/" + this.lcChannelChainName, e});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (!this.init_done) {
            return;
        }
        if (this._framework == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start; _framework=null");
            }
            return;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing chain group " + this.chainGroupName);
            }
            this._framework.initChainGroup(this.chainGroupName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Starting chain group " + this.chainGroupName);
            }
            this._framework.startChainGroup(this.chainGroupName);
            Tr.info(tc, "ADMC0070I", String.valueOf(this.serverPort));
        }
        catch (Exception e) {
            Tr.error(tc, "ADMC0072E", new Object[]{this.channelChainName + "/" + this.lcChannelChainName, e});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        block12: {
            block11: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "stop");
                }
                try {
                    this._framework.stopChainGroup(this.chainGroupName, 0L);
                }
                catch (Exception e) {
                    Tr.error(tc, "ADMC0073E", new Object[]{this.channelChainName + "/" + this.lcChannelChainName, e});
                }
                try {
                    this._framework.destroyChain(this.channelChainName);
                    this._framework.removeChain(this.channelChainName);
                    this._framework.removeChannel(this.tcpChannelName);
                    this._framework.removeChannel(this.appChannelName);
                    this._framework.removeChannel(this.sslChannelName);
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "Exception tearing down channels: " + e);
                }
            }
            if (this.helper.isZOS() && !this.helper.isServantJvm()) {
                try {
                    this._framework.destroyChain(this.lcChannelChainName);
                    this._framework.removeChain(this.lcChannelChainName);
                    this._framework.removeChannel(this.lcZAioChannelName);
                    this._framework.removeChannel(this.lcAppChannelName);
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Exception tearing down LC channels: " + e);
                }
            }
        }
        try {
            this._framework.removeChainGroup(this.chainGroupName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public String getType() {
        return "IPC";
    }

    public Properties getProperties() {
        return this.connProp;
    }

    public String getName() {
        return "type=IPC;host=" + this.serverHost + ";" + "port" + "=" + String.valueOf(this.serverPort);
    }
}

