/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.ipc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.management.connector.ipc.ChannelConnectionPool;
import com.ibm.ws.management.connector.ipc.ConnectionPool;
import com.ibm.ws.management.connector.ipc.IPCCOutboundFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.tcp.channel.impl.TCPChannelFactory;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Collection;
import java.util.HashMap;

public class ConnectionPoolMgr {
    private static TraceComponent tc = Tr.register(ConnectionPoolMgr.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final Class APP_OUTBOUND_FAC_CLASS = IPCCOutboundFactory.class;
    private static final Class TCP_OUTBOUND_FAC_CLASS = TCPChannelFactory.class;
    private static final String WS_TCP_OUTBOUND_FAC_CLASS_NAME = "com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory";
    private static final String WS_SSL_OUTBOUND_FAC_CLASS_NAME = "com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory";
    private static final String SSL_OUTBOUND_FAC_CLASS_NAME = "com.ibm.ws.ssl.channel.impl.SSLChannelFactory";
    private static final String ZAIO_LOCAL_FACTORY_CLASS_NAME = "com.ibm.ws.tcp.channel.impl.ZAioTCPChannelLocalFactory";
    private static final String TCP_OUTBOUND_NAME = "TCPOutboundChannel_ipcc";
    private static final String SSL_OUTBOUND_NAME = "SSLOutboundChannel_ipcc";
    private static final String APP_OUTBOUND_NAME = "IPCCOutboundChannel";
    private static final String OUTBOUND_CHAIN_NAME = "IPCCOutboundChain";
    private static final String OUTBOUND_GROUP_NAME = "IPCCOutboundGroup";
    private static final String LC_ZAIO_OUTBOUND_NAME = "LC_ZAioOutboundChannel";
    private static final String LC_APP_OUTBOUND_NAME = "LC_IPCCOutboundChannel";
    private static final String LC_OUTBOUND_CHAIN_NAME = "LC_IPCCOutboundChain";
    private static HashMap poolMgrs = new HashMap();
    private ChannelFramework _framework;
    private VirtualConnectionFactory _vcf;
    private VirtualConnectionFactory _lc_vcf;
    private HashMap allPools = new HashMap();
    private int timeoutInSec = 300;
    private long timeToExpiration = 300L;
    private Alarm currentAlarm;

    public static ConnectionPoolMgr getInstance(boolean secEnabled) {
        ConnectionPoolMgr inst = (ConnectionPoolMgr)poolMgrs.get(String.valueOf(secEnabled));
        if (inst == null) {
            inst = new ConnectionPoolMgr(secEnabled);
            poolMgrs.put(String.valueOf(secEnabled), inst);
        }
        return inst;
    }

    private ConnectionPoolMgr(boolean secEnabled) {
        String chainName_lc;
        String tcpChannelName_lc;
        String ipcChannelName_lc;
        String groupName;
        String chainName;
        String tcpChannelName;
        String ipcChannelName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConnectionPoolMgr<init>, secEnabled=" + secEnabled);
        }
        boolean isInternal = SecurityContext.isServerProcess();
        PlatformHelper helper = PlatformHelperFactory.getPlatformHelper();
        if (isInternal) {
            try {
                this._framework = (ChannelFrameworkService)WsServiceRegistry.getService((Object)this, ChannelFrameworkService.class);
            }
            catch (Throwable t) {
                throw new RuntimeException("Fatal error getting ChannelFrameworkService: " + t);
            }
        } else {
            this._framework = new ChannelFrameworkImpl();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ChannelFramework instance found or created");
        }
        Thread currentThd = Thread.currentThread();
        ClassLoader originalLoader = currentThd.getContextClassLoader();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Context classloader in outbound: " + originalLoader);
        }
        String sslChannelName = SSL_OUTBOUND_NAME;
        if (secEnabled) {
            ipcChannelName = "IPCCOutboundChannelSecured";
            tcpChannelName = "TCPOutboundChannel_ipccSecured";
            chainName = "IPCCOutboundChainSecured";
            groupName = "IPCCOutboundGroupSecured";
            ipcChannelName_lc = "LC_IPCCOutboundChannelSecured";
            tcpChannelName_lc = "LC_ZAioOutboundChannelSecured";
            chainName_lc = "LC_IPCCOutboundChainSecured";
        } else {
            ipcChannelName = APP_OUTBOUND_NAME;
            tcpChannelName = TCP_OUTBOUND_NAME;
            chainName = OUTBOUND_CHAIN_NAME;
            groupName = OUTBOUND_GROUP_NAME;
            ipcChannelName_lc = LC_APP_OUTBOUND_NAME;
            tcpChannelName_lc = LC_ZAIO_OUTBOUND_NAME;
            chainName_lc = LC_OUTBOUND_CHAIN_NAME;
        }
        int weight = 1;
        String[] chain = null;
        String[] group = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating ordinary TCP channel chain...");
            }
            this._framework.addChannel(ipcChannelName, APP_OUTBOUND_FAC_CLASS, null, weight);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Outbound channel added: " + ipcChannelName);
            }
            if (secEnabled) {
                if (isInternal) {
                    this._framework.addChannel(sslChannelName, Class.forName(WS_SSL_OUTBOUND_FAC_CLASS_NAME), null, weight);
                } else {
                    this._framework.addChannel(sslChannelName, Class.forName(SSL_OUTBOUND_FAC_CLASS_NAME), null, weight);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Outbound channel added: " + sslChannelName);
            }
            if (isInternal) {
                this._framework.addChannel(tcpChannelName, Class.forName(WS_TCP_OUTBOUND_FAC_CLASS_NAME), null, weight);
            } else {
                this._framework.addChannel(tcpChannelName, TCP_OUTBOUND_FAC_CLASS, null, weight);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Outbound channel added: " + tcpChannelName);
            }
            chain = secEnabled ? new String[]{ipcChannelName, sslChannelName, tcpChannelName} : new String[]{ipcChannelName, tcpChannelName};
            this._framework.addChain(chainName, FlowType.OUTBOUND, chain);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Outbound chain added: " + chainName);
            }
            group = new String[]{chainName};
            this._framework.addChainGroup(groupName, group);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Outbound group added: " + groupName);
            }
            if (helper.isZOS() && !helper.isServantJvm()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating localcomm channel chain...");
                }
                this._framework.addChannel(ipcChannelName_lc, APP_OUTBOUND_FAC_CLASS, null, weight);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Outbound channel added: " + ipcChannelName_lc);
                }
                this._framework.addChannel(tcpChannelName_lc, Class.forName(ZAIO_LOCAL_FACTORY_CLASS_NAME), null, weight);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Outbound channel added: " + tcpChannelName_lc);
                }
                chain = new String[]{ipcChannelName_lc, tcpChannelName_lc};
                this._framework.addChain(chainName_lc, FlowType.OUTBOUND, chain);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Outbound chain added: " + chainName_lc);
                }
                this._framework.addChainToGroup(groupName, chainName_lc);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In client, _framework:", this._framework);
            }
            this._vcf = this._framework.getOutboundVCFactory(chainName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_vcf obtained from chain " + chainName, this._vcf);
            }
            if (helper.isZOS() && !helper.isServantJvm()) {
                this._lc_vcf = this._framework.getOutboundVCFactory(chainName_lc);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_lc_vcf obtained from chain " + chainName_lc, this._lc_vcf);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal error creating channel chain: " + e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Starting PurgeTimer...");
        }
        this.currentAlarm = AlarmManager.createNonDeferrable((long)(this.timeToExpiration * 1000L), (AlarmListener)new PurgeTimer());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConnectionPoolMgr<init>");
        }
    }

    public ConnectionPool getConnectionPool(String host, String port, String shortName, String genericName, String daemonName) {
        ConnectionPool connPool = (ConnectionPool)this.allPools.get(host + port);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Existing connection pool: " + connPool);
        }
        if (connPool == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating new ChannelConnectionPool");
            }
            connPool = new ChannelConnectionPool(host, port, shortName, genericName, daemonName, this.timeoutInSec, this._vcf, this._lc_vcf);
            this.allPools.put(host + port, connPool);
        }
        return connPool;
    }

    public void setReadTimeout(int timeout) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setReadTimeout to " + timeout);
        }
        this.timeoutInSec = timeout;
    }

    public void setTimeToExpiration(long span) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTimeToExpiration to " + span);
        }
        this.timeToExpiration = span;
    }

    class PurgeTimer
    implements Runnable,
    AlarmListener {
        PurgeTimer() {
        }

        public void alarm(Object obj) {
            block2: {
                try {
                    Thread thd = new Thread(this);
                    thd.setDaemon(true);
                    thd.start();
                }
                catch (Throwable t) {
                    if (!tc.isDebugEnabled()) break block2;
                    Tr.debug(tc, "Error starting new purge thread", t);
                }
            }
            ConnectionPoolMgr.this.currentAlarm = AlarmManager.createNonDeferrable((long)(ConnectionPoolMgr.this.timeToExpiration * 1000L), (AlarmListener)this);
        }

        public void run() {
            Collection pools = ConnectionPoolMgr.this.allPools.values();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PurgeTimer is triggered; there are " + pools.size() + " connection pools to purge");
            }
            for (ConnectionPool connPool : pools) {
                connPool.purgeExpired(ConnectionPoolMgr.this.timeToExpiration);
            }
        }
    }
}

