/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.ipc;

import com.ibm.ws.management.connector.ipc.Constants;
import java.io.IOException;

public class Arrayster {
    private byte[] byteArray;
    private int totalCount;
    private int bufferSize = 8192;
    private byte[] arrayToChop;
    private int originalLength;
    private int segments;
    private int start;
    private int take;
    private int increment;

    public void resetMerge(int count) {
        this.byteArray = null;
        this.totalCount = count;
    }

    public boolean merge(byte[] in, int offset, int len) throws Exception {
        byte[] tmp;
        if (len > in.length) {
            throw new Exception("Given length is greater than the array's length");
        }
        if (this.byteArray == null) {
            tmp = new byte[len];
            System.arraycopy(in, offset, tmp, 0, len);
        } else {
            if (this.byteArray.length + len > this.totalCount) {
                throw new Exception("Incoming byte count exceeded expected value");
            }
            tmp = new byte[this.byteArray.length + len];
            System.arraycopy(this.byteArray, 0, tmp, 0, this.byteArray.length);
            System.arraycopy(in, offset, tmp, this.byteArray.length, len);
        }
        this.byteArray = tmp;
        return this.byteArray.length == this.totalCount;
    }

    public boolean merge(byte[] in) throws Exception {
        return this.merge(in, 0, in.length);
    }

    public byte[] getByteArray() {
        return this.byteArray;
    }

    public byte[] makeHeader(int count) {
        byte[] tmp = new byte[Constants.HEADER_LENGTH];
        System.arraycopy(Constants.HEADER_PREFIX, 0, tmp, 0, Constants.HEADER_LENGTH - 4);
        byte[] tt = Arrayster.intToByteArray(count);
        System.arraycopy(tt, 0, tmp, Constants.HEADER_LENGTH - 4, 4);
        return tmp;
    }

    public int parseHeader(byte[] hdr) throws Exception {
        if (Arrayster.byteArrayToInt(hdr, 0) != Constants.HEADER_PREFIX_AS_INT) {
            throw new IOException("Header is not as expected");
        }
        return Arrayster.byteArrayToInt(hdr, Constants.HEADER_LENGTH - 4);
    }

    public static int byteArrayToInt(byte[] b, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    public static byte[] intToByteArray(int value) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
        }
        return b;
    }

    public void setBufferSize(int inc) {
        if (inc >= 1024) {
            this.bufferSize = inc;
        }
    }

    public void chop(byte[] in) {
        this.arrayToChop = in;
        this.originalLength = in.length;
        if (this.originalLength <= this.bufferSize) {
            this.increment = this.originalLength;
            this.segments = 1;
        } else {
            this.increment = this.bufferSize;
            this.segments = this.originalLength / this.increment + 1;
        }
        this.start = 0;
        this.take = 1;
    }

    public byte[] next() throws Exception {
        byte[] tmp;
        if (this.take > this.segments) {
            this.resetChop();
            return null;
        }
        if (this.arrayToChop == null) {
            throw new Exception("No byte array in place to be chopped");
        }
        if (this.take == this.segments) {
            tmp = new byte[this.increment];
            System.arraycopy(this.arrayToChop, this.start, tmp, 0, this.increment);
        } else if (this.take == this.segments - 1) {
            this.increment = (this.originalLength - this.start) / 2;
            tmp = new byte[this.increment];
            System.arraycopy(this.arrayToChop, this.start, tmp, 0, this.increment);
            this.start += this.increment;
            this.increment = this.originalLength - this.start;
        } else {
            tmp = new byte[this.increment];
            System.arraycopy(this.arrayToChop, this.start, tmp, 0, this.increment);
            this.start += this.increment;
        }
        ++this.take;
        return tmp;
    }

    public void resetChop() {
        this.take = 0;
        this.segments = 0;
        this.arrayToChop = null;
    }
}

