/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.interop;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.management.util.UtilsClient;
import java.util.Vector;
import org.apache.soap.Header;
import org.apache.soap.rpc.RPCMessage;
import org.apache.soap.util.xml.QName;

public class JMXVersionValidation {
    private static TraceComponent tc = Tr.register(JMXVersionValidation.class, "Admin", "com.ibm.ws.management.connector");
    public static final String jmxVersion = "1.2.0";
    public static final String oldJmxVersion = "1.0.0";
    private static ThreadLocal clientVersion = new ThreadLocal();

    public static void setClientVersion(String version) {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "setClientVersion to " + version);
        }
        if (version == null) {
            version = "5";
        }
        clientVersion.set(version);
    }

    public String getClientVersion() {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getClientVersion: " + clientVersion.get());
        }
        return (String)clientVersion.get();
    }

    public static Header getJmxVersionHeader(Header h, String messageVersion) {
        Header header = h;
        if (header == null) {
            header = new Header();
        }
        header.setAttribute(new QName("admin", "JMXVersion"), jmxVersion);
        if (messageVersion != null) {
            header.setAttribute(new QName("admin", "JMXMessageVersion"), messageVersion);
        }
        String productVersion = null;
        try {
            productVersion = UtilsClient.getProductVersion();
        }
        catch (Exception e) {
            productVersion = "6.0.0.0";
        }
        if (productVersion != null) {
            header.setAttribute(new QName("admin", "WASRemoteRuntimeVersion"), productVersion);
        }
        if (header.getHeaderEntries() == null) {
            header.setHeaderEntries(new Vector());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getJmxVersionHeader, result:", header);
        }
        return header;
    }

    public static String getLocalWASVersion() {
        String version = null;
        String localCell = null;
        String localNode = null;
        String localProcess = null;
        String localVersion = null;
        if (version == null) {
            localProcess = "client";
            localCell = System.getProperty("local.cell");
            localNode = System.getProperty("local.node");
            AdminService as = AdminServiceFactory.getAdminService();
            if (as != null) {
                localProcess = AdminServiceFactory.getAdminService().getProcessName();
                localCell = AdminServiceFactory.getAdminService().getCellName();
                localNode = AdminServiceFactory.getAdminService().getNodeName();
            }
            try {
                localVersion = UtilsClient.getProductVersion();
            }
            catch (NullPointerException e) {
                localVersion = "6.0.0.0";
            }
            version = new String(localCell + ":" + localNode + ":" + localProcess + ":" + localVersion);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLocalVersion, result=" + version);
        }
        return version;
    }

    public static String getRemoteVersion(RPCMessage message) {
        Header header = null;
        if (message != null) {
            header = message.getHeader();
        }
        return JMXVersionValidation.getRemoteVersion(header);
    }

    public static String getRemoteVersion(Header header) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getRemoteVersion from header:", header);
        }
        String remoteJmxVersion = oldJmxVersion;
        if (header != null) {
            remoteJmxVersion = header.getAttribute(new QName("admin", "JMXVersion"));
        }
        if (remoteJmxVersion == null) {
            remoteJmxVersion = oldJmxVersion;
        }
        return remoteJmxVersion;
    }

    public static boolean isRemoteVersionTmx4j(String version) {
        boolean tmx4jRemote = false;
        if (version == null) {
            version = oldJmxVersion;
        }
        if (version != null && jmxVersion.compareTo(version) > 0) {
            tmx4jRemote = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isRemoteVersionTmx4j(" + version + ")? " + tmx4jRemote);
        }
        return tmx4jRemote;
    }
}

