/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice.configdiff;

import java.util.StringTokenizer;

class Version
implements Comparable {
    private int[] version;

    protected Version(String ver) {
        StringTokenizer tokenizer = new StringTokenizer(ver, ".");
        this.version = new int[tokenizer.countTokens()];
        for (int i = 0; i < this.version.length; ++i) {
            String token = tokenizer.nextToken();
            this.version[i] = Integer.parseInt(token);
        }
    }

    protected Version(Version ver) {
        this.version = ver.getComponents();
    }

    protected int length() {
        return this.version.length;
    }

    protected int getComponent(int i) throws Exception {
        return this.version[i];
    }

    protected int[] getComponents() {
        return this.version;
    }

    protected void setComponent(int i, int val) throws Exception {
        this.version[i] = val;
    }

    public int compareTo(Object other) {
        if (other instanceof Version) {
            int j;
            int mylen = this.version.length;
            Version ver = (Version)other;
            int[] otherVer = ver.getComponents();
            int otherlen = otherVer.length;
            boolean longer = mylen < otherlen;
            int minLen = longer ? mylen : otherlen;
            int diff = longer ? mylen - otherlen : otherlen - mylen;
            int i = 0;
            for (i = 0; i < minLen; ++i) {
                int firstVal = this.version[i];
                int secondVal = otherVer[i];
                if (firstVal < secondVal) {
                    return -1;
                }
                if (firstVal <= secondVal) continue;
                return 1;
            }
            boolean trail = false;
            if (longer) {
                for (j = i + 1; j < mylen; ++j) {
                    trail &= this.version[j] != 0;
                }
                if (trail) {
                    return 1;
                }
            } else {
                for (j = i + 1; j < otherlen; ++j) {
                    trail &= otherVer[j] != 0;
                }
                if (trail) {
                    return -1;
                }
            }
            return 0;
        }
        throw new ClassCastException("Object " + other + " is not of type Version");
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.version.length; ++i) {
            if (i > 0) {
                s = s + ".";
            }
            s = s + this.version[i];
        }
        return s;
    }
}

