/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SSLConfigDelegator
extends ConfigServiceDelegator {
    private static TraceComponent tc = Tr.register(SSLConfigDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public SSLConfigDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService);
    }

    public String getType() {
        return "SSLConfig";
    }

    public ObjectName createConfigData(Session session, ObjectName parent, String attributeName, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLConfigDelegator-createConfigData");
        }
        ConfigDataId parentId = ConfigServiceHelper.getConfigDataId(parent);
        DocAccessor accessor = WorkspaceHelper.getDocAccessor(session, parentId);
        boolean keyFileFound = false;
        boolean trustFileFound = false;
        boolean found = false;
        for (int i = 0; i < attrList.size(); ++i) {
            Attribute a;
            if (found) {
                --i;
                found = false;
            }
            if ("keyFileFormat".equals((a = (Attribute)attrList.get(i)).getName()) && "JCE4758RACFKS".equals(a.getValue())) {
                attrList.remove(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JCE4758RACFKS removed from SecureSocketLayer Attribute List");
                }
                keyFileFound = true;
                found = true;
            }
            if (!"trustFileFormat".equals(a.getName()) || !"JCE4758RACFKS".equals(a.getValue())) continue;
            attrList.remove(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JCE4758RACFKS removed from SecureSocketLayer Attribute List");
            }
            trustFileFound = true;
            found = true;
        }
        ObjectName result = null;
        try {
            try {
                ObjectName p;
                result = accessor.createConfigData(session, parentId, attributeName, attrList, false);
                AttributeList aList = new AttributeList();
                if (keyFileFound) {
                    ConfigServiceHelper.setAttributeValue(aList, "name", "com.ibm.ssl.keyStoreType");
                    ConfigServiceHelper.setAttributeValue(aList, "value", "JCE4758RACFKS");
                    p = this.baseConfigService.createConfigData(session, result, "properties", "Property", aList);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New property created for JCE4758RACFKS-keyStore");
                    }
                }
                if (trustFileFound) {
                    ConfigServiceHelper.setAttributeValue(aList, "name", "com.ibm.ssl.trustStoreType");
                    ConfigServiceHelper.setAttributeValue(aList, "value", "JCE4758RACFKS");
                    p = this.baseConfigService.createConfigData(session, result, "properties", "Property", aList);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New property created for JCE4758RACFKS-trustStore");
                    }
                }
                accessor.localSave();
            }
            catch (Exception ex) {
                throw new ConfigServiceException(ex, "unexpected exception trying to create new repertoire custom property during object creation");
            }
            Object var14_15 = null;
            accessor.cleanup();
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            accessor.cleanup();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exit SSLConfigDelegator-createConfigData" + result);
        }
        return result;
    }
}

