/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigDocumentLoadException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeValException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.RequiredAttributeNotFoundException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.authzgroup.AuthzGroupUtil;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class RootObjectDelegator
extends ConfigObjectDelegator {
    private static TraceComponent tc = Tr.register(RootObjectDelegator.class, "management", "com.ibm.ws.management.resources.configservice");
    private String type;
    private List types;
    private RepositoryDocumentType documentType;
    private RepositoryContextType contextType = null;
    private boolean isRootDocumentType;

    public RootObjectDelegator(ConfigServiceImpl baseConfigService, RepositoryContextType contextType) {
        this(baseConfigService, contextType.getRootDocumentType().getRootRefObjectTypes()[0], contextType.getRootDocumentType());
        this.isRootDocumentType = true;
        this.contextType = contextType;
    }

    public RootObjectDelegator(ConfigServiceImpl baseConfigService, String type, RepositoryDocumentType documentType) {
        super(baseConfigService);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RootObjectDelegator", new Object[]{baseConfigService, type, documentType});
        }
        this.type = type;
        String[] allTypeArr = null;
        try {
            allTypeArr = TypeRegistry.getSubTypes(type);
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<String> allTypes = new ArrayList<String>();
        for (int i = 0; allTypeArr != null && i < allTypeArr.length; ++i) {
            allTypes.add(allTypeArr[i]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "all types ");
        }
        allTypes.add(type);
        for (String tt : allTypes) {
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "type ", tt);
        }
        if (allTypeArr != null && allTypeArr.length > 0) {
            this.types = allTypes;
        }
        this.documentType = documentType;
        this.isRootDocumentType = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RootObjectDelegator");
        }
    }

    public List getTypes() {
        return this.types;
    }

    public void setTypes(List inTypes) {
        this.types = inTypes;
    }

    public String getType() {
        return this.type;
    }

    public String getFileName() {
        return this.documentType.getFilePattern();
    }

    public boolean isRootDocumentType() {
        return this.isRootDocumentType;
    }

    public ObjectName[] getAll(Session session, ObjectName scope, String name) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAll", new Object[]{session, scope, name});
        }
        if (!this.isRootDocumentType() || name == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAll");
            }
            return this.getAll(session, scope);
        }
        Collection rootContexts = WorkspaceHelper.getScopeContexts(session, scope);
        ArrayList<ObjectName> matches = new ArrayList<ObjectName>();
        for (RepositoryContext context : rootContexts) {
            if (context.getType().equals(this.contextType) && name.equals(context.getName())) {
                ObjectName selected = this.createObjectName(context);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "selected", selected);
                }
                matches.add(selected);
                continue;
            }
            try {
                Collection found = context.findContext(this.contextType.getName(), name);
                if (found == null) continue;
                for (RepositoryContext matchCxt : found) {
                    ObjectName selected = this.createObjectName(matchCxt);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "selected", selected);
                    }
                    matches.add(selected);
                }
            }
            catch (WorkSpaceException ex) {
                throw new ConfigServiceException(ex);
            }
        }
        ObjectName[] result = new ObjectName[matches.size()];
        matches.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAll", result);
        }
        return result;
    }

    public ObjectName[] getAll(Session session, ObjectName scope) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAll", scope);
        }
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        Collection rootContexts = WorkspaceHelper.getScopeContexts(session, scope);
        for (RepositoryContext context : rootContexts) {
            if (this.isRootDocumentType) {
                this.findAllMyTypeChildrenContext(context, result);
                continue;
            }
            List docs = this.getTypedDocuments(context, this.getFileName());
            Iterator iter = docs.iterator();
            while (iter.hasNext()) {
                try {
                    WorkSpaceFile file = (WorkSpaceFile)iter.next();
                    DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, file);
                    ObjectName[] roots = docAccessor.getRootObjects(session);
                    for (int j = 0; roots != null && j < roots.length; ++j) {
                        if (!this.getType().equals(ConfigServiceHelper.getConfigDataType(roots[j]))) continue;
                        result.add(roots[j]);
                    }
                }
                catch (ConfigDocumentLoadException ex) {
                    Tr.error(tc, "ADMG0003E", ex);
                }
            }
        }
        ObjectName[] arrayResult = new ObjectName[result.size()];
        result.toArray(arrayResult);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAll", arrayResult);
        }
        return arrayResult;
    }

    public void deleteConfigData(Session session, ObjectName configData) throws ConfigServiceException {
        block11: {
            String type;
            ConfigDataId id;
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "deleteConfigData", new Object[]{session, configData});
                }
                id = ConfigServiceHelper.getConfigDataId(configData);
                type = null;
                try {
                    type = ConfigServiceHelper.getConfigDataType(configData);
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Exception ", e.getMessage());
                }
            }
            RepositoryContext context = WorkspaceHelper.getContext(session, id);
            if (this.isRootDocumentType) {
                try {
                    context.delete(true);
                }
                catch (WorkSpaceException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.RootObjectDelegator.deleteConfigData", (String)"100", (Object)this);
                    throw new ConfigServiceException(ex, ex.getMessage());
                }
            } else {
                this.baseConfigService.deleteConfigDataBasic(session, configData);
            }
            try {
                String resName = id.toString();
                this.notifyAuthzGroup(this.baseConfigService, session, resName, type);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Exception ", e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    protected ObjectName getParent(Session session, ObjectName kid) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParent", kid);
        }
        ConfigDataId id = ConfigServiceHelper.getConfigDataId(kid);
        RepositoryContext context = WorkspaceHelper.getContext(session, id);
        ObjectName result = this.isRootDocumentType ? this.createObjectName(context.getParent()) : this.createObjectName(context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParent", result);
        }
        return result;
    }

    protected ObjectName[] getChildren(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildren", new Object[]{parent, relationshipInfo});
        }
        ArrayList<ObjectName> children = new ArrayList<ObjectName>();
        ConfigDataId parentId = ConfigServiceHelper.getConfigDataId(parent);
        RepositoryContext context = WorkspaceHelper.getContext(session, parentId);
        if (this.isRootDocumentType) {
            List childrenContext = context.getChildren();
            for (RepositoryContext childContext : childrenContext) {
                RepositoryDocumentType rootDocType;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "childContext", childContext.getName());
                }
                if ((rootDocType = childContext.getType().getRootDocumentType()) == null || !rootDocType.equals(this.documentType)) continue;
                children.add(this.createObjectName(childContext));
            }
        } else if (context.isAvailable(this.documentType.getFilePattern())) {
            ConfigDataId id = new ConfigDataId(context.getURI(), this.documentType.getFilePattern());
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, id);
            try {
                ObjectName[] roots = docAccessor.getRootObjects(session);
                for (int j = 0; roots != null && j < roots.length; ++j) {
                    if (!ConfigServiceHelper.getConfigDataType(roots[j]).equals(this.getType())) continue;
                    children.add(roots[j]);
                }
            }
            catch (ConfigDataNotFoundException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.RootObjectDelegator.getChildren", (String)"152", (Object)this);
            }
        }
        ObjectName[] result = new ObjectName[children.size()];
        children.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildren", result);
        }
        return result;
    }

    protected String getName(AttributeList attrList) throws InvalidAttributeValException {
        String name;
        try {
            name = ConfigServiceHelper.getAttributeValue(attrList, "name").toString();
            if (!ConfigServiceHelper.checkIfNameValid(name)) {
                throw new InvalidAttributeValException(name);
            }
        }
        catch (AttributeNotFoundException ex) {
            name = null;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected ObjectName createConfigObject(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo, AttributeList attrList) throws ConfigServiceException {
        block26: {
            if (RootObjectDelegator.tc.isEntryEnabled()) {
                Tr.entry(RootObjectDelegator.tc, "createConfigObject", new Object[]{session, parent});
            }
            name = this.getName(attrList);
            parentId = ConfigServiceHelper.getConfigDataId(parent);
            context = WorkspaceHelper.getContext(session, parentId);
            newContext = null;
            result = null;
            if (this.isRootDocumentType) {
                try {
                    if (name == null || name.length() == 0) {
                        throw new RequiredAttributeNotFoundException("name");
                    }
                    template = this.getTemplate(session, attrList);
                    if (RootObjectDelegator.tc.isDebugEnabled()) {
                        Tr.debug(RootObjectDelegator.tc, "template", template);
                    }
                    templateSession = null;
                    if (template != null) {
                        templateSession = WorkspaceHelper.getConfigSession(template);
                    }
                    if (templateSession == null) {
                        templateSession = session;
                    }
                    templateWS = WorkspaceHelper.getWorkspace(templateSession);
                    templateMan = TemplateManagerFactory.getManager((WorkSpace)templateWS);
                    templateContext = null;
                    if (template != null) {
                        templateContext = WorkspaceHelper.getContext(templateWS, ConfigServiceHelper.getConfigDataId(template));
                    }
                    if (templateContext == null) {
                        context = newContext = context.create(this.contextType, name);
                    } else {
                        t = templateMan.getTemplate(templateContext);
                        context = newContext = templateMan.createContext(context, name, t, new HashMap<K, V>(0));
                        context.delete(this.documentType.getFilePattern());
                    }
                    if (RootObjectDelegator.tc.isDebugEnabled()) {
                        Tr.debug(RootObjectDelegator.tc, "context", context);
                    }
                }
                catch (WorkSpaceException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.RootObjectDelegator.createConfigObject", (String)"182", (Object)this);
                    throw new ConfigServiceException(ex, ex.getMessage());
                }
            }
            id = new ConfigDataId(context.getURI(), this.documentType.getFilePattern());
            docAccessor = WorkspaceHelper.getDocAccessor(session, id);
            success = false;
            try {
                result = docAccessor.createRootConfigObject(session, this.getType(), attrList);
                docAccessor.localSave();
                success = true;
                var17_19 = null;
                docAccessor.cleanup();
                ** if (success || newContext == null) goto lbl-1000
            }
            catch (Throwable var16_25) {
                block27: {
                    var17_21 = null;
                    docAccessor.cleanup();
                    if (!success && newContext != null) {
                        try {
                            newContext.delete(true);
                        }
                        catch (Exception ex) {
                            if (!RootObjectDelegator.tc.isDebugEnabled()) break block27;
                            Tr.debug(RootObjectDelegator.tc, "unable to delete the context", ex);
                        }
                    }
                }
                throw var16_25;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    newContext.delete(true);
                }
                catch (Exception ex) {
                    if (RootObjectDelegator.tc.isDebugEnabled()) {
                        Tr.debug(RootObjectDelegator.tc, "unable to delete the context", ex);
                    }
                }
            }
lbl-1000:
            // 4 sources

            {
                break block26;
                catch (InvalidConfigDataTypeException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.RootObjectDelegator.createConfigObject", (String)"194", (Object)this);
                    Tr.error(RootObjectDelegator.tc, "ADMG0011E", ex);
                    var17_20 = null;
                    docAccessor.cleanup();
                    if (!success && newContext != null) {
                        try {
                            newContext.delete(true);
                        }
                        catch (Exception ex) {
                            if (RootObjectDelegator.tc.isDebugEnabled()) {
                                Tr.debug(RootObjectDelegator.tc, "unable to delete the context", ex);
                            }
                        }
                    }
                }
            }
        }
        if (RootObjectDelegator.tc.isEntryEnabled()) {
            Tr.exit(RootObjectDelegator.tc, "createConfigObject", result);
        }
        return result;
    }

    protected ObjectName getTemplate(Session session, AttributeList attrList) throws ConfigServiceException {
        ObjectName template = null;
        try {
            try {
                template = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Template");
            }
            catch (AttributeNotFoundException ex) {
                ObjectName scope;
                ObjectName[] templates;
                WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
                TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)workspace);
                RepositoryContext defaultTemplate = templateMan.getRootTemplateContext().findContext("default");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "defaultTemplate", defaultTemplate);
                }
                if ((templates = this.baseConfigService.getAllBasic(session, scope = MOFUtil.createObjectName(defaultTemplate), this.getType(), true)).length > 0) {
                    template = templates[0];
                }
            }
        }
        catch (WorkSpaceException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.RootObjectDelegator.createConfigObject", (String)"268", (Object)this);
            throw new ConfigServiceException(ex, ex.getMessage());
        }
        return template;
    }

    protected void setDocumentType(RepositoryDocumentType documentType) {
        this.documentType = documentType;
    }

    private void findAllMyTypeChildrenContext(RepositoryContext scope, List matches) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findAllMyTypeChildrenContext", scope);
        }
        if (scope.getType().getName().equals(this.contextType.getName())) {
            matches.add(this.createObjectName(scope));
        } else {
            List children = scope.getChildren();
            for (RepositoryContext child : children) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "child", child);
                }
                if (child.getType().getName().equals(this.contextType.getName())) {
                    ObjectName selected = this.createObjectName(child);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "selected", selected);
                    }
                    matches.add(selected);
                    continue;
                }
                this.findAllMyTypeChildrenContext(child, matches);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAllMyTypeChildrenContext", matches);
        }
    }

    private void notifyAuthzGroup(ConfigService cs, Session session, String res, String type) throws Exception {
        final ConfigService csFinal = cs;
        final Session sessionFinal = session;
        final String resFinal = res;
        final String typeFinal = type;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthzGroupUtil.removeResourceFromAuthorizationGroup(csFinal, sessionFinal, resFinal, typeFinal);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
    }
}

