/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.RequiredAttributeNotFoundException;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.CSMetadataMgr;
import com.ibm.ws.management.configservice.MetadataFilter;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.csmetadata.ConfigServiceMetadata;
import com.ibm.ws.management.configservice.csmetadata.CsmetadataFactory;
import com.ibm.ws.management.configservice.csmetadata.CsmetadataPackage;
import com.ibm.ws.management.configservice.csmetadata.EMFAttribute;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class RequiredAttributesRegistry
extends DefaultHandler {
    static final List newReqAttrs = Arrays.asList("ActivitySessionService.defaultTimeout", "WorkAreaService.maxReceiveSize", "WorkAreaService.maxSendSize", "WorkAreaPartition.maxReceiveSize", "WorkAreaPartition.maxSendSize", "TimerManagerInfo.jndiName", "TimerManagerInfo.numAlarmThreads", "WorkManagerInfo.maxThreads", "WorkManagerInfo.minThreads", "WorkManagerInfo.threadPriority", "WorkManagerInfo.jndiName", "WorkManagerInfo.numAlarmThreads", "SchedulerConfiguration.workManagers", "SchedulerConfiguration.pollInterval", "SchedulerConfiguration.tablePrefix", "SchedulerConfiguration.jndiName", "SchedulerConfiguration.datasourceJNDIName", "ObjectPool.poolImplClassName", "ObjectPool.poolClassName", "ObjectPoolManagerInfo.jndiName", "CacheInstance.cacheSize", "CacheInstance.defaultPriority", "CacheInstance.enableDiskOffload", "CacheInstance.jndiName");
    private static TraceComponent tc = Tr.register(RequiredAttributesRegistry.class, "management", "com.ibm.ws.management.resources.configservice");
    private static RequiredAttributesRegistry instance = null;
    private XMLReader parser;
    private Stack context = new Stack();
    private Hashtable requiredAttrsTable = new Hashtable();

    public RequiredAttributesRegistry() throws Exception {
        this.parser = XMLReaderFactory.createXMLReader();
        this.parser.setEntityResolver(this);
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
    }

    private void generate(String[] args) throws Exception {
        this.parseValidationFile(args[0]);
        this.dump(args[1]);
    }

    public static void main(String[] args) {
        try {
            String spec = System.getProperty("trace");
            Object traceOutput = null;
            ManagerAdmin.configureClientTrace(spec, "stdout", null, true, null, false);
            ModelMgr.initialize((String)"ws-server");
            instance.generate(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseValidationFile(String validationFile) throws Exception {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "parseValidationFile", validationFile);
            }
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(validationFile);
                    InputSource source = new InputSource(in);
                    this.parser.parse(source);
                    source.setSystemId(validationFile);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.RequiredAttributesRegistry.parseValidationFile", (String)"164");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exception", ex);
                    }
                    Object var5_6 = null;
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    break block9;
                }
                Object var5_5 = null;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (in != null) {
                    ((InputStream)in).close();
                }
                throw throwable;
            }
            ((InputStream)in).close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseValidationFile");
        }
    }

    public static Set getRequiredAttributes(String type) {
        HashSet<String> reqAttrs = (HashSet<String>)RequiredAttributesRegistry.instance.requiredAttrsTable.get(type);
        EClass metaObj = null;
        try {
            metaObj = TypeRegistry.getMetaObject(type);
        }
        catch (InvalidConfigDataTypeException ex) {
            return null;
        }
        EList superTypes = metaObj.getEAllSuperTypes();
        for (EClass superType : superTypes) {
            String shortType = TypeRegistry.getTypeShortName(superType);
            Set thisReqAttrs = (Set)RequiredAttributesRegistry.instance.requiredAttrsTable.get(shortType);
            if (thisReqAttrs == null) continue;
            if (reqAttrs == null) {
                reqAttrs = new HashSet<String>(thisReqAttrs);
                continue;
            }
            for (String reqAttr : thisReqAttrs) {
                if (reqAttrs.contains(reqAttr)) continue;
                reqAttrs.add(reqAttr);
            }
        }
        return reqAttrs;
    }

    public static void checkRequiredAttributes(EObject refObj) throws RequiredAttributeNotFoundException {
        RequiredAttributesRegistry.checkRequiredAttributes(refObj, null);
    }

    public static void checkRequiredAttributes(EObject refObj, Properties nodeProps) throws RequiredAttributeNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "haveAllRequiredAttributes", refObj);
        }
        RequiredAttributesRegistry.checkRequiredAttributesBasic(refObj, nodeProps);
        TreeIterator iter = refObj.eAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            RequiredAttributesRegistry.checkRequiredAttributesBasic(obj, nodeProps);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "haveAllRequiredAttributes");
        }
    }

    private static void checkRequiredAttributesBasic(EObject refObj, Properties nodeProps) throws RequiredAttributeNotFoundException {
        EClass metaObj;
        String type;
        Set reqAttributes;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRequiredAttributesBasic", refObj);
        }
        if ((reqAttributes = RequiredAttributesRegistry.getRequiredAttributes(type = TypeRegistry.getTypeShortName(metaObj = refObj.eClass()))) != null) {
            for (String attrName : reqAttributes) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrName", attrName);
                }
                try {
                    EStructuralFeature efeature = metaObj.getEStructuralFeature(attrName);
                    if (efeature == null || refObj.eGet(efeature) != null) continue;
                    String attr = type + '.' + attrName;
                    if (newReqAttrs.contains(attr)) {
                        Tr.warning(tc, "ADMG0020E", new Object[]{attr});
                        continue;
                    }
                    if (!RequiredAttributesRegistry.isAttrRequiredForNode(efeature, nodeProps)) continue;
                    throw new RequiredAttributeNotFoundException(attr);
                }
                catch (RequiredAttributeNotFoundException re) {
                    throw re;
                }
                catch (Exception ex) {
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRequiredAttributesBasic");
        }
    }

    private void addRequiredAttribute(String type, String attr) {
        HashSet<String> requiredAttrs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRequiredAttribute", new Object[]{type, attr});
        }
        if ((requiredAttrs = (HashSet<String>)this.requiredAttrsTable.get(type)) == null) {
            requiredAttrs = new HashSet<String>(5);
            this.requiredAttrsTable.put(type, requiredAttrs);
        }
        requiredAttrs.add(attr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRequiredAttribute");
        }
    }

    private void dump(String metadatafile) {
        CsmetadataPackage pkg = CsmetadataPackage.eINSTANCE;
        try {
            XMLResourceImpl s = new XMLResourceImpl();
            XMLMapImpl xmlMap = new XMLMapImpl();
            HashMap<String, XMLMapImpl> options = new HashMap<String, XMLMapImpl>(1);
            options.put("XML_MAP", xmlMap);
            s.setURI(URI.createURI(metadatafile));
            EList content = s.getContents();
            ConfigServiceMetadata root = CsmetadataFactory.eINSTANCE.createConfigServiceMetadata();
            content.add(root);
            Set entries = this.requiredAttrsTable.entrySet();
            EList reqAttrs = root.getRequiredAttributes();
            for (Map.Entry entry : entries) {
                String type = (String)entry.getKey();
                try {
                    Iterator iter2 = ((Set)entry.getValue()).iterator();
                    while (iter2.hasNext()) {
                        EMFAttribute emfAttribute = CsmetadataFactory.eINSTANCE.createEMFAttribute();
                        emfAttribute.setTypeName(TypeRegistry.getFullyQualifiedType(type));
                        String attr = (String)iter2.next();
                        emfAttribute.setAttrName(attr);
                        reqAttrs.add(emfAttribute);
                    }
                }
                catch (InvalidConfigDataTypeException ex) {
                    ex.printStackTrace();
                }
            }
            FileOutputStream outs = new FileOutputStream(metadatafile);
            s.save(outs, options);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Object parseForm(Attributes attrs) throws SAXException {
        String result;
        int index;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseForm", attrs);
        }
        String val = attrs.getValue("name");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "val", val);
        }
        result = (index = (result = val.substring(val.lastIndexOf(46) + 1)).lastIndexOf("DetailForm")) == -1 ? null : result.substring(0, index).trim();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseForm", result);
        }
        return result;
    }

    private Object parseField(Attributes attrs) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseField", attrs);
        }
        String val = attrs.getValue("depends");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "val", val);
        }
        StringTokenizer tokenizer = new StringTokenizer(val, ",");
        String result = null;
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.trim().equals("required")) {
                result = attrs.getValue("property");
                if (this.findFormType() != null) {
                    this.addRequiredAttribute(this.findFormType(), result);
                }
            }
            ++i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseField", result);
        }
        return result;
    }

    private String findFormType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findFormType");
        }
        String result = null;
        int num = 0;
        int i = this.context.size() - 1;
        while (i >= 0) {
            ContextElement e = (ContextElement)this.context.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "e:" + e.getName());
            }
            if (e.getName().equals("form")) {
                result = (String)e.getValue();
                break;
            }
            --i;
            ++num;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findFormType", result);
        }
        return result;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startElement", new Object[]{namespaceURI, localName, qName, attrs});
        }
        Object parseResult = null;
        if (localName.equals("form")) {
            parseResult = this.parseForm(attrs);
        } else if (localName.equals("field")) {
            parseResult = this.parseField(attrs);
        }
        this.context.push(new ContextElement(localName, parseResult));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startElement", localName);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "endElement", localName);
        }
        this.context.pop();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endElement", localName);
        }
    }

    private static boolean isAttrRequiredForNode(EStructuralFeature efeature, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAttrRequiredForNode", efeature + " node props = " + nodeProps);
        }
        boolean result = true;
        try {
            if (nodeProps != null) {
                result = MetadataFilter.isValidAttr(efeature, nodeProps);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAttrRequiredForNode", new Boolean(result));
        }
        return result;
    }

    static {
        try {
            instance = new RequiredAttributesRegistry();
            EList requiredAttrs = CSMetadataMgr.getConfigServiceMetadata().getRequiredAttributes();
            for (int i = 0; i < requiredAttrs.size(); ++i) {
                EMFAttribute attr = (EMFAttribute)requiredAttrs.get(i);
                instance.addRequiredAttribute(TypeRegistry.getShortType(attr.getTypeName()), attr.getAttrName());
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.RequiredAttributesRegistry", (String)"80");
        }
    }

    private class ContextElement {
        private String elementName;
        private Object val;

        public ContextElement(String elementName) {
            this(elementName, null);
        }

        public ContextElement(String elementName, Object val) {
            this.elementName = elementName;
            this.val = val;
        }

        public String getName() {
            return this.elementName;
        }

        public Object getValue() {
            return this.val;
        }
    }
}

