/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.websphere.models.config.coregroup.CoreGroupServer;
import com.ibm.websphere.models.config.coregroup.impl.CoregroupFactoryImpl;
import java.util.ArrayList;
import java.util.Vector;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class NodeAgentConfigHelper {
    private static final String svCGS = "coregroups";
    private static final String svCoreGroupConfigFile = "coregroup.xml";

    private NodeAgentConfigHelper() {
    }

    public static String getNDCoreGroupURI(String cellName, String cgName) {
        String uri = "coregroups/" + cgName + "/" + svCoreGroupConfigFile;
        return uri;
    }

    public static void addNode(CoreGroup nd, CoreGroup base, String nodeName, Vector v) throws Exception {
        if (nd == null) {
            throw new Exception("Null ND core group object provided");
        }
        if (base == null) {
            throw new Exception("Null base core group object provided");
        }
        if (nodeName == null) {
            throw new Exception("Null nodeName object provided");
        }
        CoregroupFactoryImpl factory = new CoregroupFactoryImpl();
        EList targetServers = nd.getCoreGroupServers();
        EList baseServers = base.getCoreGroupServers();
        if (baseServers != null) {
            int numServers = baseServers.size();
            for (int i = 0; i < numServers; ++i) {
                CoreGroupServer baseServer = (CoreGroupServer)baseServers.get(i);
                String serverName = baseServer.getServerName();
                System.out.println("found server " + baseServer.getNodeName() + " " + serverName);
                CoreGroupServer ndServer = factory.createCoreGroupServer();
                ndServer.setNodeName(nodeName);
                ndServer.setServerName(serverName);
                targetServers.add(ndServer);
                v.addElement(serverName);
            }
        }
    }

    public static void addNodeAgentProcess(CoreGroup nd, String nodeName, String naName) throws Exception {
        if (nd == null) {
            throw new Exception("Null ND core group object provided");
        }
        if (nodeName == null) {
            throw new Exception("Null nodeName object provided");
        }
        EList targetServers = nd.getCoreGroupServers();
        CoregroupFactoryImpl factory = new CoregroupFactoryImpl();
        CoreGroupServer ndServer = factory.createCoreGroupServer();
        ndServer.setNodeName(nodeName);
        ndServer.setServerName(naName);
        targetServers.add(ndServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removeNode(ConfigService cs, Session session, String nodeName) throws Exception {
        boolean createdSession = false;
        try {
            if (session == null) {
                session = new Session("removeNodeFromCoreGroups", false);
                createdSession = true;
            }
            ObjectName cgObjectName = ConfigServiceHelper.createObjectName(null, "CoreGroup", null);
            ObjectName[] cgObjNames = cs.queryConfigObjects(session, null, cgObjectName, null);
            for (int i = 0; i < cgObjNames.length; ++i) {
                ArrayList cgServers = (ArrayList)cs.getAttribute(session, cgObjNames[i], "coreGroupServers");
                if (cgServers == null) continue;
                int size = cgServers.size();
                for (int j = 0; j < size; ++j) {
                    AttributeList server = (AttributeList)cgServers.get(j);
                    String node = (String)ConfigServiceHelper.getAttributeValue(server, "nodeName");
                    if (!nodeName.equals(node)) continue;
                    ObjectName memberId = ConfigServiceHelper.createObjectName(server);
                    cs.deleteConfigData(session, memberId);
                }
            }
            Object var14_13 = null;
            if (!createdSession) return;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (!createdSession) throw throwable;
            cs.save(session, true);
            throw throwable;
        }
        cs.save(session, true);
    }

    public static void removeNode(CoreGroup nd, String nodeName) throws Exception {
        if (nd == null) {
            throw new Exception("Null ND core groups object provided");
        }
        if (nodeName == null) {
            throw new Exception("Null nodeName object provided");
        }
        EList coreGroupServers = nd.getCoreGroupServers();
        if (coreGroupServers != null) {
            int numServers = coreGroupServers.size();
            for (int i = numServers - 1; i > -1; --i) {
                CoreGroupServer server = (CoreGroupServer)coreGroupServers.get(i);
                if (!nodeName.equals(server.getNodeName())) continue;
                coreGroupServers.remove(i);
            }
        }
    }
}

