/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.SystemAttributes;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.exception.InvalidAttributeValException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.ReadOnlyAttributeException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.loggingservice.ras.ServiceLog;
import com.ibm.websphere.models.config.process.ServerComponent;
import com.ibm.websphere.models.config.rolebasedauthz.GroupExt;
import com.ibm.websphere.models.config.rolebasedauthz.SubjectExt;
import com.ibm.websphere.models.config.rolebasedauthz.UserExt;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import com.ibm.ws.management.configservice.MetadataFilter;
import com.ibm.ws.management.configservice.RequiredAttributesRegistry;
import com.ibm.ws.management.configservice.SpecialAttributeRegistry;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MOFUtil {
    private static TraceComponent tc = Tr.register(MOFUtil.class, "management", "com.ibm.ws.management.resources.configservice");
    private static final Class[] innerConfigObjectTypes = new Class[]{ServerComponent.class, J2EEResourceFactory.class};

    public static EStructuralFeature getAttributeMetaObj(EObject metaObj, String name, boolean relationship) throws InvalidAttributeNameException {
        return MOFUtil.getAttributeMetaObj((EClass)metaObj, name, new Stack(), relationship, null);
    }

    private static EStructuralFeature getAttributeMetaObjNoException(EObject metaObj, String name, boolean relationship) {
        return MOFUtil.getAttributeMetaObjNoException((EClass)metaObj, name, new Stack(), relationship, null);
    }

    public static EStructuralFeature getAttributeMetaObj(EObject metaObj, String name, boolean relationship, Properties nodeProps) throws InvalidAttributeNameException {
        return MOFUtil.getAttributeMetaObj((EClass)metaObj, name, new Stack(), relationship, nodeProps);
    }

    public static EObject newRefObject(RepositoryContext context, EObject metaObj, ObjectName template) throws ConfigServiceException {
        EObject newObj = WorkspaceHelper.getTemplate(context.getWorkSpace(), (EClassifier)metaObj, template);
        if (newObj == null) {
            newObj = MOFUtil.newInstance(metaObj);
        }
        return newObj;
    }

    public static EObject convertToEObject(Session session, ObjectName obj) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToEObject", new Object[]{session, obj});
        }
        ConfigDataId id = ConfigServiceHelper.getConfigDataId(obj);
        DocAccessor accessor = WorkspaceHelper.getDocAccessor(session, id);
        EObject result = accessor.lookup(id);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToEObject", result);
        }
        return result;
    }

    public static EObject newInstance(EObject metaObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newInstance", metaObject);
        }
        EClass eclass = (EClass)metaObject;
        EObject refObject = eclass.getEPackage().getEFactoryInstance().create(eclass);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newInstance", refObject);
        }
        return refObject;
    }

    public static void validateConfigData(EObject metaObject, AttributeList attrList, Properties nodeProps) throws InvalidAttributeNameException, InvalidAttributeValException, ReadOnlyAttributeException {
        Stack attributePathContext = new Stack();
        MOFUtil.validateAttributeList(metaObject, attrList, attrList, attributePathContext, nodeProps);
    }

    public static void setAttributes(RepositoryContext context, EObject refObj, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{context, refObj, attrList});
        }
        Properties nodeProps = MOFUtil.getNodeProperties(context);
        Iterator iter = attrList.iterator();
        while (iter.hasNext()) {
            EStructuralFeature attrFeature;
            String attrName = ((Attribute)iter.next()).getName();
            if (SystemAttributes.isSystemAttribute(attrName) || EndpointConfigHelper.isEndpointAttribute(refObj.eClass(), attrName) || !SpecialAttributeRegistry.isReadOnlyAttribute(attrFeature = MOFUtil.getAttributeMetaObj((EObject)refObj.eClass(), attrName, false, nodeProps))) continue;
            throw new ReadOnlyAttributeException(attrName);
        }
        MOFUtil.validateConfigData(refObj.eClass(), attrList, nodeProps);
        ReferenceHandler handler = new ReferenceHandler();
        MOFUtil.setAttributes(context, refObj, attrList, handler, new Stack());
        handler.update(context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes", null);
        }
    }

    public static void resetAttributes(RepositoryContext context, EObject refObj, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{refObj, attrList});
        }
        Properties nodeProps = MOFUtil.getNodeProperties(refObj);
        MOFUtil.validateConfigData(refObj.eClass(), attrList, nodeProps);
        List attrMetaObjs = MOFUtil.getAllAttributeMetaObjs(refObj.eClass(), nodeProps);
        ArrayList<String> attrNames = new ArrayList<String>();
        for (int i = 0; i < attrList.size(); ++i) {
            Attribute attr = (Attribute)attrList.get(i);
            String attrName = attr.getName();
            attrNames.add(attrName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Attribute names will be reset " + attrNames.toArray().toString());
        }
        for (EStructuralFeature attrFeature : attrMetaObjs) {
            String attrNm = attrFeature.getName();
            if (!attrNames.contains(attrNm)) continue;
            MOFUtil.unsetAttribute(refObj, attrNm);
        }
        MOFUtil.setAttributes(context, refObj, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    public static void unsetAttribute(EObject refObj, String name) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttribute", new Object[]{refObj, name});
        }
        Properties nodeProps = MOFUtil.getNodeProperties(refObj);
        EStructuralFeature attrMetaObj = MOFUtil.getAttributeMetaObj((EObject)refObj.eClass(), name, false, nodeProps);
        if (SpecialAttributeRegistry.isReadOnlyAttribute(attrMetaObj)) {
            throw new ReadOnlyAttributeException(name);
        }
        if (EndpointConfigHelper.isEndpointAttribute(refObj.eClass(), name)) {
            RepositoryContext context = WorkspaceHelper.getContext(refObj.eResource());
            EndpointConfigHelper.setEndpointAttribute(context, refObj.eClass(), name, null, new ReferenceHandler(), new Stack());
        } else if (attrMetaObj.isMany()) {
            List listVal = (List)refObj.eGet(attrMetaObj);
            for (Object val : listVal) {
                if (!(val instanceof EObject)) continue;
                RepositoryContext context = WorkspaceHelper.getContext(refObj.eResource());
                MOFUtil.objectRemoved(context, (EObject)val, new ReferenceHandler(), new Stack());
            }
            ((List)refObj.eGet(attrMetaObj)).clear();
        } else {
            Object val = refObj.eGet(attrMetaObj);
            if (val instanceof EObject) {
                RepositoryContext context = WorkspaceHelper.getContext(refObj.eResource());
                MOFUtil.objectRemoved(context, (EObject)val, new ReferenceHandler(), new Stack());
            }
            refObj.eUnset(attrMetaObj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttribute");
        }
    }

    public static Object addElementAt(RepositoryContext context, EObject obj, String name, Object element, int position, boolean relationship) throws ConfigServiceException {
        Object elementValue;
        ArrayList<Object> val = new ArrayList<Object>(1);
        val.add(element);
        AttributeList rootAttrList = new AttributeList();
        rootAttrList.add(new Attribute(name, val));
        Stack<String> attributePathContext = new Stack<String>();
        Properties nodeProps = MOFUtil.getNodeProperties(context);
        EStructuralFeature attrFeature = MOFUtil.getAttributeMetaObj((EObject)obj.eClass(), name, relationship, nodeProps);
        MOFUtil.validateAttribute(attrFeature, val, rootAttrList, attributePathContext, nodeProps);
        attributePathContext.clear();
        attributePathContext.push(name);
        List currentVal = (List)obj.eGet(attrFeature);
        if (element instanceof ObjectName && !MOFUtil.isComposite(attrFeature)) {
            try {
                ConfigDataId id = ConfigServiceHelper.getConfigDataId((ObjectName)element);
                elementValue = MOFUtil.lookup(context, id, MOFUtil.getAttributePath(attributePathContext));
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.MOFUtil.addElementAt", (String)"183");
                throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext), ex);
            }
        } else if (element instanceof AttributeList && attrFeature instanceof EReference) {
            ReferenceHandler handler = new ReferenceHandler();
            EObject newVal = MOFUtil.createRefObject(context, attrFeature.getEType(), (AttributeList)element, handler, attributePathContext);
            SpecialAttributeRegistry.checkUnique(((EReference)attrFeature).getEReferenceType(), currentVal, newVal);
            elementValue = newVal;
            handler.update(context);
        } else if (attrFeature instanceof EAttribute) {
            elementValue = element;
        } else {
            throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
        }
        if (position < 0 || position >= currentVal.size()) {
            currentVal.add(elementValue);
        } else {
            currentVal.add(position, elementValue);
        }
        if (elementValue instanceof EObject) {
            MOFUtil.objectAdded(context, (EObject)elementValue, new ReferenceHandler(), attributePathContext);
        }
        return elementValue;
    }

    public static void removeElement(RepositoryContext context, EObject obj, String attributeName, Object element) throws ConfigServiceException {
        Object elementValue;
        Properties nodeProps = MOFUtil.getNodeProperties(context);
        EStructuralFeature attrFeature = MOFUtil.getAttributeMetaObj((EObject)obj.eClass(), attributeName, false, nodeProps);
        if (!attrFeature.isMany()) {
            throw new InvalidAttributeValException(new String[]{attributeName});
        }
        if (attrFeature instanceof EReference && element instanceof ObjectName) {
            ConfigDataId id = ConfigServiceHelper.getConfigDataId((ObjectName)element);
            elementValue = MOFUtil.lookup(context, id, new String[]{attributeName});
        } else if (attrFeature instanceof EAttribute) {
            elementValue = element;
        } else {
            throw new InvalidAttributeValException(new String[]{attributeName});
        }
        if (elementValue instanceof EObject && MOFUtil.isComposite(attrFeature)) {
            MOFUtil.deleteEObject((EObject)elementValue);
            MOFUtil.objectRemoved(context, (EObject)elementValue, new ReferenceHandler(), new Stack());
        } else {
            ((List)obj.eGet(attrFeature)).remove(elementValue);
        }
    }

    public static EObject createRefObject(RepositoryContext context, EObject metaObj, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRefObject", new Object[]{context, metaObj, attrList});
        }
        Properties nodeProps = MOFUtil.getNodeProperties(context);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node Properties", nodeProps);
        }
        MOFUtil.validateConfigData(metaObj, attrList, nodeProps);
        ReferenceHandler handler = new ReferenceHandler();
        EObject result = MOFUtil.createRefObject(context, metaObj, attrList, handler, new Stack());
        handler.update(context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRefObject", new Object[]{result});
        }
        return result;
    }

    public static AttributeList getAttributes(EObject refObj, String[] names, boolean recursive) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{refObj, names});
        }
        Properties nodeProps = MOFUtil.getNodeProperties(refObj);
        EClass metaObj = refObj.eClass();
        if (names == null) {
            int i;
            List attrMetaObjs = MOFUtil.getAllAttributeMetaObjs(metaObj, nodeProps);
            List endpointAttrs = EndpointConfigHelper.getEndpointAttributeNames(metaObj);
            names = new String[attrMetaObjs.size() + endpointAttrs.size()];
            for (i = 0; i < attrMetaObjs.size(); ++i) {
                EStructuralFeature attrMetaObj = (EStructuralFeature)attrMetaObjs.get(i);
                names[i] = attrMetaObj.getName();
            }
            Iterator iter = endpointAttrs.iterator();
            while (iter.hasNext()) {
                names[i] = (String)iter.next();
                ++i;
            }
        }
        AttributeList attrList = new AttributeList(names.length);
        for (int i = 0; i < names.length; ++i) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "ADDING ATTRIBUTE: " + names[i]);
                }
                attrList.add(new Attribute(names[i], MOFUtil.getAttribute(refObj, names[i], recursive)));
                continue;
            }
            catch (ConfigServiceException ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught exception", ex);
                }
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.MOFUtil.getAttributes", (String)"271");
                throw ex;
            }
        }
        attrList.add(new Attribute("_Websphere_Config_Data_Id", MOFUtil.createConfigDataId(refObj)));
        attrList.add(new Attribute("_Websphere_Config_Data_Type", TypeRegistry.getTypeShortName(metaObj)));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", attrList);
        }
        return attrList;
    }

    public static Object getAttribute(EObject refObj, String name, boolean recursive) throws ConfigServiceException {
        EClass metaObj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{refObj, name});
        }
        Properties nodeProps = MOFUtil.getNodeProperties(refObj);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node Properties", nodeProps);
        }
        if (EndpointConfigHelper.isEndpointAttribute(metaObj = refObj.eClass(), name)) {
            Object val = EndpointConfigHelper.getEndpointAttribute(refObj, name, recursive);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAttribute", val);
            }
            return val;
        }
        EStructuralFeature attrMetaObj = MOFUtil.getAttributeMetaObj((EObject)metaObj, name, false, nodeProps);
        Serializable result = refObj.eGet(attrMetaObj);
        if (result != null) {
            if (attrMetaObj.isMany()) {
                List attrVal = result;
                ArrayList<Object> listVal = new ArrayList<Object>(attrVal.size());
                if (attrMetaObj instanceof EAttribute) {
                    if (attrMetaObj.getEType() instanceof EEnum) {
                        for (Enumerator lit : attrVal) {
                            String element = lit == null ? null : lit.getName();
                            listVal.add(element);
                        }
                    } else {
                        listVal.addAll(attrVal);
                    }
                } else {
                    for (EObject element : attrVal) {
                        if (!MOFUtil.isValidType(element)) continue;
                        if (recursive && MOFUtil.isComposite(attrMetaObj)) {
                            listVal.add(MOFUtil.getAttributes(element, null, recursive));
                            continue;
                        }
                        listVal.add(MOFUtil.createObjectName(element));
                    }
                }
                result = listVal;
            } else if (attrMetaObj instanceof EReference) {
                if (MOFUtil.isValidType((EObject)((Object)result))) {
                    result = recursive && MOFUtil.isComposite(attrMetaObj) ? MOFUtil.getAttributes((EObject)((Object)result), null, recursive) : MOFUtil.createObjectName((EObject)((Object)result));
                }
            } else if (attrMetaObj.getEType() instanceof EEnum) {
                result = ((Object)result).toString();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", result);
        }
        return result;
    }

    public static void delete(EObject obj) {
        RepositoryContext context = WorkspaceHelper.getContext(obj.eResource());
        MOFUtil.deleteEObject(obj);
        MOFUtil.objectRemoved(context, obj, new ReferenceHandler(), new Stack());
    }

    static void deleteEObject(EObject obj) {
        TreeIterator objIter = obj.eAllContents();
        while (objIter.hasNext()) {
            EObject thisObj = (EObject)objIter.next();
            MOFUtil.clearReferences(thisObj);
        }
        MOFUtil.clearReferences(obj);
        EcoreUtil.remove(obj);
    }

    private static void clearReferences(EObject obj) {
        Resource res = obj.eResource();
        if (res != null) {
            Collection refs = EcoreUtil.UsageCrossReferencer.find(obj, res.getResourceSet());
            for (EStructuralFeature.Setting setting : refs) {
                EStructuralFeature feature = setting.getEStructuralFeature();
                if (feature.isMany()) {
                    EObject referingObj = setting.getEObject();
                    List list = (List)referingObj.eGet(feature);
                    list.remove(obj);
                    continue;
                }
                setting.set(null);
            }
        }
    }

    public static AttributeList getAttributesMetaInfo(EObject metaObj) {
        return MOFUtil.getAttributesMetaInfo(metaObj, null);
    }

    public static AttributeList getAttributesMetaInfo(EObject metaObj, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributesMetaInfo", metaObj);
        }
        AttributeList attrList = new AttributeList();
        List attrMetaObjs = MOFUtil.getAllAttributeMetaObjs((EClass)metaObj, nodeProps);
        for (EStructuralFeature attrMetaObj : attrMetaObjs) {
            attrList.add(new Attribute(attrMetaObj.getName(), MOFUtil.getAttributeMetaInfo(TypeRegistry.getTypeShortName((EClassifier)metaObj), attrMetaObj, nodeProps)));
        }
        EndpointConfigHelper.getAllEndpointMetaInfo((EClass)metaObj, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributesMetaInfo", attrList);
        }
        return attrList;
    }

    public static ObjectName createObjectName(RepositoryContext context) {
        RepositoryDocumentType docType = context.getType().getRootDocumentType();
        String type = null;
        String fileName = null;
        if (docType != null) {
            type = docType.getRootRefObjectTypes()[0];
            fileName = docType.getFilePattern();
        }
        String name = context.getName();
        ConfigDataId id = new ConfigDataId(context.getURI(), fileName);
        return WorkspaceHelper.createObjectName(id, type, name, MOFUtil.getConfigSession(context));
    }

    public static ObjectName createObjectName(EObject refObj) {
        ConfigDataId id = MOFUtil.createConfigDataId(refObj);
        String type = TypeRegistry.getTypeShortName(refObj.eClass());
        String displayName = null;
        EStructuralFeature attrFeature = MOFUtil.getAttributeMetaObjNoException(refObj.eClass(), "name", false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attrFeature", attrFeature);
        }
        if (attrFeature != null) {
            displayName = (String)refObj.eGet(attrFeature);
        }
        if (displayName == null) {
            attrFeature = MOFUtil.getAttributeMetaObjNoException(refObj.eClass(), "memberName", false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrFeature", attrFeature);
            }
            if (attrFeature != null && TypeRegistry.getTypeShortName(attrFeature.getEType()).equals("String") && !attrFeature.isMany()) {
                displayName = (String)refObj.eGet(attrFeature);
            }
        }
        if (displayName == null) {
            attrFeature = MOFUtil.getAttributeMetaObjNoException(refObj.eClass(), "serverName", false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrFeature", attrFeature);
            }
            if (attrFeature != null && TypeRegistry.getTypeShortName(attrFeature.getEType()).equals("String") && !attrFeature.isMany()) {
                displayName = (String)refObj.eGet(attrFeature);
            }
        }
        Session session = MOFUtil.getConfigSession(refObj);
        return WorkspaceHelper.createObjectName(id, type, displayName, session);
    }

    public static ConfigDataId createConfigDataId(EObject refObj) {
        ConfigDataId dataId = null;
        Resource res = refObj.eResource();
        if (res != null) {
            URI uri = res.getURI();
            uri = uri.appendFragment(res.getURIFragment(refObj));
            String href = uri.toString();
            ResourceSet set = res.getResourceSet();
            if (set instanceof ContextResourceSet) {
                String contextUri = WorkspaceHelper.getContext(res).getURI();
                dataId = new ConfigDataId(contextUri, href);
            } else {
                dataId = ConfigDataId.createLocalId(href);
            }
        }
        return dataId;
    }

    static Session getConfigSession(EObject refObj) {
        ResourceSet set;
        Session result = null;
        Resource res = refObj.eResource();
        if (res != null && (set = res.getResourceSet()) instanceof ContextResourceSet) {
            result = MOFUtil.getConfigSession(WorkspaceHelper.getContext(res));
        }
        return result;
    }

    static Session getConfigSession(RepositoryContext context) {
        return new Session(context.getWorkSpace().getUserName(), true);
    }

    static URI getURI(ConfigDataId id) {
        String uriString = id.getHref();
        URI uri = URI.createURI(uriString);
        return uri;
    }

    static void objectRemoved(RepositoryContext context, EObject obj, ReferenceHandler handler, Stack attributePathContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectRemoved", new Object[]{context, obj});
        }
        if (context.getType().getName().equals("servers")) {
            MOFUtil.objectRemovedBasic(context, obj, handler, attributePathContext);
            TreeIterator iter = obj.eAllContents();
            while (iter.hasNext()) {
                MOFUtil.objectRemovedBasic(context, (EObject)iter.next(), handler, attributePathContext);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectRemoved");
        }
    }

    private static void objectRemovedBasic(RepositoryContext context, EObject obj, ReferenceHandler handler, Stack attributePathContext) {
        try {
            EClass metaObj = obj.eClass();
            List endPointAttributeNames = EndpointConfigHelper.getEndpointAttributeNames(metaObj);
            for (String endPointName : endPointAttributeNames) {
                EndpointConfigHelper.setEndpointAttribute(context, obj.eClass(), endPointName, null, handler, attributePathContext);
            }
        }
        catch (ConfigServiceException ex) {
            Tr.warning(tc, "ADMG0022W", new Object[]{ex, context.getName()});
        }
    }

    static void objectAdded(RepositoryContext context, EObject obj, ReferenceHandler handler, Stack attributePathContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectAdded", new Object[]{context, obj});
        }
        if (context.getType().getName().equals("servers")) {
            MOFUtil.objectAddedBasic(context, obj, handler, attributePathContext);
            TreeIterator iter = obj.eAllContents();
            while (iter.hasNext()) {
                MOFUtil.objectAddedBasic(context, (EObject)iter.next(), handler, attributePathContext);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectAdded");
        }
    }

    private static void objectAddedBasic(RepositoryContext context, EObject obj, ReferenceHandler handler, Stack attributePathContext) {
        try {
            EClass metaObj = obj.eClass();
            List endPointAttributeNames = EndpointConfigHelper.getEndpointAttributeNames(metaObj);
            for (String endPointName : endPointAttributeNames) {
                EndpointConfigHelper.setEndpointAttribute(context, obj.eClass(), endPointName, new AttributeList(), handler, attributePathContext);
            }
            if ("servers".equals(context.getType().getName())) {
                EndpointConfigHelper.setServerType(context, obj.eClass());
            }
        }
        catch (ConfigServiceException ex) {
            Tr.warning(tc, "ADMG0022W", new Object[]{ex, context.getName()});
        }
        if (obj instanceof EndPoint) {
            try {
                EndPoint endPoint = (EndPoint)obj;
                int port = endPoint.getPort();
                if (port != 0) {
                    endPoint.setPort(0);
                    endPoint.setPort(EndpointConfigHelper.adjustPort(context, port, null));
                }
            }
            catch (ConfigServiceException ex) {
                Tr.warning(tc, "ADMG0022W", new Object[]{ex, context.getName()});
            }
        }
    }

    private static List getAllAttributeMetaObjs(EClass metaObj, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllAttributeMetaObjs", new Object[]{metaObj, nodeProps});
        }
        ArrayList allAttrMetaObjs = new ArrayList(metaObj.getEAllAttributes());
        MetadataFilter.filterAttributes(allAttrMetaObjs, nodeProps);
        ArrayList allAttrRefObjs = new ArrayList(metaObj.getEAllReferences());
        allAttrMetaObjs.addAll(allAttrRefObjs);
        Iterator iter = allAttrMetaObjs.iterator();
        while (iter.hasNext()) {
            EStructuralFeature attr = (EStructuralFeature)iter.next();
            if (MOFUtil.isValidAttribute(attr, nodeProps)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing Attribute: ", new Object[]{attr.getName()});
            }
            iter.remove();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllAttributeMetaObjs", new Object[]{allAttrMetaObjs});
        }
        return allAttrMetaObjs;
    }

    private static EStructuralFeature getAttributeMetaObj(EClass metaObj, String name, Stack attributePathContext, boolean relationship, Properties nodeProps) throws InvalidAttributeNameException {
        EStructuralFeature result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeMetaObj", new Object[]{metaObj, name, nodeProps});
        }
        if ((result = MOFUtil.getAttributeMetaObjNoException(metaObj, name, attributePathContext, relationship, nodeProps)) == null) {
            metaObj.getName();
            if (!attributePathContext.contains(name)) {
                attributePathContext.push(name);
            }
            throw new InvalidAttributeNameException(MOFUtil.getAttributePath(attributePathContext));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeMetaObj", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EStructuralFeature getAttributeMetaObjNoException(EClass metaObj, String name, Stack attributePathContext, boolean relationship, Properties nodeProps) {
        EStructuralFeature result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeMetaObjNoException", new Object[]{metaObj, name, nodeProps});
        }
        try {
            if (attributePathContext == null) {
                attributePathContext = new Stack<String>();
            }
            attributePathContext.push(name);
            result = metaObj.getEStructuralFeature(name);
            if (result != null && !MOFUtil.isValidAttribute(result, relationship, nodeProps)) {
                result = null;
            }
            Object var7_6 = null;
            attributePathContext.pop();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            attributePathContext.pop();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeMetaObjNoException", result);
        }
        return result;
    }

    private static EStructuralFeature getAttributeMetaObj(EClass metaObj, String name, Stack attributePathContext, Properties nodeProps) throws InvalidAttributeNameException {
        return MOFUtil.getAttributeMetaObj(metaObj, name, attributePathContext, false, nodeProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void validateAttributeList(EObject metaObject, AttributeList attrList, AttributeList rootAttrList, Stack attributePathContext, Properties nodeProps) throws InvalidAttributeNameException, InvalidAttributeValException, ReadOnlyAttributeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateAttributeList", new Object[]{metaObject, attrList});
        }
        String type = null;
        try {
            type = (String)ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Type");
            EClass subTypeMetaObj = TypeRegistry.getMetaObject(type, nodeProps);
            if (((EClassifier)metaObject).getInstanceClass().isAssignableFrom(subTypeMetaObj.getInstanceClass())) {
                metaObject = subTypeMetaObj;
            }
        }
        catch (AttributeNotFoundException ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type is not specified");
            }
        }
        catch (InvalidConfigDataTypeException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.MOFUtil.validateAttributeList", (String)"497");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "specified type is not valid", new Object[]{type, ex});
            }
            throw new InvalidAttributeNameException("specified type is not valid: " + type + "  " + ex);
        }
        for (Attribute attr : attrList) {
            String name = attr.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name", name);
            }
            Object val = attr.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "val", val);
            }
            if (EndpointConfigHelper.isEndpointAttribute((EClassifier)metaObject, name)) {
                Object var11_14;
                try {
                    attributePathContext.push(name);
                    if (val != null && !(val instanceof AttributeList)) {
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                    }
                    MOFUtil.validateAttributeList(EndpointConfigHelper.getEndpointMetaObj(), (AttributeList)val, rootAttrList, attributePathContext, nodeProps);
                    var11_14 = null;
                    attributePathContext.pop();
                }
                catch (Throwable throwable) {
                    var11_14 = null;
                    attributePathContext.pop();
                    throw throwable;
                }
                {
                    continue;
                }
            }
            if (SystemAttributes.isSystemAttribute(name)) continue;
            EStructuralFeature attrMetaObj = MOFUtil.getAttributeMetaObj(metaObject, name, false, nodeProps);
            MOFUtil.validateAttribute(attrMetaObj, val, rootAttrList, attributePathContext, nodeProps);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateAttributeList");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateAttribute(EStructuralFeature attrFeature, Object val, AttributeList rootAttrList, Stack attributePathContext, Properties nodeProps) throws InvalidAttributeNameException, InvalidAttributeValException, ReadOnlyAttributeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateAttribute", new Object[]{attrFeature, val});
        }
        if (val == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateAttribute");
            }
            return;
        }
        try {
            attributePathContext.push(attrFeature.getName());
            EClassifier attrType = attrFeature.getEType();
            if (!MOFUtil.isComposite(attrFeature)) {
                if (attrFeature.isMany() && val instanceof List) {
                    for (Object element : (List)val) {
                        if (attrFeature instanceof EAttribute) {
                            if ((!(attrType instanceof EEnum) || element instanceof String) && (attrType instanceof EEnum || attrType.isInstance(element))) continue;
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                        }
                        if (!(element instanceof ObjectName)) {
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                        }
                        ConfigDataId id = ConfigServiceHelper.getConfigDataId((ObjectName)element);
                        if (!id.isLocal() || ConfigServiceHelper.lookup(rootAttrList, id) != null) continue;
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                    }
                } else {
                    if (!(val instanceof ObjectName)) {
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                    }
                    ConfigDataId id = ConfigServiceHelper.getConfigDataId((ObjectName)val);
                    if (id.isLocal() && ConfigServiceHelper.lookup(rootAttrList, id) == null) {
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                    }
                }
            } else if (attrFeature instanceof EReference && val instanceof AttributeList) {
                MOFUtil.validateAttributeList(attrType, (AttributeList)val, rootAttrList, attributePathContext, nodeProps);
            } else if (attrFeature.isMany() && val instanceof List) {
                for (Object element : (List)val) {
                    if (attrFeature instanceof EAttribute) {
                        if ((!(attrType instanceof EEnum) || element instanceof String) && (attrType instanceof EEnum || attrType.isInstance(element))) continue;
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                    }
                    MOFUtil.validateAttributeList(attrType, (AttributeList)element, rootAttrList, attributePathContext, nodeProps);
                }
            } else if (attrFeature instanceof EAttribute) {
                String name;
                if (attrType instanceof EEnum && !(val instanceof String) || !(attrType instanceof EEnum) && !attrType.isInstance(val)) {
                    throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                }
                if (attrType instanceof EEnum) {
                    EEnum e = (EEnum)attrType;
                    Enumerator enumElement = null;
                    EEnumLiteral enumLiteral = e.getEEnumLiteral((String)val);
                    if (enumLiteral != null) {
                        enumElement = enumLiteral.getInstance();
                    }
                    if (enumElement == null) {
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                    }
                    String majVer = MOFUtil.getNodeMajorVersion(nodeProps);
                    if (majVer != null && majVer.equals("5") && "type".equals(attrFeature.getName()) && "com.ibm.ejs.models.base.resources.jms.GenericJMSConnectionFactory".equals(((EClass)attrFeature.eContainer()).getInstanceClassName()) && "UNIFIED".equals((String)val)) {
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                    }
                }
                if (!(!attrFeature.getName().equals("name") || ServiceLog.class.isAssignableFrom(attrFeature.getContainerClass()) || J2EEResourceFactory.class.isAssignableFrom(attrFeature.getContainerClass()) || GroupExt.class.isAssignableFrom(attrFeature.getContainerClass()) || UserExt.class.isAssignableFrom(attrFeature.getContainerClass()) || SubjectExt.class.isAssignableFrom(attrFeature.getContainerClass()) || ConfigServiceHelper.checkIfNameValid(name = (String)val))) {
                    throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                }
            } else {
                throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
            }
            Object var11_16 = null;
            attributePathContext.pop();
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            attributePathContext.pop();
            throw throwable;
        }
        if (val == null && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateAttribute");
        }
    }

    static void setAttributes(RepositoryContext context, EObject refObj, AttributeList attrList, ReferenceHandler referenceHandler, Stack attributePathContext) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{refObj, attrList});
        }
        Properties nodeProps = MOFUtil.getNodeProperties(context);
        boolean isPassword = false;
        for (Attribute attr : attrList) {
            String value;
            String name;
            block9: {
                if (SystemAttributes.isSystemAttribute(attr.getName())) continue;
                name = attr.getName();
                if (isPassword && name.equalsIgnoreCase("value") && attr.getValue() != null) {
                    isPassword = false;
                    try {
                        value = PasswordUtil.encode((String)((String)attr.getValue()));
                        MOFUtil.setAttribute(context, refObj, attr.getName(), value, referenceHandler, attributePathContext, nodeProps);
                        continue;
                    }
                    catch (ConfigServiceException e) {
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "Received ConfigServiceException: ", e);
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        if (!tc.isEntryEnabled()) break block9;
                        Tr.debug(tc, "Received Exception: ", e);
                    }
                }
            }
            if (name.equalsIgnoreCase("name") && ((value = (String)attr.getValue()).indexOf("password") != -1 || value.indexOf("Password") != -1)) {
                isPassword = true;
            }
            MOFUtil.setAttribute(context, refObj, attr.getName(), attr.getValue(), referenceHandler, attributePathContext, nodeProps);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    static void setAttribute(RepositoryContext context, EObject obj, String name, Object value, ReferenceHandler referenceHandler, Stack attributePathContext) throws ConfigServiceException {
        Properties nodeProps = MOFUtil.getNodeProperties(context);
        MOFUtil.setAttribute(context, obj, name, value, referenceHandler, attributePathContext, nodeProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void setAttribute(RepositoryContext context, EObject obj, String name, Object value, ReferenceHandler referenceHandler, Stack attributePathContext, Properties nodeProps) throws ConfigServiceException {
        block26: {
            block25: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "setAttribute", new Object[]{obj, name, value, nodeProps});
                }
                try {
                    attributePathContext.push(name);
                    if (EndpointConfigHelper.isEndpointAttribute(obj.eClass(), name)) {
                        if (value != null && !(value instanceof AttributeList)) {
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                        }
                        EndpointConfigHelper.setEndpointAttribute(context, obj.eClass(), name, (AttributeList)value, referenceHandler, attributePathContext);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "setAttribute");
                        }
                        Object var15_7 = null;
                        attributePathContext.pop();
                        return;
                    }
                    EStructuralFeature attrMetaObj = MOFUtil.getAttributeMetaObj((EObject)obj.eClass(), name, false, nodeProps);
                    if (value == null) {
                        if (attrMetaObj.isMany()) {
                            List listVal = (List)obj.eGet(attrMetaObj);
                            for (Object val : listVal) {
                                if (!(val instanceof EObject)) continue;
                                MOFUtil.objectRemoved(context, (EObject)val, referenceHandler, attributePathContext);
                            }
                            listVal.clear();
                        } else {
                            Object val = obj.eGet(attrMetaObj);
                            if (val instanceof EObject) {
                                MOFUtil.objectRemoved(context, obj, referenceHandler, attributePathContext);
                            }
                            obj.eUnset(attrMetaObj);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "setAttribute");
                        }
                        break block25;
                    }
                    if (!MOFUtil.isComposite(attrMetaObj)) {
                        if (attrMetaObj.isMany() && !(value instanceof List)) {
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                        }
                        referenceHandler.addDeferredUpdate(obj, attrMetaObj, value, MOFUtil.getAttributePath(attributePathContext));
                    } else if (attrMetaObj.isMany() && value instanceof List) {
                        List listVal = (List)obj.eGet(attrMetaObj);
                        listVal.clear();
                        for (Object element : (List)value) {
                            EEnum e;
                            if (attrMetaObj instanceof EReference && element instanceof AttributeList) {
                                AttributeList attrList = (AttributeList)element;
                                EClassifier attrTypeMetaObj = attrMetaObj.getEType();
                                EObject newVal = MOFUtil.createRefObject(context, attrTypeMetaObj, (AttributeList)element, referenceHandler, attributePathContext);
                                listVal.add(newVal);
                                MOFUtil.objectAdded(context, newVal, referenceHandler, attributePathContext);
                                continue;
                            }
                            if (element != null && attrMetaObj.getEType() instanceof EEnum && (element = (e = (EEnum)attrMetaObj.getEType()).getEEnumLiteral((String)element).getInstance()) == null) {
                                throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                            }
                            listVal.add(element);
                        }
                    } else if (attrMetaObj instanceof EReference && value instanceof AttributeList) {
                        EObject refObjVal = MOFUtil.createRefObject(context, attrMetaObj.getEType(), (AttributeList)value, referenceHandler, attributePathContext);
                        obj.eSet(attrMetaObj, refObjVal);
                        MOFUtil.objectAdded(context, refObjVal, referenceHandler, attributePathContext);
                    } else if (attrMetaObj instanceof EAttribute) {
                        EEnum e;
                        if (attrMetaObj.getEType() instanceof EEnum && (value = (e = (EEnum)attrMetaObj.getEType()).getEEnumLiteral((String)value).getInstance()) == null) {
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
                        }
                        obj.eSet(attrMetaObj, value);
                    }
                    Object var15_9 = null;
                    attributePathContext.pop();
                    break block26;
                }
                catch (Throwable throwable) {
                    Object var15_10 = null;
                    attributePathContext.pop();
                    throw throwable;
                }
            }
            Object var15_8 = null;
            attributePathContext.pop();
            return;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "setAttribute");
    }

    private static EObject createRefObject(RepositoryContext context, EObject metaObj, AttributeList attrList, ReferenceHandler handler, Stack attributePathContext) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRefObject", new Object[]{metaObj, attrList});
        }
        Properties nodeProps = MOFUtil.getNodeProperties(context);
        String type = null;
        try {
            type = (String)ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Type");
            EClass subTypeMetaObj = TypeRegistry.getMetaObject(type, nodeProps);
            if (((EClassifier)metaObj).getInstanceClass().isAssignableFrom(subTypeMetaObj.getInstanceClass())) {
                metaObj = subTypeMetaObj;
            }
        }
        catch (AttributeNotFoundException ex) {
        }
        catch (InvalidConfigDataTypeException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.MOFUtil.createRefObject", (String)"725");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "specified type is not valid", new Object[]{type, ex});
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.MOFUtil.createRefObject", (String)"728");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", ex);
            }
            throw new InvalidAttributeValException(MOFUtil.getAttributePath(attributePathContext));
        }
        ObjectName template = null;
        try {
            template = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Template");
        }
        catch (AttributeNotFoundException ex) {
            // empty catch block
        }
        EObject obj = MOFUtil.newRefObject(context, metaObj, template);
        MOFUtil.setAttributes(context, obj, attrList, handler, attributePathContext);
        ConfigDataId id = null;
        try {
            id = (ConfigDataId)ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Id");
        }
        catch (AttributeNotFoundException ex) {
            // empty catch block
        }
        if (id != null && id.isLocal()) {
            handler.addLocalRefObject(id, obj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRefObject", obj);
        }
        return obj;
    }

    static AttributeList getAttributeMetaInfo(String parentType, EStructuralFeature attrMetaObj, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeMetaInfo", new Object[]{attrMetaObj, nodeProps});
        }
        AttributeList result = new AttributeList();
        result.add(new Attribute("_Attribute_MetaInfo_Name", attrMetaObj.getName()));
        EClassifier type = attrMetaObj.getEType();
        Object defaultValue = attrMetaObj.getDefaultValue();
        if (defaultValue != null && type instanceof EEnum) {
            defaultValue = defaultValue.toString();
        }
        if (defaultValue != null && !(defaultValue instanceof Serializable)) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "defaultValue is not serializable:", defaultValue);
            }
            defaultValue = null;
        }
        String[] ranges = MetadataFilter.getValidRanges(attrMetaObj, nodeProps);
        result.add(new Attribute("_Attribute_MetaInfo_Default_Value", defaultValue));
        result.add(new Attribute("_Attribute_MetaInfo_Is_Collection", new Boolean(attrMetaObj.isMany())));
        String typeName = TypeRegistry.getTypeShortName(type);
        result.add(new Attribute("_Attribute_MetaInfo_Type", typeName));
        try {
            String[] subTypes = TypeRegistry.getSubTypes(typeName, nodeProps);
            if (subTypes != null && subTypes.length > 0) {
                result.add(new Attribute("_Attribute_MetaInfo_Subtypes", Arrays.asList(subTypes)));
            }
        }
        catch (InvalidConfigDataTypeException ex) {
            // empty catch block
        }
        boolean isObject = attrMetaObj instanceof EReference;
        result.add(new Attribute("_Attribute_MetaInfo_Is_Object", new Boolean(isObject)));
        Set reqs = RequiredAttributesRegistry.getRequiredAttributes(parentType);
        boolean isRequired = reqs != null && reqs.contains(attrMetaObj.getName());
        result.add(new Attribute("_Attribute_MetaInfo_Is_Required", new Boolean(isRequired)));
        result.add(new Attribute("_Attribute_MetaInfo_Is_Reference", new Boolean(!MOFUtil.isComposite(attrMetaObj))));
        if (type instanceof EEnum) {
            AttributeList enumInfo = new AttributeList();
            EEnum enumType = (EEnum)type;
            EList enumLiterals = enumType.getELiterals();
            for (EEnumLiteral l : enumLiterals) {
                enumInfo.add(new Attribute(l.getName(), new Integer(l.getValue())));
            }
            result.add(new Attribute("_Attribute_MetaInfo_Enum_Info", enumInfo));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeMetaInfo", result);
        }
        return result;
    }

    private static String[] getAttributePath(Stack attributePathContext) {
        String[] result = new String[attributePathContext.size()];
        attributePathContext.toArray(result);
        return result;
    }

    private static boolean isValidAttribute(EStructuralFeature feature, boolean relationship, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidAttribute", new Object[]{feature, new Boolean(relationship), nodeProps});
        }
        boolean result = true;
        if (nodeProps != null) {
            result = MetadataFilter.isValidAttr(feature, nodeProps);
        }
        if (result) {
            if (feature.isVolatile()) {
                result = false;
            } else {
                Class attrClass = feature.getEType().getInstanceClass();
                if (attrClass == null) {
                    result = !relationship;
                } else {
                    for (int i = 0; i < innerConfigObjectTypes.length; ++i) {
                        if (!MOFUtil.isComposite(feature) || !innerConfigObjectTypes[i].isAssignableFrom(attrClass)) continue;
                        result = relationship;
                        break;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidAttribute, " + result);
        }
        return result;
    }

    private static boolean isValidAttribute(EStructuralFeature feature, Properties nodeProps) {
        return MOFUtil.isValidAttribute(feature, false, nodeProps);
    }

    private static boolean isValidType(EObject refObj) {
        return MetadataFilter.isValidType(refObj.eClass(), MOFUtil.getNodeProperties(refObj));
    }

    private static boolean isComposite(EStructuralFeature feature) {
        boolean result = true;
        if (feature instanceof EReference) {
            result = ((EReference)feature).isContainment();
        }
        return result;
    }

    private static EObject lookup(RepositoryContext context, ConfigDataId id, String[] attributePath) throws InvalidAttributeValException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookup", new Object[]{context, id});
        }
        if (context == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "lookup", null);
            }
            return null;
        }
        try {
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(context.getWorkSpace(), id);
            EObject val = docAccessor.lookup(id);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "lookup", val);
            }
            return val;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.MOFUtil.lookup", (String)"848");
            throw new InvalidAttributeValException(attributePath, ex);
        }
    }

    protected static Properties getNodeProperties(EObject refObj) {
        ObjectName objName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeProperties", refObj);
        }
        if (refObj instanceof EAttribute) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "It's an attribute");
            }
            refObj = refObj.eClass();
        }
        if ((objName = MOFUtil.createObjectName(refObj)) == null || ConfigServiceHelper.getConfigDataId(objName) == null || ConfigServiceHelper.getConfigDataId(objName).isLocal()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "objname null");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeProperties", null);
            }
            return null;
        }
        return MOFUtil.getNodeProperties(WorkspaceHelper.getWorkspace(refObj), objName);
    }

    protected static Properties getNodeProperties(RepositoryContext context) {
        ObjectName objName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeProperties - context", context);
        }
        if ((objName = MOFUtil.createObjectName(context)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "objname null");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeProperties", null);
            }
            return null;
        }
        return MOFUtil.getNodeProperties(context.getWorkSpace(), objName);
    }

    protected static Properties getNodeProperties(WorkSpace ws, ObjectName objName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeProperties - objname", objName);
        }
        Properties locProps = ConfigServiceHelper.getObjectLocation(objName);
        String nodeName = null;
        Properties nodeProps = null;
        if (locProps.getProperty("node") != null) {
            nodeName = locProps.getProperty("node");
            try {
                ManagedObjectMetadataHelper metaHelper = ws.getMetadataHelper();
                if (metaHelper != null) {
                    nodeProps = metaHelper.getAccessor().getMetadataProperties(nodeName);
                } else {
                    Tr.warning(tc, "Do not have a MetadataHelper");
                }
            }
            catch (Exception e) {
                Tr.warning(tc, "Could not getNodeProperties for node: " + nodeName, e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeProperties - objname", nodeProps);
        }
        return nodeProps;
    }

    protected static boolean isNodeVersion5(WorkSpace ws, String nodeName) {
        try {
            String majorVersion = ws.getMetadataHelper().getNodeMajorVersion(nodeName);
            return majorVersion.equals("5");
        }
        catch (Exception e) {
            Tr.warning(tc, "Could not getNodeBaseProductVersion for node: " + nodeName, e);
            return false;
        }
    }

    protected static String getNodeMajorVersion(Properties nodeProperties) {
        int index;
        if (nodeProperties == null) {
            return null;
        }
        String s = nodeProperties.getProperty("com.ibm.websphere.baseProductVersion");
        s.trim();
        String majorVer = null;
        if (s != null && s.length() > 0 && (index = (majorVer = s).indexOf(46)) != -1) {
            majorVer = majorVer.substring(0, index);
        }
        return majorVer;
    }

    protected static boolean mixedCluster(ConfigService cs, Session session, ObjectName cluster) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mixedCluster", new Object[]{cs, session, cluster});
        }
        try {
            ObjectName[] currentMemberObjs = null;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ClusterMember");
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            ManagedObjectMetadataHelper mh = ws.getMetadataHelper();
            currentMemberObjs = cs.queryConfigObjects(session, cluster, pattern, null);
            for (int i = 0; i < currentMemberObjs.length; ++i) {
                String serverName = (String)cs.getAttribute(session, currentMemberObjs[i], "memberName");
                String nodeName = (String)cs.getAttribute(session, currentMemberObjs[i], "nodeName");
                String majorVersion = ws.getMetadataHelper().getNodeMajorVersion(nodeName);
                if (!majorVersion.equals("5")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is a cluster member " + serverName + " on node " + nodeName + " That is not version 6.0 or above");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mixedCluster true");
                }
                return true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mixedCluster false");
            }
            return false;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception " + e.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mixedCluster false");
            }
            return false;
        }
    }

    protected static boolean canCreateMember(ConfigService cs, Session session, String memberNode, ObjectName cluster) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canCreateMember", new Object[]{cs, session, cluster});
        }
        boolean ret = false;
        try {
            ObjectName[] currentMemberObjs = null;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ClusterMember");
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            ManagedObjectMetadataHelper mh = ws.getMetadataHelper();
            currentMemberObjs = cs.queryConfigObjects(session, cluster, pattern, null);
            String memberVersion = ws.getMetadataHelper().getNodeMajorVersion(memberNode);
            if (currentMemberObjs.length == 0) {
                ret = true;
            }
            for (int i = 0; i < currentMemberObjs.length; ++i) {
                String serverName = (String)cs.getAttribute(session, currentMemberObjs[i], "memberName");
                String nodeName = (String)cs.getAttribute(session, currentMemberObjs[i], "nodeName");
                String majorVersion = ws.getMetadataHelper().getNodeMajorVersion(nodeName);
                if (majorVersion.compareTo(memberVersion) > 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is a matching member " + serverName + " on node " + nodeName);
                }
                ret = true;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "canCreateMember " + new Boolean(ret));
                }
                return ret;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception " + e.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canCreateMember " + new Boolean(ret));
            }
            return ret;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canCreateMember " + new Boolean(ret));
        }
        return ret;
    }

    static class ReferenceHandler {
        private List deferredUpdates = new ArrayList();
        private HashMap localRefObjs = new HashMap();

        ReferenceHandler() {
        }

        public void addLocalRefObject(ConfigDataId id, EObject refObj) {
            this.localRefObjs.put(id, refObj);
        }

        public void addDeferredUpdate(EObject refObj, EStructuralFeature feature, Object value, String[] attributePath) {
            DeferredUpdateInfo info = new DeferredUpdateInfo();
            info.refObj = refObj;
            info.feature = feature;
            info.value = value;
            info.attributePath = attributePath;
            this.deferredUpdates.add(info);
        }

        public void update(RepositoryContext context) throws InvalidAttributeValException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "update", context);
            }
            for (DeferredUpdateInfo info : this.deferredUpdates) {
                if (info.feature.isMany()) {
                    List listVal = (List)info.value;
                    List currentVal = (List)info.refObj.eGet(info.feature);
                    currentVal.clear();
                    for (Object element : listVal) {
                        if (!(element instanceof ObjectName)) {
                            throw new InvalidAttributeValException(info.attributePath);
                        }
                        currentVal.add(this.getReferredObj(context, ConfigServiceHelper.getConfigDataId((ObjectName)element), info.attributePath));
                    }
                    continue;
                }
                if (!(info.value instanceof ObjectName)) {
                    throw new InvalidAttributeValException(info.attributePath);
                }
                Object referredObj = this.getReferredObj(context, ConfigServiceHelper.getConfigDataId((ObjectName)info.value), info.attributePath);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "referredObj", referredObj);
                }
                info.refObj.eSet(info.feature, referredObj);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "update");
            }
        }

        private Object getReferredObj(RepositoryContext context, ConfigDataId id, String[] attributePath) throws InvalidAttributeValException {
            EObject val = null;
            if (id.isLocal()) {
                val = (EObject)this.localRefObjs.get(id);
                if (val == null) {
                    throw new InvalidAttributeValException(attributePath, (Exception)new ConfigDataNotFoundException(null, id, null));
                }
            } else {
                val = MOFUtil.lookup(context, id, attributePath);
            }
            return val;
        }

        static class DeferredUpdateInfo {
            public EObject refObj;
            public EStructuralFeature feature;
            public Object value;
            public String[] attributePath;

            DeferredUpdateInfo() {
            }
        }
    }
}

