/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.SessionPropertyConstants;
import com.ibm.websphere.management.configservice.ValidationResult;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigDocumentSaveException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.MalformedContainmentPathException;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.authzgroup.AuthzGroupUtil;
import com.ibm.ws.management.configservice.AuthorizationGroupDelegator;
import com.ibm.ws.management.configservice.AuthorizationTableExtDelegator;
import com.ibm.ws.management.configservice.CMPConnectorFactoryDelegator;
import com.ibm.ws.management.configservice.CSMetadataMgr;
import com.ibm.ws.management.configservice.ClusterMemberDelegator;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.DataSourceDelegator;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.HttpTransportDelegator;
import com.ibm.ws.management.configservice.InnerConfigObjectDelegator;
import com.ibm.ws.management.configservice.J2CActivationSpecDelegator;
import com.ibm.ws.management.configservice.J2CAdminObjectDelegator;
import com.ibm.ws.management.configservice.J2CConnectionFactoryDelegator;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.NodeDelegator;
import com.ibm.ws.management.configservice.PortletCachingDelegator;
import com.ibm.ws.management.configservice.ResourceProviderDelegator;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.SSLConfigDelegator;
import com.ibm.ws.management.configservice.SecureSocketLayerDelegator;
import com.ibm.ws.management.configservice.SecurityDelegator;
import com.ibm.ws.management.configservice.ServerClusterDelegator;
import com.ibm.ws.management.configservice.ServerDelegator;
import com.ibm.ws.management.configservice.ServletCachingDelegator;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.VariableMapDelegator;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.configservice.csmetadata.ConfigServiceMetadata;
import com.ibm.ws.management.configservice.csmetadata.ConnectionFactoryType;
import com.ibm.ws.management.configservice.csmetadata.ResourceProviderType;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.sm.validation.ContextValidationMessages;
import com.ibm.ws.sm.validation.DocumentValidationMessages;
import com.ibm.ws.sm.validation.ValidationHelper;
import com.ibm.ws.sm.validation.ValidationManager;
import com.ibm.ws.sm.validation.ValidationManagerException;
import com.ibm.ws.sm.validation.ValidationManagerRegistry;
import com.ibm.ws.sm.validation.ValidationPolicy;
import com.ibm.ws.sm.validation.ValidatorValidationMessages;
import com.ibm.ws.sm.workspace.ConflictResolution;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ConfigServiceImpl
implements ConfigService,
SessionPropertyConstants {
    private static TraceComponent tc = Tr.register(ConfigServiceImpl.class, "management", "com.ibm.ws.management.resources.configservice");
    private static ConfigServiceImpl instance = null;
    private static HashMap sessionProps = new HashMap();
    private final HashMap delegatorTable = new HashMap();
    private AppManagement appMgr = null;
    private boolean initialized = false;
    private Properties props;
    private String endpointUUID;

    public ConfigServiceImpl(Properties props) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigServiceImpl");
        }
        if (props == null) {
            props = new Properties();
        }
        this.props = props;
        this.endpointUUID = AdminContext.peek();
        if (this.endpointUUID == null) {
            instance = this;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigServiceImpl");
        }
    }

    private synchronized void initialize() {
        RepositoryMetaData metaData;
        block15: {
            if (this.initialized) {
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize");
            }
            this.initialized = true;
            String location = this.props.getProperty("location");
            if (location != null && location.equalsIgnoreCase("local")) {
                ModelMgr.initialize((String)"ws-server");
            }
            try {
                RepositoryMetaDataFactory.initialize();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.ConfigServiceImpl", (String)"62", (Object)this);
                Tr.error(tc, "ADMG0011E", ex);
            }
            metaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            this.registerDelegator(new NodeDelegator(this));
            this.registerDelegator(new ServerDelegator(this));
            this.registerDelegator(new AuthorizationTableExtDelegator(this));
            this.registerDelegator(new ServerClusterDelegator(this));
            this.registerDelegator(new DataSourceDelegator(this));
            this.registerDelegator(new ClusterMemberDelegator(this));
            this.registerDelegator(new SecurityDelegator(this));
            this.registerDelegator(new J2CConnectionFactoryDelegator(this));
            this.registerDelegator(new J2CAdminObjectDelegator(this));
            this.registerDelegator(new J2CActivationSpecDelegator(this));
            this.registerDelegator(new CMPConnectorFactoryDelegator(this));
            this.registerDelegator(new VariableMapDelegator(this));
            this.registerDelegator(new HttpTransportDelegator(this));
            this.registerDelegator(new SSLConfigDelegator(this));
            this.registerDelegator(new SecureSocketLayerDelegator(this));
            this.registerDelegator(new AuthorizationGroupDelegator(this));
            this.registerDelegator(new PortletCachingDelegator(this));
            this.registerDelegator(new ServletCachingDelegator(this));
            this.registerRootConfigObjectDelegator(null, metaData.getContextType("cells"));
            try {
                this.registerRootConfigObjectDelegator(null, metaData.getContextType("waspolicies"));
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug(tc, "failed to register waspolicies delegator. Check repository metadata.xml file");
            }
        }
        this.registerRootConfigObjectDelegator(null, metaData.getContextType("templates"));
        ConfigServiceMetadata metadata2 = CSMetadataMgr.getConfigServiceMetadata();
        EList resourceProviders = metadata2.getResourceProviderTypes();
        for (int i = 0; i < resourceProviders.size(); ++i) {
            ResourceProviderType resourceProvider = (ResourceProviderType)resourceProviders.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "providerType" + resourceProviders);
            }
            String providerType = resourceProvider.getTypeName();
            RootObjectDelegator providerDelegator = (RootObjectDelegator)this.getDelegator(providerType = TypeRegistry.getShortType(providerType));
            if (providerDelegator == null) continue;
            EList cfTypes = resourceProvider.getConnectionFactoryTypes();
            for (int j = 0; j < cfTypes.size(); ++j) {
                ConnectionFactoryType cfType = (ConnectionFactoryType)cfTypes.get(j);
                InnerConfigObjectDelegator factoryDelegator = new InnerConfigObjectDelegator(this, TypeRegistry.getShortType(cfType.getTypeName()), "factories");
                factoryDelegator = (InnerConfigObjectDelegator)this.registerDelegatorIfNec(factoryDelegator);
                providerDelegator.registerChildType(factoryDelegator.getType(), true, factoryDelegator);
            }
        }
        RootObjectDelegator parentDelegator = (RootObjectDelegator)this.getDelegator("J2CResourceAdapter");
        if (parentDelegator != null) {
            InnerConfigObjectDelegator aoDelegator = new InnerConfigObjectDelegator(this, "J2CAdminObject", null);
            aoDelegator = (InnerConfigObjectDelegator)this.registerDelegatorIfNec(aoDelegator);
            parentDelegator.registerChildType(aoDelegator.getType(), true, aoDelegator);
            InnerConfigObjectDelegator acDelegator = new InnerConfigObjectDelegator(this, "J2CActivationSpec", null);
            acDelegator = (InnerConfigObjectDelegator)this.registerDelegatorIfNec(acDelegator);
            parentDelegator.registerChildType(acDelegator.getType(), true, acDelegator);
        }
        try {
            String[] serverCompType = TypeRegistry.getSubTypes("ServerComponent");
            for (int i = 0; i < serverCompType.length; ++i) {
                InnerConfigObjectDelegator serverCompDelegator = new InnerConfigObjectDelegator(this, serverCompType[i], "components");
                this.registerTypeAtServer(serverCompDelegator.getType(), true, serverCompDelegator);
            }
        }
        catch (InvalidConfigDataTypeException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.ConfigServiceImpl", (String)"91", (Object)this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private void registerRootConfigObjectDelegator(ConfigObjectDelegator parentDelegator, RepositoryContextType contextType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerRootConfigObjectDelegator", new Object[]{parentDelegator, contextType});
        }
        RepositoryDocumentType rootDocumentType = contextType.getRootDocumentType();
        List documentTypes = contextType.getChildDocumentTypes();
        RootObjectDelegator rootDelegator = null;
        ConfigServiceMetadata metadata2 = CSMetadataMgr.getConfigServiceMetadata();
        EList resourceProviders = metadata2.getResourceProviderTypes();
        ArrayList<String> resourceProviderTypes = new ArrayList<String>(resourceProviders.size());
        for (ResourceProviderType resourceProvider : resourceProviders) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "providerType" + resourceProviders);
            }
            String providerType = resourceProvider.getTypeName();
            providerType = TypeRegistry.getShortType(providerType);
            resourceProviderTypes.add(providerType);
        }
        if (rootDocumentType != null && rootDocumentType.getRootRefObjectTypes().length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rootDocumentType name ", rootDocumentType.getFilePattern());
            }
            rootDelegator = new RootObjectDelegator(this, contextType);
            rootDelegator = (RootObjectDelegator)this.registerDelegatorIfNec(rootDelegator);
            List subTypes = rootDelegator.getTypes();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Type of object  ", rootDelegator.getType());
            }
            if (subTypes != null) {
                for (String typ : subTypes) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating delegator  ", typ);
                    }
                    RootObjectDelegator subTypeDelegator = new RootObjectDelegator(this, typ, contextType.getRootDocumentType());
                    subTypeDelegator = (RootObjectDelegator)this.registerDelegatorIfNec(subTypeDelegator);
                    if (parentDelegator == null) continue;
                    parentDelegator.registerChildType(subTypeDelegator.getType(), true, subTypeDelegator);
                }
            }
            List ptypes = null;
            if (parentDelegator != null) {
                ptypes = parentDelegator.getTypes();
            }
            if (ptypes != null && ptypes.size() > 0) {
                for (String ptype : ptypes) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Child of  ", ptype);
                    }
                    RootObjectDelegator pDel = (RootObjectDelegator)this.getDelegator(ptype);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Child of  ", pDel);
                    }
                    pDel.registerChildType(rootDelegator.getType(), true, rootDelegator);
                }
            } else if (parentDelegator != null) {
                parentDelegator.registerChildType(rootDelegator.getType(), true, rootDelegator);
            }
            for (RepositoryDocumentType documentType : documentTypes) {
                String[] rootObjectTypes;
                if (documentType.equals(rootDocumentType) || (rootObjectTypes = documentType.getRootRefObjectTypes()) == null) continue;
                for (int i = 0; i < rootObjectTypes.length; ++i) {
                    RootObjectDelegator delegator = (RootObjectDelegator)this.getDelegator(rootObjectTypes[i]);
                    if (delegator == null) {
                        delegator = resourceProviderTypes.contains(rootObjectTypes[i]) ? new ResourceProviderDelegator(this, rootObjectTypes[i], documentType) : new RootObjectDelegator(this, rootObjectTypes[i], documentType);
                        delegator = (RootObjectDelegator)this.registerDelegatorIfNec(delegator);
                    }
                    rootDelegator.registerChildType(delegator.getType(), true, delegator);
                }
            }
        }
        List childrenContext = contextType.getChildContextTypes();
        for (RepositoryContextType childContextType : childrenContext) {
            this.registerRootConfigObjectDelegator(rootDelegator, childContextType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerRootConfigObjectDelegator");
        }
    }

    AppManagement getAppManagement() {
        if (this.appMgr == null) {
            try {
                this.appMgr = AdminServiceFactory.getAdminService() != null ? AppManagementProxy.getJMXProxyForServer() : AppManagementProxy.getLocalProxy();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.getAppManagement", (String)"193", (Object)this);
                Tr.error(tc, "ADMG0011E", new Object[]{ex});
            }
        }
        return this.appMgr;
    }

    public void registerTypeAtCell(String relationshipName, boolean isCollection, ConfigObjectDelegator childDelegator) {
        this.checkAdminContext();
        childDelegator = (ConfigObjectDelegator)this.registerDelegatorIfNec(childDelegator);
        ((ConfigObjectDelegator)this.getDelegator("Cell")).registerChildType(relationshipName, isCollection, childDelegator);
    }

    public void registerTypeAtNode(String relationshipName, boolean isCollection, ConfigObjectDelegator childDelegator) {
        this.checkAdminContext();
        childDelegator = (ConfigObjectDelegator)this.registerDelegatorIfNec(childDelegator);
        ((ConfigObjectDelegator)this.getDelegator("Node")).registerChildType(relationshipName, isCollection, childDelegator);
    }

    public void registerTypeAtServer(String relationshipName, boolean isCollection, ConfigObjectDelegator childDelegator) {
        this.checkAdminContext();
        childDelegator = (ConfigObjectDelegator)this.registerDelegatorIfNec(childDelegator);
        ((ConfigObjectDelegator)this.getDelegator("Server")).registerChildType(relationshipName, isCollection, childDelegator);
    }

    public void setProperties(Session session, HashMap props) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", new Object[]{session, props});
        }
        this.checkAdminContext();
        this.initialize();
        Integer validationLevel = props.put("VALIDATION_LEVEL", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validationLevel", validationLevel);
        }
        Boolean enableCrossValidation = props.put("ENABLE_CROSS_VALIDATION", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enableCrossValidation", enableCrossValidation);
        }
        if (validationLevel != null || enableCrossValidation != null) {
            ValidationManager validationManager = WorkspaceHelper.getValidationManager(session);
            ValidationPolicy policy = validationManager.getPolicy();
            if (enableCrossValidation != null) {
                policy.setIncludeCross(enableCrossValidation.booleanValue());
            }
            if (NO_VALIDATION.equals(validationLevel)) {
                policy.setIncludeExtracted(false);
                policy.setIncludeParentChain(false);
                policy.setIncludeLocalSiblings(false);
                policy.setIncludeAll(false);
            } else if (LOW_LEVEL_VALIDATION.equals(validationLevel)) {
                policy.setIncludeExtracted(true);
                policy.setIncludeParentChain(false);
                policy.setIncludeLocalSiblings(false);
                policy.setIncludeAll(false);
            } else if (MEDIUM_LEVEL_VALIDATION.equals(validationLevel)) {
                policy.setIncludeExtracted(true);
                policy.setIncludeParentChain(true);
                policy.setIncludeLocalSiblings(false);
                policy.setIncludeAll(false);
            } else if (HIGH_LEVEL_VALIDATION.equals(validationLevel)) {
                policy.setIncludeExtracted(true);
                policy.setIncludeParentChain(true);
                policy.setIncludeLocalSiblings(true);
                policy.setIncludeAll(false);
            } else if (HIGHEST_LEVEL_VALIDATION.equals(validationLevel)) {
                policy.setIncludeExtracted(false);
                policy.setIncludeParentChain(false);
                policy.setIncludeLocalSiblings(false);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "set enable to be all");
                }
                policy.setIncludeAll(true);
            }
            try {
                policy.affectUpdate();
            }
            catch (ValidationManagerException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.ConfigServiceImpl", (String)"213", (Object)this);
                throw new ConfigServiceException(ex);
            }
        }
        Locale locale = (Locale)props.get("LOCALE");
        Properties myProps = (Properties)sessionProps.get(session);
        if (myProps == null) {
            myProps = new Properties();
            sessionProps.put(session, myProps);
        }
        if (locale != null) {
            myProps.put("LOCALE", locale);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    Object getSessionProperty(Session session, String propName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSessionProperty", new Object[]{session, propName});
        }
        Properties myProps = (Properties)sessionProps.get(session);
        Object result = null;
        if (myProps != null) {
            result = myProps.get(propName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessionProperty");
        }
        return result;
    }

    public ValidationResult validate(Session session, ObjectName scope) throws ConfigServiceException {
        RepositoryContext context;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{session, scope});
        }
        this.checkAdminContext();
        this.initialize();
        if (scope == null) {
            WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
            context = workspace.getRootContext();
        } else {
            ConfigDataId id = ConfigServiceHelper.getConfigDataId(scope);
            context = WorkspaceHelper.getContext(session, id);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "context" + context.getURI());
        }
        try {
            ValidationManager man = WorkspaceHelper.getValidationManager(session);
            ContextValidationMessages msgs = man.getResults(context);
            ValidationResult result = new ValidationResult();
            Locale locale = (Locale)this.getSessionProperty(session, "LOCALE");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "client locale", locale);
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            Iterator iter = msgs.getDocumentMessages();
            while (iter.hasNext()) {
                DocumentValidationMessages documentMsgs = (DocumentValidationMessages)iter.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "documentMsgs", documentMsgs);
                }
                Iterator innerIter = documentMsgs.getValidatorMessages();
                while (innerIter.hasNext()) {
                    ValidatorValidationMessages validatorMsgs = (ValidatorValidationMessages)innerIter.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "validatorMsgs", validatorMsgs);
                    }
                    Iterator msgIter = validatorMsgs.getMessages();
                    while (msgIter.hasNext()) {
                        IMessage msg = (IMessage)msgIter.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "msg", msg);
                        }
                        String text = msg.getText(locale);
                        Object targetObject = msg.getTargetObject();
                        if (targetObject instanceof EObject) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "targetObject", targetObject);
                            }
                            try {
                                targetObject = MOFUtil.createObjectName((EObject)targetObject);
                            }
                            catch (Exception ex) {
                                targetObject = targetObject.toString();
                            }
                        } else if (targetObject != null) {
                            targetObject = targetObject.toString();
                        }
                        ValidationResult.ValidationMessage myMsg = new ValidationResult.ValidationMessage(text, targetObject, msg.getSeverity(), msg.getLineNumber());
                        result.addMessage(documentMsgs.getDocumentFullUri(), validatorMsgs.getValidatorClassName(), myMsg);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate", result);
            }
            return result;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.ConfigServiceImpl", (String)"277", (Object)this);
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0017E", new Object[]{session, scope}, null);
            throw new ConfigServiceException(ex, msg);
        }
    }

    public String[] getUnsavedChanges(Session session) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnsavedChanges", session);
        }
        this.checkAdminContext();
        this.initialize();
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        List modified = workspace.getModifiedList();
        String[] result = new String[modified.size()];
        for (int i = 0; i < modified.size(); ++i) {
            result[i] = ((WorkSpaceFile)modified.get(i)).getURI();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnsavedChanges", result);
        }
        return result;
    }

    public Map getConflictDocuments(Session session) throws ConfigServiceException {
        Map conflict;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConflictDocuments", session);
        }
        this.checkAdminContext();
        this.initialize();
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        try {
            conflict = workspace.checkSynchState();
        }
        catch (WorkSpaceException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.getConflictDocuments", (String)"164", (Object)this);
            throw new ConfigServiceException(ex, ex.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConflictDocuments", conflict);
        }
        return conflict;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(Session session, boolean overwriteOnConflict) throws ConfigServiceException {
        block23: {
            block22: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "save", session);
                }
                this.checkAdminContext();
                this.initialize();
                try {
                    Set s = this.delegatorTable.keySet();
                    if (s != null) {
                        for (String key : s) {
                            ConfigServiceDelegator cg = (ConfigServiceDelegator)this.delegatorTable.get(key);
                            cg.saveSession(session);
                        }
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block22;
                    Tr.debug(tc, "failed to invoke cleanup in delegator ", e);
                }
            }
            WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
            Subject currentSubject = SecurityHelper.retrieveSubject();
            boolean boostCred = false;
            try {
                try {
                    if (AdminServiceFactory.getAdminService() != null && currentSubject != null) {
                        AdminAuthorizer aa;
                        List modifiedList = workspace.getModifiedList();
                        Iterator i = modifiedList.iterator();
                        while (i.hasNext()) {
                            String fileUri = ((WorkSpaceFile)i.next()).getURI();
                            if (!RestrictedAccess.isRestricted((String)fileUri) && (fileUri == null || !fileUri.endsWith("audit-authz.xml"))) continue;
                            boostCred = true;
                            break;
                        }
                        if ((aa = AdminAuthorizerFactory.getAdminAuthorizer()) != null && aa.isFineGrainedAdminSecurity()) {
                            boostCred = true;
                        }
                        if (boostCred) {
                            try {
                                Subject svrSubject = null;
                                svrSubject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() {
                                        return SecurityHelper.getOwnedSubject();
                                    }
                                });
                                if (svrSubject != null) {
                                    SecurityHelper.pushInvocationSubject(svrSubject);
                                }
                            }
                            catch (Exception ex) {
                                throw new ConfigServiceException(ex, TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", null, null));
                            }
                        }
                    }
                    Map syncState = workspace.checkSynchState();
                    ArrayList uris = new ArrayList(syncState.keySet());
                    for (Object uri : uris) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "conflict uri" + uri);
                        }
                        if (overwriteOnConflict) {
                            syncState.put(uri, ConflictResolution.OVER_WRITE);
                            continue;
                        }
                        syncState.remove(uri);
                    }
                    workspace.synch(syncState);
                }
                catch (WorkSpaceException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.save", (String)"191", (Object)this);
                    throw new ConfigServiceException(ex, ex.getMessage());
                }
                Object var11_14 = null;
                if (!boostCred || currentSubject == null) break block23;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (!boostCred) throw throwable;
                if (currentSubject == null) throw throwable;
                try {
                    SecurityHelper.pushInvocationSubject(currentSubject);
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new ConfigServiceException(ex, TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", null, null));
                }
            }
            try {}
            catch (Exception ex) {
                throw new ConfigServiceException(ex, TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", null, null));
            }
            SecurityHelper.pushInvocationSubject(currentSubject);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "save", session);
    }

    public void discard(Session session) {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "discard", session);
            }
            this.checkAdminContext();
            this.initialize();
            try {
                block8: {
                    try {
                        Set s = this.delegatorTable.keySet();
                        if (s != null) {
                            for (String key : s) {
                                ConfigServiceDelegator cg = (ConfigServiceDelegator)this.delegatorTable.get(key);
                                cg.discardSession(session);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block8;
                        Tr.debug(tc, "failed to invoke cleanup in delegator ", e);
                    }
                }
                WorkSpaceManager workspaceMan = WorkSpaceManagerFactory.getManager();
                ValidationManagerRegistry registry = ValidationHelper.getRegistry();
                registry.release(WorkspaceHelper.getWorkspace(session));
                workspaceMan.removeWorkSpace(session.toString());
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.discard", (String)"207", (Object)this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "unexpected exception", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discard");
        }
    }

    private ConfigServiceDelegator registerDelegatorIfNec(ConfigServiceDelegator delegator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerDelegatorIfNec", delegator);
        }
        if (this.delegatorTable.get(delegator.getType()) == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "register delegator for type " + delegator.getType());
            }
            this.delegatorTable.put(delegator.getType(), delegator);
        } else {
            delegator = (ConfigServiceDelegator)this.delegatorTable.get(delegator.getType());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerDelegatorIfNec", delegator);
        }
        return delegator;
    }

    public void registerDelegator(ConfigServiceDelegator delegator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerDelegator", new Object[]{delegator.getType(), delegator});
        }
        this.checkAdminContext();
        this.delegatorTable.put(delegator.getType(), delegator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerDelegator");
        }
    }

    public String[] getSupportedConfigObjectTypes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedConfigObjectTypes");
        }
        this.checkAdminContext();
        this.initialize();
        Set keySet = TypeRegistry.getAllTypes();
        String[] result = new String[keySet.size()];
        keySet.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedConfigObjectTypes", result);
        }
        return result;
    }

    public AttributeList getAttributesMetaInfo(String configDataType) throws InvalidConfigDataTypeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributesMetaInfo", configDataType);
        }
        this.checkAdminContext();
        this.initialize();
        AttributeList result = null;
        ConfigServiceDelegator delegator = (ConfigServiceDelegator)this.delegatorTable.get(configDataType);
        result = delegator == null ? this.getAttributesMetaInfoBasic(configDataType) : delegator.getAttributesMetaInfo(configDataType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributesMetaInfo", result);
        }
        return result;
    }

    public AttributeList getRelationshipsMetaInfo(String configObjectType) throws InvalidConfigDataTypeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationshipsMetaInfo", configObjectType);
        }
        this.checkAdminContext();
        this.initialize();
        AttributeList result = null;
        ConfigServiceDelegator delegator = (ConfigServiceDelegator)this.delegatorTable.get(configObjectType);
        result = delegator == null ? this.getRelationshipsMetaInfoBasic(configObjectType) : delegator.getRelationshipsMetaInfo(configObjectType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationshipsMetaInfo", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] queryTemplates(Session inSession, String type) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "qeuryTemplates", new Object[]{inSession, type});
        }
        this.checkAdminContext();
        this.initialize();
        Session session = inSession;
        if (session == null) {
            session = new Session();
        }
        ObjectName[] result = null;
        try {
            RepositoryContext templateContext;
            WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
            try {
                TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)workspace);
                templateContext = templateMan.getRootTemplateContext();
            }
            catch (WorkSpaceException ex) {
                throw new ConfigServiceException(ex, ex.getLocalizedMessage());
            }
            ObjectName scope = MOFUtil.createObjectName(templateContext);
            result = this.getAllBasic(session, scope, type, false);
            Object var9_9 = null;
            if (inSession == null) {
                this.discard(session);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (inSession == null) {
                this.discard(session);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryTemplates", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectName[] queryConfigObjects(Session inSession, ObjectName scope, ObjectName name, QueryExp query) throws ConfigServiceException {
        ObjectName[] result;
        Session session;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "queryConfigObjects", new Object[]{inSession, scope, name, query});
            }
            this.checkAdminContext();
            this.initialize();
            session = inSession;
            if (session == null) {
                session = new Session();
            }
            result = null;
            try {
                ConfigDataId configId = ConfigServiceHelper.getConfigDataId(name);
                if (configId != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configId", configId);
                    }
                    ObjectName resolved = null;
                    try {
                        resolved = WorkspaceHelper.getDocAccessor(session, configId).resolveObjectName(session, configId);
                    }
                    catch (Exception e) {
                        resolved = null;
                    }
                    if (resolved == null) {
                        ObjectName[] e = null;
                        Object var15_13 = null;
                        if (inSession != null) return e;
                        this.discard(session);
                        return e;
                    }
                    if (ConfigServiceHelper.getDisplayName(resolved) == null && ConfigServiceHelper.getDisplayName(name) != null) {
                        resolved = ConfigServiceHelper.createObjectName(ConfigServiceHelper.getConfigDataId(resolved), ConfigServiceHelper.getConfigDataType(resolved), ConfigServiceHelper.getDisplayName(name));
                    }
                    result = new ObjectName[]{resolved};
                    break block15;
                }
                ConfigServiceDelegator delegator = WorkspaceHelper.getDelegator(session, name);
                String displayName = ConfigServiceHelper.getDisplayName(name);
                ObjectName[] configObjects = delegator == null ? this.getAllBasic(session, scope, ConfigServiceHelper.getConfigDataType(name), true) : (delegator instanceof RootObjectDelegator && displayName != null ? ((RootObjectDelegator)delegator).getAll(session, scope, displayName) : delegator.getAll(session, scope));
                ArrayList<ObjectName> selected = new ArrayList<ObjectName>(configObjects.length);
                for (int i = 0; i < configObjects.length; ++i) {
                    if (displayName != null && !displayName.equals(ConfigServiceHelper.getDisplayName(configObjects[i]))) continue;
                    selected.add(configObjects[i]);
                }
                Iterator itr = selected.iterator();
                while (itr.hasNext()) {
                    ObjectName objName = (ObjectName)itr.next();
                    if (this.checkAccess(session, objName)) continue;
                    itr.remove();
                }
                result = new ObjectName[selected.size()];
                selected.toArray(result);
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (inSession == null) {
                    this.discard(session);
                }
                throw throwable;
            }
        }
        Object var15_14 = null;
        if (inSession == null) {
            this.discard(session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryConfigObjects", result);
        }
        return result;
    }

    public ObjectName[] resolve(Session inSession, String containmentPath) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{inSession, containmentPath});
        }
        this.checkAdminContext();
        return this.resolve(inSession, null, containmentPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] resolve(Session inSession, ObjectName scope, String containmentPath) throws ConfigServiceException {
        ObjectName[] result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{inSession, scope, containmentPath});
        }
        this.checkAdminContext();
        this.initialize();
        Session session = inSession;
        if (session == null) {
            session = new Session();
        }
        ArrayList matches = new ArrayList();
        try {
            AttributeList typeNamePairs;
            boolean isValidXPath;
            block13: {
                isValidXPath = false;
                try {
                    if (containmentPath.indexOf("/") != -1 || containmentPath.indexOf("[") != -1) {
                        typeNamePairs = this.parseXPathContainment(containmentPath);
                        this.resolveXPath(session, scope, typeNamePairs, matches);
                        isValidXPath = true;
                    }
                }
                catch (Throwable t) {
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug(tc, "Exception caught while parsing XPath", t);
                }
            }
            if (!isValidXPath) {
                typeNamePairs = this.parseContainmentPath(containmentPath);
                Attribute rootQuery = (Attribute)typeNamePairs.remove(0);
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, rootQuery.getName(), (String)rootQuery.getValue());
                if (pattern == null) {
                    throw new MalformedContainmentPathException(containmentPath, rootQuery.getName());
                }
                ObjectName[] roots = this.queryConfigObjects(session, scope, pattern, null);
                for (int i = 0; roots != null && i < roots.length; ++i) {
                    this.resolve(session, roots[i], (AttributeList)typeNamePairs.clone(), matches);
                }
            }
            result = new ObjectName[matches.size()];
            matches.toArray(result);
            Object var14_14 = null;
            if (inSession == null) {
                this.discard(session);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (inSession == null) {
                this.discard(session);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName createConfigDataByTemplate(Session inSession, ObjectName parent, String attributeName, AttributeList attrList, ObjectName template) throws ConfigServiceException {
        ObjectName result;
        block11: {
            Session session;
            block12: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "createConfigDataByTemplate", new Object[]{inSession, parent, attributeName, this.maskPasswordInAttrList(attrList), template});
                }
                this.checkAdminContext();
                this.initialize();
                session = inSession;
                if (session == null) {
                    session = new Session();
                }
                boolean success = false;
                result = null;
                try {
                    ConfigServiceDelegator delegator;
                    if (template != null) {
                        ConfigServiceHelper.setAttributeValue(attrList, "_Websphere_Config_Data_Template", template);
                    }
                    result = (delegator = WorkspaceHelper.getDelegator(session, parent)) == null ? this.createConfigDataBasic(session, parent, attributeName, attrList) : delegator.createConfigData(session, parent, attributeName, attrList);
                    success = true;
                    Object var11_10 = null;
                    if (inSession != null) break block11;
                    if (!success) break block12;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (inSession == null) {
                        if (success) {
                            try {
                                this.save(session, false);
                            }
                            catch (ConfigDocumentSaveException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.createConfigData", (String)"359", (Object)this);
                                Tr.error(tc, "ADMG0011E", ex);
                            }
                        }
                        this.discard(session);
                    }
                    throw throwable;
                }
                try {
                    this.save(session, false);
                }
                catch (ConfigDocumentSaveException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.createConfigData", (String)"359", (Object)this);
                    Tr.error(tc, "ADMG0011E", ex);
                }
            }
            this.discard(session);
            {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigDataByTemplate", result);
        }
        return result;
    }

    public ObjectName createConfigData(Session inSession, ObjectName parent, String attributeName, String type, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{inSession, parent, attributeName, type, this.maskPasswordInAttrList(attrList)});
        }
        this.checkAdminContext();
        this.initialize();
        if (type != null && type.length() > 0) {
            ConfigServiceHelper.setAttributeValue(attrList, "_Websphere_Config_Data_Type", type);
        }
        ObjectName result = this.createConfigDataByTemplate(inSession, parent, attributeName, attrList, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigData", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Session inSession, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        block9: {
            Session session;
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "setAttributes", new Object[]{inSession, configData, this.maskPasswordInAttrList(attrList)});
                }
                this.checkAdminContext();
                this.initialize();
                session = inSession;
                if (session == null) {
                    session = new Session();
                }
                boolean success = false;
                try {
                    ConfigServiceDelegator delegator = WorkspaceHelper.getDelegator(session, configData);
                    if (delegator == null) {
                        this.setAttributesBasic(session, configData, attrList);
                    } else {
                        delegator.setAttributes(session, configData, attrList);
                    }
                    success = true;
                    Object var8_7 = null;
                    if (inSession != null) break block9;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (inSession == null) {
                        if (success) {
                            this.save(session, false);
                        }
                        this.discard(session);
                    }
                    throw throwable;
                }
                this.save(session, false);
            }
            this.discard(session);
            {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(Session inSession, ObjectName configData, String attribute, Object element, int position) throws ConfigServiceException {
        block9: {
            Session session;
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "addElement", new Object[]{inSession, configData, attribute, element, new Integer(position)});
                }
                this.checkAdminContext();
                this.initialize();
                session = inSession;
                if (session == null) {
                    session = new Session();
                }
                boolean success = false;
                try {
                    ConfigServiceDelegator delegator = WorkspaceHelper.getDelegator(session, configData);
                    if (delegator == null) {
                        this.addElementBasic(session, configData, attribute, element, position);
                    } else {
                        delegator.addElement(session, configData, attribute, element, position);
                    }
                    success = true;
                    Object var10_9 = null;
                    if (inSession != null) break block9;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (inSession == null) {
                        if (success) {
                            this.save(session, false);
                        }
                        this.discard(session);
                    }
                    throw throwable;
                }
                this.save(session, false);
            }
            this.discard(session);
            {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addElement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(Session inSession, ObjectName configData, String attribute, Object element) throws ConfigServiceException {
        block9: {
            Session session;
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "removeElement", new Object[]{inSession, configData, attribute, element});
                }
                this.checkAdminContext();
                this.initialize();
                session = inSession;
                if (session == null) {
                    session = new Session();
                }
                boolean success = false;
                try {
                    ConfigServiceDelegator delegator = WorkspaceHelper.getDelegator(session, configData);
                    if (delegator == null) {
                        this.removeElementBasic(session, configData, attribute, element);
                    } else {
                        delegator.removeElement(session, configData, attribute, element);
                    }
                    success = true;
                    Object var9_8 = null;
                    if (inSession != null) break block9;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (inSession == null) {
                        if (success) {
                            this.save(session, false);
                        }
                        this.discard(session);
                    }
                    throw throwable;
                }
                this.save(session, false);
            }
            this.discard(session);
            {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeElement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetAttributes(Session inSession, ObjectName configData, String[] attributes) throws ConfigServiceException {
        block9: {
            Session session;
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "unsetAttributes", new Object[]{inSession, configData, attributes});
                }
                this.checkAdminContext();
                this.initialize();
                session = inSession;
                if (session == null) {
                    session = new Session();
                }
                boolean success = false;
                try {
                    ConfigServiceDelegator delegator = WorkspaceHelper.getDelegator(session, configData);
                    if (delegator == null) {
                        this.unsetAttributesBasic(session, configData, attributes);
                    } else {
                        delegator.unsetAttributes(session, configData, attributes);
                    }
                    success = true;
                    Object var8_7 = null;
                    if (inSession != null) break block9;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (inSession == null) {
                        if (success) {
                            this.save(session, false);
                        }
                        this.discard(session);
                    }
                    throw throwable;
                }
                this.save(session, false);
            }
            this.discard(session);
            {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAttributes(Session inSession, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        block9: {
            Session session;
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "resetAttributes", new Object[]{inSession, configData, this.maskPasswordInAttrList(attrList)});
                }
                this.checkAdminContext();
                this.initialize();
                session = inSession;
                if (session == null) {
                    session = new Session();
                }
                boolean success = false;
                try {
                    ConfigServiceDelegator delegator = WorkspaceHelper.getDelegator(session, configData);
                    if (delegator == null) {
                        this.resetAttributesBasic(session, configData, attrList);
                    } else {
                        delegator.resetAttributes(session, configData, attrList);
                    }
                    success = true;
                    Object var8_7 = null;
                    if (inSession != null) break block9;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (inSession == null) {
                        if (success) {
                            this.save(session, false);
                        }
                        this.discard(session);
                    }
                    throw throwable;
                }
                this.save(session, false);
            }
            this.discard(session);
            {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(Session inSession, ObjectName configData, String[] attributes, boolean recursive) throws ConfigServiceException {
        AttributeList result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{inSession, configData, attributes, new Boolean(recursive)});
        }
        this.checkAdminContext();
        this.initialize();
        Session session = inSession;
        if (session == null) {
            session = new Session();
        }
        boolean success = false;
        try {
            ConfigServiceDelegator delegator = WorkspaceHelper.getDelegator(session, configData);
            result = delegator == null ? this.getAttributesBasic(session, configData, attributes, recursive) : delegator.getAttributes(session, configData, attributes, recursive);
            Object var10_9 = null;
            if (inSession == null) {
                this.discard(session);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (inSession == null) {
                this.discard(session);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(Session inSession, ObjectName configData, String attribute) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{inSession, configData, attribute});
        }
        this.checkAdminContext();
        this.initialize();
        Session session = inSession;
        if (session == null) {
            session = new Session();
        }
        Object result = null;
        try {
            ConfigServiceDelegator delegator = WorkspaceHelper.getDelegator(session, configData);
            result = delegator == null ? this.getAttributeBasic(session, configData, attribute) : delegator.getAttribute(session, configData, attribute);
            Object var8_7 = null;
            if (inSession == null) {
                this.discard(session);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (inSession == null) {
                this.discard(session);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", result);
        }
        return result;
    }

    public Object getAttribute(Session session, ObjectName configData, String attribute, boolean recursive) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Enter - ConfigServiceImpl.getAttribute.new", new Object[]{session, configData, attribute, new Boolean(recursive)});
        }
        this.checkAdminContext();
        if (recursive) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exit  - ConfigServiceImpl.getAttribute.new", new Object[]{session, configData, attribute, new Boolean(recursive)});
            }
            return this.getAttribute(session, configData, attribute);
        }
        AttributeList attrList = this.getAttributes(session, configData, new String[]{attribute}, false);
        Object result = null;
        try {
            result = ConfigServiceHelper.getAttributeValue(attrList, attribute);
        }
        catch (AttributeNotFoundException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.websphere.management.configservice.ConfigServiceHelper.getConfigDataId", (String)"39");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exit  - ConfigServiceImpl.getAttribute.new", new Object[]{session, configData, attribute, new Boolean(recursive)});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteConfigData(Session inSession, ObjectName configData) throws ConfigServiceException {
        block13: {
            Session session;
            block14: {
                String type;
                ConfigDataId id;
                boolean success;
                block11: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "deleteConfigData", new Object[]{inSession, configData});
                    }
                    this.checkAdminContext();
                    this.initialize();
                    session = inSession;
                    if (session == null) {
                        session = new Session();
                    }
                    success = false;
                    id = ConfigServiceHelper.getConfigDataId(configData);
                    type = null;
                    try {
                        type = ConfigServiceHelper.getConfigDataType(configData);
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "Exception ", e.getMessage());
                    }
                }
                try {
                    block12: {
                        ConfigServiceDelegator delegator = WorkspaceHelper.getDelegator(session, configData);
                        if (delegator == null) {
                            this.deleteConfigDataBasic(session, configData);
                        } else {
                            delegator.deleteConfigData(session, configData);
                        }
                        success = true;
                        try {
                            String resName = id.toString();
                            this.notifyAuthzGroup(this, session, resName, type);
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block12;
                            Tr.debug(tc, "Exception ", e.getMessage());
                        }
                    }
                    Object var10_11 = null;
                    if (inSession != null) break block13;
                    if (!success) break block14;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (inSession != null) throw throwable;
                    if (success) {
                        this.save(session, false);
                        throw throwable;
                    }
                    this.discard(session);
                    throw throwable;
                }
                this.save(session, false);
                break block13;
            }
            this.discard(session);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "deleteConfigData");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getRelationships(Session inSession, ObjectName configData, String[] relationshipNames) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{inSession, configData, relationshipNames});
        }
        this.checkAdminContext();
        this.initialize();
        Session session = inSession;
        if (session == null) {
            session = new Session();
        }
        AttributeList attrList = new AttributeList();
        try {
            for (int i = 0; i < relationshipNames.length; ++i) {
                try {
                    ObjectName[] value = this.getRelationship(session, configData, relationshipNames[i]);
                    attrList.add(new Attribute(relationshipNames[i], value));
                    continue;
                }
                catch (InvalidAttributeNameException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.getRelationships", (String)"611", (Object)this);
                }
            }
            Object var9_9 = null;
            if (inSession == null) {
                this.discard(session);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (inSession == null) {
                this.discard(session);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationships", attrList);
        }
        return attrList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getRelationship(Session inSession, ObjectName configData, String relationship) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationship", new Object[]{inSession, configData, relationship});
        }
        this.checkAdminContext();
        this.initialize();
        Session session = inSession;
        if (session == null) {
            session = new Session();
        }
        ObjectName[] result = null;
        try {
            ConfigServiceDelegator delegator = WorkspaceHelper.getDelegator(session, configData);
            result = delegator == null ? this.getRelationshipBasic(session, configData, relationship) : delegator.getRelationship(session, configData, relationship);
            Object var8_7 = null;
            if (inSession == null) {
                this.discard(session);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (inSession == null) {
                this.discard(session);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationship", result);
        }
        return result;
    }

    public AttributeList getRelationshipsMetaInfoBasic(String configObjectType) throws InvalidConfigDataTypeException {
        this.checkAdminContext();
        TypeRegistry.getMetaObject(configObjectType);
        return new AttributeList();
    }

    public AttributeList getAttributesMetaInfoBasic(String configDataType) throws InvalidConfigDataTypeException {
        this.checkAdminContext();
        return MOFUtil.getAttributesMetaInfo(TypeRegistry.getMetaObject(configDataType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName createConfigDataBasic(Session session, ObjectName parent, String attributeName, AttributeList attrList) throws ConfigServiceException {
        this.checkAdminContext();
        ConfigDataId parentId = ConfigServiceHelper.getConfigDataId(parent);
        DocAccessor accessor = WorkspaceHelper.getDocAccessor(session, parentId);
        try {
            ObjectName result = accessor.createConfigData(session, parentId, attributeName, attrList, false);
            accessor.localSave();
            ObjectName objectName = result;
            Object var10_9 = null;
            accessor.cleanup();
            return objectName;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            accessor.cleanup();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributesBasic(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        this.checkAdminContext();
        ConfigDataId id = ConfigServiceHelper.getConfigDataId(configData);
        DocAccessor accessor = WorkspaceHelper.getDocAccessor(session, id);
        try {
            accessor.setAttributes(session, id, attrList);
            accessor.localSave();
            Object var7_6 = null;
            accessor.cleanup();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            accessor.cleanup();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElementBasic(Session session, ObjectName configData, String attribute, Object element, int position) throws ConfigServiceException {
        this.checkAdminContext();
        ConfigDataId id = ConfigServiceHelper.getConfigDataId(configData);
        DocAccessor accessor = WorkspaceHelper.getDocAccessor(session, id);
        try {
            accessor.addElementAt(session, id, attribute, element, position, false);
            accessor.localSave();
            Object var9_8 = null;
            accessor.cleanup();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            accessor.cleanup();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElementBasic(Session session, ObjectName configData, String attribute, Object element) throws ConfigServiceException {
        this.checkAdminContext();
        ConfigDataId id = ConfigServiceHelper.getConfigDataId(configData);
        DocAccessor accessor = WorkspaceHelper.getDocAccessor(session, id);
        try {
            accessor.removeElement(session, id, attribute, element);
            accessor.localSave();
            Object var8_7 = null;
            accessor.cleanup();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            accessor.cleanup();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetAttributesBasic(Session session, ObjectName configData, String[] attributes) throws ConfigServiceException {
        this.checkAdminContext();
        ConfigDataId id = ConfigServiceHelper.getConfigDataId(configData);
        DocAccessor accessor = WorkspaceHelper.getDocAccessor(session, id);
        try {
            accessor.unsetAttributes(session, id, attributes);
            accessor.localSave();
            Object var7_6 = null;
            accessor.cleanup();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            accessor.cleanup();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAttributesBasic(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        this.checkAdminContext();
        ConfigDataId id = ConfigServiceHelper.getConfigDataId(configData);
        DocAccessor accessor = null;
        try {
            accessor = WorkspaceHelper.getDocAccessor(session, id);
            accessor.resetAttributes(session, id, attrList);
            accessor.localSave();
            Object var7_6 = null;
            if (accessor != null) {
                accessor.cleanup();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (accessor != null) {
                accessor.cleanup();
            }
            throw throwable;
        }
    }

    public AttributeList getAttributesBasic(Session session, ObjectName configData, String[] attributes, boolean recursive) throws ConfigServiceException {
        this.checkAdminContext();
        ConfigDataId id = ConfigServiceHelper.getConfigDataId(configData);
        DocAccessor accessor = WorkspaceHelper.getDocAccessor(session, id);
        return accessor.getAttributes(session, id, attributes, recursive);
    }

    public Object getAttributeBasic(Session session, ObjectName configData, String attribute) throws ConfigServiceException {
        this.checkAdminContext();
        ConfigDataId id = ConfigServiceHelper.getConfigDataId(configData);
        DocAccessor accessor = WorkspaceHelper.getDocAccessor(session, id);
        return accessor.getAttribute(session, id, attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConfigDataBasic(Session session, ObjectName configData) throws ConfigServiceException {
        this.checkAdminContext();
        ConfigDataId id = ConfigServiceHelper.getConfigDataId(configData);
        DocAccessor accessor = WorkspaceHelper.getDocAccessor(session, id);
        try {
            accessor.deleteConfigData(session, id);
            accessor.localSave();
            Object var6_5 = null;
            accessor.cleanup();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            accessor.cleanup();
            throw throwable;
        }
    }

    public ObjectName[] getRelationshipBasic(Session session, ObjectName configData, String relationship) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationshipBasic", new Object[]{session, configData, relationship});
        }
        this.checkAdminContext();
        if (relationship.equals("parent")) {
            EObject obj = MOFUtil.convertToEObject(session, configData);
            EObject parent = obj.eContainer();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parent", parent);
            }
            if (parent != null) {
                ObjectName[] result = new ObjectName[]{MOFUtil.createObjectName(parent)};
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getRelationshipBasic", result);
                }
                return result;
            }
        }
        throw new UnsupportedOperationException();
    }

    public ObjectName[] getAllBasic(Session session, ObjectName scope, String type, boolean configDocumentOnly) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllBasic", scope);
        }
        this.checkAdminContext();
        ObjectName[] arrayResult = null;
        if (scope == null || WorkspaceHelper.isScopeContext(session, scope)) {
            ArrayList<ObjectName> result = new ArrayList<ObjectName>();
            Collection rootContexts = WorkspaceHelper.getScopeContexts(session, scope);
            for (RepositoryContext context : rootContexts) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "context", context.getURI());
                }
                List docs = context.getAllList(true);
                for (WorkSpaceFile file : docs) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "file", file);
                    }
                    if (!file.toString().endsWith("xml")) continue;
                    boolean validDoc = true;
                    if (configDocumentOnly) {
                        validDoc = WorkspaceHelper.isConfigDocument(context.getType(), file.getFileName());
                    }
                    if (!validDoc) continue;
                    DocAccessor docAccessor = null;
                    try {
                        docAccessor = WorkspaceHelper.getDocAccessor(session, file);
                    }
                    catch (Exception e) {
                        docAccessor = null;
                        continue;
                    }
                    ObjectName[] selected = docAccessor.getTypedObjects(session, type);
                    for (int j = 0; selected != null && j < selected.length; ++j) {
                        result.add(selected[j]);
                    }
                }
            }
            arrayResult = new ObjectName[result.size()];
            result.toArray(arrayResult);
        } else {
            ConfigDataId id = ConfigServiceHelper.getConfigDataId(scope);
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, id);
            EObject scopeObj = docAccessor.lookup(id);
            arrayResult = docAccessor.getTypedObjects(type, scopeObj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAll", arrayResult);
        }
        return arrayResult;
    }

    ConfigServiceDelegator getDelegator(String type) {
        return (ConfigServiceDelegator)this.delegatorTable.get(type);
    }

    private String generateRelationshipName(ConfigServiceDelegator delegator) {
        String type = delegator.getType();
        return type;
    }

    private void resolve(Session session, ObjectName parent, AttributeList containmentPath, List result) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, parent, containmentPath, result});
        }
        if (containmentPath.size() > 0) {
            Attribute currentQuery = (Attribute)containmentPath.get(0);
            String type = currentQuery.getName();
            String objectName = (String)currentQuery.getValue();
            try {
                ObjectName[] matches = this.getRelationship(session, parent, type);
                containmentPath.remove(0);
                for (int i = 0; matches != null && i < matches.length; ++i) {
                    if (objectName != null) {
                        if (!objectName.equals(ConfigServiceHelper.getDisplayName(matches[i]))) continue;
                        this.resolve(session, matches[i], new AttributeList(containmentPath), result);
                        continue;
                    }
                    this.resolve(session, matches[i], new AttributeList(containmentPath), result);
                }
            }
            catch (InvalidAttributeNameException ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ConfigServiceImpl.resolve() has caught InvalidAttributeNameException");
                }
                DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, ConfigServiceHelper.getConfigDataId(parent));
                docAccessor.resolve(session, parent, containmentPath, result);
            }
        } else {
            result.add(parent);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Exiting ConfigServiceImpl.resolve().  The current function argument values are : ", new Object[]{session, parent, containmentPath, result});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve");
        }
    }

    private void resolveXPath(Session session, ObjectName parent, AttributeList containmentPath, List result) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveXPath", new Object[]{session, parent, containmentPath, result});
        }
        if (containmentPath.size() > 0) {
            Attribute currentQuery = (Attribute)containmentPath.get(0);
            String axisName = currentQuery.getName();
            Attribute typeNamePairs = this.getPredicateAttribute((String)currentQuery.getValue());
            try {
                ObjectName[] matches;
                if (parent == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resolve Root element " + axisName);
                    }
                    ObjectName pattern = ConfigServiceHelper.createObjectName(null, axisName);
                    matches = this.queryConfigObjects(session, null, pattern, null);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resolve element " + axisName + " parent: " + ConfigServiceHelper.getDisplayName(parent));
                    }
                    matches = this.getRelationship(session, parent, axisName);
                }
                containmentPath.remove(0);
                boolean matchPredicateResult = false;
                for (int i = 0; matches != null && i < matches.length; ++i) {
                    block16: {
                        ArrayList attrMatchResult = new ArrayList();
                        if (typeNamePairs != null) {
                            try {
                                String predicateName = typeNamePairs.getName();
                                if (predicateName.startsWith("@")) {
                                    matchPredicateResult = this.matchXPathAttribute(session, matches[i], typeNamePairs);
                                    break block16;
                                }
                                ObjectName[] matchedAttribute = this.getRelationship(session, matches[i], typeNamePairs.getName());
                                String predicateValue = (String)typeNamePairs.getValue();
                                for (int j = 0; j < matchedAttribute.length; ++j) {
                                    if (predicateValue != null && !predicateValue.equals(ConfigServiceHelper.getDisplayName(matchedAttribute[i]))) continue;
                                    matchPredicateResult = true;
                                    break;
                                }
                            }
                            catch (InvalidAttributeNameException iane) {
                                matchPredicateResult = this.matchXPathAttribute(session, matches[i], typeNamePairs);
                            }
                        }
                    }
                    if (typeNamePairs != null && !matchPredicateResult) continue;
                    this.resolveXPath(session, matches[i], containmentPath, result);
                }
            }
            catch (InvalidAttributeNameException ex) {
                DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, ConfigServiceHelper.getConfigDataId(parent));
                docAccessor.resolveXPath(session, parent, containmentPath, result);
            }
        } else {
            result.add(parent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveXPath", result);
        }
    }

    private boolean matchXPathAttribute(Session session, ObjectName parent, Attribute predicate) {
        boolean matchResult;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resolveXPathAttribute", new Object[]{session, parent, predicate});
            }
            matchResult = false;
            String key = predicate.getName();
            if (key.startsWith("@")) {
                key = key.substring(1);
            }
            String value = (String)predicate.getValue();
            try {
                String attributeValue;
                Object attribute = this.getAttribute(session, parent, key);
                if (attribute instanceof AttributeList) {
                    ObjectName attributeObjName = ConfigServiceHelper.createObjectName((AttributeList)attribute);
                    attributeValue = ConfigServiceHelper.getDisplayName(attributeObjName);
                } else {
                    attributeValue = attribute.toString();
                }
                if (value == null || attributeValue.equals(value)) {
                    matchResult = true;
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception captured, assume no matching attribute");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveXPathAttribute", new Boolean(matchResult));
        }
        return matchResult;
    }

    private AttributeList parseContainmentPath(String containmentPath) throws MalformedContainmentPathException, InvalidConfigDataTypeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseContainmentPath", containmentPath);
        }
        StringTokenizer tokenizer = new StringTokenizer(containmentPath, ":");
        AttributeList result = new AttributeList();
        while (tokenizer.hasMoreTokens()) {
            int index;
            String token = tokenizer.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token", token);
            }
            String key = (index = token.indexOf(61)) == -1 ? token : token.substring(0, index);
            key = key.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "key", key);
            }
            TypeRegistry.getMetaObject(key);
            if (key.length() == 0) {
                throw new MalformedContainmentPathException(containmentPath, token);
            }
            String value = index == -1 || index == token.length() - 1 ? "" : token.substring(index + 1);
            if ((value = value.trim()).startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            if (value.length() == 0) {
                value = null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value", value);
            }
            result.add(new Attribute(key, value));
        }
        if (result.size() == 0) {
            throw new MalformedContainmentPathException(containmentPath, containmentPath);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseContainmentPath", result);
        }
        return result;
    }

    private AttributeList parseXPathContainment(String locationPath) throws MalformedContainmentPathException, InvalidConfigDataTypeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseXPathContainment", locationPath);
        }
        StringTokenizer xpathToken = new StringTokenizer(locationPath, "/");
        AttributeList result = new AttributeList();
        String axisName = null;
        String predicate = null;
        ArrayList parents = new ArrayList();
        while (xpathToken.hasMoreTokens()) {
            String locationStep = xpathToken.nextToken();
            if (locationStep == null && locationStep == "") continue;
            int axisindex = locationStep.indexOf("[");
            if (axisindex != -1) {
                axisName = locationStep.substring(0, locationStep.indexOf("["));
                predicate = locationStep.substring(axisindex + 1, locationStep.indexOf("]"));
            } else {
                axisName = locationStep;
            }
            if (axisName == null || axisName.length() == 0) {
                throw new MalformedContainmentPathException(locationPath, locationStep);
            }
            result.add(new Attribute(axisName, predicate));
        }
        if (result.size() == 0) {
            throw new MalformedContainmentPathException(locationPath, locationPath);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseXPathContainment", result);
        }
        return result;
    }

    private Attribute getPredicateAttribute(String predicate) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPredicateAttribute", predicate);
        }
        Attribute expresssionAttribute = null;
        if (predicate != null && predicate != "") {
            String expressionKey = predicate.substring(0, predicate.indexOf("="));
            String expressionValue = predicate.substring(predicate.indexOf("=") + 2, predicate.lastIndexOf("'"));
            AttributeList expresssionAttrList = new AttributeList();
            expresssionAttribute = new Attribute(expressionKey, expressionValue);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPredicateAttribute", expresssionAttribute);
        }
        return expresssionAttribute;
    }

    public static ConfigServiceImpl getInstance() {
        ConfigServiceImpl inst = null;
        String pKey = AdminContext.peek();
        inst = pKey != null ? (ConfigServiceImpl)AdminSubsystemServiceRegistry.getService((String)ConfigService.class.getName()) : instance;
        return inst;
    }

    private boolean checkAccess(Session session, ObjectName obj) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", obj);
        }
        AdminAuthorizer aa = AdminAuthorizerFactory.getAdminAuthorizer();
        if (obj == null || aa == null) {
            return true;
        }
        String res = ConfigServiceHelper.getConfigDataId(obj).toString();
        String fileName = null;
        try {
            EObject eobj = MOFUtil.convertToEObject(session, obj);
            fileName = eobj.eResource().getURI().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (aa != null) {
            if (fileName != null && fileName.endsWith("admin-authz.xml")) {
                return aa.checkAccess(res, "adminsecuritymanager");
            }
            if (fileName != null && fileName.endsWith("audit-authz.xml")) {
                return aa.checkAccess(res, "auditor");
            }
            return aa.checkAccess(res, "monitor");
        }
        return true;
    }

    private void notifyAuthzGroup(ConfigService cs, Session session, String res, String type) throws Exception {
        final ConfigService csFinal = cs;
        final Session sessionFinal = session;
        final String resFinal = res;
        final String typeFinal = type;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthzGroupUtil.removeResourceFromAuthorizationGroup(csFinal, sessionFinal, resFinal, typeFinal);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
    }

    private AttributeList maskPasswordInAttrList(AttributeList attributelist) {
        AttributeList attributelist1 = new AttributeList();
        for (int i = 0; attributelist != null && i < attributelist.size(); ++i) {
            String s = ((Attribute)attributelist.get(i)).getName();
            Object obj = ((Attribute)attributelist.get(i)).getValue();
            if (s != null && s.trim().equalsIgnoreCase("password")) {
                attributelist1.add(new Attribute(s, "****"));
                continue;
            }
            attributelist1.add(new Attribute(s, obj));
        }
        return attributelist1;
    }

    public void checkAdminContext() {
        String uuid = AdminContext.peek();
        if (this.endpointUUID == uuid || this.endpointUUID != null && this.endpointUUID.equals(uuid) || uuid != null && uuid.equals(this.endpointUUID)) {
            return;
        }
        IllegalStateException ex = new IllegalStateException("ConfigServiceImpl was created for admin subsystem " + this.endpointUUID + " but top of AdminContext stack  contains: " + uuid);
        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.ConfigServiceImpl.checkAdminContext", (String)"1843");
        throw ex;
    }
}

