/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public abstract class ConfigObjectDelegator
extends ConfigServiceDelegator {
    private static TraceComponent tc = Tr.register(ConfigObjectDelegator.class, "management", "com.ibm.ws.management.resources.configservice");
    protected final String PARENT = "parent";
    protected Set parentTypes = new HashSet();
    protected List childTypes = new ArrayList();

    public ConfigObjectDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService);
    }

    protected abstract ObjectName[] getChildren(Session var1, ObjectName var2, ChildTypeInfo var3) throws ConfigServiceException;

    protected abstract ObjectName createConfigObject(Session var1, ObjectName var2, ChildTypeInfo var3, AttributeList var4) throws ConfigServiceException;

    protected abstract ObjectName getParent(Session var1, ObjectName var2) throws ConfigServiceException;

    public AttributeList getRelationshipsMetaInfo(String configObjectType) throws InvalidConfigDataTypeException {
        AttributeList metaInfo = new AttributeList();
        if (this.parentTypes.size() > 0) {
            AttributeList parentInfo = new AttributeList();
            parentInfo.add(new Attribute("_Attribute_MetaInfo_Name", "parent"));
            parentInfo.add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
            parentInfo.add(new Attribute("_Attribute_MetaInfo_Type", new ArrayList(this.parentTypes)));
            metaInfo.add(new Attribute("parent", parentInfo));
        }
        if (tc.isDebugEnabled() && this.parentTypes.size() > 0) {
            Iterator iter = this.parentTypes.iterator();
            while (iter.hasNext()) {
                Tr.debug(tc, "parent ", iter.next());
            }
        }
        for (ChildTypeInfo childTypeInfo : this.childTypes) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "child ", childTypeInfo);
            }
            AttributeList childInfo = new AttributeList();
            childInfo.add(new Attribute("_Attribute_MetaInfo_Name", childTypeInfo.getRelationshipName()));
            childInfo.add(new Attribute("_Attribute_MetaInfo_Type", childTypeInfo.getChildDelegator().getType()));
            childInfo.add(new Attribute("_Attribute_MetaInfo_Is_Collection", new Boolean(childTypeInfo.isCollection())));
            metaInfo.add(new Attribute(childTypeInfo.getRelationshipName(), childInfo));
        }
        return metaInfo;
    }

    public ObjectName[] getRelationship(Session session, ObjectName configData, String relationship) throws ConfigServiceException {
        ObjectName[] result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationship", new Object[]{configData, relationship});
        }
        if (relationship.equals("parent")) {
            ObjectName parent = this.getParent(session, configData);
            result = new ObjectName[]{parent};
        } else {
            ChildTypeInfo childTypeInfo = this.getChildInfo(relationship);
            result = childTypeInfo.getChildDelegator().getChildren(session, configData, childTypeInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationship", result);
        }
        return result;
    }

    public ObjectName createConfigData(Session session, ObjectName parent, String attributeName, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{session, parent, attributeName, attrList});
        }
        ChildTypeInfo childTypeInfo = null;
        try {
            childTypeInfo = this.getChildInfo(attributeName);
        }
        catch (InvalidAttributeNameException ex) {
            // empty catch block
        }
        ObjectName result = childTypeInfo != null ? childTypeInfo.getChildDelegator().createConfigObject(session, parent, childTypeInfo, attrList) : this.baseConfigService.createConfigDataBasic(session, parent, attributeName, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigData", new Object[]{result});
        }
        return result;
    }

    public void removeElement(Session session, ObjectName configData, String attribute, Object element) throws ConfigServiceException {
        try {
            ChildTypeInfo childTypeInfo = this.getChildInfo(attribute);
            throw new UnsupportedOperationException();
        }
        catch (InvalidAttributeNameException ex) {
            this.baseConfigService.removeElementBasic(session, configData, attribute, element);
            return;
        }
    }

    protected final void registerChildType(String relationshipName, boolean isCollection, ConfigObjectDelegator childDelegator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "regsiterChildType", new Object[]{relationshipName, this.getType()});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "child type", new Object[]{childDelegator.getType()});
        }
        this.childTypes.add(new ChildTypeInfo(relationshipName, isCollection, childDelegator));
        childDelegator.registerParentType(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "regsiterChildType");
        }
    }

    protected final void registerParentType(ConfigObjectDelegator parentDelegator) {
        List allTypes;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "regsiterParentType", new Object[]{parentDelegator.getType()});
        }
        if ((allTypes = parentDelegator.getTypes()) != null) {
            for (String tt : allTypes) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "type ", tt);
            }
        }
        if (allTypes != null) {
            this.parentTypes.addAll(allTypes);
        } else {
            this.parentTypes.add(parentDelegator.getType());
        }
    }

    protected ObjectName getMOFParent(Session session, ObjectName kid) throws ConfigServiceException {
        ConfigDataId id = ConfigServiceHelper.getConfigDataId(kid);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, id);
        return docAccessor.getParent(session, id);
    }

    protected ChildTypeInfo getChildInfo(String relationshipName) throws InvalidAttributeNameException {
        ChildTypeInfo result = null;
        for (ChildTypeInfo childTypeInfo : this.childTypes) {
            if (!childTypeInfo.getRelationshipName().equals(relationshipName)) continue;
            result = childTypeInfo;
            break;
        }
        if (result == null) {
            throw new InvalidAttributeNameException(relationshipName);
        }
        return result;
    }

    protected List getTypedDocuments(RepositoryContext scope, String fileName) {
        List files = scope.getAllList(true);
        ArrayList<WorkSpaceFile> fileNames = new ArrayList<WorkSpaceFile>();
        for (WorkSpaceFile file : files) {
            if (!file.getFileName().equals(fileName)) continue;
            fileNames.add(file);
        }
        return fileNames;
    }

    protected ObjectName createObjectName(RepositoryContext context) {
        return MOFUtil.createObjectName(context);
    }

    protected static class ChildTypeInfo {
        private String relationshipName;
        private boolean isCollection;
        private ConfigObjectDelegator childDelegator;

        public ChildTypeInfo(String relationshipName, boolean isCollection, ConfigObjectDelegator childDelegator) {
            this.relationshipName = relationshipName;
            this.isCollection = isCollection;
            this.childDelegator = childDelegator;
        }

        public String getRelationshipName() {
            return this.relationshipName;
        }

        public boolean isCollection() {
            return this.isCollection;
        }

        public ConfigObjectDelegator getChildDelegator() {
            return this.childDelegator;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj != null && obj instanceof ChildTypeInfo) {
                result = this.relationshipName.equals(((ChildTypeInfo)obj).relationshipName);
            }
            return result;
        }

        public int hashcode() {
            return this.relationshipName.hashCode();
        }
    }
}

