/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.MetadataNotAvailableException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.websphere.models.config.coregroup.CoreGroupServer;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroup;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroupMember;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.bla.model.ModelHelper;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.security.common.util.MergeSecurityConfig;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.ImportCommand;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ImportWsprofile
extends ImportCommand {
    private static TraceComponent tc = Tr.register(ImportWsprofile.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private final String CELL_NAME = "CELL_NAME";
    private final String NODE_NAME = "NODE_NAME";
    private final String SERVER_NAME = "SERVER_NAME";
    private final String SERVER_INDEX = "SERVER_INDEX";
    private final String NODE_VARIABLE_MAP = "NODE_VARIABLE_MAP";
    private final String SYSTEM_APPS = "SYSTEM_APPS";
    private final String VIRTUAL_HOSTS = "VIRTUAL_HOSTS";
    private final String NUMBER_SERVERS = "NUMBER_SERVERS";
    private final String BASE_WAS_PRODUCT_SHORTNAME = "BASE_WAS_PRODUCT_SHORTNAME";
    private int oldServerCnt;

    public ImportWsprofile(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ImportWsprofile(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Node");
            ObjectName[] queryResult = configService.queryConfigObjects(session, null, pattern, null);
            if (queryResult.length != 1) {
                String msg = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configarchive", "ADMB0001E");
                throw new CommandValidationException(msg);
            }
            pattern = ConfigServiceHelper.createObjectName(null, "Server");
            ObjectName[] oldServers = queryResult = configService.queryConfigObjects(session, null, pattern, null);
            Session bundleSession = this.getConfigArchiveSession();
            queryResult = configService.queryConfigObjects(bundleSession, null, pattern = ConfigServiceHelper.createObjectName(null, "Node"), null);
            if (queryResult.length != 1) {
                String msg = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configarchive", "ADMB0003E");
                throw new CommandValidationException(msg);
            }
            pattern = ConfigServiceHelper.createObjectName(null, "Server");
            ObjectName[] newServers = queryResult = configService.queryConfigObjects(bundleSession, null, pattern, null);
            this.oldServerCnt = oldServers.length;
            if (oldServers.length > 0 && oldServers.length != newServers.length) {
                String msg = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configarchive", "ADMB0016E");
                throw new CommandValidationException(msg);
            }
            for (int i = 0; oldServers.length > 0 && i < oldServers.length; ++i) {
                String oldName = (String)ConfigServiceHelper.getObjectLocation(oldServers[i]).get("server");
                boolean match = false;
                for (int j = 0; j < newServers.length; ++j) {
                    String newName = (String)ConfigServiceHelper.getObjectLocation(newServers[j]).get("server");
                    if (!oldName.equals(newName)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                String msg = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configarchive", "ADMB0017E");
                throw new CommandValidationException(msg);
            }
        }
        catch (CommandValidationException ex) {
            throw ex;
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ImportWsprofile.validate", (String)"113");
            throw new CommandValidationException(th, "An unexpected exception is thrown.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            Properties props;
            List serversList;
            List children;
            RepositoryContext aContext;
            RepositoryContext aContextInArchive;
            RepositoryContext contextInArchive2;
            RepositoryMetaData metadata2;
            RepositoryContext rootContext;
            ObjectName pattern;
            WorkSpace archiveWorkspace;
            WorkSpace workspace;
            ConfigService configService;
            block41: {
                configService = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                workspace = WorkspaceHelper.getWorkspace(session);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "target workspace path ", workspace.getPath());
                }
                archiveWorkspace = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "archive workspace path ", archiveWorkspace.getPath());
                }
                pattern = ConfigServiceHelper.createObjectName(null, "Cell");
                ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
                configService.deleteConfigData(session, cell);
                rootContext = workspace.getRootContext();
                metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
                contextInArchive2 = (RepositoryContext)archiveWorkspace.findContext(metadata2.getContextType("cells")).iterator().next();
                RepositoryContext context = ConfigArchiveUtils.createContext(rootContext, (String)this.preImportData.get("CELL_NAME"), contextInArchive2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell context", context);
                }
                String cellName = context.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell name ", cellName);
                }
                aContextInArchive = contextInArchive2;
                aContext = context;
                children = contextInArchive2.getChildren();
                for (RepositoryContext child : children) {
                    if (child.getType().getName().equals("nodes") || child.getType().getName().equals("applications")) continue;
                    ConfigArchiveUtils.copyContext(context, child, null);
                }
                this.updateSecurity((String)this.preImportData.get("NODE_NAME"));
                Resource secRes = ConfigArchiveUtils.getResource(context, "security.xml");
                Security sec = (Security)secRes.getContents().get(0);
                MergeSecurityConfig.updateCellNameAndNodeName((Security)sec, (String)((String)this.preImportData.get("CELL_NAME")), (String)((String)this.preImportData.get("NODE_NAME")));
                secRes.save(Collections.EMPTY_MAP);
                Resource vhostResource = ConfigArchiveUtils.getResource(context, "virtualhosts.xml");
                EList vhostContent = vhostResource.getContents();
                List preImportVhost = (List)this.preImportData.get("VIRTUAL_HOSTS");
                ConfigArchiveUtils.mergeVirtualHostList(vhostContent, preImportVhost, "name", true);
                vhostResource.save(Collections.EMPTY_MAP);
                this.updateCellVariableMap(context, (String)this.preImportData.get("CELL_NAME"));
                RepositoryContext ngCtx = (RepositoryContext)context.findContext(metadata2.getContextType("nodegroups")).iterator().next();
                this.updateNodeGroup(ngCtx, (String)this.preImportData.get("NODE_NAME"));
                RepositoryContext cgCtx = (RepositoryContext)context.findContext(metadata2.getContextType("coregroups")).iterator().next();
                this.updateCoreGroup(cgCtx, (String)this.preImportData.get("NODE_NAME"));
                contextInArchive2 = (RepositoryContext)contextInArchive2.findContext(metadata2.getContextType("nodes")).iterator().next();
                context = ConfigArchiveUtils.createContext(context, (String)this.preImportData.get("NODE_NAME"), contextInArchive2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node context", context);
                }
                children = contextInArchive2.getChildren();
                for (RepositoryContext child : children) {
                    if (child.getType().getName().equals("servers")) continue;
                    ConfigArchiveUtils.copyContext(context, child, null);
                }
                Resource res = ConfigArchiveUtils.getResource(context, "variables.xml");
                EList content = res.getContents();
                VariableMap preImportVarMap = (VariableMap)this.preImportData.get("NODE_VARIABLE_MAP");
                if (content.size() == 0) {
                    content.add(preImportVarMap);
                } else {
                    ConfigArchiveUtils.mergeVariableList(((VariableMap)content.get(0)).getEntries(), preImportVarMap.getEntries(), "symbolicName", true);
                }
                res.save(Collections.EMPTY_MAP);
                res = ConfigArchiveUtils.getResource(context, "serverindex.xml");
                ServerIndex serverIndex = (ServerIndex)res.getContents().get(0);
                ServerIndex preImportServerIndex = (ServerIndex)this.preImportData.get("SERVER_INDEX");
                String hostName = preImportServerIndex.getHostName();
                this.setHostName(serverIndex, hostName);
                serversList = (List)this.preImportData.get("SERVER_NAME");
                for (int i = 0; i < this.oldServerCnt; ++i) {
                    ServerEntry serverEntry = (ServerEntry)serverIndex.getServerEntries().get(i);
                    serverEntry.setServerName((String)serversList.get(i));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "serverEntry", serverEntry);
                    }
                    EList endPnts = serverEntry.getSpecialEndpoints();
                    serverEntry = (ServerEntry)preImportServerIndex.getServerEntries().get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "serverEntry", serverEntry);
                    }
                    EList preImportEndPnts = serverEntry.getSpecialEndpoints();
                    ConfigArchiveUtils.mergeList(endPnts, preImportEndPnts, "endPointName", true);
                }
                if (!((List)this.preImportData.get("SYSTEM_APPS")).isEmpty()) {
                    context.delete("systemapps.xml");
                    DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(context, "systemapps.xml");
                    content = context.getResourceSet().getResource(URI.createURI("systemapps.xml"), false).getContents();
                    List systemApps = (List)this.preImportData.get("SYSTEM_APPS");
                    content.addAll(systemApps);
                    docAccessor.localSave();
                } else {
                    this.checkSystemAppsPath(contextInArchive2);
                }
                props = (Properties)this.getParameter("options");
                String resolvePorts = "true";
                if (props != null) {
                    resolvePorts = props.getProperty("resolvePorts", "true");
                }
                if (resolvePorts.equals("true")) {
                    this.resolvePortConflict(context, serverIndex);
                }
                res.save(Collections.EMPTY_MAP);
                String prodShortName = (String)this.preImportData.get("BASE_WAS_PRODUCT_SHORTNAME");
                if (prodShortName != null && prodShortName.length() != 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using the target base WAS product short name: " + prodShortName);
                    }
                    this.updateNodeMetadataProperties(context, session, (String)this.preImportData.get("NODE_NAME"), prodShortName);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The target base WAS product short name does not exist so uses one from the archive");
                }
                Collection contextsInArchive = contextInArchive2.findContext(metadata2.getContextType("servers"));
                for (RepositoryContext contextInArchive2 : contextsInArchive) {
                    RepositoryContext serverContext = ConfigArchiveUtils.createContext(context, contextInArchive2.getName(), contextInArchive2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "server context", serverContext);
                }
                this.updateServer((String)this.preImportData.get("NODE_NAME"));
                for (int i = 0; i < this.oldServerCnt; ++i) {
                    this.updateServerVariableMap(context, (String)serversList.get(i));
                }
                try {
                    this.getRars(rootContext, cellName);
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block41;
                    Tr.debug(tc, "import of rars failed");
                }
            }
            String reDeployApps = "true";
            if (props != null) {
                reDeployApps = props.getProperty("reDeployApps", "true");
            }
            Session archiveSession = this.getConfigArchiveSession();
            pattern = ConfigServiceHelper.createObjectName(null, "Deployment");
            ObjectName[] deployments = configService.queryConfigObjects(archiveSession, null, pattern, null);
            for (int i = 0; i < deployments.length; ++i) {
                String serverName = null;
                Deployment deployment = (Deployment)MOFUtil.convertToEObject(archiveSession, deployments[i]);
                int numServers = (Integer)this.preImportData.get("NUMBER_SERVERS");
                if (numServers > 1 || numServers <= 0 || serversList.size() == 0) {
                    TreeIterator iter = deployment.eAllContents();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        if (!(obj instanceof ServerTarget)) continue;
                        ServerTarget svrTarget = (ServerTarget)obj;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "svrTarget", svrTarget);
                        }
                        serverName = svrTarget.getName();
                    }
                } else {
                    serverName = (String)serversList.get(0);
                }
                com.ibm.ws.runtime.service.VariableMap nvMap = this.createVariableMap(rootContext, (String)this.preImportData.get("CELL_NAME"), (String)this.preImportData.get("NODE_NAME"), serverName);
                String appName = ConfigServiceHelper.getDisplayName(deployments[i]);
                this.updateDeploymentTarget(deployment);
                if (reDeployApps.equals("true")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Make deployApplications call");
                    }
                    Iterator appit = aContextInArchive.findContext(metadata2.getContextType("applications")).iterator();
                    this.deployApplications(appName, aContextInArchive, aContext, appit, deployment, nvMap);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "No deployApplications() call");
            }
            if (reDeployApps.equals("false")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Copy the applications context tree from archive to target workspace.");
                }
                contextInArchive2 = (RepositoryContext)archiveWorkspace.findContext(metadata2.getContextType("cells")).iterator().next();
                children = contextInArchive2.getChildren();
                for (RepositoryContext child : children) {
                    if (!child.getType().getName().equals("applications")) continue;
                    ConfigArchiveUtils.copyContext(aContext, child, null);
                }
            }
            this.renameCUTargetWASFileNames(archiveSession, workspace.getUserName());
            String msg = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configarchive", "ADMB0008I");
            result.addWarnings(msg);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ImportWsProfile.beforeStepsExecuted", (String)"99");
            result.setException((Throwable)new ConfigArchiveException(th, "importWsprofile command failed"));
            th.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private void renameCUTargetWASFileNames(Session archiveSession, String workspaceId) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "renameCUTargetWASFileNames", new Object[]{archiveSession, workspaceId});
        }
        String oldNode = null;
        try {
            ObjectName node = this.getConfigService().resolve(archiveSession, "Node=")[0];
            oldNode = ConfigServiceHelper.getDisplayName(node);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "old node = " + oldNode);
            }
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Caught an Exception while resolving the old node: " + e);
            }
            throw e;
        }
        String newNode = (String)this.preImportData.get("NODE_NAME");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new node = " + newNode);
        }
        try {
            ModelHelper.getSingleton().renameNodeForCUs(oldNode, newNode, workspaceId);
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Caught an Exception while reanming CU target WAS file names: " + e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "renameCUTargetWASFileNames");
        }
    }

    private com.ibm.ws.runtime.service.VariableMap createVariableMap(RepositoryContext root, String cellName, String nodeName, String serverName) {
        String wsRoot = root.getPath();
        Repository repository2 = RepositoryFactory.createRepository((String)"ws-server", (String)wsRoot, (String)cellName, (String)nodeName, (String)serverName);
        com.ibm.ws.runtime.service.VariableMap map = VariableMapFactory.createVariableMap((Repository)repository2);
        map.refresh();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVarMap: " + map);
        }
        return map;
    }

    private void checkSystemAppsPath(RepositoryContext contextInArchive) throws CommandValidationException {
        Resource sysAppsRes = contextInArchive.getResourceSet().getResource(URI.createURI("systemapps.xml"), true);
        if (sysAppsRes == null) {
            return;
        }
        ServerIndex si = (ServerIndex)sysAppsRes.getContents().iterator().next();
        if (si == null) {
            return;
        }
        String variable = "${WAS_INSTALL_ROOT}";
        String appName = "adminconsole.ear";
        EList servers = si.getServerEntries();
        for (int i = 0; i < servers.size(); ++i) {
            ServerEntry server = (ServerEntry)servers.get(i);
            EList apps = server.getDeployedApplications();
            String appPath = null;
            for (int a = 0; a < apps.size(); ++a) {
                appPath = (String)apps.get(a);
                if (!appPath.endsWith(appName) || appPath.startsWith(variable)) continue;
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configarchive", "ADMB0010E", new Object[]{variable, appName}, null);
                throw new CommandValidationException(msg);
            }
        }
    }

    protected void collectConfigBeforeImport() throws Exception {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "collectConfigBeforeImport");
            }
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session bundleSession = this.getConfigArchiveSession();
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Server");
            ObjectName[] queryResult = configService.queryConfigObjects(bundleSession, null, pattern, null);
            Integer numServers = new Integer(queryResult.length);
            this.preImportData.put("NUMBER_SERVERS", numServers);
            Session session = this.getConfigSession();
            pattern = ConfigServiceHelper.createObjectName(null, "Server");
            ObjectName[] servers = configService.queryConfigObjects(session, null, pattern, null);
            ObjectName server = null;
            Properties location = null;
            if (servers.length > 0) {
                server = servers[0];
                location = ConfigServiceHelper.getObjectLocation(server);
            } else {
                ObjectName[] nodes = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(null, "Node"), null);
                ObjectName node = nodes[0];
                location = ConfigServiceHelper.getObjectLocation(node);
            }
            this.preImportData.put("CELL_NAME", location.get("cell"));
            String nodeName = (String)location.get("node");
            this.preImportData.put("NODE_NAME", nodeName);
            ArrayList<Object> serverList = new ArrayList<Object>();
            for (int i = 0; i < servers.length; ++i) {
                Properties loc = ConfigServiceHelper.getObjectLocation(servers[i]);
                serverList.add(loc.get("server"));
            }
            this.preImportData.put("SERVER_NAME", serverList);
            ObjectName node = configService.resolve(session, "Node=" + nodeName)[0];
            ObjectName serverIndexObj = configService.getRelationship(session, node, "ServerIndex")[0];
            ServerIndex serverindex = (ServerIndex)MOFUtil.convertToEObject(session, serverIndexObj);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverindex", serverindex);
            }
            this.preImportData.put("SERVER_INDEX", serverindex);
            RepositoryContext nodeContext = WorkspaceHelper.getContext(session, ConfigServiceHelper.getConfigDataId(node));
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(nodeContext, "systemapps.xml");
            EList content = nodeContext.getResourceSet().getResource(URI.createURI("systemapps.xml"), false).getContents();
            this.preImportData.put("SYSTEM_APPS", content);
            ObjectName nodeVarObj = configService.getRelationship(session, node, "VariableMap")[0];
            VariableMap nodeVar = (VariableMap)MOFUtil.convertToEObject(session, nodeVarObj);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeVar", nodeVar);
            }
            this.preImportData.put("NODE_VARIABLE_MAP", nodeVar);
            pattern = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
            RepositoryContext cellContext = WorkspaceHelper.getContext(session, ConfigServiceHelper.getConfigDataId(cell));
            docAccessor = WorkspaceHelper.getDocAccessor(cellContext, "virtualhosts.xml");
            EList vhosts = cellContext.getResourceSet().getResource(URI.createURI("virtualhosts.xml"), false).getContents();
            this.preImportData.put("VIRTUAL_HOSTS", vhosts);
            Properties props = new Properties();
            props.setProperty("CONFIG_SESSION", session.toString());
            ManagedObjectMetadataAccessor mAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(props);
            try {
                this.preImportData.put("BASE_WAS_PRODUCT_SHORTNAME", mAccessor.getMetadataProperty(nodeName, "com.ibm.websphere.baseProductShortName"));
            }
            catch (MetadataNotAvailableException mnae) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "node metadata accessor getMetadataProperty: no target metadata available.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectConfigBeforeImport");
        }
    }

    private void setHostName(ServerIndex serverindex, String hostName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHostName", new Object[]{serverindex, hostName});
        }
        serverindex.setHostName(hostName);
        TreeIterator iter = serverindex.eAllContents();
        while (iter.hasNext()) {
            String host;
            Object obj = iter.next();
            if (!(obj instanceof NamedEndPoint)) continue;
            NamedEndPoint namedEP = (NamedEndPoint)obj;
            String endpointName = namedEP.getEndPointName();
            EndPoint endpointObj = namedEP.getEndPoint();
            EndPoint ep = endpointObj;
            if (ep == null || (host = ep.getHost()) == null) continue;
            if (host.equals("*")) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Preserving  HostName as *  for port " + ep.getPort());
                continue;
            }
            if ("IPC_CONNECTOR_ADDRESS".equals(endpointName)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Preserving  HostName as " + host + " for endpoint IPC_CONNECTOR_ADDRESS and port " + ep.getPort());
                continue;
            }
            ep.setHost(hostName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHostName");
        }
    }

    private void resolvePortConflict(RepositoryContext nodeContext, ServerIndex serverIndex) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolvePortConflict", new Object[]{nodeContext, serverIndex});
        }
        TreeIterator iter = serverIndex.eAllContents();
        while (iter.hasNext()) {
            int port;
            Object obj = iter.next();
            if (!(obj instanceof EndPoint)) continue;
            EndPoint endPnt = (EndPoint)obj;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "endPnt", endPnt);
            }
            if ((port = endPnt.getPort()) != 0) {
                endPnt.setPort(0);
                EndpointConfigHelper.adjustPort(nodeContext, port, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "port," + port);
                }
            }
            endPnt.setPort(port);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolvePortConflict");
        }
    }

    private void updateDeploymentTarget(Deployment deployment) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateDeploymentTarget", deployment);
        }
        TreeIterator iter = deployment.eAllContents();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof ServerTarget) {
                ServerTarget svrTarget = (ServerTarget)obj;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "svrTarget", svrTarget);
                }
                int numServers = (Integer)this.preImportData.get("NUMBER_SERVERS");
                List serversList = (List)this.preImportData.get("SERVER_NAME");
                String serverName = numServers > 1 || numServers <= 0 || serversList.size() == 0 ? svrTarget.getName() : (String)serversList.get(0);
                svrTarget.setName(serverName);
                svrTarget.setNodeName((String)this.preImportData.get("NODE_NAME"));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serverName = ", serverName);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeName = ", (String)this.preImportData.get("NODE_NAME"));
                }
            }
            if (!(obj instanceof ApplicationDeployment)) continue;
            ApplicationDeployment appDeploy = (ApplicationDeployment)obj;
            String appCID = appDeploy.getAppContextIDForSecurity();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "old appContextIDForSecurity", appCID);
            }
            String cellName = (String)this.preImportData.get("CELL_NAME");
            String newAppCID = appCID.replaceAll("DefaultCell", cellName);
            appDeploy.setAppContextIDForSecurity(newAppCID);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "new appContextIDForSecurity", newAppCID);
        }
        deployment.eResource().save(Collections.EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateDeploymentTarget");
        }
    }

    private void deployApplications(String appName, RepositoryContext acold, RepositoryContext acnew, Iterator appit, Deployment deployment, com.ibm.ws.runtime.service.VariableMap vMap) throws Exception {
        Object obj;
        TreeIterator iter;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deployApplications", new Object[]{appName, acold, acnew, appit, deployment, vMap});
        }
        RepositoryContext aContextInArchive = acold;
        RepositoryContext aContext = acnew;
        String appBinName = appName;
        if (!appName.endsWith(".ear")) {
            appBinName = appName + ".ear";
        }
        List serversList = (List)this.preImportData.get("SERVER_NAME");
        String serverName = null;
        int numServers = (Integer)this.preImportData.get("NUMBER_SERVERS");
        if (numServers > 1 || numServers <= 0 || serversList.size() == 0) {
            iter = deployment.eAllContents();
            while (iter.hasNext()) {
                obj = iter.next();
                if (!(obj instanceof ServerTarget)) continue;
                ServerTarget svrTarget = (ServerTarget)obj;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "svrTarget", svrTarget);
                }
                serverName = svrTarget.getName();
            }
        } else {
            serverName = (String)serversList.get(0);
        }
        iter = deployment.eAllContents();
        block9: while (iter.hasNext()) {
            obj = iter.next();
            Session archiveSession = this.getConfigArchiveSession();
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName[] queryResult = ConfigServiceFactory.getConfigService().queryConfigObjects(archiveSession, null, pattern, null);
            String cellInArchive = ConfigServiceHelper.getDisplayName(queryResult[0]);
            if (!(obj instanceof ApplicationDeployment)) continue;
            ApplicationDeployment appDeploy = (ApplicationDeployment)obj;
            String binURL = appDeploy.getBinariesURL();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "old binURL", binURL);
            }
            String expandedURL = vMap.expand(binURL);
            String matchString = "$(APP_INSTALL_ROOT)/" + cellInArchive + "/";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expandedURL= ", expandedURL);
            }
            boolean valid = false;
            boolean exist = false;
            try {
                File ff = new File(expandedURL);
                if (!ff.exists()) {
                    ff.mkdirs();
                    ff.delete();
                    valid = true;
                } else {
                    exist = true;
                    valid = true;
                }
            }
            catch (Throwable th) {
                valid = false;
                exist = false;
            }
            if (appDeploy.isEnableDistribution()) {
                if (!valid) {
                    binURL = "${APP_INSTALL_ROOT}/" + this.preImportData.get("CELL_NAME") + "/" + appBinName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new binURL", binURL);
                    }
                    appDeploy.setBinariesURL(binURL);
                    deployment.eResource().save(Collections.EMPTY_MAP);
                }
                ConfigArchiveUtils.deployApplication(appDeploy, this.getConfigSession(), appName, this.getConfigArchiveSession(), appName, (String)this.preImportData.get("NODE_NAME"), serverName);
                continue;
            }
            if (exist) {
                try {
                    Iterator it = appit;
                    while (it.hasNext()) {
                        RepositoryContext rc = (RepositoryContext)it.next();
                        if (!rc.getName().equals(appName) && !rc.getName().equals(appBinName)) continue;
                        aContextInArchive = rc;
                        break;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "app context = " + aContextInArchive);
                    }
                    aContext = ConfigArchiveUtils.createContextIfNeeded(aContext, "applications", appBinName);
                    List children = aContextInArchive.getChildren();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "created app context = " + aContext);
                    }
                    for (RepositoryContext child : children) {
                        ConfigArchiveUtils.copyContext(aContext, child, null);
                    }
                }
                catch (WorkSpaceException e) {
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                ConfigArchiveUtils.updateApplication(appDeploy, this.getConfigSession(), appName, this.getConfigArchiveSession(), appName, expandedURL, (String)this.preImportData.get("NODE_NAME"), serverName);
                continue;
            }
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            try {
                Iterator cusIt;
                Iterator blasIt;
                Iterator it = blasIt = acnew.findContext(metadata2.getContextType("blas")).iterator();
                while (it.hasNext()) {
                    RepositoryContext child = (RepositoryContext)it.next();
                    if (!child.getName().equals(appName)) continue;
                    child.delete(true);
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Removed unwanted directory under blas for appName = " + appName);
                    break;
                }
                Iterator it2 = cusIt = acnew.findContext(metadata2.getContextType("cus")).iterator();
                while (it2.hasNext()) {
                    RepositoryContext child = (RepositoryContext)it2.next();
                    if (!child.getName().equals(appName)) continue;
                    child.delete(true);
                    if (!tc.isDebugEnabled()) continue block9;
                    Tr.debug(tc, "Removed unwanted directory under cus for appName = " + appName);
                }
            }
            catch (WorkSpaceException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got a WorkSpaceException while Removing unwanted app directory under blas or cus failed, appName = " + appName);
                }
                e.printStackTrace();
            }
            catch (Throwable t) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got a throwable while Removing unwanted app directory under blas or cus failed, appName = " + appName);
                }
                t.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deployApplications");
        }
    }

    private void updateSecurity(String nodeName) throws Exception {
        ObjectName pattern;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateSecurity", nodeName);
        }
        Session session = this.getConfigSession();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName[] matches = configService.queryConfigObjects(session, null, pattern = ConfigServiceHelper.createObjectName(null, "Cell"), null);
        if (matches == null || matches.length <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateSecurity", "cell context not found");
            }
            return;
        }
        ObjectName cell = matches[0];
        pattern = ConfigServiceHelper.createObjectName(null, "Security");
        if ((matches = configService.queryConfigObjects(session, cell, pattern, null)) == null || matches.length <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateSecurity", "security context not found");
            }
            return;
        }
        ObjectName security = matches[0];
        this.updateAllSSL(nodeName, security, "IIOPTransport", "sslConfig", configService, session, null);
        this.updateAllSSL(nodeName, security, "SSLConfig", "alias", configService, session, null);
        this.updateAllSSL(nodeName, security, "LDAPUserRegistry", "sslConfig", configService, session, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSecurity");
        }
    }

    private void updateNodeMetadataProperties(RepositoryContext archiveNodeContext, Session targetSession, String nodeName, String baseWASProdShortName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateNodeMetadataProperties", baseWASProdShortName);
        }
        Properties props = new Properties();
        props.setProperty("CONFIG_SESSION", targetSession.toString());
        ManagedObjectMetadataAccessor mAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(props);
        Properties mdProps = mAccessor.getMetadataProperties(nodeName);
        mdProps.setProperty("com.ibm.websphere.baseProductShortName", baseWASProdShortName);
        this.storeNodeMetadataProperties(archiveNodeContext, nodeName, mdProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNodeMetadataProperties");
        }
    }

    /*
     * Loose catch block
     */
    private void storeNodeMetadataProperties(RepositoryContext archiveNodeContext, String nodeName, Properties nodeMetadataProps) throws Exception {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "storeNodeMetadataProperties");
            }
            OutputStream os = null;
            os = archiveNodeContext.getOutputStream("node-metadata.properties");
            nodeMetadataProps.store(os, "");
            Object var8_5 = null;
            try {
                if (os != null) {
                    os.close();
                }
                break block13;
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.configarchive.ImportWsprofile", (String)"925");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "storeNodeMetadataProperties: got the IOException: ", ioe);
                }
                break block13;
            }
            {
                catch (Throwable t) {
                    MetadataNotAvailableException me = new MetadataNotAvailableException(t, "Unexpected exception received while storeing node metadata properties.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "storeNodeMetadataProperties: unexpected exception: ", (Object)me);
                    }
                    throw me;
                }
            }
            catch (Throwable throwable) {
                block14: {
                    Object var8_6 = null;
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException ioe) {
                        FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.configarchive.ImportWsprofile", (String)"925");
                        if (!tc.isEntryEnabled()) break block14;
                        Tr.exit(tc, "storeNodeMetadataProperties: got the IOException: ", ioe);
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "storeNodeMetadataProperties");
        }
    }

    private void updateServer(String nodeName) throws Exception {
        ObjectName pattern;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServer", nodeName);
        }
        Session session = this.getConfigSession();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName[] matches = configService.queryConfigObjects(session, null, pattern = ConfigServiceHelper.createObjectName(null, "Node"), null);
        if (matches == null || matches.length <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateServer", "node context not found");
            }
            return;
        }
        ObjectName node = matches[0];
        pattern = ConfigServiceHelper.createObjectName(null, "Server");
        if ((matches = configService.queryConfigObjects(session, node, pattern, null)) == null || matches.length <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateServer", "server context not found");
            }
            return;
        }
        for (int i = 0; i < matches.length; ++i) {
            ObjectName server = matches[i];
            this.updateAllSSL(nodeName, server, "SSLInboundChannel", "sslConfigAlias", configService, session, null);
            this.updateAllSSL(nodeName, server, "SSLOutboundChannel", "sslConfigAlias", configService, session, null);
            pattern = ConfigServiceHelper.createObjectName(null, "SOAPConnector");
            ObjectName[] soapMatches = configService.queryConfigObjects(session, server, pattern, null);
            if (soapMatches == null || soapMatches.length <= 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "updateServer", "soap connector context not found");
                }
                return;
            }
            ObjectName soapConnector = soapMatches[0];
            List props = (List)configService.getAttribute(session, soapConnector, "properties", false);
            AttributeList attrList = new AttributeList();
            for (ObjectName prop : props) {
                String val;
                if (!"sslConfig".equals(configService.getAttribute(session, prop, "name")) || (val = (String)configService.getAttribute(session, prop, "value")).indexOf("/") <= 0) continue;
                attrList.clear();
                int index = val.indexOf("/");
                String newSSLConfig = nodeName + val.substring(index);
                ConfigServiceHelper.setAttributeValue(attrList, "value", newSSLConfig);
                configService.setAttributes(session, prop, attrList);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Soap connector ssl config alias is changed  from " + val + " to " + newSSLConfig);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServer", nodeName);
        }
    }

    private void updateAllSSL(String nodeName, ObjectName pObj, String objectType, String attrName, ConfigService configService, Session session, String match) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateSslAlias", new Object[]{pObj, objectType, attrName});
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, objectType);
        ObjectName[] matches = configService.queryConfigObjects(session, pObj, pattern, null);
        AttributeList attrList = new AttributeList();
        int len = matches == null ? 0 : matches.length;
        for (int i = 0; i < len; ++i) {
            ObjectName obj = matches[i];
            String sslAlias = (String)configService.getAttribute(session, obj, attrName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updating ", obj);
            }
            if (sslAlias == null || sslAlias.indexOf("/") < 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslAlias=", sslAlias);
            }
            int index = sslAlias.indexOf("/");
            String newSslAlias = nodeName + sslAlias.substring(index);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "newSslAlias=", newSslAlias);
            }
            attrList.clear();
            ConfigServiceHelper.setAttributeValue(attrList, attrName, newSslAlias);
            configService.setAttributes(session, obj, attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSslAlias");
        }
    }

    private void updateServerVariableMap(RepositoryContext context, String serverName) throws Exception {
        Resource resVM;
        VariableMap vm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServerVariableMap", new Object[]{context, serverName});
        }
        if ((vm = (VariableMap)(resVM = ConfigArchiveUtils.getResource(context, "variables.xml")).getContents().get(0)) != null) {
            EList entries = vm.getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                VariableSubstitutionEntry entry = (VariableSubstitutionEntry)entries.get(i);
                if (entry.getSymbolicName().equals("WAS_SERVER_NAME")) {
                    entry.setValue(serverName);
                }
                if (!entry.getSymbolicName().equals("SERVER_LOG_ROOT")) continue;
                entry.setValue("${LOG_ROOT}/" + serverName);
            }
        }
        resVM.save(Collections.EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateServerVariableMap");
        }
    }

    private void updateCellVariableMap(RepositoryContext context, String cellName) throws Exception {
        Resource resVM;
        VariableMap vm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCellVariableMap", new Object[]{context, cellName});
        }
        if ((vm = (VariableMap)(resVM = ConfigArchiveUtils.getResource(context, "variables.xml")).getContents().get(0)) != null) {
            EList entries = vm.getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                VariableSubstitutionEntry entry = (VariableSubstitutionEntry)entries.get(i);
                if (!entry.getSymbolicName().equals("WAS_CELL_NAME")) continue;
                entry.setValue(cellName);
            }
        }
        resVM.save(Collections.EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCellVariableMap");
        }
    }

    private void updateNodeGroup(RepositoryContext context, String nodeName) throws Exception {
        Resource resNG;
        NodeGroup ng;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateNodeGroup", new Object[]{context, nodeName});
        }
        if ((ng = (NodeGroup)(resNG = ConfigArchiveUtils.getResource(context, "nodegroup.xml")).getContents().get(0)) != null) {
            EList members = ng.getMembers();
            for (int i = 0; i < members.size(); ++i) {
                NodeGroupMember member = (NodeGroupMember)members.get(i);
                member.setNodeName(nodeName);
            }
        }
        resNG.save(Collections.EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNodeGroup");
        }
    }

    private void updateCoreGroup(RepositoryContext context, String nodeName) throws Exception {
        Resource resCG;
        CoreGroup cg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCoreGroup", new Object[]{context, nodeName});
        }
        if ((cg = (CoreGroup)(resCG = ConfigArchiveUtils.getResource(context, "coregroup.xml")).getContents().get(0)) != null) {
            EList servers = cg.getCoreGroupServers();
            for (int i = 0; i < servers.size(); ++i) {
                CoreGroupServer server = (CoreGroupServer)servers.get(i);
                server.setNodeName(nodeName);
            }
        }
        resCG.save(Collections.EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCoreGroup");
        }
    }

    private void getRars(RepositoryContext rootContext, String cellName) throws Exception {
        RepositoryContextType nodeType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRars", rootContext);
        }
        RepositoryContext nodeCtx = null;
        RepositoryContext serverCtx2 = null;
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContextType cellType = metadata2.getContextType("cells");
        Collection matches = rootContext.findContext(cellType);
        RepositoryContext cell = (RepositoryContext)matches.iterator().next();
        if ((matches = cell.findContext(nodeType = metadata2.getContextType("nodes"))) != null && matches.size() > 0) {
            nodeCtx = (RepositoryContext)matches.iterator().next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeCtx ", nodeCtx);
        }
        if (nodeCtx == null) {
            return;
        }
        RepositoryContextType serverType = metadata2.getContextType("servers");
        matches = nodeCtx.findContext(serverType);
        if (matches != null && matches.size() > 0) {
            for (RepositoryContext serverCtx2 : matches) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serverCtx ", serverCtx2);
                }
                com.ibm.ws.runtime.service.VariableMap vMap = this.createVariableMap(rootContext, cellName, nodeCtx.getName(), serverCtx2.getName());
                Resource res = ConfigArchiveUtils.getResource(nodeCtx, "resources.xml");
                if (res != null) {
                    this.getRarFromArchive(res, nodeCtx, vMap);
                }
                if ((res = ConfigArchiveUtils.getResource(serverCtx2, "resources.xml")) == null) continue;
                this.getRarFromArchive(res, serverCtx2, vMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRars");
        }
    }

    private void getRarFromArchive(Resource res, RepositoryContext nodeCtx, com.ibm.ws.runtime.service.VariableMap vMap) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRarFromArchive", nodeCtx);
        }
        String rarsPath = null;
        String rarsUri = null;
        EList contents = res.getContents();
        for (int i = 0; i < contents.size(); ++i) {
            WorkSpaceFile wsf;
            Object obj = contents.get(i);
            if (!(obj instanceof J2CResourceAdapter)) continue;
            J2CResourceAdapter j2cadapter = (J2CResourceAdapter)obj;
            String archiveLocation = j2cadapter.getArchivePath();
            String resName = j2cadapter.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resName ", resName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "archiveLocation ", archiveLocation);
            }
            if ((wsf = nodeCtx.getFile("resources.xml")) == null) continue;
            String uri = wsf.getURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resource uri ", uri);
            }
            uri = uri.substring(0, uri.indexOf("/resources.xml"));
            rarsUri = uri + "/rars";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node uri ", uri);
            }
            String wsPath = nodeCtx.getWorkSpace().getPath();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "archive workspace path ", wsPath);
            }
            rarsPath = wsPath + File.separator + uri + File.separator + "rars";
            wsPath = wsPath + File.separator + uri + File.separator + "rars" + File.separator + resName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rar path ", wsPath);
            }
            archiveLocation = vMap.expand(archiveLocation);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expanded src rar path ", archiveLocation);
            }
            try {
                ConfigArchiveUtils.getRar(archiveLocation, wsPath);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (rarsPath != null) {
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContextType rarType = metadata2.getContextType("rars");
            Collection ctxs = nodeCtx.findContext(rarType);
            for (RepositoryContext ctx : ctxs) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "expanded src rar path ", ctx.getName());
                }
                ctx.delete(true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRarFromArchive");
        }
    }
}

