/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.metadata.ManagedObjectMetadataUtilities;
import com.ibm.ws.security.common.util.MergeSecurityConfig;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.ImportStep;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class AddNodeSecurityExt
extends ImportStep {
    private static TraceComponent tc = Tr.register(AddNodeSecurityExt.class, "configarchive", "com.ibm.ws.management.resources.configarchive");

    public AddNodeSecurityExt(AbstractTaskCommand taskcmd, CommandMetadata commandmetadata) {
        super(taskcmd, commandmetadata);
    }

    public AddNodeSecurityExt(AbstractTaskCommand taskcmd, CommandData commanddata) throws CommandNotFoundException {
        super(taskcmd, commanddata);
    }

    protected void executeStep() {
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.taskCmd.getTaskCommandResult();
        if (!result.isSuccessful()) {
            return;
        }
        try {
            super.executeStep();
            Session session = this.getConfigSession();
            Session archiveSession = this.getConfigArchiveSession();
            Security cellSecurity = this.getSecurity(session);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cellSecurity: ", cellSecurity);
            }
            Security nodeSecurity = this.getSecurity(archiveSession);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeSecurity: ", nodeSecurity);
            }
            ServerIndex nodeServerIndex = this.getServerIndex(archiveSession);
            String nodeHostName = nodeServerIndex.getHostName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeHostName: ", nodeHostName);
            }
            String nodeName = (String)this.taskCmd.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName: ", nodeName);
            }
            String workSpacePath = WorkspaceHelper.getWorkspace(session).getPath();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "workspace path: ", workSpacePath);
            }
            String workSpaceArchivePath = WorkspaceHelper.getWorkspace(archiveSession).getPath();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "workspace (archive) path: ", workSpaceArchivePath);
            }
            ManagedObjectMetadataHelper metadataHelper = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
            String nodeOS = metadataHelper.getNodePlatformOS(nodeName);
            String cellOS = System.getProperty("os.name");
            if (cellOS != null) {
                cellOS = ManagedObjectMetadataUtilities.normalizeOSName((String)cellOS);
            }
            if (cellOS == null) {
                cellOS = "windows";
            }
            if (nodeOS == null) {
                nodeOS = cellOS;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeOS", nodeOS);
            }
            Properties adminProperties = (Properties)this.taskCmd.getParameter("options");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminProperties: " + adminProperties);
            }
            String oldCellName = adminProperties.getProperty("oldCellName");
            String excludeSecurityDomains = adminProperties.getProperty("excludesecuritydomains");
            boolean isOlderThan61Node = false;
            if (metadataHelper.compareNodeVersion(nodeName, "6.1") == -1) {
                isOlderThan61Node = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isOlderThan61Node ", Boolean.toString(isOlderThan61Node));
            }
            AdminService adminService = AdminServiceFactory.getAdminService();
            String dmgrNodeName = adminService.getNodeName();
            MergeSecurityConfig.merge((String)workSpaceArchivePath, (String)workSpacePath, (Security)cellSecurity, (Security)nodeSecurity, (String)nodeName, (String)nodeHostName, (String)cellOS, (String)nodeOS, (boolean)isOlderThan61Node, (String)dmgrNodeName);
            cellSecurity.eResource().save(Collections.EMPTY_MAP);
            if (excludeSecurityDomains == null || !excludeSecurityDomains.equals("true")) {
                this.changeSecurityDomainInfo(archiveSession, oldCellName);
            }
            this.copyWasPolicies(session, archiveSession);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.AddNodeSecurityExt.executeStep", (String)"48");
            result.setException((Throwable)new ConfigArchiveException(th, "mergeSecurity step failed"));
        }
    }

    private void copyWasPolicies(Session session, Session archiveSession) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyWasPolicies", new Object[]{session, archiveSession});
        }
        RepositoryContext policyInArchiveCxt = null;
        WorkSpace archivews = WorkspaceHelper.getWorkspace(archiveSession);
        WorkSpace ws = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        Collection archivepolicies = archivews.getRootContext().findContext(metadata2.getContextType("waspolicies"));
        if (archivepolicies != null && archivepolicies.size() > 0) {
            policyInArchiveCxt = (RepositoryContext)archivepolicies.iterator().next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "policies context in archive ", policyInArchiveCxt);
        }
        if (policyInArchiveCxt != null) {
            Collection policies = ws.getRootContext().findContext(metadata2.getContextType("waspolicies"));
            RepositoryContext policy = null;
            if (policies != null && policies.size() > 0) {
                Collection sdomains;
                policy = (RepositoryContext)policies.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "policies context in dmgr ", policy);
                }
                if ((sdomains = policyInArchiveCxt.findContext(metadata2.getContextType("securitydomains"))) != null) {
                    for (RepositoryContext secDomain : sdomains) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "securitydomain context in archive ", secDomain);
                        }
                        if (!this.contextExists(metadata2, secDomain.getName(), policy, "securitydomains")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "copying securitydomain context from archive ", secDomain.getName());
                            }
                            ConfigArchiveUtils.copyContext(policy, secDomain, secDomain.getName());
                            continue;
                        }
                        throw new Exception("SecurityDomain already exists in dmgr : " + secDomain.getName());
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "copying policies context from archive ", policyInArchiveCxt);
                }
                ConfigArchiveUtils.copyContext(ws.getRootContext(), policyInArchiveCxt, "default");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyWasPolicies");
        }
    }

    private boolean contextExists(RepositoryMetaData metadata2, String ctxName, RepositoryContext parent, String contextName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contextExists", new Object[]{ctxName, parent, contextName});
        }
        boolean result = false;
        Collection ctxs = parent.findContext(metadata2.getContextType(contextName));
        if (ctxs != null) {
            for (RepositoryContext ctx : ctxs) {
                if (!ctx.getName().equals(ctxName)) continue;
                result = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contextExists", new Boolean(result));
        }
        return result;
    }

    private void changeSecurityDomainInfo(Session session, String oldCellName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeSecurityDomainInfo");
        }
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ObjectName[] domains = configService.resolve(session, "SecurityDomain");
            if (tc.isDebugEnabled() && domains != null && domains.length > 0) {
                Tr.debug(tc, "number of security domains = " + domains.length);
            }
            for (int i = 0; i < domains.length; ++i) {
                ObjectName domain = domains[i];
                List members = null;
                try {
                    members = (List)configService.getAttribute(session, domain, "members");
                }
                catch (ConfigDataNotFoundException ce) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting resource names " + ce);
                    }
                    FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.management.configarchive.AddNodeSecurityExt.changeSecurityDomainInfo", (String)"252");
                }
                if (members == null) continue;
                for (AttributeList member : members) {
                    String resourceType;
                    String resourceName = (String)ConfigServiceHelper.getAttributeValue(member, "resourceName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resourceName = " + resourceName);
                    }
                    if (resourceName == null || !resourceName.contains(oldCellName) || (resourceType = (String)ConfigServiceHelper.getAttributeValue(member, "resourceType")) == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resourceType " + resourceType);
                    }
                    configService.deleteConfigData(session, ConfigServiceHelper.createObjectName(member));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deletedOldConfigData");
                    }
                    String cellName = ManagementScopeManager.getInstance().getCellName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new cellName = " + cellName);
                    }
                    String newResourceName = resourceName.replaceFirst(oldCellName, cellName);
                    Object serverResourceName = null;
                    if (resourceType.equalsIgnoreCase("Cell")) {
                        int j;
                        String federatedServerName;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "about to handle case of a cell-wide domain from the added node");
                        }
                        if ((federatedServerName = ConfigArchiveUtils.addNodeServerName) != null && federatedServerName.length() > 0 && (j = federatedServerName.indexOf("/nodes/")) >= 0) {
                            String restOfName = federatedServerName.substring(j);
                            newResourceName = newResourceName + restOfName;
                            resourceType = "Server";
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "changed resource type in the domain mapping file to: " + resourceType);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "changed resource name in the domain mapping file to: " + newResourceName);
                            }
                        }
                    }
                    AttributeList attrList = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(attrList, "resourceName", newResourceName);
                    ConfigServiceHelper.setAttributeValue(attrList, "resourceType", resourceType);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "creating new configData using " + newResourceName);
                    }
                    configService.createConfigData(session, domain, "members", "SecurityDomainMember", attrList);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.configarchive.AddNodeSecurityExt.changeSecurityDomainInfo", (String)"312");
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeSecurityDomainInfo");
        }
    }

    private Security getSecurity(Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurity");
        }
        Security sec = null;
        ConfigService cs = ConfigServiceFactory.getConfigService();
        ObjectName security = cs.resolve(session, null, "Cell=:Security=")[0];
        sec = (Security)MOFUtil.convertToEObject(session, security);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurity", sec);
        }
        return sec;
    }

    private ServerIndex getServerIndex(Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerIndex");
        }
        ServerIndex si = null;
        ConfigService cs = ConfigServiceFactory.getConfigService();
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Node");
        ObjectName node = cs.queryConfigObjects(session, null, pattern, null)[0];
        ObjectName serverindex = cs.getRelationship(session, node, "ServerIndex")[0];
        si = (ServerIndex)MOFUtil.convertToEObject(session, serverindex);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerIndex", si);
        }
        return si;
    }
}

