/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.j2c.J2CProps;
import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.j2c.J2cFactory;
import com.ibm.ejs.models.base.resources.j2c.J2cPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.DocumentChangedException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.application.CommonAppUtils;
import com.ibm.ws.management.application.J2CAppUtils;
import com.ibm.ws.management.component.AdminImpl;
import com.ibm.ws.management.component.InstallRAHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.discovery.Utils;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import com.ibm.ws.management.service.AdminSubSystem;
import com.ibm.ws.management.tools.DMgrConfigUtils;
import com.ibm.ws.management.util.PlatformUtils;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.sm.workspace.template.RefObjectHelper;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManager;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManagerFactory;
import com.ibm.wsspi.management.tools.DmgrSideExtensionChecker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.RarFileDynamicClassLoader;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jca.ConfigProperty;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.ResourceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminOperationsMBean {
    private static int iii = 1;
    private static final String MESSAGE_BUNDLE = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.adminservice");
    private static final TraceComponent tc = Tr.register(AdminOperationsMBean.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private static final String[] NTFY_PARAMS = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"};
    private static final long TOKEN_EXPIRATION_TIME = 1800000L;
    private AdminImpl adminImpl;
    private AdminSubSystem adminAgent;
    private boolean nodeFederationOrRemovalInProgress = false;
    private Integer currentToken = new Integer(0);
    private long previousTokenHandout = 0L;
    private int chmodPermissions = 0;
    private int permsetPermissions = 0;
    private boolean zos = false;
    private PlatformUtils platformUtils = AdminServiceImpl.getPlatformUtils();
    static final int DELETE_FLAG = 1000;

    public AdminOperationsMBean(AdminImpl adminImpl) throws AdminException {
        this.adminImpl = adminImpl;
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.zos = true;
        }
    }

    public AdminOperationsMBean(AdminSubSystem aa) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminOperationsMBean for the subsystem");
        }
        this.adminAgent = aa;
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.zos = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminOperationsMBean for the subsystem");
        }
    }

    public static void mergeConfigDataOnDmgr(Properties nodeProperties, Properties adminProperties) throws Exception {
        Tr.debug(tc, "Enter mergeConfigDataOnDmgr()\n nodePoperties = " + nodeProperties);
        Tr.debug(tc, "Enter mergeConfigDataOnDmgr()\n adminPoperties = " + adminProperties);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeConfigDataOnDmgr:  " + nodeProperties);
        }
        DMgrConfigUtils.doMergeConfig(nodeProperties, adminProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeConfigDataOnDmgr");
        }
    }

    public static void doUnMergeConfigDataOnDmgr(Properties nodeProperties) throws Exception {
        Tr.debug(tc, "Enter doUnMergeConfigDataOnDmgr()\n nodePoperties = " + nodeProperties);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doUnMergeConfigDataOnDmgr:  " + nodeProperties);
        }
        DMgrConfigUtils.doUnMergeConfig(nodeProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doUnMergeConfigDataOnDmgr");
        }
    }

    public void checkNodeAndDmgrCompatibility(Properties nodeMetadataProp) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNodeAndDmgrCompatibility", nodeMetadataProp);
        }
        String extPointID = "com.ibm.wsspi.extension.dmgr-side-extension-checker";
        IExtensionRegistry reg = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint extPoint = reg.getExtensionPoint(extPointID);
        Properties dmgrMetadataProp = null;
        if (extPoint == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkNodeAndDmgrCompatibility - ext point not defined");
            }
            return;
        }
        IConfigurationElement[] elements = extPoint.getConfigurationElements();
        for (int i = 0; i < elements.length; ++i) {
            DmgrSideExtensionChecker ec;
            try {
                ec = (DmgrSideExtensionChecker)elements[i].createExecutableExtension("class");
            }
            catch (Exception e) {
                throw new AdminException("At extension point " + extPointID + ", the extension class " + elements[i].getAttribute("class") + " failed to load");
            }
            if (dmgrMetadataProp == null) {
                ManagedObjectMetadataAccessor acc = null;
                AdminService as = AdminServiceFactory.getAdminService();
                if (as == null) {
                    throw new AdminException("Unable to get AdminService");
                }
                String nodeName = as.getNodeName();
                acc = ManagedObjectMetadataAccessorFactory.createAccessor(null);
                dmgrMetadataProp = acc.getMetadataProperties(nodeName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Dmgr node metadata:", dmgrMetadataProp);
                }
            }
            ec.checkCompatibility(nodeMetadataProp, dmgrMetadataProp);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkNodeAndDmgrCompatibility");
        }
    }

    public static void renameNodeOnDmgr(String oldNode, String newNode, String shortName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "renameNodeOnDmgr", new Object[]{oldNode, newNode, shortName});
        }
        DMgrConfigUtils.doRenameNode(oldNode, newNode, shortName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "renameNodeOnDmgr");
        }
    }

    public void addNode(String cellHost, String cellPort) throws Exception {
        if (this.zos) {
            this.add390Node(cellHost, cellPort, null);
        } else {
            this.addNodeWithOptions(cellHost, cellPort, null);
        }
    }

    public void addNodeWithOptions(String cellHost, String cellPort, String options) throws Exception {
        block14: {
            if (this.zos) {
                this.add390Node(cellHost, cellPort, options);
            } else {
                CreationParams params = new CreationParams();
                String path = System.getProperty("was.install.root") + File.separator + "bin";
                params.setWorkingDirectory(path);
                String pgmName = "addNode.sh";
                if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                    pgmName = "addNode.bat";
                } else if (System.getProperty("os.name").equals("OS/400")) {
                    pgmName = "addNode";
                }
                String command = path + File.separator + pgmName;
                params.setExecutable(command);
                params.setProcessName("addNode");
                params.setDetachProcess(true);
                List<String> argList = new ArrayList<String>();
                if (System.getProperty("os.name").equals("OS/400")) {
                    argList.add("-instance");
                    argList.add(this.getInstanceName());
                }
                argList.add(cellHost);
                argList.add(cellPort);
                argList = this.addCommandLineOptions(argList, options);
                argList.add("-fromMBean");
                params.setCommandLineArgs(this.createCommandArgsFromGivenOptions(argList));
                String logFileName = this.getLogFileName("addNode");
                params.setStdFileName(1, logFileName);
                params.setStdFileName(2, logFileName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Launching process with params: " + params.toString());
                }
                AdminClient ac = null;
                Properties userData = this.createUserData();
                ObjectName notificationService = null;
                try {
                    ac = this.createAdminClient(cellHost, cellPort, argList);
                    notificationService = this.getNotificationService(ac);
                    if (notificationService != null) {
                        this.emitStartingNotification(ac, notificationService, "websphere.addnode.starting", params, userData);
                    }
                }
                catch (Exception exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.component.AdminOperationsMBean.addNode", (String)"149", (Object)this);
                }
                try {
                    Process p = ProcessFactory.create((CreationParams)params);
                    p.release();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminOperationsMBean.addNode", (String)"157", (Object)this);
                    if (notificationService == null) break block14;
                    try {
                        this.emitFailedNotification(ac, notificationService, "websphere.addnode.failed", params, userData, e);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private String getInstanceName() {
        String instance = System.getProperty("user.install.root");
        return instance.substring(instance.lastIndexOf(File.separator) + 1);
    }

    private String getLogFileName(String commandName) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.expandVariable("${LOG_ROOT}"));
        buf.append(File.separator);
        buf.append(commandName);
        buf.append("MBean.log");
        return buf.toString();
    }

    private ObjectName getNotificationService(AdminClient dmgrAdminClient) throws Exception {
        String NTFY_MBEAN_NAME = "WebSphere:*,type=NotificationService,process=" + com.ibm.ws.management.util.Utils.getNetmgrName(dmgrAdminClient);
        Set s = dmgrAdminClient.queryNames(new ObjectName(NTFY_MBEAN_NAME), null);
        if (!s.isEmpty()) {
            return (ObjectName)s.iterator().next();
        }
        return null;
    }

    private Properties createUserData() {
        Properties userData = new Properties();
        userData.setProperty("nodeName", AdminServiceFactory.getAdminService().getNodeName());
        return userData;
    }

    private void emitStartingNotification(AdminClient dmgrAdminClient, ObjectName notificationService, String notificationType, CreationParams params, Properties userData) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "emitStartingNotification", new Object[]{dmgrAdminClient, notificationService, notificationType, params, userData});
        }
        String msg = AdminOperationsMBean.getFormattedMessage("ADMN0032I", new Object[]{params.getExecutable() + " " + this.toString(params.getCommandLineArgs())}, null);
        dmgrAdminClient.invoke(notificationService, "emitNotification", new Object[]{notificationType, msg, userData}, NTFY_PARAMS);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "emitStartingNotification");
        }
    }

    private void emitFailedNotification(AdminClient dmgrAdminClient, ObjectName notificationService, String notificationType, CreationParams params, Properties userData, Exception exc) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "emitFailedNotification", new Object[]{dmgrAdminClient, notificationService, notificationType, params, userData, exc});
        }
        String msg = AdminOperationsMBean.getFormattedMessage("ADMN0033E", new Object[]{params.getProcessName(), exc}, null);
        dmgrAdminClient.invoke(notificationService, "emitNotification", new Object[]{notificationType, msg, userData}, NTFY_PARAMS);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "emitFailedNotification");
        }
    }

    public void removeNode() throws Exception {
        if (this.zos) {
            this.remove390Node(null);
        } else {
            this.removeNodeWithOptions(null);
        }
    }

    public void add390Node(String cellHost, String cellPort, String options) throws Exception {
        CreationParams params = new CreationParams();
        String path = System.getProperty("server.root") + System.getProperty("file.separator") + "bin";
        String pgmName = "addNode";
        String command = path + System.getProperty("file.separator") + pgmName;
        String dest = "/tmp";
        File baseDir = new File(dest);
        File tempCommandFile = File.createTempFile(pgmName, ".sh", baseDir);
        String tempCommand = dest + System.getProperty("file.separator") + tempCommandFile.getName();
        List<String> argList = new ArrayList<String>();
        argList.add(cellHost);
        argList.add(cellPort);
        argList = this.addCommandLineOptions(argList, options);
        argList.add("-fromMBean");
        String[] cmdArgs = this.createCommandArgsFromGivenOptions(argList);
        String cmd = this.getLine(command, cmdArgs);
        FileOutputStream fos = new FileOutputStream(tempCommandFile);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "Cp1047"));
        pw.println("#!/bin/sh");
        pw.println(cmd);
        pw.close();
        params.setExecutable(tempCommand);
        params.setCommandLineArgs(new String[]{" "});
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Launching process with params: " + params.toString());
        }
        this.chmod(tempCommand);
        AdminClient ac = null;
        Properties userData = this.createUserData();
        ObjectName notificationService = null;
        try {
            ac = this.createAdminClient(cellHost, cellPort, argList);
            notificationService = this.getNotificationService(ac);
            if (notificationService != null) {
                this.emitStartingNotification(ac, notificationService, "websphere.addnode.starting", params, userData);
            }
        }
        catch (Exception ex) {
            Tr.debug(tc, "AdminOperationsMBean.addNode Notification Failed", ex);
        }
        try {
            Process p = ProcessFactory.create((CreationParams)params);
            p.release();
        }
        catch (Exception e) {
            Tr.debug(tc, "AdminOperationsMBean.addNode Failed", e);
        }
    }

    public void remove390Node(String options) throws Exception {
        CreationParams params = new CreationParams();
        String path = System.getProperty("server.root") + System.getProperty("file.separator") + "bin";
        String pgmName = "removeNode";
        String command = path + System.getProperty("file.separator") + pgmName;
        String dest = "/tmp";
        File baseDir = new File(dest);
        File tempCommandFile = File.createTempFile(pgmName, ".sh", baseDir);
        String tempCommand = dest + System.getProperty("file.separator") + tempCommandFile.getName();
        List<String> argList = new ArrayList();
        argList = this.addCommandLineOptions(argList, options);
        argList.add("-fromMBean");
        String[] cmdArgs = this.createCommandArgsFromGivenOptions(argList);
        String cmd = this.getLine(command, cmdArgs);
        FileOutputStream fos = new FileOutputStream(tempCommandFile);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "Cp1047"));
        pw.println("#!/bin/sh");
        pw.println(cmd);
        pw.close();
        params.setExecutable(tempCommand);
        params.setCommandLineArgs(new String[]{" "});
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Launching process with params: " + params.toString());
        }
        this.chmod(tempCommand);
        AdminClient ac = null;
        Properties userData = this.createUserData();
        ObjectName notificationService = null;
        try {
            ac = Utils.getDmgrAdminClient();
            notificationService = this.getNotificationService(ac);
            if (notificationService != null) {
                this.emitStartingNotification(ac, notificationService, "websphere.removenode.starting", params, userData);
            }
        }
        catch (Exception ex) {
            Tr.debug(tc, "AdminOperationsMBean.removeNode Notification Failed", ex);
        }
        try {
            Process p = ProcessFactory.create((CreationParams)params);
            p.release();
        }
        catch (Exception e) {
            Tr.debug(tc, "AdminOperationsMBean.removeNode Failed", e);
        }
    }

    public void removeNodeWithOptions(String options) throws Exception {
        block14: {
            if (this.zos) {
                this.remove390Node(options);
            } else {
                CreationParams params = new CreationParams();
                String path = System.getProperty("was.install.root") + File.separator + "bin";
                params.setWorkingDirectory(path);
                String pgmName = "removeNode.sh";
                if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                    pgmName = "removeNode.bat";
                } else if (System.getProperty("os.name").equals("OS/400")) {
                    pgmName = "removeNode";
                }
                String command = path + File.separator + pgmName;
                params.setExecutable(command);
                params.setProcessName("removeNode");
                params.setDetachProcess(true);
                List<String> argList = new ArrayList<String>();
                if (System.getProperty("os.name").equals("OS/400")) {
                    argList.add("-instance");
                    argList.add(this.getInstanceName());
                }
                argList = this.addCommandLineOptions(argList, options);
                argList.add("-fromMBean");
                params.setCommandLineArgs(this.createCommandArgsFromGivenOptions(argList));
                String logFileName = this.getLogFileName("removeNode");
                params.setStdFileName(1, logFileName);
                params.setStdFileName(2, logFileName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Launching process with params: " + params.toString());
                }
                AdminClient ac = null;
                Properties userData = this.createUserData();
                ObjectName notificationService = null;
                try {
                    ac = Utils.getDmgrAdminClient();
                    notificationService = this.getNotificationService(ac);
                    if (notificationService != null) {
                        this.emitStartingNotification(ac, notificationService, "websphere.removenode.starting", params, userData);
                    }
                }
                catch (Exception exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.component.AdminOperationsMBean.removeNode", (String)"282", (Object)this);
                }
                try {
                    Process p = ProcessFactory.create((CreationParams)params);
                    p.release();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminOperationsMBean.removeNode", (String)"291", (Object)this);
                    if (notificationService == null) break block14;
                    try {
                        this.emitFailedNotification(ac, notificationService, "websphere.removenode.failed", params, userData, e);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private List addCommandLineOptions(List argList, String argsString) throws Exception {
        int tokenType;
        if (argsString == null) {
            return argList;
        }
        StringReader stringReader = new StringReader(argsString);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.commentChar(47);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        block8: while ((tokenType = streamTokenizer.nextToken()) != -1) {
            try {
                switch (tokenType) {
                    case -3: {
                        argList.add(streamTokenizer.sval);
                        continue block8;
                    }
                    case -1: {
                        continue block8;
                    }
                    case 10: {
                        continue block8;
                    }
                    case -2: {
                        continue block8;
                    }
                }
                argList.add(streamTokenizer.sval);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        stringReader.close();
        return argList;
    }

    private String[] createCommandArgsFromGivenOptions(List argList) {
        int index = argList.indexOf("-configURL");
        if (index != -1) {
            argList.remove(index);
            String url = (String)argList.remove(index);
            int strIndex = url.indexOf(34);
            boolean lookForClosingQuote = false;
            if (strIndex != -1) {
                lookForClosingQuote = true;
                if ((strIndex = url.indexOf(34, strIndex + 1)) >= 0) {
                    lookForClosingQuote = false;
                }
                while (lookForClosingQuote) {
                    String urlSuffix = (String)argList.remove(index);
                    url = url + urlSuffix;
                    strIndex = urlSuffix.indexOf(34);
                    if (strIndex < 0) continue;
                    lookForClosingQuote = !lookForClosingQuote;
                }
            }
            url = this.expandVariable(url);
            index = argList.indexOf("-conntype");
            if (index != -1) {
                String connType = (String)argList.get(index + 1);
                if (connType.equalsIgnoreCase("SOAP")) {
                    System.setProperty("com.ibm.SOAP.ConfigURL", url);
                } else {
                    System.setProperty("com.ibm.CORBA.ConfigURL", url);
                }
            } else {
                System.setProperty("com.ibm.SOAP.ConfigURL", url);
            }
        }
        String[] cargs = new String[argList.size()];
        cargs = argList.toArray(cargs);
        return cargs;
    }

    private AdminClient createAdminClient(String host, String port, List argList) throws ConnectorException {
        Properties props = new Properties();
        props.setProperty("host", host);
        props.setProperty("port", port);
        if (argList != null) {
            int index = argList.indexOf("-conntype");
            if (index != -1) {
                props.setProperty("type", (String)argList.get(index + 1));
            } else {
                props.setProperty("type", "SOAP");
            }
            index = argList.indexOf("-username");
            if (index != -1) {
                props.setProperty("username", (String)argList.get(index + 1));
            }
            if ((index = argList.indexOf("-user")) != -1) {
                props.setProperty("username", (String)argList.get(index + 1));
            }
            if ((index = argList.indexOf("-password")) != -1) {
                props.setProperty("password", (String)argList.get(index + 1));
            }
        }
        return AdminClientFactory.createAdminClient(props);
    }

    private String toString(String[] array) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            buf.append(array[i] + " ");
        }
        return buf.toString();
    }

    public synchronized Object getTokenForNodeFederationOrRemoval() throws AdminException {
        String dmgrVersion = com.ibm.ws.management.util.Utils.getProductVersion();
        Tr.audit(tc, "ADMN1100E", new Object[]{dmgrVersion});
        String tmpMsg = AdminOperationsMBean.getFormattedMessage("ADMN1100E", new Object[]{dmgrVersion}, null);
        throw new AdminException(tmpMsg);
    }

    public synchronized Object getTokenForNodeFederationOrRemoval(String version) {
        String dmgrVersion = com.ibm.ws.management.util.Utils.getProductVersion();
        Tr.audit(tc, "ADMN1101I", new Object[]{version, dmgrVersion});
        if (this.nodeFederationOrRemovalInProgress) {
            if (this.isTokenExpired()) {
                this.currentToken = new Integer(this.currentToken + 1);
            } else {
                return null;
            }
        }
        this.nodeFederationOrRemovalInProgress = true;
        this.previousTokenHandout = System.currentTimeMillis();
        return this.currentToken;
    }

    private boolean isTokenExpired() {
        return System.currentTimeMillis() - this.previousTokenHandout > 1800000L;
    }

    public synchronized boolean completeNodeFederationOrRemoval(Object token) {
        if (token != null && token.equals(this.currentToken)) {
            this.nodeFederationOrRemovalInProgress = false;
            this.currentToken = new Integer(this.currentToken + 1);
            return true;
        }
        return false;
    }

    public synchronized void forceNodeFederationOrRemovalTokenReset() {
        this.nodeFederationOrRemovalInProgress = false;
    }

    public String expandVariable(String variable) {
        String ret = variable;
        if (this.adminAgent != null) {
            VariableMap varMap = (VariableMap)this.adminAgent.getService(VariableMap.class.getName());
            if (varMap != null) {
                try {
                    ret = varMap.expand(variable);
                }
                catch (IllegalArgumentException e) {
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.component.AdminOperationsMBean.expandVariable", (String)"938", (Object)this);
                }
            }
        } else {
            try {
                ret = this.adminImpl.expandGivenVariable(variable);
            }
            catch (IllegalArgumentException e) {
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.component.AdminOperationsMBean.expandVariable", (String)"313", (Object)this);
            }
        }
        return ret;
    }

    public AttributeList getResourceAdapterFromRAR(String rarPath, Hashtable props) throws AdminException {
        String path = this.expandVariable(rarPath);
        path = path.replace('\\', '/');
        return AdminOperationsMBean._getResourceAdapterFromRAR(path, props);
    }

    public static AttributeList local_getResourceAdapterFromRAR(String rarPath, Hashtable props, String configRoot, String cell, String node) throws AdminException {
        String path = InstallRAHelper.expandVar(rarPath, configRoot, cell, node);
        path = path.replace('\\', '/');
        return AdminOperationsMBean._getResourceAdapterFromRAR(path, props);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AttributeList _getResourceAdapterFromRAR(String rarPath, Hashtable props) throws AdminException {
        AttributeList ret;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "_getResourceAdapterFromRAR: " + rarPath + ", " + props);
            }
            if (rarPath == null) {
                throw new AdminException(AdminOperationsMBean.getFormattedMessage("ADMN0027E", null, null));
            }
            RARFile rarFile = null;
            try {
                ArchiveInit.init();
                CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Path: " + rarPath);
                }
                rarFile = factory.openRARFile(rarPath);
            }
            catch (Exception oex) {
                FFDCFilter.processException((Throwable)oex, (String)"com.ibm.ws.management.component.AdminOperationsMBean._getResourceAdapterFromRAR", (String)"545");
                throw new AdminException(oex, AdminOperationsMBean.getFormattedMessage("ADMN0028E", new String[]{rarPath, oex.toString()}, "Could not open RAR file " + rarPath));
            }
            Connector connector2 = rarFile.getDeploymentDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Connector is: " + connector2);
            }
            ModelMgr.initialize((String)"ws-server");
            J2cPackage j2cpkg = (J2cPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.j2c.xmi");
            J2cFactory j2cFactory = j2cpkg.getJ2cFactory();
            props = InstallRAHelper.populateProps(props, rarPath, connector2);
            RefObjectHelper rHelper = RefObjectHelperFactory.getRefObjectHelper();
            Connector newConnector = (Connector)rHelper.clone((EObject)connector2);
            ret = null;
            try {
                try {
                    J2CResourceAdapter ra = null;
                    int vid = ((XMLResource)connector2.eResource()).getVersionID();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "version id: " + vid);
                    }
                    if (vid < 14) {
                        ResourcesPackage respkg = (ResourcesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.xmi");
                        ResourcesFactory resFact = respkg.getResourcesFactory();
                        ra = AdminOperationsMBean.createJ2CResourceAdapter(j2cFactory, resFact, newConnector, props);
                    } else {
                        AdminService adminservice2 = AdminServiceFactory.getAdminService();
                        if (adminservice2 != null) {
                            int nVersion;
                            String nodeName = adminservice2.getNodeName();
                            String cellName = adminservice2.getCellName();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "node name is " + nodeName + " cell name is  " + cellName);
                            }
                            String nodeVersion = AdminOperationsMBean.getNodeMajorVersion(cellName, nodeName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "node version is " + nodeVersion);
                            }
                            if ((nVersion = Integer.parseInt(nodeVersion)) < 6) {
                                throw new AdminException(AdminOperationsMBean.getFormattedMessage("ADMN0065E", new Object[]{new Integer(vid), nodeName, new Integer(nVersion)}, null));
                            }
                        }
                        ra = AdminOperationsMBean.createJ2C15ResourceAdapter(j2cFactory, newConnector, props, rarFile);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Created new J2CResourceAdapter : " + ra);
                    }
                    AdminOperationsMBean.saveThis(ra, rHelper);
                    ret = MOFUtil.getAttributes(ra, null, true);
                }
                catch (Throwable th) {
                    FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.component.AdminOperationsMBean._getResourceAdapterFromRAR", (String)"606");
                    if (th instanceof AdminException) {
                        throw (AdminException)th;
                    }
                    throw new AdminException(th, "");
                }
                Object var17_20 = null;
                if (rarFile == null) break block21;
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                if (rarFile != null) {
                    rarFile.close();
                }
                throw throwable;
            }
            rarFile.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceAdapterFromRAR:" + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static J2CResourceAdapter createJ2C15ResourceAdapter(J2cFactory fact, Connector connector2, Hashtable props, RARFile rarFile) throws Exception {
        boolean isPermissionUpdateRequired;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJ2C15ResourceAdapter");
        }
        J2CResourceAdapter ra = null;
        SecurityManager sm = System.getSecurityManager();
        boolean isJava2SecEnabled = sm != null;
        boolean bl = isPermissionUpdateRequired = rarFile.getDeploymentDescriptor().getResourceAdapter().getSecurityPermissions() != null && isJava2SecEnabled;
        if (!isPermissionUpdateRequired) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createJ2C15ResourceAdapter Without Protection Domain");
            }
            ra = AdminOperationsMBean.createJ2C15ResourceAdapter(fact, connector2, props, rarFile, null);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createJ2C15ResourceAdapter With Protection Domain");
            }
            ProtectionDomain pd = null;
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            DynamicPolicy dPolicy = DynamicPolicyFactory.getInstance();
            try {
                if (dPolicy != null) {
                    map.put("type", "ra");
                    map.put("RARFile", rarFile);
                    dPolicy.setupPolicy(map);
                }
                pd = InstallRAHelper.getProtectionDomainForRAR(rarFile);
                ra = AdminOperationsMBean.createJ2C15ResourceAdapter(fact, connector2, props, rarFile, pd);
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                InstallRAHelper.removePDFromCache(rarFile.toString());
                dPolicy.removePolicy(map);
                throw throwable;
            }
            InstallRAHelper.removePDFromCache(rarFile.toString());
            dPolicy.removePolicy(map);
            {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJ2C15ResourceAdapter");
        }
        return ra;
    }

    public static J2CResourceAdapter createJ2C15ResourceAdapter(J2cFactory fact, Connector connector2, Hashtable props, RARFile rarFile, ProtectionDomain pd) throws Exception {
        EList RAtier1cfg;
        RarFileDynamicClassLoader racl;
        List RAtier0;
        List RAtier2;
        ClassLoader ecl;
        String msg;
        String value;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJ2C15ResourceAdapter");
        }
        int vid = 15;
        J2CResourceAdapter ra = fact.createJ2CResourceAdapter();
        ra.setDeploymentDescriptor(connector2);
        ResourceAdapter rAdapter = connector2.getResourceAdapter();
        if (props != null && props.containsKey("rar.HACapability") && (value = (String)props.get("rar.HACapability")).equals("no")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Removing HACapablity if it's set to no.");
            }
            props.remove("rar.HACapability");
        }
        if ((msg = AdminOperationsMBean._validateProps(props)) != null) {
            throw new AdminException(msg);
        }
        InstallRAHelper.setupRAGeneralProperty(props, ra);
        List pp = (List)props.get("rar.propertiesSet");
        List RAtier3 = InstallRAHelper.setupRAProperties(pp);
        String raClass = rAdapter.getResourceAdapterClass();
        if (raClass == null || raClass.equals("")) {
            Tr.warning(tc, "ADMN0063W", "<resourceadapter-class>");
        }
        if ((ecl = ExtClassLoader.getInstance()) == null) {
            ecl = AdminOperationsMBean.class.getClassLoader();
        }
        if ((RAtier2 = J2CProps.mergeRAProperties((List)(RAtier0 = InstallRAHelper.loadBeanProperty(raClass, racl = new RarFileDynamicClassLoader(rarFile, ecl, null, pd))), (List)(RAtier1cfg = rAdapter.getConfigProperties()), (List)RAtier3, (int)vid)) != null) {
            J2EEResourcePropertySet RApropSet = InstallRAHelper.getResourcePropertySet(RAtier2);
            ra.setPropertySet(RApropSet);
        }
        InstallRAHelper.setOutboundRA(fact, rAdapter, ra, rarFile, RAtier2, vid);
        InstallRAHelper.setInboundRA(fact, rAdapter, ra, rarFile, RAtier2);
        InstallRAHelper.setAdminObject(fact, rAdapter, ra, rarFile, vid);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJ2C15ResourceAdapter");
        }
        return ra;
    }

    private static String _validateProps(Hashtable<?, ?> props) {
        String value;
        String msg = null;
        if (props != null && props.containsKey("rar.HACapability") && !(value = (String)props.get("rar.HACapability")).equals("endpoint") && !value.equals("instance")) {
            msg = AdminOperationsMBean.getFormattedMessage("ADMN1217E", new Object[]{"rar.HACapability", value}, "ADMN1217E: Parameter {0} has invalid value {1} set.");
        }
        return msg;
    }

    private static void saveThis(EObject ra, RefObjectHelper rHelper) throws Exception {
        try {
            WASResourceSetImpl rs = new WASResourceSetImpl();
            URIConverterImpl uric = new URIConverterImpl(){

                public URI normalize(URI uri) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "normalize -----" + uri);
                    }
                    return super.normalize(uri);
                }
            };
            rs.setURIConverter(uric);
            URI uri = URI.createFileURI("test1_" + iii);
            Resource res = rs.createResource(uri);
            res.getContents().add(ra);
            rHelper.refreshRefId(ra);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.component.AdminOperationsMBean.saveThis", (String)"693");
            throw new AdminException(th, AdminOperationsMBean.getFormattedMessage("ADMN038E", new Object[]{th.toString()}, "Internal error"));
        }
    }

    public static J2CResourceAdapter createJ2CResourceAdapter(J2cFactory fact, ResourcesFactory resFact, Connector connector2, Hashtable props) throws Exception {
        ResourceAdapter rAdapter;
        String nPath;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJ2CResourceAdapter");
        }
        boolean ispassword = false;
        J2CResourceAdapter ra = fact.createJ2CResourceAdapter();
        ra.setDeploymentDescriptor(connector2);
        String name = (String)props.get("rar.name");
        ra.setName(name);
        String isolatedCL = (String)props.get("rar.isolatedClassLoader");
        if (isolatedCL != null && isolatedCL.equalsIgnoreCase("true")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isolatedCL set to: true");
            }
            ra.setIsolatedClassLoader(true);
        }
        String aPath = (String)props.get("rar.archivePath");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Archive path: " + aPath);
        }
        ra.setArchivePath(aPath);
        String desc = (String)props.get("rar.desc");
        if (desc == null || desc.equals("")) {
            desc = connector2.getDescription();
        }
        if (desc != null) {
            ra.setDescription(desc);
        }
        String cPath = (String)props.get("rar.classpath");
        ra.getClasspath().add(aPath);
        if (cPath != null) {
            AdminOperationsMBean.addFromString(cPath, ra.getClasspath());
        }
        if ((nPath = (String)props.get("rar.nativePath")) != null) {
            AdminOperationsMBean.addFromString(nPath, ra.getNativepath());
        }
        if ((rAdapter = connector2.getResourceAdapter()).getConfigProperties() != null) {
            J2EEResourcePropertySet propertySet = resFact.createJ2EEResourcePropertySet();
            EList configs = rAdapter.getConfigProperties();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "========================");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configs " + configs);
            }
            for (int i = 0; i < configs.size(); ++i) {
                String propname;
                ConfigProperty prop = (ConfigProperty)configs.get(i);
                J2EEResourceProperty property = resFact.createJ2EEResourceProperty();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "..... setting up resource property: " + prop.getName());
                }
                if ((propname = prop.getName()).indexOf("Password") != -1) {
                    ispassword = true;
                } else if (propname.indexOf("password") != -1) {
                    ispassword = true;
                }
                property.setName(prop.getName());
                property.setType(prop.getType());
                if (ispassword) {
                    String password = prop.getValue();
                    if (password != null && !password.trim().equals("")) {
                        password = PasswordUtil.encode((String)password);
                    }
                    property.setValue(password);
                } else {
                    property.setValue(prop.getValue());
                }
                ispassword = false;
                property.setDescription(prop.getDescription());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "..... setting up resource desc: " + prop.getDescription());
                }
                propertySet.getResourceProperties().add(property);
            }
            ra.setPropertySet(propertySet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJ2CResourceAdapter");
        }
        return ra;
    }

    private static void addFromString(String s, List l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addFromString: " + s + " and " + l);
        }
        if (s == null || l == null) {
            return;
        }
        StringTokenizer tk = new StringTokenizer(s, "\n\r");
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken().trim();
            if (token == null || token.trim().length() == 0) continue;
            l.add(token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addFromString: " + l);
        }
    }

    private static String getFormattedMessage(String key, Object[] args, String defaultString) {
        try {
            String result = nls.getString(key);
            if (result == null) {
                return defaultString;
            }
            return MessageFormat.format(result, args);
        }
        catch (Exception e) {
            if (defaultString == null) {
                return defaultString;
            }
            return MessageFormat.format(defaultString, args);
        }
    }

    public void extractArchive(String archivePath, String dest, int flag) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractArchive: " + archivePath + ", flags=: " + flag);
        }
        String path = this.expandVariable(archivePath);
        path = path.replace('\\', '/');
        String dpath = this.expandVariable(dest);
        dpath = dpath.replace('/', File.separatorChar);
        AdminOperationsMBean._extractArchive(path, dpath, flag);
        if (this.zos) {
            File destFile = new File(dpath);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "destFile", destFile.getAbsolutePath());
            }
            this.permset(destFile);
        }
    }

    public static void local_extractArchive(String archivePath, String dest, int flag, String configRoot, String cell, String node) throws AdminException {
        String path = InstallRAHelper.expandVar(archivePath, configRoot, cell, node);
        path = path.replace('\\', '/');
        String dpath = InstallRAHelper.expandVar(dest, configRoot, cell, node);
        dpath = dpath.replace('/', File.separatorChar);
        AdminOperationsMBean._extractArchive(path, dpath, flag);
    }

    public static void _extractArchive(String archivePath, String dest, int flag) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractArchive: " + archivePath + ", flags=: " + flag);
        }
        try {
            ArchiveInit.init();
            CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ArchivePath: " + archivePath);
            }
            Archive archive = factory.openArchive(archivePath);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Archive: " + archive);
            }
            if (archive != null) {
                String path = dest;
                File dir = new File(path);
                if (!(dir.mkdirs() || dir.exists() && dir.isDirectory())) {
                    throw new AdminException(AdminOperationsMBean.getFormattedMessage("ADMN0031E", new String[]{path}, "Error extracting archive: could not create directory path " + path));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Dest: " + path);
                }
                int flag0 = 0;
                if (flag >= 1000) {
                    flag0 = flag - 1000;
                }
                archive.extractTo(path, flag0);
                archive.close();
                if (flag >= 1000) {
                    File delFile = new File(archivePath);
                    boolean resDelete = delFile.delete();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Delete original archive: " + path + " -- success: " + resDelete);
                    }
                }
            }
        }
        catch (Throwable th) {
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(AdminOperationsMBean.getFormattedMessage("ADMN0029E", new String[]{archivePath, th.toString()}, "Error extracting archive " + archivePath + ": " + th));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractArchive");
        }
    }

    public void configChanged(ConfigRepositoryEvent e) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configChanged");
        }
        this.adminImpl.configChanged(e);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }

    private String getLine(String pgmName, String[] args) {
        StringBuffer sb = new StringBuffer(pgmName + ".sh ");
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i] + " ");
        }
        return sb.toString();
    }

    private void chmod(String file) throws Exception {
        int returnCode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chmod()");
        }
        if (this.chmodPermissions == 0) {
            this.chmodPermissions = this.platformUtils.getUserReadMask() | this.platformUtils.getUserWriteMask() | this.platformUtils.getUserExecuteMask() | this.platformUtils.getGroupReadMask() | this.platformUtils.getGroupExecuteMask() | this.platformUtils.getOtherReadMask() | this.platformUtils.getOtherExecuteMask();
        }
        if ((returnCode = this.platformUtils.chmod(file, this.chmodPermissions)) != 0 && tc.isEntryEnabled()) {
            Tr.exit(tc, "Return Code: ", new Integer(returnCode).toString());
        }
    }

    private void permset(File targetFile) {
        File[] files = targetFile.listFiles();
        String dirPath = targetFile.getAbsolutePath();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "files.length", new Integer(files.length).toString());
        }
        for (int i = 0; i < files.length; ++i) {
            int returnCode;
            if (files[i].isDirectory()) {
                this.permset(files[i]);
                continue;
            }
            if (!files[i].getName().endsWith(".so")) continue;
            String cmd = dirPath + File.separator + files[i].getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cmd =", cmd);
            }
            if (this.permsetPermissions == 0) {
                this.permsetPermissions = this.platformUtils.getUserReadMask() | this.platformUtils.getUserWriteMask() | this.platformUtils.getUserExecuteMask() | this.platformUtils.getGroupReadMask() | this.platformUtils.getGroupExecuteMask() | this.platformUtils.getOtherReadMask() | this.platformUtils.getOtherExecuteMask();
            }
            if ((returnCode = this.platformUtils.chmod(cmd, this.permsetPermissions)) == 0 || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Return Code: ", new Integer(returnCode).toString());
        }
    }

    public void updateMetadataForNode(String nodeName, Properties nodeMetadata) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMetadataForNode");
        }
        try {
            AdminService adminService;
            block36: {
                if (nodeName == null) {
                    AdminException ae = new AdminException("updateMetadataForNode: Invalid parameter. Null node name.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateMetadataForNode: Null node name.");
                    }
                    throw ae;
                }
                if (nodeMetadata == null) {
                    AdminException ae = new AdminException("updateMetadataForNode: Invalid parameter. Null metadata properties object.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateMetadataForNode: Null metadata properties object.");
                    }
                    throw ae;
                }
                adminService = AdminServiceFactory.getAdminService();
                if (adminService == null) {
                    AdminException ae = new AdminException("updateMetadataForNode: Null AdminService reference.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateMetadataForNode: Null AdminService reference.");
                    }
                    throw ae;
                }
                String procType = adminService.getProcessType();
                if (!procType.equals("DeploymentManager") && !procType.equals("UnManagedProcess")) {
                    AdminException ae = new AdminException("The updateMetadataForNode method on the AdminOperations MBean was invoked in a process in a managed environment other than the dmgr process.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateMetadataForNode: Not DMgr process.");
                    }
                    throw ae;
                }
                try {
                    ManagedObjectMetadataAccessor accessor = ManagedObjectMetadataAccessorFactory.createAccessor(null);
                    Properties currentProps = accessor.getMetadataProperties(nodeName);
                    if (currentProps.equals(nodeMetadata)) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "updateMetadataForNode: No metadata properties have changed.");
                        }
                        return;
                    }
                }
                catch (AdminException ae) {
                    if (!tc.isDebugEnabled()) break block36;
                    Tr.debug(tc, "updateMetadataForNode: exception occurred while comparing node metadata: ", ae);
                }
            }
            Properties rProps = new Properties();
            rProps.setProperty("location", "local");
            ConfigRepository repo = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)rProps);
            if (repo == null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "updateMetadataForNode: Null ConfigRepository returned.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "updateMetadataForNode: Null ConfigRepository.");
                }
                return;
            }
            String cellName = adminService.getCellName();
            String docURI = ConfigStructureHelper.getURI((String)adminService.getCellName(), (String)nodeName, (String)"", (String)"node-metadata.properties");
            ByteArrayOutputStream baOut = new ByteArrayOutputStream();
            nodeMetadata.store(baOut, null);
            byte[] docBytes = baOut.toByteArray();
            DocumentContentSource docContents = null;
            int DOC_CHANGED_RETRY_COUNT = 2;
            int documentChangedRetryCount = 2;
            DocumentChangedException documentChangedException = null;
            try {
                do {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "updateMetadataForNode: Extracting " + docURI);
                    }
                    DocumentDigest curDigest = repo.getDigest(docURI);
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "updateMetadataForNode: Modifying " + docURI);
                        }
                        docContents = new DocumentContentSource(new Document(docURI, curDigest), (InputStream)new ByteArrayInputStream(docBytes));
                        DocumentDigest digest = repo.modify(docContents);
                        documentChangedRetryCount = -99;
                    }
                    catch (DocumentChangedException e) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "updateMetadataForNode: DocumentChangedException.", new Object[]{"retryCount=" + documentChangedRetryCount, e});
                        }
                        --documentChangedRetryCount;
                        documentChangedException = e;
                    }
                    catch (Throwable t) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "updateMetadataForNode: Failed to write metadata.", t);
                        }
                        AdminException ae = new AdminException(t, "Could not update node metadata.  See root exception for more info.");
                        throw ae;
                    }
                } while (documentChangedRetryCount >= 0);
                if (documentChangedRetryCount == -1) {
                    AdminException ae = new AdminException(documentChangedException, "Could not store metadata to the config repository after 2 retries.");
                    Tr.exit(tc, "updateMetadataForNode: Exhausted retry count.", ae);
                    throw ae;
                }
            }
            catch (DocumentNotFoundException repE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateMetadataForNode: Creating " + docURI);
                }
                docContents = new DocumentContentSource(new Document(docURI), (InputStream)new ByteArrayInputStream(docBytes));
                DocumentDigest digest = repo.create(docContents);
                documentChangedRetryCount = -99;
            }
            catch (Throwable t) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateMetadataForNode: Failed to read existing metadata.", t);
                }
                AdminException ae = new AdminException(t, "Could not read node metadata.  See root exception for more info.");
                throw ae;
            }
        }
        catch (AdminException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminOperationsMBean.updateMetadataForNode", (String)"1032");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateMetadataForNode: AdminException: " + e);
            }
            throw e;
        }
        catch (Throwable t) {
            AdminException ae = new AdminException(t, "Could not update node metadata.  See root exception for more info.");
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.component.AdminOperationsMBean.updateMetadataForNode", (String)"953");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateMetadataForNode: Exception: ", t);
            }
            throw ae;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMetadataForNode");
        }
    }

    public Properties collectMetadataForThisNode() throws AdminException {
        Properties metadata2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectMetadataForThisNode");
        }
        try {
            ManagedObjectMetadataCollectorManager collectorMgr;
            AdminService adminService = AdminServiceFactory.getAdminService();
            if (adminService == null) {
                AdminException ae = new AdminException("collectMetadataForThisNode: Null AdminService reference.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "collectMetadataForThisNode: Null AdminService reference.");
                }
                throw ae;
            }
            String procType = adminService.getProcessType();
            if (procType.equals("DeploymentManager") || procType.equals("UnManagedProcess")) {
                collectorMgr = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager(null);
            } else {
                AdminClient adminClient = adminService.getDeploymentManagerAdminClient();
                collectorMgr = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager(null, adminClient);
            }
            metadata2 = collectorMgr.updateMetadata("Collect Metadata", null);
        }
        catch (AdminException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "collectMetadataForThisNode: AdminException: " + e);
            }
            throw e;
        }
        catch (Throwable t) {
            AdminException ae = new AdminException(t, "Could not collect metadata.  See root exception for more info.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "collectMetadataForThisNode: Exception: ", t);
            }
            throw ae;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectMetadataForThisNode", metadata2);
        }
        return metadata2;
    }

    public Hashtable _getAppDistributionStatus(String appName, Hashtable options) throws AdminException {
        File f;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getAppDistributionStatus: " + appName);
        }
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        String status = new String();
        String uiRoot = System.getProperty("user.install.root");
        String mName = CommonAppUtils.getAppSyncMarkerLocation((String)uiRoot, (String)appName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "marker name: " + mName);
        }
        status = !(f = new File(mName)).exists() ? "-1" : (f.length() < 4L ? "0" : "ADMA7008E");
        table.put(appName, status);
        if (!f.exists()) {
            Tr.debug(tc, " marker file doesnt exist calling J2CApp");
            Hashtable tbl = J2CAppUtils.getAppDocuments((String)appName);
            if (tbl != null) {
                table.put("uri", tbl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getAppDistributionStatus: " + table);
        }
        return table;
    }

    public Hashtable getRARInfo(String rarPath, Hashtable props) throws AdminException {
        String path = this.expandVariable(rarPath);
        path = path.replace('\\', '/');
        Hashtable result = AdminOperationsMBean._getRARInfo(path, props);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Hashtable _getRARInfo(String rarPath, Hashtable props) throws AdminException {
        Hashtable<String, String> result;
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getRARInfo: " + rarPath + ", " + props);
            }
            if (rarPath == null) {
                throw new AdminException(AdminOperationsMBean.getFormattedMessage("ADMN0027E", null, null));
            }
            Archive rarFile = null;
            result = new Hashtable<String, String>();
            try {
                try {
                    ArchiveInit.init();
                    CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Path: " + rarPath);
                    }
                    rarFile = factory.openRARFile(rarPath);
                    Connector connector2 = rarFile.getDeploymentDescriptor();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Connector is: " + connector2);
                    }
                    String name = null;
                    String description = (String)props.get("rar.desc");
                    String archivePath = (String)props.get("rar.archivePath");
                    String classPath = (String)props.get("rar.classpath");
                    String nativePath = (String)props.get("rar.nativePath");
                    name = connector2.getDisplayName();
                    if (name == null || name.equals("")) {
                        name = (String)props.get("rar.name");
                    }
                    if (description == null || description.equals("")) {
                        description = connector2.getDescription();
                    }
                    if (archivePath == null || archivePath.equals("")) {
                        archivePath = rarPath;
                    }
                    if (classPath == null || classPath.equals("")) {
                        classPath = rarPath;
                    }
                    if (nativePath == null || nativePath.equals("")) {
                        nativePath = rarPath;
                    }
                    if (name != null) {
                        result.put("rar.name", name);
                    }
                    if (description != null) {
                        result.put("rar.desc", description);
                    }
                    if (archivePath != null) {
                        result.put("rar.archivePath", archivePath);
                    }
                    if (classPath != null) {
                        result.put("rar.classpath", classPath);
                    }
                    if (nativePath != null) {
                        result.put("rar.nativePath", nativePath);
                    }
                }
                catch (Exception oex) {
                    FFDCFilter.processException((Throwable)oex, (String)"com.ibm.ws.management.component.AdminOperationsMBean._getResourceAdapterFromRAR", (String)"545");
                    throw new AdminException(oex, AdminOperationsMBean.getFormattedMessage("ADMN0028E", new String[]{rarPath, oex.toString()}, "Could not open RAR file " + rarPath));
                }
                Object var12_12 = null;
                if (rarFile == null) break block20;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (rarFile != null) {
                    rarFile.close();
                }
                throw throwable;
            }
            rarFile.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceAdapterFromRAR:" + result);
        }
        return result;
    }

    public static Hashtable local_getRARInfo(String rarPath, Hashtable props, String configRoot, String cell, String node) {
        Hashtable result = new Hashtable();
        String path = InstallRAHelper.expandVar(rarPath, configRoot, cell, node);
        path = path.replace('\\', '/');
        try {
            result = AdminOperationsMBean._getRARInfo(rarPath, props);
        }
        catch (Exception ex) {
            System.out.println("Unexpected Exception" + ex);
        }
        return result;
    }

    public static String getNodeMajorVersion(String cellName, String nodeName) throws AdminException {
        try {
            Properties inProps = new Properties();
            inProps.setProperty("local.cell", cellName);
            ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(inProps));
            String nodeVersion = helper.getNodeMajorVersion(nodeName);
            return nodeVersion;
        }
        catch (Throwable th) {
            throw new AdminException(th, "");
        }
    }
}

