/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class ListServers
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListServers.class, "ListServers", "com.ibm.ws.management.commands.server");
    private ObjectName scope = null;

    public ListServers(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListServers(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        String nodeName = (String)this.getParameter("nodeName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", nodeName);
        }
        String serverType = (String)this.getParameter("serverType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverType", serverType);
        }
        try {
            if (nodeName != null) {
                ObjectName[] match = null;
                final Session sessionFinal = session;
                final String nodeNameFinal = "Node=" + nodeName;
                final ConfigService csFinal = cs;
                try {
                    Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                    match = (ObjectName[])ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return csFinal.resolve(sessionFinal, nodeNameFinal);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (match == null || match.length != 1) {
                    throw new InvalidParameterValueException(this.getName(), "nodeName", nodeName);
                }
                this.scope = match[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scope", this.scope);
                }
            }
            if (serverType != null && !this.listServerTypes().contains(serverType)) {
                throw new InvalidParameterValueException(this.getName(), "serverType", serverType);
            }
        }
        catch (CommandValidationException ex) {
            throw ex;
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.commands.server.validate", (String)"83");
            throw new CommandValidationException(th, "validation for command listServers failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Server");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName[] servers = cs.queryConfigObjects(session, this.scope, pattern, null);
            String expectedServerType = (String)this.getParameter("serverType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expectedServerType", expectedServerType);
            }
            List<Object> match = new ArrayList(servers.length);
            if (expectedServerType != null) {
                for (int i = 0; i < servers.length; ++i) {
                    String serverType;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "servers[" + i + "]", servers[i]);
                    }
                    if ((serverType = this.getServerType(servers[i])) == null || !expectedServerType.equals(serverType)) continue;
                    match.add(servers[i]);
                }
            } else {
                match = Arrays.asList(servers);
            }
            result.setResult(match);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.commands.server.validate", (String)"94");
            result.setException(new CommandException(th, "getServerType command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public Object[] getChoices(String paramName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", paramName);
        }
        Object[] result = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            if (paramName.equals("nodeName")) {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Node");
                ObjectName[] match = cs.queryConfigObjects(session, null, pattern, null);
                result = new String[match.length];
                for (int i = 0; i < match.length; ++i) {
                    result[i] = ConfigServiceHelper.getDisplayName(match[i]);
                }
            } else if (paramName.equals("serverType")) {
                List serverTypes = this.listServerTypes();
                result = serverTypes.toArray();
            }
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ListServer.getChoices", (String)"147");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChoices");
        }
        return result;
    }

    private List listServerTypes() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServerTypes");
        }
        AdminCommand cmd = CommandMgr.getCommandMgr().createCommand("listServerTypes");
        cmd.setConfigSession(this.getConfigSession());
        if (this.getParameter("nodeName") != null) {
            cmd.setTargetObject(this.getParameter("nodeName"));
        }
        cmd.execute();
        CommandResult result = cmd.getCommandResult();
        if (!result.isSuccessful()) {
            throw result.getException();
        }
        List types = (List)result.getResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServerTypes", types);
        }
        return types;
    }

    private String getServerType(ObjectName server) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerType", server);
        }
        Properties props = ConfigServiceHelper.getObjectLocation(server);
        String nodeName = props.getProperty("node");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", nodeName);
        }
        if (nodeName == null || nodeName.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No node present.  Return now");
            }
            return null;
        }
        String svrName = props.getProperty("server");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "svrName", svrName);
        }
        AdminCommand cmd = CommandMgr.getCommandMgr().createCommand("getServerType");
        cmd.setConfigSession(this.getConfigSession());
        cmd.setParameter("nodeName", nodeName);
        cmd.setParameter("serverName", svrName);
        cmd.execute();
        CommandResult result = cmd.getCommandResult();
        if (!result.isSuccessful()) {
            throw result.getException();
        }
        String serverType = (String)result.getResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerType", serverType);
        }
        return serverType;
    }
}

