/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.mapping;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.ws.management.commands.properties.resources.mapping.PropertyData;
import com.ibm.ws.management.commands.properties.resources.properties.Props;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.ObjectName;

public class CommandInfo {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(CommandInfo.class, "CommandInfo", "com.ibm.ws.management.resources.configservice");
    private String commandName = null;
    private String commandType = null;
    private String commandResult = null;
    private PropertyData[] parameters = null;

    CommandInfo(String commandType, String commandName, String commandResult, PropertyData[] parameters) {
        this.commandType = commandType;
        this.commandName = commandName;
        this.commandResult = commandResult;
        this.parameters = parameters;
    }

    public String getCommandResult() {
        return this.commandResult;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandType() {
        return this.commandType;
    }

    public List getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; this.parameters != null && i < this.parameters.length; ++i) {
            params.add(this.parameters[i].getAttrName());
        }
        return params;
    }

    public List getProperties() {
        ArrayList<String> props = new ArrayList<String>();
        for (int i = 0; this.parameters != null && i < this.parameters.length; ++i) {
            props.add(this.parameters[i].getPropName());
        }
        return props;
    }

    private boolean isValidProp(String pName, Props[] props) {
        for (int i = 0; props != null && i < props.length; ++i) {
            if (!props[i].getName().equals(pName)) continue;
            return true;
        }
        return false;
    }

    public List getPropertiesProcessed(Props[] props) {
        ArrayList<String> pList = new ArrayList<String>();
        for (int i = 0; this.parameters != null && i < this.parameters.length; ++i) {
            String pName = this.parameters[i].getPropName();
            if (pName.indexOf(":ObjectName") >= 0 || !this.isValidProp(pName, props)) continue;
            pList.add(pName);
        }
        return pList;
    }

    public Object execute(ConfigService cs, Session session, ObjectName configData, Props[] props) throws Exception {
        Object result = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", new Object[]{cs, session, configData});
        }
        CommandMgr cmdMgr = this.getCmdMgr(cs);
        AdminCommand cmd = cmdMgr.createCommand(this.commandName);
        cmd.setConfigSession(session);
        for (int i = 0; this.parameters != null && i < this.parameters.length; ++i) {
            String pName = this.parameters[i].getAttrName();
            Object pValue = this.getParamValue(cs, session, this.parameters[i], configData, props);
            cmd.setParameter(pName, pValue);
        }
        cmd.execute();
        CommandResult res = cmd.getCommandResult();
        if (!res.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Command failed");
            }
        } else {
            result = res.getResult();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute", result);
        }
        return result;
    }

    private CommandMgr getCmdMgr(ConfigService configService) throws Exception {
        CommandMgr cmdMgr = null;
        cmdMgr = configService instanceof ConfigServiceProxy ? CommandMgr.getCommandMgr(((ConfigServiceProxy)configService).getAdminClient()) : CommandMgr.getCommandMgr();
        return cmdMgr;
    }

    private Object getParamValue(ConfigService cs, Session session, PropertyData pData, ObjectName configData, Props[] sectionProps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParamValue", new Object[]{cs, session, pData, configData, sectionProps});
        }
        Object result = null;
        String prop = pData.getPropName();
        int inx = prop.indexOf(":ObjectName");
        if (inx > 0) {
            String key = prop.substring(0, inx);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "key = ", key);
            }
            Properties objProps = ConfigServiceHelper.getObjectLocation(configData);
            result = objProps.getProperty(key);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value = ", result);
            }
        } else if (sectionProps != null) {
            String pName = pData.getPropName();
            for (int i = 0; sectionProps != null && i < sectionProps.length; ++i) {
                String propName = sectionProps[i].getName();
                if (!propName.equals(pName)) continue;
                String propValue = sectionProps[i].getValue();
                if (sectionProps[i].isArray()) {
                    result = CommandInfo.convert(sectionProps[i].getValues(), pData.getType());
                }
                result = CommandInfo.convert(propValue, pData.getType());
            }
        }
        if (result == null) {
            String type = pData.getType();
            result = CommandInfo.convert(pData.getPropName(), type);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParamValue", result);
        }
        return result;
    }

    private static Object convert(String pValue, String pType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convert", new Object[]{pValue, pType});
        }
        Object res = null;
        if (pType.indexOf("String") >= 0) {
            res = pValue;
        } else if (pType.indexOf("Integer") >= 0 || pType.indexOf("int") >= 0) {
            res = new Integer(pValue);
        } else if (pType.indexOf("Long") >= 0 || pType.indexOf("long") >= 0) {
            res = new Long(pValue);
        } else if (pType.indexOf("Boolean") >= 0 || pType.indexOf("bool") >= 0) {
            res = new Boolean(pValue);
        } else if (pType.indexOf("Byte") >= 0 || pType.indexOf("byte") >= 0) {
            res = new Byte(pValue);
        } else if (pType.indexOf("Short") >= 0 || pType.indexOf("short") >= 0) {
            res = new Short(pValue);
        } else if (pType.indexOf("Double") >= 0 || pType.indexOf("double") >= 0) {
            res = new Double(pValue);
        } else if (pType.indexOf("Float") >= 0 || pType.indexOf("float") >= 0) {
            res = new Float(pValue);
        } else if (pType.indexOf("Character") >= 0 || pType.indexOf("char") >= 0) {
            res = new Character(pValue.charAt(0));
        } else if (pType.indexOf("ObjectName") >= 0) {
            ObjectName on = ConfigServiceHelper.createObjectName(new ConfigDataId(pValue));
            res = on;
        } else if (pType.indexOf("URL") >= 0) {
            res = new URL(new String(pValue));
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unknown type", pType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convert", res);
        }
        return res;
    }

    private static Object convert(List pValue, String pType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convert", new Object[]{pValue, pType});
        }
        Properties result = null;
        if (pValue == null || pValue.size() <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convert", "null value specified for " + pType);
            }
            return result;
        }
        pType = CommandInfo.getActualType(pType);
        Class<?> typeClass = null;
        try {
            typeClass = Class.forName(pType);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                typeClass = Class.forName("java.lang." + pType);
            }
            catch (ClassNotFoundException cnfe1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " unknown type ", pType);
                }
                typeClass = Class.forName("java.lang.String");
            }
        }
        if (typeClass == Properties.class) {
            result = CommandInfo.getProperties(pValue);
        } else {
            Object res = Array.newInstance(typeClass.getComponentType(), pValue.size());
            for (int i = 0; i < pValue.size(); ++i) {
                Array.set(res, i, CommandInfo.convert((String)pValue.get(i), pType));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convert");
        }
        return result;
    }

    private static String getActualType(String pType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActualType", pType);
        }
        String res = pType;
        if (pType.indexOf("String") >= 0) {
            res = "String";
        } else if (pType.indexOf("Integer") >= 0 || pType.indexOf("int") >= 0) {
            res = "Integer";
        } else if (pType.indexOf("Long") >= 0 || pType.indexOf("long") >= 0) {
            res = "Long";
        } else if (pType.indexOf("Boolean") >= 0 || pType.indexOf("bool") >= 0) {
            res = "Boolean";
        } else if (pType.indexOf("Byte") >= 0 || pType.indexOf("byte") >= 0) {
            res = "Byte";
        } else if (pType.indexOf("Short") >= 0 || pType.indexOf("short") >= 0) {
            res = "Short";
        } else if (pType.indexOf("Double") >= 0 || pType.indexOf("double") >= 0) {
            res = "Double";
        } else if (pType.indexOf("Float") >= 0 || pType.indexOf("float") >= 0) {
            res = "Float";
        } else if (pType.indexOf("Character") >= 0 || pType.indexOf("char") >= 0) {
            res = "Character";
        } else if (pType.indexOf("ObjectName") >= 0) {
            res = "javax.management.ObjectName";
        } else if (pType.indexOf("URL") >= 0) {
            res = "java.net.URL";
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unknown type", pType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActualType", res);
        }
        return res;
    }

    private static Properties getProperties(List pValue) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", pValue);
        }
        Properties props = new Properties();
        for (int i = 0; i < pValue.size(); ++i) {
            String val = (String)pValue.get(i);
            StringTokenizer st = new StringTokenizer(val, "=");
            String name = st.nextToken();
            String value = st.nextToken();
            props.setProperty(name, value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", props);
        }
        return props;
    }
}

