/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.TaskCommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.properties.ConfigPropertiesHelper;
import com.ibm.ws.management.commands.properties.resources.common.EnvVariables;
import com.ibm.ws.management.commands.properties.resources.common.SectionedPropertiesHelper;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.ObjectName;

public class ExtractConfigPropertiesCommand
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ExtractConfigPropertiesCommand.class, "PropertiesConfig", BUNDLE_NAME);

    public ExtractConfigPropertiesCommand(TaskCommandMetadata metadata2) throws CommandNotFoundException {
        super(metadata2);
    }

    public ExtractConfigPropertiesCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ObjectName[] matches;
            Object fName = this.getParameter("propertiesFileName");
            String fileName = fName != null ? fName.toString() : null;
            String configData = (String)this.getParameter("configData");
            ObjectName configDataId = (ObjectName)this.getTargetObject();
            if (configDataId != null && configData != null) {
                throw new CommandValidationException("Cannot provide both targetObject and configData parameters.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "propertiesFileName", fileName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configData", configData);
            }
            CommandProviderHelper ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService cs = ch.getConfigService();
            Session session = this.getConfigSession();
            if (configData != null && ((matches = cs.resolve(session, configData)) == null || matches.length != 1)) {
                String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0657E", new Object[]{this.getName(), configData});
                throw new CommandValidationException(msg);
            }
            File f = new File(fileName);
            f.createNewFile();
            if (!f.canWrite()) {
                String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0656E", new Object[]{this.getName(), fileName});
                throw new CommandValidationException(msg);
            }
        }
        catch (CommandValidationException cve) {
            throw cve;
        }
        catch (Exception e) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0658E", new Object[]{this.getName()});
            throw new CommandValidationException(e, msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void beforeStepsExecuted() {
        block26: {
            if (ExtractConfigPropertiesCommand.tc.isEntryEnabled()) {
                Tr.entry(ExtractConfigPropertiesCommand.tc, "beforeStepsExecuted");
            }
            result = this.getTaskCommandResult();
            props = null;
            os = null;
            try {
                fName = this.getParameter("propertiesFileName");
                fileName = fName != null ? fName.toString() : null;
                configData = (String)this.getParameter("configData");
                options = (Properties)this.getParameter("options");
                filter = (String)this.getParameter("filterMechanism");
                subTypes = (String[])this.getParameter("selectedSubTypes");
                if (ExtractConfigPropertiesCommand.tc.isDebugEnabled()) {
                    Tr.debug(ExtractConfigPropertiesCommand.tc, "propertiesFileName", fileName);
                }
                if (ExtractConfigPropertiesCommand.tc.isDebugEnabled()) {
                    Tr.debug(ExtractConfigPropertiesCommand.tc, "configData", configData);
                }
                if (ExtractConfigPropertiesCommand.tc.isDebugEnabled()) {
                    Tr.debug(ExtractConfigPropertiesCommand.tc, "options", options);
                }
                ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
                cs = ch.getConfigService();
                session = this.getConfigSession();
                configDataId = (ObjectName)this.getTargetObject();
                if (ExtractConfigPropertiesCommand.tc.isDebugEnabled()) {
                    Tr.debug(ExtractConfigPropertiesCommand.tc, "configDataId = " + configDataId);
                }
                if (configData != null) {
                    matches = cs.resolve(session, configData);
                    configDataId = matches[0];
                } else if (configDataId == null) {
                    configDataId = cs.resolve(session, "Cell=")[0];
                }
                os = new FileOutputStream(fileName);
                SectionedPropertiesHelper.writeFileHeader(ConfigServiceHelper.getConfigDataId(configDataId).toString(), os);
                sectionNumber = "1.0";
                extractingType = ConfigServiceHelper.getConfigDataType(configDataId);
                if (extractingType == null) {
                    displayName = ConfigServiceHelper.getDisplayName(configDataId);
                    cfgId = ConfigServiceHelper.getConfigDataId(configDataId);
                    cid = cfgId.toString();
                    start = cid.lastIndexOf("#");
                    end = cid.lastIndexOf("_");
                    if (start > 0 && end > 0 && end > start) {
                        extractingType = cid.substring(start + 1, end);
                        if (ExtractConfigPropertiesCommand.tc.isDebugEnabled()) {
                            Tr.debug(ExtractConfigPropertiesCommand.tc, "extracting type", extractingType);
                        }
                        configDataId = ConfigServiceHelper.createObjectName(cfgId, extractingType, displayName);
                        if (ExtractConfigPropertiesCommand.tc.isDebugEnabled()) {
                            Tr.debug(ExtractConfigPropertiesCommand.tc, "extracting object name", configDataId);
                        }
                    }
                }
                selectedTypes = subTypes;
                if (subTypes != null && subTypes.length > 0 && extractingType != null) {
                    allTypes = new ArrayList<String>();
                    for (i = 0; i < subTypes.length; ++i) {
                        allTypes.add(subTypes[i]);
                    }
                    selectedTypes = allTypes.toArray(new String[0]);
                }
                varObject = new EnvVariables();
                ConfigPropertiesHelper.extractProperties(session, cs, configDataId, os, sectionNumber, extractingType, options, filter, selectedTypes, varObject);
                varObject.dumpProperties(os);
                os.flush();
                os.close();
                var22_24 = null;
                ** if (os == null) goto lbl-1000
            }
            catch (Throwable var21_30) {
                var22_26 = null;
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception ioe) {
                        // empty catch block
                    }
                }
                throw var21_30;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    os.close();
                }
                catch (Exception ioe) {}
            }
lbl-1000:
            // 2 sources

            {
                break block26;
                catch (Exception e) {
                    ((CommandResultImpl)result).setException(e);
                    msg = TemplateConfigHelper.getFormattedMessage(ExtractConfigPropertiesCommand.resBundle, "ADMG0659E", new Object[]{this.getName()});
                    ((CommandResultImpl)result).setResult(msg);
                    var22_25 = null;
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception ioe) {}
                    }
                }
            }
        }
        ((CommandResultImpl)result).setResult(props);
        if (ExtractConfigPropertiesCommand.tc.isEntryEnabled()) {
            Tr.exit(ExtractConfigPropertiesCommand.tc, "beforeStepsExecuted", props);
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        TaskCommandResult result = this.getTaskCommandResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

